/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.calc;

import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XNameAccess;
import com.sun.star.frame.XModel;
import com.sun.star.frame.XStorable;
import com.sun.star.helper.ApplicationImpl;
import com.sun.star.helper.HelperInterfaceAdaptor;
import com.sun.star.helper.calc.QueryTableDescriptor;
import com.sun.star.helper.calc.QueryTableImpl;
import com.sun.star.helper.calc.SheetImpl;
import com.sun.star.helper.calc.XCalcRange;
import com.sun.star.helper.calc.XQueryTable;
import com.sun.star.helper.calc.XQueryTables;
import com.sun.star.helper.calc.XSheet;
import com.sun.star.helper.calc.range.RangeImpl;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.script.BasicErrorException;
import com.sun.star.sheet.XAreaLinks;
import com.sun.star.sheet.XCellRangeAddressable;
import com.sun.star.sheet.XSheetLinkable;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.table.CellAddress;
import com.sun.star.table.CellRangeAddress;
import com.sun.star.table.XCellRange;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.uno.XNamingService;
import com.sun.star.util.XImportable;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class QueryTablesImpl
extends HelperInterfaceAdaptor
implements XQueryTables {
    protected static final String __serviceName = "com.sun.star.helper.calc.QueryTables";
    XSheet parent;
    XComponent xComponent;
    CellAddress Addr;
    XCellRange CR;
    static /* synthetic */ Class class$com$sun$star$lang$XComponent;
    static /* synthetic */ Class class$com$sun$star$beans$XPropertySet;
    static /* synthetic */ Class class$com$sun$star$sheet$XAreaLinks;
    static /* synthetic */ Class class$com$sun$star$sheet$XSheetLinkable;
    static /* synthetic */ Class class$com$sun$star$util$XImportable;
    static /* synthetic */ Class class$com$sun$star$sheet$XCellRangeAddressable;
    static /* synthetic */ Class class$com$sun$star$uno$XNamingService;
    static /* synthetic */ Class class$com$sun$star$container$XNameAccess;
    static /* synthetic */ Class class$com$sun$star$frame$XStorable;

    public QueryTablesImpl(HelperInterfaceAdaptor helperInterfaceAdaptor, XModel xModel) {
        super(__serviceName, helperInterfaceAdaptor);
        if (helperInterfaceAdaptor instanceof XSheet) {
            this.parent = (XSheet)((Object)helperInterfaceAdaptor);
        } else {
            DebugHelper.writeInfo("QueryTablesImpl: Parent needs to be a sheet");
        }
        this.xComponent = (XComponent)UnoRuntime.queryInterface((Class)(class$com$sun$star$lang$XComponent == null ? (class$com$sun$star$lang$XComponent = QueryTablesImpl.class$("com.sun.star.lang.XComponent")) : class$com$sun$star$lang$XComponent), (Object)xModel);
    }

    public XQueryTable Add(Object object, XCalcRange xCalcRange, Object object2) throws BasicErrorException {
        QueryTableDescriptor queryTableDescriptor = null;
        this.CR = ((RangeImpl)xCalcRange).getXCellRange();
        this.Addr = this.getCellAddress(this.CR);
        if (AnyConverter.isVoid((Object)object)) {
            DebugHelper.writeInfo("Connection must not be void");
            DebugHelper.exception(14, "");
        }
        if (object instanceof String) {
            String string = "";
            String string2 = "";
            try {
                string = AnyConverter.toString((Object)object);
                if (!AnyConverter.isVoid((Object)object2)) {
                    string2 = AnyConverter.toString((Object)object2);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DebugHelper.exception((com.sun.star.uno.Exception)((Object)illegalArgumentException));
            }
            queryTableDescriptor = this.addTable(string, string2);
        } else {
            DebugHelper.writeInfo("The usage of recordsets and querytables as Connection isn't supported");
            DebugHelper.exception(73, "");
        }
        return new QueryTableImpl(this, queryTableDescriptor, this.xComponent);
    }

    private QueryTableDescriptor addTable(String string, String string2) throws BasicErrorException {
        if (string.startsWith("URL")) {
            return this.addWebQuery(string);
        }
        if (string.startsWith("TEXT")) {
            return this.addTextQuery(string);
        }
        if (string.toLowerCase().startsWith("finder")) {
            return this.addFinderQuery(string);
        }
        if (string.startsWith("ODBC")) {
            return this.addODBCQuery(string, string2);
        }
        DebugHelper.writeInfo(string + " is no valid query type");
        DebugHelper.exception(14, "");
        return null;
    }

    private QueryTableDescriptor addWebQuery(String string) throws BasicErrorException {
        QueryTableDescriptor queryTableDescriptor = new QueryTableDescriptor();
        DebugHelper.writeInfo("adding WebQuery with " + string);
        try {
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = QueryTablesImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)this.xComponent);
            XAreaLinks xAreaLinks = (XAreaLinks)AnyConverter.toObject((Type)new Type(class$com$sun$star$sheet$XAreaLinks == null ? (class$com$sun$star$sheet$XAreaLinks = QueryTablesImpl.class$("com.sun.star.sheet.XAreaLinks")) : class$com$sun$star$sheet$XAreaLinks), (Object)xPropertySet.getPropertyValue("AreaLinks"));
            String string2 = string.substring(4, string.length());
            queryTableDescriptor.Type = 1;
            queryTableDescriptor.link = string2;
            queryTableDescriptor.Destination = this.Addr;
            queryTableDescriptor.UnoInterface = xAreaLinks;
        }
        catch (com.sun.star.uno.Exception exception) {
            DebugHelper.exception(exception);
        }
        DebugHelper.writeInfo("...done");
        return queryTableDescriptor;
    }

    private QueryTableDescriptor addTextQuery(String string) throws BasicErrorException {
        DebugHelper.writeInfo("adding TextQuery with " + string);
        QueryTableDescriptor queryTableDescriptor = new QueryTableDescriptor();
        XSpreadsheet xSpreadsheet = ((SheetImpl)this.parent).getXSpreadsheet();
        XSheetLinkable xSheetLinkable = (XSheetLinkable)UnoRuntime.queryInterface((Class)(class$com$sun$star$sheet$XSheetLinkable == null ? (class$com$sun$star$sheet$XSheetLinkable = QueryTablesImpl.class$("com.sun.star.sheet.XSheetLinkable")) : class$com$sun$star$sheet$XSheetLinkable), (Object)xSpreadsheet);
        String string2 = string.substring(5, string.length());
        File file = new File(string2);
        if (!file.exists()) {
            DebugHelper.exception(53, "");
        }
        queryTableDescriptor.Type = (short)2;
        queryTableDescriptor.link = string2;
        queryTableDescriptor.UnoInterface = xSheetLinkable;
        DebugHelper.writeInfo("... done");
        return queryTableDescriptor;
    }

    private QueryTableDescriptor addFinderQuery(String string) throws BasicErrorException {
        DebugHelper.writeInfo("adding FinderQuery with " + string);
        String string2 = string.substring(7, string.length());
        Object[] objectArray = this.getLines(string2);
        String string3 = "";
        if (objectArray[0].equals("WEB")) {
            string3 = "URL;";
            return this.addWebQuery(string3 + (String)objectArray[2]);
        }
        if (objectArray[0].equals("XLODBC")) {
            string3 = "ODBC;";
            return this.addODBCQuery(string3 + (String)objectArray[2], (String)objectArray[3]);
        }
        DebugHelper.writeInfo(string + " doesn't contain a valid query type");
        DebugHelper.exception(14, "");
        return null;
    }

    private QueryTableDescriptor addODBCQuery(String string, String string2) throws BasicErrorException {
        DebugHelper.writeInfo("adding ODBCQuery with " + string);
        DebugHelper.writeInfo("using sql " + string2);
        if (string2.equals("")) {
            DebugHelper.writeInfo("Database queries need the sql-statement to be set");
            DebugHelper.exception(14, "");
            return null;
        }
        String[] stringArray = this.getDBInfo(string);
        this.registerDB(stringArray[0], stringArray[1], stringArray[2]);
        QueryTableDescriptor queryTableDescriptor = new QueryTableDescriptor();
        XImportable xImportable = (XImportable)UnoRuntime.queryInterface((Class)(class$com$sun$star$util$XImportable == null ? (class$com$sun$star$util$XImportable = QueryTablesImpl.class$("com.sun.star.util.XImportable")) : class$com$sun$star$util$XImportable), (Object)this.CR);
        queryTableDescriptor.Type = 0;
        queryTableDescriptor.UnoInterface = xImportable;
        queryTableDescriptor.link = stringArray[0];
        queryTableDescriptor.sql = string2;
        return queryTableDescriptor;
    }

    private CellAddress getCellAddress(XCellRange xCellRange) {
        XCellRangeAddressable xCellRangeAddressable = (XCellRangeAddressable)UnoRuntime.queryInterface((Class)(class$com$sun$star$sheet$XCellRangeAddressable == null ? (class$com$sun$star$sheet$XCellRangeAddressable = QueryTablesImpl.class$("com.sun.star.sheet.XCellRangeAddressable")) : class$com$sun$star$sheet$XCellRangeAddressable), (Object)xCellRange);
        CellAddress cellAddress = new CellAddress();
        CellRangeAddress cellRangeAddress = xCellRangeAddressable.getRangeAddress();
        cellAddress.Sheet = cellRangeAddress.Sheet;
        cellAddress.Row = cellRangeAddress.StartRow;
        cellAddress.Column = cellRangeAddress.StartColumn;
        return cellAddress;
    }

    private Object[] getLines(String string) throws BasicErrorException {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
            while ((object = bufferedReader.readLine()) != null) {
                if (((String)object).startsWith("\"") && ((String)object).endsWith("\"")) {
                    object = ((String)object).substring(1, ((String)object).length() - 1);
                    DebugHelper.writeInfo("\t" + (String)object);
                }
                arrayList.add(object);
            }
        }
        catch (IOException iOException) {
            DebugHelper.exception(53, "");
        }
        if (bufferedReader != null) {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                DebugHelper.exception(53, "");
            }
        }
        object = arrayList.toArray();
        return object;
    }

    private String[] getDBInfo(String string) {
        String[] stringArray = new String[3];
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        int n = 0;
        while (n < arrayList.size()) {
            String string2 = (String)arrayList.toArray()[n];
            if (string2.startsWith("DSN")) {
                stringArray[0] = string2.substring(4, string2.length());
            } else if (string2.startsWith("UID")) {
                stringArray[1] = string2.substring(4, string2.length());
            } else if (string2.startsWith("PASSWORD")) {
                stringArray[2] = string2.substring(9, string2.length());
            }
            ++n;
        }
        return stringArray;
    }

    private void registerDB(String string, String string2, String string3) throws BasicErrorException {
        try {
            XMultiServiceFactory xMultiServiceFactory = ApplicationImpl.getXMultiServiceFactory();
            Object object = xMultiServiceFactory.createInstance("com.sun.star.sdb.DatabaseContext");
            XNamingService xNamingService = (XNamingService)UnoRuntime.queryInterface((Class)(class$com$sun$star$uno$XNamingService == null ? (class$com$sun$star$uno$XNamingService = QueryTablesImpl.class$("com.sun.star.uno.XNamingService")) : class$com$sun$star$uno$XNamingService), (Object)object);
            XNameAccess xNameAccess = (XNameAccess)UnoRuntime.queryInterface((Class)(class$com$sun$star$container$XNameAccess == null ? (class$com$sun$star$container$XNameAccess = QueryTablesImpl.class$("com.sun.star.container.XNameAccess")) : class$com$sun$star$container$XNameAccess), (Object)object);
            XInterface xInterface = (XInterface)xMultiServiceFactory.createInstance("com.sun.star.sdb.DataSource");
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = QueryTablesImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)xInterface);
            PropertyValue[] propertyValueArray = new PropertyValue[2];
            propertyValueArray[0] = new PropertyValue();
            propertyValueArray[0].Name = "user";
            propertyValueArray[0].Value = string2;
            propertyValueArray[1] = new PropertyValue();
            propertyValueArray[1].Name = "password";
            propertyValueArray[1].Value = string3;
            xPropertySet.setPropertyValue("URL", (Object)("sdbc:odbc:" + string));
            xPropertySet.setPropertyValue("Info", (Object)propertyValueArray);
            String string4 = string;
            if (xNameAccess.hasByName(string4)) {
                return;
            }
            XStorable xStorable = (XStorable)UnoRuntime.queryInterface((Class)(class$com$sun$star$frame$XStorable == null ? (class$com$sun$star$frame$XStorable = QueryTablesImpl.class$("com.sun.star.frame.XStorable")) : class$com$sun$star$frame$XStorable), (Object)xInterface);
            if (xStorable != null) {
                String string5 = this.getTempDir();
                String string6 = string5 + string + ".odb";
                DebugHelper.writeInfo("writing to file " + string6);
                xStorable.storeAsURL(string6, new PropertyValue[0]);
            } else {
                DebugHelper.writeInfo("XStorable isn't available");
                try {
                    Object object2 = UnoRuntime.queryInterface((Type)new Type("com.sun.star.sdb.XDocumentDataSource"), (Object)xInterface);
                    if (object2 != null) {
                        Method method = object2.getClass().getDeclaredMethod("getDatabaseDocument", new Class[0]);
                        xStorable = (XStorable)UnoRuntime.queryInterface((Class)(class$com$sun$star$frame$XStorable == null ? (class$com$sun$star$frame$XStorable = QueryTablesImpl.class$("com.sun.star.frame.XStorable")) : class$com$sun$star$frame$XStorable), (Object)method.invoke(object2, new Object[0]));
                        String string7 = this.getTempDir();
                        String string8 = string7 + string + ".odb";
                        DebugHelper.writeInfo("writing to file " + string8);
                        xStorable.storeAsURL(string8, new PropertyValue[0]);
                    }
                }
                catch (Exception exception) {
                    DebugHelper.warning(new com.sun.star.uno.Exception(exception.getMessage(), (Object)exception));
                }
            }
            xNamingService.registerObject(string4, (Object)xInterface);
        }
        catch (com.sun.star.uno.Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    private String getTempDir() {
        Object object;
        String string = System.getProperty("java.io.tmpdir");
        string = string.replace('\\', '/');
        String string2 = "";
        string2 = string.startsWith("//") ? "file:" : (string.startsWith("/") ? "file://" : "file:///");
        if (!string.endsWith("/") && ((File)(object = new File(string))).isDirectory()) {
            string = string + "/";
        }
        object = string2 + string;
        return object;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

