/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.calc;

import com.sun.star.beans.PropertyState;
import com.sun.star.beans.XPropertySet;
import com.sun.star.beans.XPropertyState;
import com.sun.star.frame.XModel;
import com.sun.star.helper.ApplicationImpl;
import com.sun.star.helper.HelperInterfaceAdaptor;
import com.sun.star.helper.calc.CalcBordersImpl;
import com.sun.star.helper.calc.CalcFontImpl;
import com.sun.star.helper.calc.CalcInteriorImpl;
import com.sun.star.helper.calc.XCalcBorders;
import com.sun.star.helper.calc.XCalcFont;
import com.sun.star.helper.calc.XCalcInterior;
import com.sun.star.helper.calc.XFormat;
import com.sun.star.helper.calc.range.Constants;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.NumberFormatter;
import com.sun.star.helper.common.NumericalHelper;
import com.sun.star.lang.Locale;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.script.BasicErrorException;
import com.sun.star.table.CellHoriJustify;
import com.sun.star.table.CellOrientation;
import com.sun.star.table.CellVertJustify;
import com.sun.star.text.WritingMode;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.CellProtection;
import com.sun.star.util.XNumberFormatTypes;
import com.sun.star.util.XNumberFormats;
import com.sun.star.util.XNumberFormatsSupplier;

public abstract class FormatImpl
extends HelperInterfaceAdaptor
implements XFormat,
Constants {
    protected XPropertySet mxPropertySet = null;
    protected XNumberFormatsSupplier mxNumberFormatsSupplier;
    protected XNumberFormats xNumberFormats = null;
    protected XNumberFormatTypes xNumberFormatTypes = null;
    protected XModel mxModel;
    protected XServiceInfo mxServiceInfo;
    protected boolean mbAddIndent = false;
    protected XPropertyState xPropertyState = null;
    protected boolean mbCheckAmbiguoity;
    private NumberFormatter oNumberFormatter = null;
    protected XMultiServiceFactory xMultiServiceFactory = null;
    private Locale m_aDefaultLocale = null;
    static /* synthetic */ Class class$com$sun$star$lang$XServiceInfo;
    static /* synthetic */ Class class$com$sun$star$util$XNumberFormatsSupplier;
    static /* synthetic */ Class class$com$sun$star$table$CellOrientation;
    static /* synthetic */ Class class$com$sun$star$util$XNumberFormatTypes;
    static /* synthetic */ Class class$com$sun$star$util$CellProtection;
    static /* synthetic */ Class class$com$sun$star$beans$XPropertyState;

    public FormatImpl(String string, HelperInterfaceAdaptor helperInterfaceAdaptor, XPropertySet xPropertySet, boolean bl) throws BasicErrorException {
        super(string, helperInterfaceAdaptor);
        try {
            this.mbCheckAmbiguoity = bl;
            this.mxPropertySet = xPropertySet;
            this.mxServiceInfo = (XServiceInfo)UnoRuntime.queryInterface((Class)(class$com$sun$star$lang$XServiceInfo == null ? (class$com$sun$star$lang$XServiceInfo = FormatImpl.class$("com.sun.star.lang.XServiceInfo")) : class$com$sun$star$lang$XServiceInfo), (Object)xPropertySet);
            this.mxModel = this.getXModel();
            this.verifyNullability(this.mxModel, "XModel Interface could not be retrieved");
            this.mxNumberFormatsSupplier = (XNumberFormatsSupplier)UnoRuntime.queryInterface((Class)(class$com$sun$star$util$XNumberFormatsSupplier == null ? (class$com$sun$star$util$XNumberFormatsSupplier = FormatImpl.class$("com.sun.star.util.XNumberFormatsSupplier")) : class$com$sun$star$util$XNumberFormatsSupplier), (Object)this.mxModel);
        }
        catch (com.sun.star.uno.Exception exception) {
            DebugHelper.exception(1004, "");
        }
    }

    public void verifyNullability(Object object, String string) throws BasicErrorException {
        if (object == null) {
            DebugHelper.exception(1004, string);
        }
    }

    public XServiceInfo getXServiceInfo() {
        return this.mxServiceInfo;
    }

    public void setVerticalAlignment(Object object) throws BasicErrorException {
        try {
            int n = NumericalHelper.toInt(object);
            switch (n) {
                case -4107: {
                    this.mxPropertySet.setPropertyValue("VertJustify", (Object)CellVertJustify.BOTTOM);
                    break;
                }
                case -4108: {
                    this.mxPropertySet.setPropertyValue("VertJustify", (Object)CellVertJustify.CENTER);
                    break;
                }
                case -4130: 
                case -4117: {
                    this.mxPropertySet.setPropertyValue("VertJustify", (Object)CellVertJustify.STANDARD);
                    break;
                }
                case -4160: {
                    this.mxPropertySet.setPropertyValue("VertJustify", (Object)CellVertJustify.TOP);
                    break;
                }
                default: {
                    this.mxPropertySet.setPropertyValue("VertJustify", (Object)CellVertJustify.STANDARD);
                    break;
                }
            }
        }
        catch (com.sun.star.uno.Exception exception) {
            DebugHelper.exception(1004, "");
        }
    }

    public Object getVerticalAlignment() throws BasicErrorException {
        Integer n = null;
        try {
            if (!this.isAmbiguous("VertJustify")) {
                int n2 = -4107;
                CellVertJustify cellVertJustify = (CellVertJustify)this.mxPropertySet.getPropertyValue("VertJustify");
                if (cellVertJustify == CellVertJustify.BOTTOM) {
                    n2 = -4107;
                }
                if (cellVertJustify == CellVertJustify.CENTER) {
                    n2 = -4108;
                }
                if (cellVertJustify == CellVertJustify.STANDARD) {
                    n2 = -4107;
                }
                if (cellVertJustify == CellVertJustify.TOP) {
                    n2 = -4160;
                }
                n = new Integer(n2);
            }
        }
        catch (com.sun.star.uno.Exception exception) {
            DebugHelper.exception(1004, "");
        }
        return n;
    }

    public void setHorizontalAlignment(Object object) throws BasicErrorException {
        try {
            int n = NumericalHelper.toInt(object);
            if (n == -4130) {
                this.mxPropertySet.setPropertyValue("HoriJustify", (Object)CellHoriJustify.BLOCK);
            }
            if (n == -4108) {
                this.mxPropertySet.setPropertyValue("HoriJustify", (Object)CellHoriJustify.CENTER);
            }
            if (n == -4117) {
                this.mxPropertySet.setPropertyValue("HoriJustify", (Object)CellHoriJustify.BLOCK);
            }
            if (n == -4131) {
                this.mxPropertySet.setPropertyValue("HoriJustify", (Object)CellHoriJustify.LEFT);
            }
            if (n == -4152) {
                this.mxPropertySet.setPropertyValue("HoriJustify", (Object)CellHoriJustify.RIGHT);
            }
        }
        catch (com.sun.star.uno.Exception exception) {
            DebugHelper.exception(1004, "");
        }
    }

    public Object getHorizontalAlignment() throws BasicErrorException {
        Integer n = null;
        try {
            if (!this.isAmbiguous("HoriJustify")) {
                int n2 = -4131;
                CellHoriJustify cellHoriJustify = (CellHoriJustify)this.mxPropertySet.getPropertyValue("HoriJustify");
                if (cellHoriJustify == CellHoriJustify.BLOCK) {
                    n2 = -4130;
                }
                if (cellHoriJustify == CellHoriJustify.CENTER) {
                    n2 = -4108;
                }
                if (cellHoriJustify == CellHoriJustify.LEFT) {
                    n2 = -4131;
                }
                if (cellHoriJustify == CellHoriJustify.RIGHT) {
                    n2 = -4152;
                }
                n = new Integer(n2);
            }
        }
        catch (com.sun.star.uno.Exception exception) {
            DebugHelper.exception(1004, "");
        }
        return n;
    }

    public void setOrientation(Object object) throws BasicErrorException {
        try {
            int n = NumericalHelper.toInt(object);
            if (n == -4170) {
                this.mxPropertySet.setPropertyValue("Orientation", (Object)CellOrientation.TOPBOTTOM);
            }
            if (n == -4128) {
                this.mxPropertySet.setPropertyValue("Orientation", (Object)CellOrientation.STANDARD);
                this.mxPropertySet.setPropertyValue("RotateAngle", (Object)new Integer(0));
            }
            if (n == -4171) {
                this.mxPropertySet.setPropertyValue("Orientation", (Object)CellOrientation.BOTTOMTOP);
            }
            if (n == -4166) {
                this.mxPropertySet.setPropertyValue("Orientation", (Object)CellOrientation.STACKED);
            }
        }
        catch (com.sun.star.uno.Exception exception) {
            DebugHelper.exception(1004, "");
        }
    }

    public Object getOrientation() throws BasicErrorException {
        Integer n = null;
        try {
            if (!this.isAmbiguous("Orientation")) {
                int n2 = -4128;
                CellOrientation cellOrientation = (CellOrientation)AnyConverter.toObject((Class)(class$com$sun$star$table$CellOrientation == null ? (class$com$sun$star$table$CellOrientation = FormatImpl.class$("com.sun.star.table.CellOrientation")) : class$com$sun$star$table$CellOrientation), (Object)this.mxPropertySet.getPropertyValue("Orientation"));
                switch (cellOrientation.getValue()) {
                    case 0: {
                        n2 = -4128;
                        break;
                    }
                    case 2: {
                        n2 = -4171;
                        break;
                    }
                    case 1: {
                        n2 = -4170;
                        break;
                    }
                    case 3: {
                        n2 = -4166;
                        break;
                    }
                    default: {
                        n2 = -4128;
                    }
                }
                n = new Integer(n2);
            }
        }
        catch (com.sun.star.uno.Exception exception) {
            DebugHelper.exception(1004, "");
        }
        return n;
    }

    public void setWrapText(Object object) throws BasicErrorException {
        try {
            this.mxPropertySet.setPropertyValue("IsTextWrapped", object);
        }
        catch (com.sun.star.uno.Exception exception) {
            DebugHelper.exception(1004, "");
        }
    }

    public Object getWrapText() throws BasicErrorException {
        Boolean bl = null;
        try {
            if (!this.isAmbiguous("IsTextWrapped")) {
                bl = (Boolean)this.mxPropertySet.getPropertyValue("IsTextWrapped");
            }
        }
        catch (com.sun.star.uno.Exception exception) {
            DebugHelper.exception(1004, "");
        }
        return bl;
    }

    public XCalcBorders Borders() throws BasicErrorException {
        return new CalcBordersImpl(this, this.mxPropertySet);
    }

    public XCalcFont Font() throws BasicErrorException {
        return new CalcFontImpl((HelperInterfaceAdaptor)this, this.mxPropertySet);
    }

    public XCalcInterior Interior() throws BasicErrorException {
        return new CalcInteriorImpl((HelperInterfaceAdaptor)this, this.mxPropertySet);
    }

    public Object getNumberFormatLocal() throws BasicErrorException {
        String string = "";
        try {
            if (!this.isAmbiguous("NumberFormat")) {
                this.initializeNumberFormats();
                int n = (Integer)this.mxPropertySet.getPropertyValue("NumberFormat");
                string = (String)this.xNumberFormats.getByKey(n).getPropertyValue("FormatString");
                string = string.toLowerCase();
            }
        }
        catch (com.sun.star.uno.Exception exception) {
            DebugHelper.exception(1004, "");
        }
        return string;
    }

    public Object getNumberFormat() throws BasicErrorException {
        String string = null;
        try {
            if (!this.isAmbiguous("NumberFormat")) {
                Locale locale = new Locale("en", "US", "");
                this.initializeNumberFormats();
                int n = (Integer)this.mxPropertySet.getPropertyValue("NumberFormat");
                int n2 = this.xNumberFormatTypes.getFormatForLocale(n, locale);
                string = (String)this.xNumberFormats.getByKey(n2).getPropertyValue("FormatString");
            }
        }
        catch (com.sun.star.uno.Exception exception) {
            DebugHelper.exception(1004, "");
        }
        return string;
    }

    protected void initializeNumberFormats() throws BasicErrorException {
        if (this.xNumberFormats == null) {
            this.xNumberFormats = this.mxNumberFormatsSupplier.getNumberFormats();
            this.xNumberFormatTypes = (XNumberFormatTypes)UnoRuntime.queryInterface((Class)(class$com$sun$star$util$XNumberFormatTypes == null ? (class$com$sun$star$util$XNumberFormatTypes = FormatImpl.class$("com.sun.star.util.XNumberFormatTypes")) : class$com$sun$star$util$XNumberFormatTypes), (Object)this.xNumberFormats);
        }
    }

    protected void setNumberFormat(Locale locale, String string) throws BasicErrorException {
        try {
            this.initializeNumberFormats();
            int n = this.xNumberFormats.queryKey(string, locale, true);
            if (n == -1) {
                this.xNumberFormats.addNew(string, locale);
            }
            this.mxPropertySet.setPropertyValue("NumberFormat", (Object)new Integer(n));
        }
        catch (com.sun.star.uno.Exception exception) {
            DebugHelper.exception(1004, "");
        }
    }

    public void setNumberFormatLocal(Object object) throws BasicErrorException {
        try {
            String string = NumericalHelper.toStringWithErrorMessage(object);
            string = string.toUpperCase();
            this.initializeNumberFormats();
            int n = (Integer)this.mxPropertySet.getPropertyValue("NumberFormat");
            Locale locale = (Locale)this.xNumberFormats.getByKey(n).getPropertyValue("Locale");
            int n2 = this.xNumberFormats.queryKey(string, locale, true);
            if (n2 == -1) {
                n2 = this.xNumberFormats.addNew(string, locale);
            }
            this.mxPropertySet.setPropertyValue("NumberFormat", (Object)new Integer(n2));
        }
        catch (com.sun.star.uno.Exception exception) {
            DebugHelper.exception(1004, "");
        }
    }

    protected Locale getDefaultLocale() {
        if (this.m_aDefaultLocale == null) {
            this.m_aDefaultLocale = new Locale("en", "US", "");
        }
        return this.m_aDefaultLocale;
    }

    public void setNumberFormat(Object object) throws BasicErrorException {
        try {
            String string = NumericalHelper.toStringWithErrorMessage(object);
            string = string.toUpperCase();
            Locale locale = this.getDefaultLocale();
            this.initializeNumberFormats();
            int n = this.xNumberFormats.queryKey(string, locale, true);
            if (n == -1) {
                n = this.xNumberFormats.addNew(string, locale);
            }
            Locale locale2 = (Locale)this.xNumberFormats.getByKey(n).getPropertyValue("Locale");
            int n2 = this.xNumberFormatTypes.getFormatForLocale(n, locale2);
            this.mxPropertySet.setPropertyValue("NumberFormat", (Object)new Integer(n2));
        }
        catch (com.sun.star.uno.Exception exception) {
            DebugHelper.exception(1004, "");
        }
    }

    public void setIndentLevel(Object object) throws BasicErrorException {
        try {
            int n = NumericalHelper.toInt(object);
            CellHoriJustify cellHoriJustify = (CellHoriJustify)this.mxPropertySet.getPropertyValue("HoriJustify");
            if (cellHoriJustify == CellHoriJustify.STANDARD) {
                this.mxPropertySet.setPropertyValue("HoriJustify", (Object)CellHoriJustify.LEFT);
            }
            this.mxPropertySet.setPropertyValue("ParaIndent", (Object)new Short((short)((double)n * 352.8)));
        }
        catch (com.sun.star.uno.Exception exception) {
            DebugHelper.exception(1004, "");
        }
    }

    public Object getIndentLevel() throws BasicErrorException {
        Integer n;
        block3: {
            n = null;
            try {
                if (this.isAmbiguous("ParaIndent")) break block3;
                Short s = (Short)this.mxPropertySet.getPropertyValue("ParaIndent");
                if (s != null) {
                    n = new Integer((int)Math.round((double)s.intValue() / 352.8));
                    break block3;
                }
                n = new Integer(0);
            }
            catch (com.sun.star.uno.Exception exception) {
                DebugHelper.exception(1004, "");
            }
        }
        return n;
    }

    public void setLocked(Object object) throws BasicErrorException {
        try {
            boolean bl = NumericalHelper.toBoolean(object);
            CellProtection cellProtection = (CellProtection)AnyConverter.toObject((Class)(class$com$sun$star$util$CellProtection == null ? (class$com$sun$star$util$CellProtection = FormatImpl.class$("com.sun.star.util.CellProtection")) : class$com$sun$star$util$CellProtection), (Object)this.mxPropertySet.getPropertyValue("CellProtection"));
            cellProtection.IsLocked = bl;
            this.mxPropertySet.setPropertyValue("CellProtection", (Object)cellProtection);
        }
        catch (com.sun.star.uno.Exception exception) {
            DebugHelper.exception(1004, "");
        }
    }

    public void setFormulaHidden(Object object) throws BasicErrorException {
        try {
            boolean bl = NumericalHelper.toBoolean(object);
            CellProtection cellProtection = (CellProtection)AnyConverter.toObject((Class)(class$com$sun$star$util$CellProtection == null ? (class$com$sun$star$util$CellProtection = FormatImpl.class$("com.sun.star.util.CellProtection")) : class$com$sun$star$util$CellProtection), (Object)this.mxPropertySet.getPropertyValue("CellProtection"));
            cellProtection.IsFormulaHidden = bl;
            this.mxPropertySet.setPropertyValue("CellProtection", (Object)cellProtection);
        }
        catch (com.sun.star.uno.Exception exception) {
            DebugHelper.exception(1004, "");
        }
    }

    public Object getLocked() throws BasicErrorException {
        CellProtection cellProtection = null;
        try {
            if (!this.isAmbiguous("CellProtection")) {
                cellProtection = (CellProtection)AnyConverter.toObject((Class)(class$com$sun$star$util$CellProtection == null ? (class$com$sun$star$util$CellProtection = FormatImpl.class$("com.sun.star.util.CellProtection")) : class$com$sun$star$util$CellProtection), (Object)this.mxPropertySet.getPropertyValue("CellProtection"));
                return new Boolean(cellProtection.IsLocked);
            }
        }
        catch (com.sun.star.uno.Exception exception) {
            DebugHelper.exception(1004, "");
        }
        return cellProtection;
    }

    public Object getFormulaHidden() throws BasicErrorException {
        Boolean bl = null;
        try {
            if (!this.isAmbiguous("CellProtection")) {
                CellProtection cellProtection = (CellProtection)AnyConverter.toObject((Class)(class$com$sun$star$util$CellProtection == null ? (class$com$sun$star$util$CellProtection = FormatImpl.class$("com.sun.star.util.CellProtection")) : class$com$sun$star$util$CellProtection), (Object)this.mxPropertySet.getPropertyValue("CellProtection"));
                bl = new Boolean(cellProtection.IsFormulaHidden);
            }
        }
        catch (com.sun.star.uno.Exception exception) {
            DebugHelper.exception(1004, "");
        }
        return bl;
    }

    public void setAddIndent(Object object) throws BasicErrorException {
        this.mbAddIndent = NumericalHelper.toBooleanWithErrorMessage(object);
    }

    public Object getAddIndent() {
        return new Boolean(this.mbAddIndent);
    }

    public void setShrinkToFit(Object object) throws BasicErrorException {
        try {
            this.mxPropertySet.setPropertyValue("ShrinkToFit", object);
        }
        catch (com.sun.star.uno.Exception exception) {
            DebugHelper.exception(73, "");
        }
    }

    public Object getShrinkToFit() throws BasicErrorException {
        try {
            if (!this.isAmbiguous("ShrinkToFit")) {
                return (Boolean)this.mxPropertySet.getPropertyValue("ShrinkToFit");
            }
        }
        catch (com.sun.star.uno.Exception exception) {
            DebugHelper.exception(73, "");
        }
        return null;
    }

    public void setReadingOrder(Object object) throws BasicErrorException {
        try {
            int n = NumericalHelper.toInt(object);
            switch (n) {
                case -5003: {
                    this.mxPropertySet.setPropertyValue("WritingMode", (Object)WritingMode.LR_TB);
                    break;
                }
                case -5004: {
                    this.mxPropertySet.setPropertyValue("WritingMode", (Object)WritingMode.RL_TB);
                    break;
                }
                case -5002: {
                    DebugHelper.exception(73, "");
                    break;
                }
                default: {
                    DebugHelper.exception(1004, "");
                    break;
                }
            }
        }
        catch (com.sun.star.uno.Exception exception) {
            DebugHelper.exception(1004, "");
        }
    }

    public Object getReadingOrder() throws BasicErrorException {
        Integer n = null;
        try {
            if (!this.isAmbiguous("WritingMode")) {
                WritingMode writingMode = (WritingMode)this.mxPropertySet.getPropertyValue("WritingMode");
                switch (writingMode.getValue()) {
                    case 0: {
                        n = new Integer(-5003);
                        break;
                    }
                    case 1: {
                        n = new Integer(-5004);
                        break;
                    }
                    default: {
                        n = new Integer(-5004);
                    }
                }
            }
        }
        catch (com.sun.star.uno.Exception exception) {
            DebugHelper.exception(73, "");
        }
        return n;
    }

    protected XPropertyState getXPropertyState() {
        if (this.xPropertyState == null) {
            this.xPropertyState = (XPropertyState)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertyState == null ? (class$com$sun$star$beans$XPropertyState = FormatImpl.class$("com.sun.star.beans.XPropertyState")) : class$com$sun$star$beans$XPropertyState), (Object)this.mxPropertySet);
        }
        return this.xPropertyState;
    }

    protected boolean isAmbiguous(String string) throws BasicErrorException {
        try {
            if (!this.mbCheckAmbiguoity) {
                return false;
            }
            boolean bl = this.getXPropertyState().getPropertyState(string) == PropertyState.AMBIGUOUS_VALUE;
            return bl;
        }
        catch (com.sun.star.uno.Exception exception) {
            DebugHelper.exception(1004, "");
            return true;
        }
    }

    protected NumberFormatter getNumberFormatter() throws BasicErrorException {
        try {
            if (this.oNumberFormatter == null) {
                this.initializeNumberFormats();
                this.oNumberFormatter = new NumberFormatter(this.getXMultiServiceFactory(), this.mxNumberFormatsSupplier);
            }
        }
        catch (Exception exception) {
            DebugHelper.exception(1004, "");
        }
        return this.oNumberFormatter;
    }

    protected XMultiServiceFactory getXMultiServiceFactory() {
        if (this.xMultiServiceFactory == null) {
            this.xMultiServiceFactory = ApplicationImpl.getXMultiServiceFactory();
        }
        return this.xMultiServiceFactory;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

