/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.calc;

import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.frame.XModel;
import com.sun.star.helper.HelperInterfaceAdaptor;
import com.sun.star.helper.calc.CalcImpl;
import com.sun.star.helper.calc.CalcStylesImpl;
import com.sun.star.helper.calc.ConditionImpl;
import com.sun.star.helper.calc.FormatConditionImpl;
import com.sun.star.helper.calc.SpreadsheetImpl;
import com.sun.star.helper.calc.XCalcStyle;
import com.sun.star.helper.calc.XCalcStyles;
import com.sun.star.helper.calc.XFormatCondition;
import com.sun.star.helper.calc.XFormatConditions;
import com.sun.star.helper.calc.range.RangeImpl;
import com.sun.star.helper.calc.range.RangesImpl;
import com.sun.star.helper.common.ContainerUtilities;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.NumericalHelper;
import com.sun.star.helper.common.Properties;
import com.sun.star.helper.constant.XlFormatConditionType;
import com.sun.star.script.BasicErrorException;
import com.sun.star.sheet.ConditionOperator;
import com.sun.star.sheet.XSheetConditionalEntries;
import com.sun.star.sheet.XSheetConditionalEntry;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import java.util.Vector;

public class FormatConditionsImpl
extends HelperInterfaceAdaptor
implements XFormatConditions,
XlFormatConditionType {
    protected static final String __serviceName = "com.sun.star.helper.calc.FormatConditions";
    protected XSheetConditionalEntries mxSheetConditionalEntries;
    protected final String sStyleNamePrefix = "Excel_CondFormat";
    protected XCalcStyles mxStyles;
    protected XPropertySet mxParentRangePropertySet;
    protected HelperInterfaceAdaptor moParent;
    static /* synthetic */ Class class$com$sun$star$beans$XPropertySet;
    static /* synthetic */ Class class$com$sun$star$sheet$XSheetConditionalEntry;

    public FormatConditionsImpl(HelperInterfaceAdaptor helperInterfaceAdaptor, XSheetConditionalEntries xSheetConditionalEntries) throws BasicErrorException {
        super(__serviceName, helperInterfaceAdaptor);
        HelperInterfaceAdaptor helperInterfaceAdaptor2;
        this.mxSheetConditionalEntries = xSheetConditionalEntries;
        CalcImpl calcImpl = (CalcImpl)this.Application();
        XModel xModel = null;
        this.moParent = helperInterfaceAdaptor;
        if (helperInterfaceAdaptor instanceof RangeImpl) {
            helperInterfaceAdaptor2 = (RangeImpl)helperInterfaceAdaptor;
            xModel = helperInterfaceAdaptor2.getXModel();
            this.mxParentRangePropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = FormatConditionsImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)((RangeImpl)helperInterfaceAdaptor2).getUnoObject());
        } else if (helperInterfaceAdaptor instanceof RangesImpl) {
            helperInterfaceAdaptor2 = (RangesImpl)helperInterfaceAdaptor;
            xModel = helperInterfaceAdaptor2.getXModel();
            this.mxParentRangePropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = FormatConditionsImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)((RangesImpl)helperInterfaceAdaptor2).getUnoObject());
        } else {
            DebugHelper.exception(5, "");
        }
        helperInterfaceAdaptor2 = new SpreadsheetImpl(calcImpl, xModel);
        this.mxStyles = new CalcStylesImpl(helperInterfaceAdaptor2);
    }

    public void Delete() throws BasicErrorException {
        try {
            int n = this.mxSheetConditionalEntries.getCount();
            int n2 = n - 1;
            while (n2 >= 0) {
                XSheetConditionalEntry xSheetConditionalEntry = (XSheetConditionalEntry)UnoRuntime.queryInterface((Class)(class$com$sun$star$sheet$XSheetConditionalEntry == null ? FormatConditionsImpl.class$("com.sun.star.sheet.XSheetConditionalEntry") : class$com$sun$star$sheet$XSheetConditionalEntry), (Object)this.mxSheetConditionalEntries.getByIndex(n2));
                ((CalcStylesImpl)this.mxStyles).delete(xSheetConditionalEntry.getStyleName());
                this.mxSheetConditionalEntries.removeByIndex(n2);
                --n2;
            }
            this.notifyRange();
        }
        catch (Exception exception) {
            DebugHelper.exception(1004, "");
        }
    }

    public XFormatCondition Item(Object object) throws BasicErrorException {
        try {
            int n = NumericalHelper.toIntWithErrorMessage(object);
            if (n < 1 || n > this.mxSheetConditionalEntries.getCount()) {
                DebugHelper.exception(9, "");
                return null;
            }
            XSheetConditionalEntry xSheetConditionalEntry = (XSheetConditionalEntry)UnoRuntime.queryInterface((Class)(class$com$sun$star$sheet$XSheetConditionalEntry == null ? (class$com$sun$star$sheet$XSheetConditionalEntry = FormatConditionsImpl.class$("com.sun.star.sheet.XSheetConditionalEntry")) : class$com$sun$star$sheet$XSheetConditionalEntry), (Object)this.mxSheetConditionalEntries.getByIndex(n - 1));
            XCalcStyle xCalcStyle = this.mxStyles.Item(xSheetConditionalEntry.getStyleName());
            return new FormatConditionImpl(this.moParent, xSheetConditionalEntry, xCalcStyle, this, this.mxParentRangePropertySet);
        }
        catch (Exception exception) {
            DebugHelper.exception(1004, "");
            return null;
        }
    }

    public XFormatCondition Add(int n, Object object, Object object2, Object object3) throws BasicErrorException {
        return this.Add(n, object, object2, object3, null);
    }

    protected XFormatCondition Add(int n, Object object, Object object2, Object object3, XCalcStyle xCalcStyle) throws BasicErrorException {
        try {
            PropertyValue[] propertyValueArray;
            XCalcStyle xCalcStyle2 = xCalcStyle;
            String string = "";
            if (xCalcStyle2 == null) {
                string = this.getStyleName();
                xCalcStyle2 = this.mxStyles.Add(string, null);
            } else {
                string = xCalcStyle2.getName();
            }
            Vector vector = new Vector();
            ConditionOperator conditionOperator = FormatConditionImpl.retrieveAPIType(n, null);
            if (conditionOperator.getValue() == 9) {
                Properties.addPropertyToVector("Operator", ConditionOperator.FORMULA, vector);
            } else {
                propertyValueArray = ConditionImpl.retrieveAPIOperator(object);
                Properties.addPropertyToVector("Operator", propertyValueArray, vector);
            }
            Properties.addPropertyToVector("Formula1", object2, vector);
            Properties.addPropertyToVector("Formula2", object3, vector);
            Properties.addPropertyToVector("StyleName", string, vector);
            propertyValueArray = new PropertyValue[vector.size()];
            vector.toArray(propertyValueArray);
            this.mxSheetConditionalEntries.addNew(propertyValueArray);
            int n2 = this.mxSheetConditionalEntries.getCount() - 1;
            while (n2 >= 0) {
                XSheetConditionalEntry xSheetConditionalEntry = (XSheetConditionalEntry)UnoRuntime.queryInterface((Class)(class$com$sun$star$sheet$XSheetConditionalEntry == null ? FormatConditionsImpl.class$("com.sun.star.sheet.XSheetConditionalEntry") : class$com$sun$star$sheet$XSheetConditionalEntry), (Object)this.mxSheetConditionalEntries.getByIndex(n2));
                if (xSheetConditionalEntry.getStyleName().equals(string)) {
                    FormatConditionImpl formatConditionImpl = new FormatConditionImpl(this.moParent, xSheetConditionalEntry, xCalcStyle2, this, this.mxParentRangePropertySet);
                    this.notifyRange();
                    return formatConditionImpl;
                }
                --n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        DebugHelper.exception(1004, "");
        return null;
    }

    protected String getStyleName() {
        String[] stringArray = ((CalcStylesImpl)this.mxStyles).getStyleNames();
        return ContainerUtilities.getUniqueName(stringArray, "Excel_CondFormat", "_");
    }

    public int Count() throws BasicErrorException {
        return this.mxSheetConditionalEntries.getCount();
    }

    protected void removeFormatCondition(String string, boolean bl) throws BasicErrorException {
        try {
            int n = 0;
            while (n < this.mxSheetConditionalEntries.getCount()) {
                XSheetConditionalEntry xSheetConditionalEntry = (XSheetConditionalEntry)UnoRuntime.queryInterface((Class)(class$com$sun$star$sheet$XSheetConditionalEntry == null ? FormatConditionsImpl.class$("com.sun.star.sheet.XSheetConditionalEntry") : class$com$sun$star$sheet$XSheetConditionalEntry), (Object)this.mxSheetConditionalEntries.getByIndex(n));
                if (string.equals(xSheetConditionalEntry.getStyleName())) {
                    this.mxSheetConditionalEntries.removeByIndex(n);
                    if (bl) {
                        ((CalcStylesImpl)this.mxStyles).delete(string);
                    }
                    return;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            DebugHelper.exception(1004, "");
        }
    }

    protected void notifyRange() throws BasicErrorException {
        try {
            this.mxParentRangePropertySet.setPropertyValue("ConditionalFormat", (Object)this.mxSheetConditionalEntries);
        }
        catch (Exception exception) {
            DebugHelper.exception(1004, "");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

