/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.calc;

import com.sun.star.beans.XPropertySet;
import com.sun.star.helper.HelperInterfaceAdaptor;
import com.sun.star.helper.calc.ConditionImpl;
import com.sun.star.helper.calc.FormatConditionsImpl;
import com.sun.star.helper.calc.XCalcBorders;
import com.sun.star.helper.calc.XCalcFont;
import com.sun.star.helper.calc.XCalcInterior;
import com.sun.star.helper.calc.XCalcStyle;
import com.sun.star.helper.calc.XFormatCondition;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.NumericalHelper;
import com.sun.star.helper.constant.XlFormatConditionType;
import com.sun.star.script.BasicErrorException;
import com.sun.star.sheet.ConditionOperator;
import com.sun.star.sheet.XSheetCondition;
import com.sun.star.sheet.XSheetConditionalEntries;
import com.sun.star.sheet.XSheetConditionalEntry;
import com.sun.star.uno.Exception;

public class FormatConditionImpl
extends ConditionImpl
implements XFormatCondition,
XlFormatConditionType {
    protected static final String __serviceName = "com.sun.star.helper.calc.FormatCondition";
    protected XSheetConditionalEntry mxSheetConditionalEntry = null;
    protected String msStyleName;
    protected XSheetConditionalEntries mxSheetConditionalEntries;
    protected FormatConditionsImpl moFormatConditionsImpl;
    protected XCalcStyle mxStyle;
    protected XPropertySet mxParentRangePropertySet;

    public FormatConditionImpl(HelperInterfaceAdaptor helperInterfaceAdaptor, XSheetConditionalEntry xSheetConditionalEntry, XCalcStyle xCalcStyle, FormatConditionsImpl formatConditionsImpl, XPropertySet xPropertySet) throws BasicErrorException {
        super(__serviceName, helperInterfaceAdaptor, xSheetConditionalEntry);
        this.mxSheetConditionalEntries = formatConditionsImpl.mxSheetConditionalEntries;
        this.mxSheetConditionalEntry = xSheetConditionalEntry;
        this.mxStyle = xCalcStyle;
        this.msStyleName = this.mxStyle.getName();
        this.mxParentRangePropertySet = xPropertySet;
        this.moFormatConditionsImpl = formatConditionsImpl;
    }

    public void Delete() throws BasicErrorException {
        this.moFormatConditionsImpl.removeFormatCondition(this.msStyleName, true);
        this.notifyRange();
    }

    public void Modify(int n, Object object, Object object2, Object object3) throws BasicErrorException {
        try {
            this.moFormatConditionsImpl.removeFormatCondition(this.msStyleName, false);
            this.moFormatConditionsImpl.Add(n, object, object2, object3, this.mxStyle);
        }
        catch (Exception exception) {
            DebugHelper.exception(1004, "");
        }
    }

    public XCalcInterior Interior() throws BasicErrorException {
        return this.mxStyle.Interior();
    }

    public XCalcBorders Borders() throws BasicErrorException {
        return this.mxStyle.Borders();
    }

    public XCalcFont Font() throws BasicErrorException {
        return this.mxStyle.Font();
    }

    protected static ConditionOperator retrieveAPIType(int n, XSheetCondition xSheetCondition) throws BasicErrorException {
        ConditionOperator conditionOperator = ConditionOperator.getDefault();
        switch (n) {
            case 2: {
                conditionOperator = ConditionOperator.FORMULA;
                break;
            }
            case 1: {
                if (!NumericalHelper.isValid(xSheetCondition) || xSheetCondition.getOperator().getValue() != 9) break;
                conditionOperator = ConditionOperator.getDefault();
                break;
            }
            default: {
                DebugHelper.exception(1004, "");
            }
        }
        return conditionOperator;
    }

    public int Type() throws BasicErrorException {
        int n = 0;
        n = this.mxSheetCondition.getOperator() == ConditionOperator.FORMULA ? 2 : 1;
        return n;
    }

    public int Operator() throws BasicErrorException {
        return super.Operator(true);
    }

    protected void notifyRange() throws BasicErrorException {
        try {
            this.mxParentRangePropertySet.setPropertyValue("ConditionalFormat", (Object)this.mxSheetConditionalEntries);
        }
        catch (Exception exception) {
            DebugHelper.exception(1004, "");
        }
    }
}

