/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.calc;

import com.sun.star.beans.XPropertySet;
import com.sun.star.helper.HelperInterfaceAdaptor;
import com.sun.star.helper.calc.CalcBorderImpl;
import com.sun.star.helper.calc.CalcHelper;
import com.sun.star.helper.calc.CalcImpl;
import com.sun.star.helper.calc.SpreadsheetImpl;
import com.sun.star.helper.calc.XCalcBorder;
import com.sun.star.helper.calc.XCalcBorders;
import com.sun.star.helper.calc.range.RangeHelperImpl;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.XUnoAccess;
import com.sun.star.helper.constant.XlBorderWeight;
import com.sun.star.helper.constant.XlBordersIndex;
import com.sun.star.helper.constant.XlLineStyle;
import com.sun.star.script.BasicErrorException;
import com.sun.star.table.BorderLine;
import com.sun.star.table.TableBorder;
import com.sun.star.uno.Exception;

public class CalcBordersImpl
extends HelperInterfaceAdaptor
implements XCalcBorders,
XlBordersIndex,
XlBorderWeight,
XlLineStyle,
XUnoAccess {
    protected static final String __serviceName = "com.sun.star.helper.calc.Borders";
    protected XPropertySet mxPropertySet;
    protected TableBorder maTableBorder;
    protected SpreadsheetImpl mxSpreadsheet;
    protected boolean bIsCell;
    protected static final int THINWIDTH = 35;
    protected static final int MEDIUMWIDTH = 71;
    protected static final int THICKWIDTH = 118;

    public CalcBordersImpl(HelperInterfaceAdaptor helperInterfaceAdaptor, XPropertySet xPropertySet) throws BasicErrorException {
        super(__serviceName, helperInterfaceAdaptor);
        try {
            this.mxPropertySet = xPropertySet;
            this.maTableBorder = (TableBorder)this.mxPropertySet.getPropertyValue("TableBorder");
            CalcImpl calcImpl = (CalcImpl)this.Application();
            this.mxSpreadsheet = CalcImpl.getSpreadsheet(this.getXModel());
            this.bIsCell = RangeHelperImpl.isCellRangeACell(this.mxPropertySet);
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    public int Count() throws BasicErrorException {
        return 6;
    }

    public XCalcBorder Item(int n) throws BasicErrorException {
        CalcBorderImpl calcBorderImpl = null;
        switch (n) {
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                calcBorderImpl = new CalcBorderImpl((HelperInterfaceAdaptor)this, this.mxPropertySet, n);
                break;
            }
            default: {
                DebugHelper.exception(1004, "");
            }
        }
        return calcBorderImpl;
    }

    public int getColor() throws BasicErrorException {
        int n = 0;
        if (this.bIsCell && this.areAllBorderColorsSame()) {
            n = CalcHelper.swapFirstAndThirdByte(this.maTableBorder.TopLine.Color);
        }
        return n;
    }

    protected boolean areAllBorderColorsSame() {
        if (this.bIsCell) {
            return this.maTableBorder.TopLine.Color == this.maTableBorder.BottomLine.Color && this.maTableBorder.TopLine.Color == this.maTableBorder.LeftLine.Color && this.maTableBorder.TopLine.Color == this.maTableBorder.RightLine.Color;
        }
        return this.maTableBorder.TopLine.Color == this.maTableBorder.BottomLine.Color && this.maTableBorder.TopLine.Color == this.maTableBorder.LeftLine.Color && this.maTableBorder.TopLine.Color == this.maTableBorder.HorizontalLine.Color && this.maTableBorder.TopLine.Color == this.maTableBorder.VerticalLine.Color && this.maTableBorder.TopLine.Color == this.maTableBorder.RightLine.Color;
    }

    public void setColor(int n) throws BasicErrorException {
        int n2 = CalcHelper.swapFirstAndThirdByte(n);
        try {
            this.maTableBorder.TopLine.Color = n2;
            this.maTableBorder.BottomLine.Color = n2;
            this.maTableBorder.LeftLine.Color = n2;
            this.maTableBorder.RightLine.Color = n2;
            this.maTableBorder.HorizontalLine.Color = n2;
            this.maTableBorder.VerticalLine.Color = n2;
            this.mxPropertySet.setPropertyValue("TableBorder", (Object)this.maTableBorder);
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    public int getColorIndex() throws BasicErrorException {
        int n = 0;
        int n2 = 0;
        if (this.bIsCell) {
            n = this.areAllBorderColorsSame() ? this.maTableBorder.TopLine.Color : -1;
        }
        if (n == -1) {
            return n;
        }
        n2 = 0;
        while (n2 < 56) {
            if (n == this.mxSpreadsheet.getColorAtIndex(n2)) break;
            ++n2;
        }
        if (n2 == 56) {
            n2 = -2;
        }
        return n2 + 1;
    }

    public void setColorIndex(int n) throws BasicErrorException {
        int n2 = 0;
        n2 = this.mxSpreadsheet.getColorAtIndex(n - 1);
        try {
            this.maTableBorder.TopLine.Color = n2;
            this.maTableBorder.BottomLine.Color = n2;
            this.maTableBorder.LeftLine.Color = n2;
            this.maTableBorder.RightLine.Color = n2;
            this.maTableBorder.HorizontalLine.Color = n2;
            this.maTableBorder.VerticalLine.Color = n2;
            this.mxPropertySet.setPropertyValue("TableBorder", (Object)this.maTableBorder);
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    protected boolean areAllLineWidthsSame() {
        if (this.bIsCell) {
            return this.maTableBorder.TopLine.OuterLineWidth == this.maTableBorder.BottomLine.OuterLineWidth && this.maTableBorder.TopLine.OuterLineWidth == this.maTableBorder.LeftLine.OuterLineWidth && this.maTableBorder.TopLine.OuterLineWidth == this.maTableBorder.RightLine.OuterLineWidth;
        }
        return this.maTableBorder.TopLine.OuterLineWidth == this.maTableBorder.BottomLine.OuterLineWidth && this.maTableBorder.TopLine.OuterLineWidth == this.maTableBorder.LeftLine.OuterLineWidth && this.maTableBorder.TopLine.OuterLineWidth == this.maTableBorder.HorizontalLine.OuterLineWidth && this.maTableBorder.TopLine.OuterLineWidth == this.maTableBorder.VerticalLine.OuterLineWidth && this.maTableBorder.TopLine.OuterLineWidth == this.maTableBorder.RightLine.OuterLineWidth;
    }

    public int getLineStyle() throws BasicErrorException {
        int n;
        block5: {
            n = -4142;
            try {
                this.maTableBorder = (TableBorder)this.mxPropertySet.getPropertyValue("TableBorder");
                if (!this.areAllLineWidthsSame()) break block5;
                if (this.maTableBorder.TopLine.LineDistance != 0) {
                    n = -4119;
                } else if (this.maTableBorder.TopLine.OuterLineWidth != 0) {
                    n = 1;
                }
            }
            catch (Exception exception) {
                DebugHelper.exception(exception);
            }
        }
        return n;
    }

    protected void setLineWidthsAndDistance(BorderLine borderLine, short s, short s2, short s3) {
        borderLine.InnerLineWidth = s;
        borderLine.OuterLineWidth = s2;
        borderLine.LineDistance = s3;
    }

    protected void setLineWidth(BorderLine borderLine, short s, short s2) {
        borderLine.InnerLineWidth = s;
        borderLine.OuterLineWidth = s2;
    }

    public void setLineStyle(int n) throws BasicErrorException {
        try {
            if (n == -4142) {
                this.setNoneLineStyle(this.maTableBorder.TopLine);
                this.setNoneLineStyle(this.maTableBorder.BottomLine);
                this.setNoneLineStyle(this.maTableBorder.LeftLine);
                this.setNoneLineStyle(this.maTableBorder.RightLine);
                this.setNoneLineStyle(this.maTableBorder.VerticalLine);
                this.setNoneLineStyle(this.maTableBorder.HorizontalLine);
            }
            if (n == -4119) {
                this.setDoubleLineStyle(this.maTableBorder.TopLine);
                this.setDoubleLineStyle(this.maTableBorder.BottomLine);
                this.setDoubleLineStyle(this.maTableBorder.LeftLine);
                this.setDoubleLineStyle(this.maTableBorder.RightLine);
                this.setDoubleLineStyle(this.maTableBorder.VerticalLine);
                this.setDoubleLineStyle(this.maTableBorder.HorizontalLine);
            }
            if (n == 1) {
                this.setContinuousLineStyle(this.maTableBorder.TopLine);
                this.setContinuousLineStyle(this.maTableBorder.BottomLine);
                this.setContinuousLineStyle(this.maTableBorder.LeftLine);
                this.setContinuousLineStyle(this.maTableBorder.RightLine);
                this.setContinuousLineStyle(this.maTableBorder.VerticalLine);
                this.setContinuousLineStyle(this.maTableBorder.HorizontalLine);
            }
            this.mxPropertySet.setPropertyValue("TableBorder", (Object)this.maTableBorder);
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    protected void setNoneLineStyle(BorderLine borderLine) {
        this.setLineWidthsAndDistance(borderLine, (short)0, (short)0, (short)0);
    }

    protected void setDoubleLineStyle(BorderLine borderLine) {
        borderLine.LineDistance = (short)35;
        if (borderLine.OuterLineWidth == 118) {
            borderLine.InnerLineWidth = (short)35;
            borderLine.OuterLineWidth = (short)35;
        }
    }

    protected void setContinuousLineStyle(BorderLine borderLine) {
        borderLine.LineDistance = 0;
        if (borderLine.OuterLineWidth == 35) {
            borderLine.InnerLineWidth = 0;
            borderLine.OuterLineWidth = (short)118;
        }
    }

    public int getWeight() throws BasicErrorException {
        int n = -4138;
        if (this.areAllLineWidthsSame()) {
            if (this.maTableBorder.TopLine.OuterLineWidth == 35 && this.maTableBorder.TopLine.LineDistance == 0) {
                n = 2;
            }
            if (this.maTableBorder.TopLine.OuterLineWidth == 35 && this.maTableBorder.TopLine.LineDistance == 35) {
                n = 4;
            }
            if (this.maTableBorder.TopLine.OuterLineWidth == 71) {
                n = -4138;
            }
            if (this.maTableBorder.TopLine.OuterLineWidth == 118) {
                n = 4;
            }
        }
        return n;
    }

    public void setWeight(int n) throws BasicErrorException {
        short s = 0;
        short s2 = 0;
        short s3 = 0;
        try {
            switch (n) {
                case 1: {
                    s = 0;
                    s2 = 0;
                    break;
                }
                case 2: {
                    s3 = 0;
                    s = 35;
                    s2 = 0;
                    break;
                }
                case -4138: {
                    s3 = 0;
                    s = 71;
                    s2 = 0;
                    break;
                }
                case 4: {
                    if (this.maTableBorder.TopLine.LineDistance == 35) {
                        s = 35;
                        s2 = 35;
                        break;
                    }
                    s = 118;
                    s2 = 0;
                    break;
                }
                default: {
                    s = 0;
                    s2 = 0;
                }
            }
            this.setLineWidthsAndDistance(this.maTableBorder.TopLine, s2, s, s3);
            this.setLineWidthsAndDistance(this.maTableBorder.BottomLine, s2, s, s3);
            this.setLineWidthsAndDistance(this.maTableBorder.LeftLine, s2, s, s3);
            this.setLineWidthsAndDistance(this.maTableBorder.RightLine, s2, s, s3);
            this.setLineWidthsAndDistance(this.maTableBorder.VerticalLine, s2, s, s3);
            this.setLineWidthsAndDistance(this.maTableBorder.HorizontalLine, s2, s, s3);
            this.mxPropertySet.setPropertyValue("TableBorder", (Object)this.maTableBorder);
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    public Object getUnoObject() throws BasicErrorException {
        return this.maTableBorder;
    }
}

