/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.calc;

import com.sun.star.beans.XPropertySet;
import com.sun.star.helper.HelperInterfaceAdaptor;
import com.sun.star.helper.calc.AxisImpl;
import com.sun.star.helper.calc.ChartImpl;
import com.sun.star.helper.calc.XAxes;
import com.sun.star.helper.calc.XAxis;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.NumericalHelper;
import com.sun.star.helper.constant.XlAxisGroup;
import com.sun.star.helper.constant.XlAxisType;
import com.sun.star.script.BasicErrorException;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;

public class AxesImpl
extends HelperInterfaceAdaptor
implements XAxes,
XlAxisType,
XlAxisGroup {
    protected static final String __serviceName = "com.sun.star.helper.calc.Axes";
    protected ChartImpl moChartParent;

    public AxesImpl(HelperInterfaceAdaptor helperInterfaceAdaptor) {
        super(__serviceName, helperInterfaceAdaptor);
        if (helperInterfaceAdaptor instanceof ChartImpl) {
            this.moChartParent = (ChartImpl)helperInterfaceAdaptor;
        }
    }

    public XAxis Item(int n, Object object) throws BasicErrorException {
        try {
            int n2 = 1;
            if (n == 1 || n == 3 || n == 2) {
                if (NumericalHelper.isValidAndNumerical(object)) {
                    n2 = AnyConverter.toInt((Object)object);
                }
                if (n2 != 1 && n2 != 2) {
                    throw new BasicErrorException("", null, 1004, "");
                }
                XPropertySet xPropertySet = this.moChartParent.getAxisPropertySet(n, n2);
                if (xPropertySet != null) {
                    return new AxisImpl(this, xPropertySet, n, n2);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        DebugHelper.exception(1004, "");
        return null;
    }

    public int Count() throws BasicErrorException {
        int n;
        block7: {
            n = 0;
            try {
                if (this.moChartParent == null) break block7;
                if (AnyConverter.toBoolean((Object)this.moChartParent.mxDiagramPropertySet.getPropertyValue("HasXAxis"))) {
                    ++n;
                }
                if (AnyConverter.toBoolean((Object)this.moChartParent.mxDiagramPropertySet.getPropertyValue("HasYAxis"))) {
                    ++n;
                }
                if (this.moChartParent.is3D()) {
                    ++n;
                }
                if (AnyConverter.toBoolean((Object)this.moChartParent.mxDiagramPropertySet.getPropertyValue("HasSecondaryXAxis"))) {
                    ++n;
                }
                if (AnyConverter.toBoolean((Object)this.moChartParent.mxDiagramPropertySet.getPropertyValue("HasSecondaryYAxis"))) {
                    ++n;
                }
            }
            catch (Exception exception) {
                DebugHelper.exception(exception);
            }
        }
        return n;
    }

    protected ChartImpl getChartParent() {
        return this.moChartParent;
    }
}

