/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.sandbox;

import com.sun.star.lib.sandbox.ClassContext;
import com.sun.star.lib.sandbox.SandboxThreadGroup;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.Observable;
import java.util.ResourceBundle;

public abstract class ExecutionContext
extends Observable {
    private static final boolean DEBUG = false;
    private static int instances;
    protected static final int CMD_LOAD = 1;
    protected static final int CMD_INIT = 2;
    protected static final int CMD_START = 3;
    protected static final int CMD_STOP = 4;
    protected static final int CMD_DESTROY = 5;
    protected static final int CMD_DISPOSE = 6;
    protected static final int LOADED = 1;
    protected static final int INITED = 2;
    protected static final int STARTED = 3;
    protected static final int STOPPED = 4;
    protected static final int DESTROYED = 5;
    protected static final int DISPOSED = 6;
    private int status = 6;
    private Object statusLock = new Object();
    private boolean bDispatchException;
    protected ClassContext classContext;
    private Thread dispatchThread = null;
    private SandboxThreadGroup threadGroup = null;
    private String name;
    protected ResourceBundle resourceBundle;
    private Object synObj = new Object();
    private Message head;
    private Message tail;
    private boolean loop = true;

    protected ExecutionContext() {
        ++instances;
    }

    public void finalize() {
        --instances;
    }

    public int getStatus() {
        return this.status;
    }

    Object getSynObject() {
        return this.synObj;
    }

    public void init(String string, ClassContext classContext) throws MissingResourceException {
        this.name = string;
        this.resourceBundle = ResourceBundle.getBundle("sun.applet.resources.MsgAppletViewer");
        this.classContext = classContext;
        this.threadGroup = new SandboxThreadGroup(classContext.getThreadGroup(), string, classContext.getClassLoader());
        this.threadGroup.setDaemon(true);
        this.dispatchThread = new Thread((ThreadGroup)this.threadGroup, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (ExecutionContext.this.loop) {
                    Object object;
                    if (ExecutionContext.this.head != null) {
                        ExecutionContext.this.dispatch(((ExecutionContext)ExecutionContext.this).head.id);
                        object = ExecutionContext.this.getSynObject();
                        synchronized (object) {
                            ExecutionContext.this.head = ((ExecutionContext)ExecutionContext.this).head.next;
                            ExecutionContext.this.getSynObject().notify();
                        }
                    }
                    object = ExecutionContext.this.getSynObject();
                    synchronized (object) {
                        if (ExecutionContext.this.head == null) {
                            try {
                                ExecutionContext.this.getSynObject().wait();
                            }
                            catch (InterruptedException interruptedException) {
                                break;
                            }
                        }
                    }
                }
            }
        });
        this.dispatchThread.setDaemon(true);
        this.dispatchThread.start();
    }

    public void sendEvent(int n) {
        this.sendEvent(n, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendEvent(int n, int n2) {
        Object object = this.getSynObject();
        synchronized (object) {
            try {
                Message message = new Message(n);
                if (this.tail != null) {
                    this.tail.next = message;
                }
                this.tail = message;
                if (this.head == null) {
                    this.head = this.tail;
                }
                this.getSynObject().notify();
                if (n2 != 0) {
                    this.getSynObject().wait(n2);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void dispose() {
        this.dispose(1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose(long l) {
        try {
            try {
                Object object = this.getSynObject();
                synchronized (object) {
                    while (this.head != null) {
                        this.getSynObject().wait(l);
                    }
                    this.loop = false;
                    this.getSynObject().notifyAll();
                }
                this.dispatchThread.join(l);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.threadGroup.isDestroyed()) {
                this.threadGroup.destroy();
            }
        }
        catch (Exception exception) {
            try {
                this.threadGroup.stop();
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        this.classContext = null;
        this.dispatchThread = null;
        this.threadGroup.dispose();
        this.threadGroup = null;
        this.name = null;
        this.resourceBundle = null;
        this.synObj = null;
        this.head = null;
        this.tail = null;
    }

    protected void showStatus(String string) {
        this.setChanged();
        this.notifyObservers(this.resourceBundle.getString("appletpanel." + string));
    }

    protected void showStatus(String string, String string2) {
        try {
            Object[] objectArray = new Object[]{string2};
            this.setChanged();
            try {
                this.notifyObservers(MessageFormat.format(this.resourceBundle.getString("appletpanel." + string), objectArray));
            }
            catch (MissingResourceException missingResourceException) {
            }
        }
        catch (Exception exception) {}
    }

    public ThreadGroup getThreadGroup() {
        return this.threadGroup;
    }

    public void dispatch(int n) {
        try {
            switch (n) {
                case 1: {
                    if (this.status == 6) {
                        this.xload();
                        this.setStatus(1);
                        this.showStatus("loaded");
                        break;
                    }
                    this.showStatus("notdisposed");
                    break;
                }
                case 2: {
                    if (this.status == 1 || this.status == 5) {
                        this.xinit();
                        this.setStatus(2);
                        this.showStatus("inited");
                        break;
                    }
                    this.showStatus("notloaded");
                    break;
                }
                case 3: {
                    if (this.status == 2 || this.status == 4) {
                        this.xstart();
                        this.setStatus(3);
                        this.showStatus("started");
                        break;
                    }
                    this.showStatus("notinited");
                    break;
                }
                case 4: {
                    if (this.status == 3) {
                        this.xstop();
                        this.setStatus(4);
                        this.showStatus("stopped");
                        break;
                    }
                    this.showStatus("notstarted");
                    break;
                }
                case 5: {
                    if (this.status == 2 || this.status == 4) {
                        this.xdestroy();
                        this.setStatus(5);
                        this.showStatus("destroyed");
                        break;
                    }
                    this.showStatus("notstopped");
                    break;
                }
                case 6: {
                    if (this.status == 1 || this.status == 5) {
                        this.xdispose();
                        this.showStatus("disposed");
                        this.setStatus(6);
                        break;
                    }
                    this.showStatus("notdestroyed");
                    break;
                }
                default: {
                    this.xExtended(n);
                    break;
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.setDispatchException();
            this.showStatus("notfound", this.name);
        }
        catch (InstantiationException instantiationException) {
            this.setDispatchException();
            this.showStatus("nocreate", this.name);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.setDispatchException();
            this.showStatus("noconstruct", this.name);
        }
        catch (Exception exception) {
            this.setDispatchException();
            this.showStatus("exception", exception.getMessage());
        }
        catch (ThreadDeath threadDeath) {
            this.setDispatchException();
            this.showStatus("death");
            throw threadDeath;
        }
        catch (Error error) {
            this.setDispatchException();
            this.showStatus("error", error.getMessage());
        }
    }

    protected abstract void xload() throws ClassNotFoundException, InstantiationException, IllegalAccessException;

    protected abstract void xinit();

    protected abstract void xstart();

    protected abstract void xstop();

    protected abstract void xdestroy();

    protected abstract void xdispose();

    protected void xExtended(int n) {
    }

    public void sendLoad() {
        this.sendEvent(1);
    }

    public void sendInit() {
        this.sendEvent(2);
    }

    public void sendStart() {
        this.sendEvent(3);
    }

    public void sendStop() {
        this.sendEvent(4);
    }

    public void sendDestroy() {
        this.sendEvent(5);
    }

    public void sendDispose() {
        this.sendEvent(6);
    }

    public void startUp() {
        this.sendLoad();
        this.sendInit();
        this.sendStart();
    }

    public void shutdown() {
        this.sendStop();
        this.sendDestroy();
        this.sendDispose();
    }

    public void restart() {
        this.sendStop();
        this.sendDestroy();
        this.sendInit();
        this.sendStart();
    }

    public void reload() {
        this.sendStop();
        this.sendDestroy();
        this.sendDispose();
        this.sendLoad();
        this.sendInit();
        this.sendStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void waitForDispose() {
        if (this.status == 6 || this.bDispatchException) {
            return;
        }
        Object object = this.statusLock;
        synchronized (object) {
            while (this.status != 6 && !this.bDispatchException) {
                try {
                    this.statusLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        System.err.println("exit");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setStatus(int n) {
        Object object = this.statusLock;
        synchronized (object) {
            this.status = n;
            this.statusLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setDispatchException() {
        Object object = this.statusLock;
        synchronized (object) {
            this.bDispatchException = true;
            this.statusLock.notifyAll();
        }
    }

    class Message {
        Message next;
        int id;

        Message(int n) {
            this.id = n;
        }
    }
}

