/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.policy.util;

import com.sun.apoc.policy.util.MetaConfiguration;

public class BootstrapData {
    public static final String DATASTORE_TYPE_KEY = "DataStoreType";
    public static final String HOST_KEY = "Server";
    public static final String PORT_KEY = "Port";
    public static final String BASEDN_KEY = "BaseDn";
    public static final String AUTHDN_KEY = "AuthDn";
    public static final String PASSWORD_KEY = "Password";
    public static final String AUTHTYPE_KEY = "AuthType";
    public static final String AUTH_GSSAPI = "GSSAPI";
    public static final String AUTH_ANONYMOUS = "Anonymous";
    public static int sAuthTypeAnonymous = 0;
    public static int sAuthTypeGSSAPI = 1;
    public static final String CONNECTION_TIMEOUT = "ConnectTimeout";
    public static final String SIZE_LIMIT = "SizeLimit";
    public static final int DEFAULT_SIZE_LIMIT = 200;
    public String mDataStoreType = "LDAP";
    private String mServer = "localhost";
    private int mPort = 389;
    private String mAuthDN;
    private String mPassword;
    private String mBaseDN = null;
    private int mAuthType;
    private int mConnectionTimeout;
    private int mSizeLimit;
    private static final String MODULE = "BootstrapData";

    public BootstrapData(MetaConfiguration metaConfiguration) {
        String string = metaConfiguration.getString(DATASTORE_TYPE_KEY, this.mDataStoreType);
        if (!string.equals("")) {
            this.mDataStoreType = string;
        }
        if (!(string = metaConfiguration.getString(HOST_KEY, this.mServer)).equals("")) {
            this.mServer = string;
        }
        try {
            this.mPort = metaConfiguration.getInt(PORT_KEY, this.mPort);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.mAuthDN = metaConfiguration.getString(AUTHDN_KEY, this.mAuthDN);
        this.mPassword = metaConfiguration.getString(PASSWORD_KEY, this.mPassword);
        this.mBaseDN = metaConfiguration.getString(BASEDN_KEY, this.mBaseDN);
        if (this.mAuthDN != null && this.mAuthDN.equals("")) {
            this.mAuthDN = null;
            this.mPassword = null;
        }
        this.mAuthType = metaConfiguration.getString(AUTHTYPE_KEY, AUTH_ANONYMOUS).compareTo(AUTH_GSSAPI) == 0 ? sAuthTypeGSSAPI : sAuthTypeAnonymous;
        this.mConnectionTimeout = metaConfiguration.getInt(CONNECTION_TIMEOUT, 1);
        this.mSizeLimit = metaConfiguration.getInt(SIZE_LIMIT, 200);
    }

    public String getDataStoreType() {
        return this.mDataStoreType;
    }

    public String getServer() {
        return this.mServer;
    }

    public int getPort() {
        return this.mPort;
    }

    public String getAuthDN() {
        return this.mAuthDN;
    }

    public String getPassword() {
        return this.mPassword;
    }

    public String getBaseDN() {
        return this.mBaseDN;
    }

    public int getAuthType() {
        return this.mAuthType;
    }

    public int getConnectionTimeout() {
        return this.mConnectionTimeout;
    }

    public int getSizeLimit() {
        return this.mSizeLimit;
    }

    public void setAuthDN(String string) {
        this.mAuthDN = string;
    }

    public void setPassword(String string) {
        this.mPassword = string;
    }
}

