/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.policy.pmgr;

import com.sun.apoc.policy.common.EntityId;
import com.sun.apoc.policy.common.RegistryException;
import com.sun.apoc.policy.organization.Organization;
import com.sun.apoc.policy.pmgr.ClientContext;
import com.sun.apoc.policy.pmgr.SaslCallbackHandler;
import com.sun.apoc.policy.pmgr.SaslFactory;
import com.sun.apoc.policy.util.BootstrapData;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPDN;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSocketFactory;
import netscape.ldap.factory.JSSESocketFactory;

public class LdapClientContext
extends ClientContext {
    private static final JSSESocketFactory sSocketFactory = new JSSESocketFactory(null);
    private LDAPConnection mConnection = null;
    private EntityId mEntityId = null;
    private String mServer;
    private int mPort;
    private int mConnectTimeout;
    private int mSizeLimit;
    private boolean mUseSaslBind;
    private static final int LDAP_MINPORTNUMBER = 0;
    private static final int LDAP_MAXPORTNUMBER = 65535;
    private static final String MODULE = "LdapClientContext";

    protected LdapClientContext(BootstrapData bootstrapData, String string) throws RegistryException {
        this.mServer = bootstrapData.getServer();
        if (this.mServer == null) {
            this.mServer = "localhost";
        }
        this.mPort = bootstrapData.getPort();
        if (this.mPort < 0 || this.mPort > 65535) {
            throw new RegistryException("The bootstrapping information is incomplete.", "error.bootstrap.incomplete", MODULE, 0);
        }
        this.mConnectTimeout = bootstrapData.getConnectionTimeout();
        this.mSizeLimit = bootstrapData.getSizeLimit();
        boolean bl = this.mUseSaslBind = bootstrapData.getAuthType() == BootstrapData.sAuthTypeGSSAPI;
        if (string == null) {
            try {
                this.mConnection = this.createConnection(bootstrapData.getAuthDN(), bootstrapData.getPassword(), false);
            }
            catch (LDAPException lDAPException) {
                throw new RegistryException("An authorized connection could not be established: " + (Object)((Object)lDAPException), "error.open.connection", MODULE, 0);
            }
        }
    }

    protected void authenticate(String string, String string2, Organization organization, ClientContext clientContext) throws RegistryException {
        String[] stringArray = null;
        EntityId entityId = null;
        if (string != null) {
            stringArray = LDAPDN.explodeDN((String)string, (boolean)false);
        }
        entityId = stringArray != null && stringArray.length != 0 ? organization.getEntityIdFromLocation(string, clientContext) : organization.findUserEntityId(string, clientContext);
        try {
            this.mConnection = this.createConnection(entityId.getLocation(), string2, this.mUseSaslBind);
        }
        catch (LDAPException lDAPException) {
            throw new RegistryException("The connection for the user '" + string + "' could not be established: " + (Object)((Object)lDAPException), "error.user.invalid", MODULE, 0);
        }
        this.mEntityId = entityId;
    }

    protected void close() {
        if (this.mConnection != null && this.mConnection.isConnected()) {
            new LDAPConnectionDisconnector(this.mConnection).start();
            this.mConnection = null;
        }
    }

    private LDAPConnection createConnection(String string, String string2, boolean bl) throws LDAPException {
        LDAPConnection lDAPConnection;
        try {
            lDAPConnection = this.createConnection(true);
            this.authConnection(lDAPConnection, string, string2, bl);
        }
        catch (LDAPException lDAPException) {
            if (lDAPException.getLDAPResultCode() == 80 || lDAPException.getLDAPResultCode() == 91) {
                lDAPConnection = this.createConnection(false);
                this.authConnection(lDAPConnection, string, string2, bl);
            }
            throw lDAPException;
        }
        return lDAPConnection;
    }

    private LDAPConnection createConnection(boolean bl) throws LDAPException {
        LDAPConnection lDAPConnection = bl ? new LDAPConnection((LDAPSocketFactory)sSocketFactory) : new LDAPConnection();
        lDAPConnection.setOption(3, (Object)new Integer(this.mSizeLimit));
        try {
            lDAPConnection.setOption(17, (Object)new Integer(3));
            lDAPConnection.setOption(8, (Object)new Boolean(true));
        }
        catch (LDAPException lDAPException) {
            // empty catch block
        }
        lDAPConnection.setConnectTimeout(this.mConnectTimeout);
        lDAPConnection.connect(this.mServer, this.mPort);
        return lDAPConnection;
    }

    private void authConnection(LDAPConnection lDAPConnection, String string, String string2, boolean bl) throws LDAPException {
        if (bl) {
            lDAPConnection.authenticate(null, SaslFactory.sMechs, null, (Object)new SaslCallbackHandler(string2));
        } else {
            if (string2 == null || string2.length() == 0 || string == null || string.length() == 0) {
                string = null;
                string2 = null;
            }
            lDAPConnection.authenticate(string, string2);
        }
    }

    public LDAPConnection getConnection() {
        return this.mConnection;
    }

    public EntityId getEntityId() {
        return this.mEntityId;
    }

    class LDAPConnectionDisconnector
    extends Thread {
        LDAPConnection mConnection;

        LDAPConnectionDisconnector(LDAPConnection lDAPConnection) {
            this.mConnection = lDAPConnection;
        }

        public void run() {
            try {
                this.mConnection.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

