/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.policy.cfgtree;

import com.sun.apoc.policy.cfgtree.ConfigNode;
import com.sun.apoc.policy.cfgtree.ConfigNodeImpl;
import com.sun.apoc.policy.cfgtree.EnumIterator;
import com.sun.apoc.policy.cfgtree.HierarchyNode;
import com.sun.apoc.policy.cfgtree.NodeType;
import com.sun.apoc.policy.cfgtree.OperationType;
import com.sun.apoc.policy.cfgtree.PropertyNode;
import com.sun.apoc.policy.cfgtree.PropertyNodeImpl;
import com.sun.apoc.policy.common.NodeKey;
import com.sun.apoc.policy.common.PolicyGroupIdImpl;
import com.sun.apoc.policy.common.RegistryException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class HierarchyNodeImpl
extends ConfigNodeImpl
implements HierarchyNode {
    private Hashtable mChildrenTable;
    private Vector mChildren;
    private Vector mRemovedChildren;
    private static final String MODULE = "HierarchyNodeImpl";
    public static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n";
    private static final String COMPONENT_NAMESPACE = " xmlns:oor=\"http://openoffice.org/2001/registry\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"";

    protected PropertyNodeImpl addProperty(String string, PolicyGroupIdImpl policyGroupIdImpl) throws RegistryException {
        if (string == null) {
            throw new RegistryException("Cannot add new property because parameters are invalid.", "error.occurred", MODULE, 0);
        }
        this.checkIsReadOnly();
        PropertyNodeImpl propertyNodeImpl = new PropertyNodeImpl();
        propertyNodeImpl.createDefaultNodeValueImpl();
        propertyNodeImpl.setName(string);
        propertyNodeImpl.setAddedAtTopLayer();
        propertyNodeImpl.setConfigDataManager(this.getConfigDataManager());
        propertyNodeImpl.setOrigin(policyGroupIdImpl);
        propertyNodeImpl.setPath(this.getPath() + "/" + string);
        if (this.isFinalized()) {
            propertyNodeImpl.setFinalized(true, this.getPath(), (PolicyGroupIdImpl)this.getOriginOfFinalized());
        }
        this.addChild(propertyNodeImpl);
        return propertyNodeImpl;
    }

    public void removeProperty(PropertyNode propertyNode) throws RegistryException {
        if (propertyNode == null) {
            return;
        }
        this.checkIsReadOnly();
        if (!((PropertyNodeImpl)propertyNode).isAddedAtTopLayer()) {
            throw new RegistryException("A mandatory item cannot be removed: " + ((PropertyNodeImpl)propertyNode).getName() + ".", "error.mandatory.remove", MODULE, 0);
        }
        this.deleteChild(((PropertyNodeImpl)propertyNode).getName());
    }

    public NodeType getNodeType() {
        return NodeType.HIERARCHY;
    }

    public Iterator getChildren() {
        if (this.mChildren == null) {
            return new EnumIterator(new Vector().elements());
        }
        return new EnumIterator(this.mChildren.elements());
    }

    public Iterator getChildren(NodeType nodeType) {
        if (this.mChildren == null) {
            return new EnumIterator(new Vector().elements());
        }
        Enumeration enumeration = this.mChildren.elements();
        if (!enumeration.hasMoreElements()) {
            return new EnumIterator(enumeration);
        }
        Vector<ConfigNodeImpl> vector = new Vector<ConfigNodeImpl>();
        while (enumeration.hasMoreElements()) {
            ConfigNodeImpl configNodeImpl = (ConfigNodeImpl)enumeration.nextElement();
            if (configNodeImpl.getNodeType() != nodeType) continue;
            vector.add(configNodeImpl);
        }
        return new EnumIterator(vector.elements());
    }

    public ConfigNode getChild(String string) {
        if (string == null || this.mChildren == null || this.mChildrenTable == null) {
            return null;
        }
        return (ConfigNode)this.mChildrenTable.get(string);
    }

    protected Vector getChildrenVector() {
        return this.mChildren;
    }

    protected void setChildrenVector(Vector vector) {
        this.mChildren = vector;
    }

    protected ConfigNodeImpl shallowCopy() throws RegistryException {
        ConfigNodeImpl configNodeImpl = super.shallowCopy();
        if (this.mRemovedChildren != null) {
            ((HierarchyNodeImpl)configNodeImpl).mRemovedChildren = this.copyNodeVector(this.mRemovedChildren);
        }
        return configNodeImpl;
    }

    protected void addChild(ConfigNodeImpl configNodeImpl) {
        ConfigNodeImpl configNodeImpl2;
        if (configNodeImpl == null) {
            return;
        }
        if (this.mChildren == null) {
            this.mChildren = new Vector();
        }
        if (this.mChildrenTable == null) {
            this.mChildrenTable = new Hashtable();
        }
        if ((configNodeImpl2 = (ConfigNodeImpl)this.mChildrenTable.get(configNodeImpl.getName())) != null) {
            int n = this.mChildren.indexOf(configNodeImpl2);
            if (n > -1) {
                this.mChildren.setElementAt(configNodeImpl, n);
            } else {
                this.mChildren.add(configNodeImpl);
            }
        } else {
            this.mChildren.add(configNodeImpl);
        }
        this.mChildrenTable.put(configNodeImpl.getName(), configNodeImpl);
        configNodeImpl.setParent(this);
    }

    protected Vector getRemovedChildrenVector() {
        return this.mRemovedChildren;
    }

    protected void addRemovedChild(ConfigNodeImpl configNodeImpl) {
        if (configNodeImpl == null) {
            return;
        }
        if (this.mRemovedChildren == null) {
            this.mRemovedChildren = new Vector();
        }
        this.mRemovedChildren.add(configNodeImpl);
    }

    protected void deleteChild(String string) {
        ConfigNodeImpl configNodeImpl = null;
        if (this.mChildrenTable != null && (configNodeImpl = (ConfigNodeImpl)this.mChildrenTable.get(string)) != null) {
            this.mChildrenTable.remove(string);
        }
        if (configNodeImpl != null && this.mChildren != null) {
            this.mChildren.remove(configNodeImpl);
        }
    }

    protected void readModifyNode(ConfigNodeImpl configNodeImpl, NodeKey nodeKey, String string, boolean bl) throws RegistryException {
        ConfigNodeImpl configNodeImpl2 = (ConfigNodeImpl)configNodeImpl.getChild(this.getName());
        if (configNodeImpl2 != null) {
            if (configNodeImpl2.isReadOnly()) {
                return;
            }
            if (this.isMandatory()) {
                configNodeImpl2.setMandatoryFlag();
                configNodeImpl2.setOriginOfMandatory((PolicyGroupIdImpl)this.getOriginOfMandatory());
            }
        } else {
            configNodeImpl2 = this;
            configNodeImpl.addChild(configNodeImpl2);
            if (!bl) {
                configNodeImpl2.setAddedAtTopLayer();
            }
        }
        configNodeImpl2.setPath(string);
        Vector vector = this.getChildrenVector();
        if (vector != null) {
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ConfigNodeImpl configNodeImpl3 = (ConfigNodeImpl)vector.get(i);
                String string2 = string + "/" + configNodeImpl3.getName();
                configNodeImpl3.processReadOperation(configNodeImpl2, nodeKey, string2, bl);
            }
        }
        if (this.isFinalized()) {
            try {
                configNodeImpl2.checkIsNodeOrChildrenReadOnly();
                configNodeImpl2.setFinalized(true, configNodeImpl2.getPath(), (PolicyGroupIdImpl)this.getOriginOfFinalized());
                if (bl) {
                    configNodeImpl2.setReadOnly();
                }
            }
            catch (RegistryException registryException) {
                // empty catch block
            }
        }
    }

    protected void readReplaceNode(ConfigNodeImpl configNodeImpl, NodeKey nodeKey, String string, boolean bl) throws RegistryException {
        ConfigNodeImpl configNodeImpl2 = (ConfigNodeImpl)((HierarchyNodeImpl)configNodeImpl).getChild(this.getName());
        if (configNodeImpl2 != null && configNodeImpl2.isMandatory()) {
            return;
        }
        this.setSettingsForAddedNode(configNodeImpl.getPath() + "/" + this.getName(), (PolicyGroupIdImpl)this.getOrigin(), bl);
        if (this.isFinalized()) {
            this.setFinalized(true, this.getPath(), (PolicyGroupIdImpl)this.getOriginOfFinalized());
            if (bl) {
                this.setReadOnly();
            }
        }
        configNodeImpl.addChild(this);
    }

    protected void readRemoveNode(ConfigNodeImpl configNodeImpl, String string, boolean bl) throws RegistryException {
        ConfigNodeImpl configNodeImpl2 = (ConfigNodeImpl)configNodeImpl.getChild(this.getName());
        if (configNodeImpl2 != null && !configNodeImpl2.isMandatory()) {
            if (!bl) {
                configNodeImpl2.setOperationType(2);
                ((HierarchyNodeImpl)configNodeImpl).addRemovedChild(configNodeImpl2);
            }
            ((HierarchyNodeImpl)configNodeImpl).deleteChild(configNodeImpl2.getName());
        }
    }

    protected HierarchyNodeImpl addNode(String string, PolicyGroupIdImpl policyGroupIdImpl) throws RegistryException {
        if (string == null) {
            throw new RegistryException("Cannot add new node because parameters are invalid.", "error.occurred", MODULE, 0);
        }
        this.checkIsReadOnly();
        HierarchyNodeImpl hierarchyNodeImpl = new HierarchyNodeImpl();
        hierarchyNodeImpl.setName(string);
        hierarchyNodeImpl.setSettingsForAddedNode(this.getPath() + "/" + string, policyGroupIdImpl, false);
        hierarchyNodeImpl.setConfigDataManager(this.getConfigDataManager());
        this.addChild(hierarchyNodeImpl);
        return hierarchyNodeImpl;
    }

    protected ConfigNodeImpl addHierarchyNode(String string) {
        HierarchyNodeImpl hierarchyNodeImpl = new HierarchyNodeImpl();
        hierarchyNodeImpl.setName(string);
        this.addChild(hierarchyNodeImpl);
        return hierarchyNodeImpl;
    }

    public void delete() throws RegistryException {
        this.checkIsReadOnly();
        this.checkIsNodeOrChildrenReadOnlyOrMandatory();
        this.setOperationType(2);
    }

    public void removeNode(ConfigNode configNode) throws RegistryException {
        if (configNode == null) {
            return;
        }
        this.checkIsReadOnly();
        ((ConfigNodeImpl)configNode).checkIsNodeOrChildrenReadOnlyOrMandatory();
        if (!((ConfigNodeImpl)configNode).isAddedAtTopLayer()) {
            ((ConfigNodeImpl)configNode).setOperationType(2);
            this.addRemovedChild((ConfigNodeImpl)configNode);
        }
        this.deleteChild(configNode.getName());
    }

    public void printTag(String string, PrintStream printStream, boolean bl, int n) {
        if (bl && this.getParent() == null) {
            printStream.print(XML_HEADER);
        }
        printStream.print(string + (bl ? "<" : "</"));
        switch (n) {
            case 0: 
            case 1: {
                if (this.getParent() == null) {
                    printStream.print("oor:");
                    printStream.print("component-data");
                    if (!bl) break;
                    printStream.print(COMPONENT_NAMESPACE);
                    break;
                }
                printStream.print("node");
                break;
            }
            case 2: {
                printStream.print(this.getNodeType().getStringValue());
            }
        }
        if (bl) {
            printStream.print(" " + this.getAttributes(n));
        }
        printStream.print(">\n");
    }

    public String getAttributes(int n) {
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append(super.getAttributes(n));
        if (this.getPackage() != null) {
            stringBuffer.append(" ").append("oor:package").append("=\"").append(this.getPackage()).append("\"");
        }
        String string = OperationType.getString(this.getOperationType());
        switch (n) {
            case 0: 
            case 1: {
                if (this.isFinalized() && (this.getParent() == null || !this.getParent().isFinalized())) {
                    stringBuffer.append(" ").append("oor:finalized").append("=\"true\"");
                }
                if (n == 1 && this.isMandatory() && ((PropertyNodeImpl)((Object)this.getOriginOfMandatory())).equals(this.getConfigDataManager().mMergedCache.getPolicyGroupId())) {
                    stringBuffer.append(" ");
                    stringBuffer.append("oor:mandatory");
                    stringBuffer.append("=\"true\"");
                }
                if (n == 0 && this.isMandatory()) {
                    stringBuffer.append(" ");
                    stringBuffer.append("oor:mandatory");
                    stringBuffer.append("=\"true\"");
                }
                if (string == null) break;
                switch (OperationType.getInt(string)) {
                    case 1: 
                    case 2: {
                        stringBuffer.append(" ").append("oor:op").append("=\"").append(string).append("\"");
                    }
                }
                break;
            }
            case 2: {
                if (this.isReadOnly()) {
                    stringBuffer.append(" ").append("oor:readonly").append("=\"true\"");
                } else if (this.isFinalized()) {
                    stringBuffer.append(" ").append("oor:finalized").append("=\"true\"");
                }
                if (this.isMandatory()) {
                    stringBuffer.append(" ").append("oor:mandatory").append("=\"true\"");
                }
                if (string == null) break;
                stringBuffer.append(" ").append("oor:op").append("=\"").append(string).append("\"");
            }
        }
        return stringBuffer.toString();
    }
}

