/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.policy.cfgtree;

import com.sun.apoc.policy.cfgtree.ConfigDataManager;
import com.sun.apoc.policy.cfgtree.ConfigNode;
import com.sun.apoc.policy.cfgtree.EnumIterator;
import com.sun.apoc.policy.cfgtree.HierarchyNodeImpl;
import com.sun.apoc.policy.cfgtree.NodeType;
import com.sun.apoc.policy.cfgtree.XMLStreamable;
import com.sun.apoc.policy.common.NodeKey;
import com.sun.apoc.policy.common.PolicyGroupIdImpl;
import com.sun.apoc.policy.common.PolicySetId;
import com.sun.apoc.policy.common.RegistryException;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Vector;

public abstract class ConfigNodeImpl
implements ConfigNode,
XMLStreamable {
    private String mName;
    private String mPath;
    private ConfigNodeImpl mParent;
    private ConfigNodeImpl mDefaultNode;
    private boolean mIsReadOnly = false;
    private boolean mIsFinalized = false;
    private boolean mIsDynamic = false;
    private boolean mIsAddedAtTopLayer = false;
    private String mPackage;
    private PolicyGroupIdImpl mOriginLayer;
    private PolicyGroupIdImpl mOriginOfFinalized;
    private String mNameOfNodeWhereFinalizedSet;
    private PolicyGroupIdImpl mOriginOfMandatory;
    private boolean mIsMandatory = false;
    private int mOperationType = -1;
    private ConfigDataManager mConfigDataManager;
    private static final String MODULE = "ConfigNodeImpl";

    public NodeType getNodeType() {
        return NodeType.UNKNOWN;
    }

    public String getName() {
        return this.mName;
    }

    public String getPath() {
        return this.mPath;
    }

    public ConfigNode getParent() {
        return this.mParent;
    }

    public PolicySetId getOrigin() {
        return this.mOriginLayer;
    }

    public String getPackage() {
        return this.mPackage;
    }

    public boolean isReadOnly() {
        return this.mIsReadOnly;
    }

    public boolean isFinalized() {
        return this.mIsFinalized;
    }

    public void protect(boolean bl) throws RegistryException {
        this.checkIsNodeOrChildrenReadOnly();
        if (!bl && this.getParent() != null && this.getParent().isFinalized()) {
            throw new RegistryException("The item cannot be unprotected, because the parent item is protected: " + this.getName().toString() + ".", "error.unprotect.item", MODULE, 0);
        }
        if (bl) {
            PolicyGroupIdImpl policyGroupIdImpl = null;
            if (this.getConfigDataManager().mMergedCache != null) {
                policyGroupIdImpl = this.getConfigDataManager().mMergedCache.getPolicyGroupId();
            }
            this.setFinalized(bl, this.getPath(), policyGroupIdImpl);
        } else {
            this.setFinalized(bl, null, null);
        }
    }

    public PolicySetId getOriginOfFinalized() {
        return this.mOriginOfFinalized;
    }

    public String getNameOfNodeWhereFinalizedSet() {
        return this.mNameOfNodeWhereFinalizedSet;
    }

    public boolean isDynamic() {
        return this.mIsDynamic;
    }

    public boolean isMandatory() {
        return this.mIsMandatory;
    }

    public void setMandatory(boolean bl) throws RegistryException {
        if (this.mIsMandatory == bl) {
            return;
        }
        this.checkIsReadOnly();
        if (this.getParent() == null || this.mIsMandatory && (this.mOriginOfMandatory == null || this.mOriginOfMandatory.equals(this.mConfigDataManager.mMergedCache.getPolicyGroupId()))) {
            throw new RegistryException("The mandatory setting cannot be changed for this item: " + this.mName.toString() + ".", "error.mandatory.setting", MODULE, 0);
        }
        this.mIsMandatory = bl;
        this.mOriginOfMandatory = bl && this.mConfigDataManager.mMergedCache != null ? this.mConfigDataManager.mMergedCache.getPolicyGroupId() : null;
    }

    public PolicySetId getOriginOfMandatory() {
        return this.mOriginOfMandatory;
    }

    public boolean hasChildren() {
        return this.getChildren().hasNext();
    }

    public Iterator getChildren() {
        return new EnumIterator(new Vector().elements());
    }

    public Iterator getChildren(NodeType nodeType) {
        return new EnumIterator(new Vector().elements());
    }

    public ConfigNode getChild(String string) {
        return null;
    }

    public void clear() throws RegistryException {
        this.checkIsNodeOrChildrenReadOnly();
        ConfigNodeImpl configNodeImpl = this.mDefaultNode;
        HierarchyNodeImpl hierarchyNodeImpl = (HierarchyNodeImpl)this.getParent();
        if (configNodeImpl != null) {
            this.setNodeAndChildrenToDefault(configNodeImpl);
            configNodeImpl.setOperationType(3);
            if (hierarchyNodeImpl != null) {
                if (hierarchyNodeImpl.isFinalized()) {
                    configNodeImpl.setFinalized(true, this.getNameOfNodeWhereFinalizedSet(), (PolicyGroupIdImpl)this.getOriginOfFinalized());
                }
                hierarchyNodeImpl.addChild(configNodeImpl);
            } else {
                this.copyNodeSettings(configNodeImpl);
                ((HierarchyNodeImpl)this).setChildrenVector(configNodeImpl.getChildrenVector());
            }
        } else {
            this.checkIsMandatory();
            this.setOperationType(2);
        }
    }

    public void printToStream(String string, PrintStream printStream, int n) {
        this.printTag(string, printStream, true, n);
        this.printChildren(string + '\t', printStream, n);
        this.printTag(string, printStream, false, n);
    }

    public void printTag(String string, PrintStream printStream, boolean bl, int n) {
        printStream.print(string + (bl ? "<" : "</"));
        printStream.print(this.getNodeType().getStringValue());
        if (bl) {
            printStream.print(" " + this.getAttributes(n));
        }
        printStream.print(">\n");
    }

    public void printChildren(String string, PrintStream printStream, int n) {
        Vector vector = this.getChildrenVector();
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                ((ConfigNodeImpl)vector.get(i)).printToStream(string, printStream, n);
            }
        }
    }

    public String getAttributes(int n) {
        String string = "oor:name=\"" + this.mName + "\"";
        return string;
    }

    protected void setName(String string) {
        this.mName = string;
    }

    protected void setPath(String string) {
        this.mPath = string;
    }

    protected void setPackage(String string) {
        this.mPackage = string;
    }

    protected void setOrigin(PolicyGroupIdImpl policyGroupIdImpl) {
        this.mOriginLayer = policyGroupIdImpl;
    }

    protected void setOperationType(int n) {
        this.mOperationType = n;
    }

    protected Vector getChildrenVector() {
        return null;
    }

    protected int getOperationType() {
        return this.mOperationType;
    }

    protected void addChild(ConfigNodeImpl configNodeImpl) {
    }

    protected void setOriginOfFinalized(PolicyGroupIdImpl policyGroupIdImpl) {
        if (policyGroupIdImpl != null) {
            this.mOriginOfFinalized = policyGroupIdImpl;
        }
    }

    protected void setNameOfNodeWhereFinalizedSet(String string) {
        if (string != null) {
            this.mNameOfNodeWhereFinalizedSet = string;
        }
    }

    protected void setMandatoryFlag() {
        this.mIsMandatory = true;
    }

    protected void setOriginOfMandatory(PolicyGroupIdImpl policyGroupIdImpl) {
        this.mOriginOfMandatory = policyGroupIdImpl;
    }

    private void copyNodeSettings(ConfigNodeImpl configNodeImpl) throws RegistryException {
        configNodeImpl.mDefaultNode = this.mDefaultNode;
        configNodeImpl.mName = this.mName;
        configNodeImpl.mPath = this.mPath;
        configNodeImpl.mParent = this.mParent;
        configNodeImpl.mPackage = this.mPackage;
        configNodeImpl.mOriginLayer = this.mOriginLayer;
        configNodeImpl.mOperationType = this.mOperationType;
        configNodeImpl.mIsDynamic = this.mIsDynamic;
        configNodeImpl.mIsMandatory = this.mIsMandatory;
        configNodeImpl.mOriginOfMandatory = this.mOriginOfMandatory;
        configNodeImpl.mIsReadOnly = this.mIsReadOnly;
        configNodeImpl.mIsFinalized = this.mIsFinalized;
        configNodeImpl.mOriginOfFinalized = this.mOriginOfFinalized;
        configNodeImpl.mNameOfNodeWhereFinalizedSet = this.mNameOfNodeWhereFinalizedSet;
        configNodeImpl.mIsAddedAtTopLayer = this.mIsAddedAtTopLayer;
        configNodeImpl.mConfigDataManager = this.mConfigDataManager;
    }

    protected ConfigNodeImpl shallowCopy() throws RegistryException {
        ConfigNodeImpl configNodeImpl = null;
        try {
            configNodeImpl = (ConfigNodeImpl)this.getClass().newInstance();
        }
        catch (Exception exception) {
            throw new RegistryException("Cannot create copy of " + this.getName() + ".", "error.occurred", MODULE, 0);
        }
        this.copyNodeSettings(configNodeImpl);
        return configNodeImpl;
    }

    protected ConfigNodeImpl deepCopy() throws RegistryException {
        ConfigNodeImpl configNodeImpl = this.shallowCopy();
        Vector vector = this.getChildrenVector();
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                ConfigNodeImpl configNodeImpl2 = (ConfigNodeImpl)vector.get(i);
                configNodeImpl.addChild(configNodeImpl2.deepCopy());
            }
        }
        return configNodeImpl;
    }

    protected void setConfigDataManager(ConfigDataManager configDataManager) {
        this.mConfigDataManager = configDataManager;
    }

    protected ConfigDataManager getConfigDataManager() {
        return this.mConfigDataManager;
    }

    protected void setDefaultNode(ConfigNodeImpl configNodeImpl) throws RegistryException {
        this.mDefaultNode = configNodeImpl;
    }

    protected ConfigNodeImpl getDefaultNode() throws RegistryException {
        return this.mDefaultNode != null ? this.mDefaultNode.shallowCopy() : null;
    }

    protected void setDynamic() {
        this.mIsDynamic = true;
    }

    protected void setReadOnly() {
        Vector vector;
        if (this.mIsFinalized) {
            this.mIsReadOnly = true;
            this.mIsFinalized = false;
        }
        if ((vector = this.getChildrenVector()) != null) {
            for (int i = 0; i < vector.size(); ++i) {
                ConfigNodeImpl configNodeImpl = (ConfigNodeImpl)vector.get(i);
                configNodeImpl.setReadOnly();
            }
        }
    }

    protected void setAddedAtTopLayer() {
        this.mIsAddedAtTopLayer = true;
    }

    protected boolean isAddedAtTopLayer() {
        return this.mIsAddedAtTopLayer;
    }

    protected void expand(String string, boolean bl) throws RegistryException {
        Vector vector;
        this.mPath = string;
        if (this.isFinalized()) {
            if (this.getParent() == null || !this.getParent().isFinalized()) {
                this.setFinalized(true, this.getPath(), (PolicyGroupIdImpl)this.getOriginOfFinalized());
            }
            if (bl) {
                this.setReadOnly();
            }
        }
        if ((vector = this.getChildrenVector()) != null) {
            for (int i = 0; i < vector.size(); ++i) {
                ConfigNodeImpl configNodeImpl = (ConfigNodeImpl)vector.get(i);
                String string2 = string + "/" + configNodeImpl.getName();
                configNodeImpl.expand(string2, bl);
            }
        }
    }

    private void setNodeAndChildrenToDefault(ConfigNodeImpl configNodeImpl) throws RegistryException {
        Vector vector;
        if (configNodeImpl.getNodeType() != NodeType.PROPERTY && (vector = this.getChildrenVector()) == null) {
            Vector vector2;
            ConfigNodeImpl configNodeImpl2;
            vector = this.getChildrenVector();
            if (vector != null) {
                for (int i = 0; i < vector.size(); ++i) {
                    ConfigNodeImpl configNodeImpl3 = (ConfigNodeImpl)vector.get(i);
                    configNodeImpl2 = configNodeImpl3.getDefaultNode();
                    if (configNodeImpl2 == null) continue;
                    configNodeImpl3.setNodeAndChildrenToDefault(configNodeImpl2);
                    configNodeImpl.addChild(configNodeImpl2);
                }
            }
            if ((vector2 = this.getRemovedChildrenVector()) != null) {
                for (int i = 0; i < vector2.size(); ++i) {
                    configNodeImpl2 = (ConfigNodeImpl)vector2.get(i);
                    ConfigNodeImpl configNodeImpl4 = configNodeImpl2.getDefaultNode();
                    if (configNodeImpl4 == null) continue;
                    configNodeImpl.addChild(configNodeImpl4);
                }
            }
        }
        configNodeImpl.setDefaultNode(configNodeImpl.shallowCopy());
    }

    protected void changeFinalizedNodesToReadOnly() {
        Vector vector;
        if (this.mIsFinalized) {
            this.mIsReadOnly = true;
            this.mIsFinalized = false;
        }
        if ((vector = this.getChildrenVector()) != null) {
            for (int i = 0; i < vector.size(); ++i) {
                ConfigNodeImpl configNodeImpl = (ConfigNodeImpl)vector.get(i);
                configNodeImpl.changeFinalizedNodesToReadOnly();
            }
        }
    }

    protected void checkIsReadOnly() throws RegistryException {
        if (this.mIsReadOnly) {
            throw new RegistryException("A read-only item cannot be edited: " + this.mName + ".", "error.readonly.item", MODULE, 0);
        }
    }

    protected void checkIsNodeOrChildrenReadOnly() throws RegistryException {
        this.checkIsReadOnly();
        Vector vector = this.getChildrenVector();
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                ConfigNodeImpl configNodeImpl = (ConfigNodeImpl)vector.get(i);
                configNodeImpl.checkIsNodeOrChildrenReadOnly();
            }
        }
    }

    protected void checkIsNodeOrChildrenReadOnlyOrMandatory() throws RegistryException {
        this.checkIsReadOnly();
        this.checkIsMandatory();
        Vector vector = this.getChildrenVector();
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                ConfigNodeImpl configNodeImpl = (ConfigNodeImpl)vector.get(i);
                configNodeImpl.checkIsNodeOrChildrenReadOnlyOrMandatory();
            }
        }
    }

    protected void setFinalized(boolean bl, String string, PolicyGroupIdImpl policyGroupIdImpl) {
        this.mIsFinalized = bl;
        this.mNameOfNodeWhereFinalizedSet = string;
        this.mOriginOfFinalized = policyGroupIdImpl;
        Vector vector = this.getChildrenVector();
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                ConfigNodeImpl configNodeImpl = (ConfigNodeImpl)vector.get(i);
                configNodeImpl.setFinalized(bl, string, policyGroupIdImpl);
            }
        }
    }

    protected boolean processUpdateOperation(ConfigNodeImpl configNodeImpl, PolicyGroupIdImpl policyGroupIdImpl, String string) throws RegistryException {
        boolean bl = false;
        switch (this.mOperationType) {
            case 1: {
                bl = this.updateReplaceNode(configNodeImpl, policyGroupIdImpl, string);
                break;
            }
            case 2: {
                bl = this.updateRemoveNode(configNodeImpl, policyGroupIdImpl, string);
                break;
            }
            case 3: {
                bl = this.updateResetNode(configNodeImpl, policyGroupIdImpl, string);
                break;
            }
            case -1: 
            case 0: {
                bl = this.updateModifyNode(configNodeImpl, policyGroupIdImpl, string);
            }
        }
        return bl;
    }

    protected boolean updateModifyNode(ConfigNodeImpl configNodeImpl, PolicyGroupIdImpl policyGroupIdImpl, String string) throws RegistryException {
        int n;
        Vector vector;
        boolean bl = false;
        if (this.mIsFinalized) {
            if (this.getParent() == null || !this.getParent().isFinalized()) {
                bl = true;
            }
        } else if (this.mIsMandatory) {
            if (policyGroupIdImpl == null) {
                bl = true;
            } else if (policyGroupIdImpl.equals(this.mOriginOfMandatory)) {
                bl = true;
            }
        }
        if ((vector = this.getRemovedChildrenVector()) != null) {
            for (n = 0; n < vector.size(); ++n) {
                ConfigNodeImpl configNodeImpl2 = (ConfigNodeImpl)vector.get(n);
                if (configNodeImpl2 == null) continue;
                configNodeImpl.addChild(configNodeImpl2.shallowCopy());
                bl = true;
            }
        }
        n = this.processUpdateNodeChildren(configNodeImpl, policyGroupIdImpl, string) ? 1 : 0;
        return bl || n != 0;
    }

    protected boolean updateReplaceNode(ConfigNodeImpl configNodeImpl, PolicyGroupIdImpl policyGroupIdImpl, String string) throws RegistryException {
        boolean bl = false;
        boolean bl2 = false;
        if (this.mIsAddedAtTopLayer) {
            bl = true;
        } else if (this.mIsFinalized) {
            if (this.getParent() == null || !this.getParent().isFinalized()) {
                bl = true;
            }
        } else if (this.mIsMandatory) {
            if (policyGroupIdImpl == null) {
                bl = true;
            } else if (policyGroupIdImpl.equals(this.mOriginOfMandatory)) {
                bl = true;
            }
        }
        Vector vector = this.getRemovedChildrenVector();
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                ConfigNodeImpl configNodeImpl2 = (ConfigNodeImpl)vector.get(i);
                if (configNodeImpl2 == null) continue;
                configNodeImpl.addChild(configNodeImpl2.shallowCopy());
                bl = true;
            }
        }
        bl2 = this.processUpdateNodeChildren(configNodeImpl, policyGroupIdImpl, string);
        return bl || bl2;
    }

    protected boolean processUpdateNodeChildren(ConfigNodeImpl configNodeImpl, PolicyGroupIdImpl policyGroupIdImpl, String string) throws RegistryException {
        Object object;
        int n;
        boolean bl = false;
        Vector vector = this.getRemovedChildrenVector();
        if (vector != null) {
            for (n = 0; n < vector.size(); ++n) {
                object = (ConfigNodeImpl)vector.get(n);
                if (object == null) continue;
                configNodeImpl.addChild(((ConfigNodeImpl)object).shallowCopy());
                bl = true;
            }
        }
        n = 0;
        object = this.getChildrenVector();
        if (object != null) {
            int n2 = ((Vector)object).size();
            ConfigNodeImpl[] configNodeImplArray = new ConfigNodeImpl[n2];
            configNodeImplArray = ((Vector)object).toArray(configNodeImplArray);
            for (int i = 0; i < n2; ++i) {
                ConfigNodeImpl configNodeImpl2 = configNodeImplArray[i];
                if (configNodeImpl2 == null || configNodeImpl2.getName() == null) {
                    throw new RegistryException("The policy data is invalid.", "error.policy.data.invalid", MODULE, 0);
                }
                ConfigNodeImpl configNodeImpl3 = configNodeImpl2.shallowCopy();
                configNodeImpl.addChild(configNodeImpl3);
                String string2 = string + "/" + configNodeImpl2.getName();
                n = configNodeImpl2.processUpdateOperation(configNodeImpl3, policyGroupIdImpl, string2) ? 1 : 0;
                if (n == 0) {
                    ((HierarchyNodeImpl)configNodeImpl).deleteChild(configNodeImpl3.getName());
                    continue;
                }
                bl = true;
            }
        }
        return bl || n != 0;
    }

    protected boolean updateRemoveNode(ConfigNodeImpl configNodeImpl, PolicyGroupIdImpl policyGroupIdImpl, String string) throws RegistryException {
        HierarchyNodeImpl hierarchyNodeImpl = (HierarchyNodeImpl)this.getParent();
        if (!this.mIsAddedAtTopLayer) {
            hierarchyNodeImpl.addRemovedChild(this);
        }
        if (policyGroupIdImpl != null) {
            hierarchyNodeImpl.deleteChild(this.mName);
        }
        return !this.mIsAddedAtTopLayer;
    }

    protected boolean updateResetNode(ConfigNodeImpl configNodeImpl, PolicyGroupIdImpl policyGroupIdImpl, String string) throws RegistryException {
        boolean bl = false;
        if (this.mIsFinalized) {
            if (this.getParent() == null || !this.getParent().isFinalized()) {
                bl = true;
            }
        } else if (this.mIsMandatory) {
            if (policyGroupIdImpl == null) {
                bl = true;
            } else if (policyGroupIdImpl.equals(this.mOriginOfMandatory)) {
                bl = true;
            }
        }
        boolean bl2 = this.processUpdateNodeChildren(configNodeImpl, policyGroupIdImpl, string);
        if (!bl && !bl2) {
            return false;
        }
        configNodeImpl.setOperationType(0);
        return true;
    }

    protected void processReadOperation(ConfigNodeImpl configNodeImpl, NodeKey nodeKey, String string, boolean bl) throws RegistryException {
        if (this.mName == null) {
            throw new RegistryException("The policy data is invalid: " + string + ".", "error.policy.data.invalid", MODULE, 0);
        }
        switch (this.mOperationType) {
            case 1: {
                this.readReplaceNode(configNodeImpl, nodeKey, string, bl);
                break;
            }
            case 2: {
                this.readRemoveNode(configNodeImpl, string, bl);
                break;
            }
            case -1: 
            case 0: {
                this.readModifyNode(configNodeImpl, nodeKey, string, bl);
            }
        }
    }

    protected void readReplaceNode(ConfigNodeImpl configNodeImpl, NodeKey nodeKey, String string, boolean bl) throws RegistryException {
    }

    protected void readRemoveNode(ConfigNodeImpl configNodeImpl, String string, boolean bl) throws RegistryException {
    }

    protected void readModifyNode(ConfigNodeImpl configNodeImpl, NodeKey nodeKey, String string, boolean bl) throws RegistryException {
    }

    protected void setParsedNodeMandatory(boolean bl, PolicyGroupIdImpl policyGroupIdImpl) {
        this.mIsMandatory = bl;
        this.mOriginOfMandatory = this.mIsMandatory ? policyGroupIdImpl : null;
    }

    protected void setParent(ConfigNodeImpl configNodeImpl) {
        this.mParent = configNodeImpl;
    }

    protected Vector getRemovedChildrenVector() {
        return null;
    }

    protected Vector copyNodeVector(Vector vector) throws RegistryException {
        Vector<ConfigNodeImpl> vector2 = new Vector<ConfigNodeImpl>();
        for (int i = 0; i < vector.size(); ++i) {
            ConfigNodeImpl configNodeImpl = (ConfigNodeImpl)vector.get(i);
            if (configNodeImpl == null) continue;
            vector2.add(configNodeImpl.deepCopy());
        }
        return vector2;
    }

    public void checkIsMandatory() throws RegistryException {
        if (this.mIsMandatory) {
            throw new RegistryException("A mandatory item cannot be removed: " + this.mName + ".", "error.mandatory.remove", MODULE, 0);
        }
    }

    protected void setSettingsForAddedNode(String string, PolicyGroupIdImpl policyGroupIdImpl, boolean bl) {
        Vector vector;
        this.setPath(string);
        if (policyGroupIdImpl != null) {
            this.setOrigin(policyGroupIdImpl);
        }
        if (!bl) {
            this.setAddedAtTopLayer();
        }
        if ((vector = this.getChildrenVector()) != null) {
            ConfigNodeImpl configNodeImpl = null;
            String string2 = null;
            for (int i = 0; i < vector.size(); ++i) {
                configNodeImpl = (ConfigNodeImpl)vector.get(i);
                string2 = string + "/" + configNodeImpl.getName();
                configNodeImpl.setSettingsForAddedNode(string2, policyGroupIdImpl, bl);
            }
        }
    }

    protected void addNodeDefaults() throws RegistryException {
        this.setDefaultNode(this.shallowCopy());
        Vector vector = this.getChildrenVector();
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                ConfigNodeImpl configNodeImpl = (ConfigNodeImpl)vector.get(i);
                configNodeImpl.addNodeDefaults();
            }
        }
    }
}

