/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.policy.util;

import com.sun.apoc.policy.common.RegistryException;
import com.sun.apoc.policy.datastore.DataStore;
import com.sun.apoc.policy.util.ImporterExporter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipImporterExporter
extends ImporterExporter {
    private static final String MODULE = "ZipImporterExporter";
    private static final char COMPONENT_SEPARATOR = '.';
    private static final String COMPONENT_SEPARATOR_STR = ".";
    private static final char ENTRY_SEPARATOR = '/';
    private static final String ENTRY_SUFFIX = ".xcu";
    private static final String ENTRY_ENCODING = "UTF-8";

    public ZipImporterExporter(DataStore dataStore) {
        super(dataStore);
    }

    private void addEntry(String string, String string2, ZipOutputStream zipOutputStream) throws IOException {
        ZipEntry zipEntry = new ZipEntry(string);
        zipOutputStream.putNextEntry(zipEntry);
        if (string2 != null) {
            byte[] byArray = string2.getBytes(ENTRY_ENCODING);
            zipOutputStream.write(byArray, 0, byArray.length);
        }
        zipOutputStream.closeEntry();
    }

    private void createDirectories(String string, ZipOutputStream zipOutputStream, Set set) throws IOException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, COMPONENT_SEPARATOR_STR);
        if (stringTokenizer.countTokens() == 1) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        String string2 = stringTokenizer.nextToken();
        do {
            stringBuffer.append(string2).append('/');
            if (!set.contains(stringBuffer.toString())) {
                this.addEntry(stringBuffer.toString(), null, zipOutputStream);
                set.add(stringBuffer.toString());
            }
            string2 = stringTokenizer.nextToken();
        } while (stringTokenizer.hasMoreTokens());
    }

    private void createEntry(String string, String string2, ZipOutputStream zipOutputStream) throws IOException {
        this.addEntry(string.replace('.', '/') + ENTRY_SUFFIX, string2, zipOutputStream);
    }

    protected void writePolicies(String[] stringArray, String[] stringArray2, OutputStream outputStream) throws RegistryException {
        ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
        try {
            HashSet hashSet = new HashSet();
            for (int i = 0; i < stringArray.length; ++i) {
                this.createDirectories(stringArray[i], zipOutputStream, hashSet);
                this.createEntry(stringArray[i], stringArray2[i], zipOutputStream);
            }
            zipOutputStream.close();
        }
        catch (ZipException zipException) {
            try {
                zipOutputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new RegistryException("Zip error while exporting policy group data. " + zipException, "error.export.policygroup", MODULE, 0);
        }
        catch (IOException iOException) {
            try {
                zipOutputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new RegistryException("I/O error when exporting policy group data: " + iOException, "error.export.policygroup", MODULE, 0);
        }
    }

    private void readPolicy(ZipInputStream zipInputStream, ZipEntry zipEntry, Vector vector, Vector vector2) throws IOException {
        String string = zipEntry.getName();
        int n = string.length() - ENTRY_SUFFIX.length();
        if (n <= 0 || !string.substring(n).equals(ENTRY_SUFFIX)) {
            return;
        }
        string = string.substring(0, n).replace('/', '.');
        byte[] byArray = new byte[1024];
        StringBuffer stringBuffer = new StringBuffer();
        while (zipInputStream.available() != 0) {
            int n2 = zipInputStream.read(byArray, 0, byArray.length);
            if (n2 <= 0) continue;
            stringBuffer.append(new String(byArray, 0, n2, ENTRY_ENCODING));
        }
        vector.add(string);
        vector2.add(stringBuffer.toString());
    }

    protected void readPolicies(InputStream inputStream, Vector vector, Vector vector2) throws RegistryException {
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        try {
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                if (!zipEntry.isDirectory()) {
                    this.readPolicy(zipInputStream, zipEntry, vector, vector2);
                }
                zipInputStream.closeEntry();
                zipEntry = zipInputStream.getNextEntry();
            }
            zipInputStream.close();
        }
        catch (ZipException zipException) {
            try {
                zipInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new RegistryException("Zip error while importing a policy group: " + zipException, "error.import.policygroup", MODULE, 0);
        }
        catch (IOException iOException) {
            try {
                zipInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new RegistryException("Zip error while importing a policy group: " + iOException, "error.import.policygroup", MODULE, 0);
        }
    }
}

