/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.policy.common;

import com.sun.apoc.policy.common.EntityType;
import com.sun.apoc.policy.common.RegistryException;
import java.util.Hashtable;
import java.util.Vector;
import netscape.ldap.LDAPDN;

public class EntityId {
    private static final String MODULE = "EntityId";
    private EntityType mType = EntityType.UNKNOWN;
    private String mDisplayName = null;
    private String mUniqueId = "";
    private String mLocation = null;
    private boolean mIsInContainer = false;
    private int mParentIndex = -1;
    public static final String LDAP_SEPARATOR = ",";
    private static final String[] MANGLING_ATTRS = new String[]{"type=", "dispname=", "cont=", "parent=", "dn=", "uid="};
    private static final String UH_SEPARATOR = ":";

    private void getNameFromLocation() {
        String[] stringArray = LDAPDN.explodeDN((String)this.mLocation, (boolean)true);
        if (stringArray != null && stringArray.length > 0) {
            this.mDisplayName = LDAPDN.unEscapeRDN((String)stringArray[0]);
        }
    }

    public EntityId(EntityType entityType, String string, boolean bl, int n) {
        this.mType = entityType;
        this.mLocation = string;
        this.mIsInContainer = bl;
        this.mParentIndex = n;
        this.getNameFromLocation();
    }

    private void throwParsingException(String string) throws RegistryException {
        throw new RegistryException("Cannot create EntityId because string " + string + " is invalid", "error.occurred", MODULE, 0);
    }

    public EntityId(String string) throws RegistryException {
        int n = string.indexOf(UH_SEPARATOR);
        if (n == -1) {
            this.throwParsingException(string);
        }
        StringBuffer stringBuffer = new StringBuffer(MANGLING_ATTRS[0]);
        stringBuffer.append(string.substring(0, n));
        stringBuffer.append(LDAP_SEPARATOR);
        stringBuffer.append(string.substring(n + 1));
        this.fillFromString(stringBuffer.toString());
    }

    private void fillFromString(String string) throws RegistryException {
        String[] stringArray;
        int n = MANGLING_ATTRS.length;
        String string2 = string;
        if (string.endsWith(MANGLING_ATTRS[5])) {
            --n;
            string2 = string.substring(0, string.length() - MANGLING_ATTRS[5].length() - 1);
        }
        if ((stringArray = LDAPDN.explodeDN((String)string2, (boolean)false)) == null || stringArray.length != n) {
            this.throwParsingException(string);
        }
        for (int i = 0; i < n; ++i) {
            if (stringArray[i].startsWith(MANGLING_ATTRS[i])) continue;
            this.throwParsingException(string);
        }
        this.mType = EntityType.getEntityType(stringArray[0].substring(MANGLING_ATTRS[0].length()));
        if (this.mType == EntityType.UNKNOWN || this.mType == EntityType.NULL) {
            this.throwParsingException(string);
        }
        this.mDisplayName = LDAPDN.unEscapeRDN((String)stringArray[1]);
        this.mDisplayName = this.mDisplayName.substring(MANGLING_ATTRS[1].length());
        stringArray[2] = stringArray[2].substring(MANGLING_ATTRS[2].length());
        this.mIsInContainer = Boolean.valueOf(stringArray[2]);
        stringArray[3] = stringArray[3].substring(MANGLING_ATTRS[3].length());
        this.mParentIndex = Integer.parseInt(stringArray[3]);
        this.mLocation = LDAPDN.unEscapeRDN((String)stringArray[4]);
        this.mLocation = this.mLocation.substring(MANGLING_ATTRS[4].length());
        if (stringArray.length == MANGLING_ATTRS.length) {
            this.mUniqueId = LDAPDN.unEscapeRDN((String)stringArray[5]);
            this.mUniqueId = this.mUniqueId.substring(MANGLING_ATTRS[5].length());
        }
    }

    public void setUniqueId(String string) {
        if (string != null) {
            this.mUniqueId = string;
        }
    }

    public String getUniqueId() {
        return this.mUniqueId;
    }

    public EntityType getEntityType() {
        return this.mType;
    }

    public String getDisplayName() {
        return this.mDisplayName;
    }

    public boolean equals(Object object) {
        if (object instanceof EntityId) {
            return LDAPDN.equals((String)this.mLocation.toLowerCase(), (String)((EntityId)object).mLocation.toLowerCase());
        }
        if (object instanceof String) {
            try {
                return this.equals(new EntityId((String)object));
            }
            catch (RegistryException registryException) {
                // empty catch block
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.mType.toString()).append(UH_SEPARATOR);
        stringBuffer.append(LDAPDN.escapeRDN((String)(MANGLING_ATTRS[1] + this.mDisplayName)));
        stringBuffer.append(LDAP_SEPARATOR);
        stringBuffer.append(MANGLING_ATTRS[2]);
        stringBuffer.append(String.valueOf(this.mIsInContainer));
        stringBuffer.append(LDAP_SEPARATOR);
        stringBuffer.append(MANGLING_ATTRS[3]);
        stringBuffer.append(String.valueOf(this.mParentIndex));
        stringBuffer.append(LDAP_SEPARATOR);
        stringBuffer.append(LDAPDN.escapeRDN((String)(MANGLING_ATTRS[4] + this.mLocation)));
        stringBuffer.append(LDAP_SEPARATOR);
        stringBuffer.append(LDAPDN.escapeRDN((String)(MANGLING_ATTRS[5] + this.mUniqueId)));
        return stringBuffer.toString();
    }

    public static EntityId getEntityId(String string) throws RegistryException {
        return new EntityId(string);
    }

    public int hashCode() {
        return this.mLocation.hashCode();
    }

    public void setDisplayName(Hashtable hashtable, String[] stringArray, String string) {
        if (hashtable == null || stringArray == null || string == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            Vector vector = (Vector)hashtable.get(stringArray[i]);
            String string2 = null;
            if (vector != null && !vector.isEmpty()) {
                string2 = (String)vector.get(0);
            }
            if (string2 == null) continue;
            if (bl) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(string2);
            bl = true;
        }
        if (stringBuffer.length() > 0) {
            this.mDisplayName = stringBuffer.toString();
        }
    }

    public String getLocation() {
        return this.mLocation;
    }

    public EntityId getParentBeforeContainer() {
        if (this.mParentIndex == -1) {
            return null;
        }
        int n = this.mParentIndex - 1;
        if (this.mIsInContainer) {
            --n;
        }
        if (n < 1) {
            return null;
        }
        String[] stringArray = LDAPDN.explodeDN((String)this.mLocation, (boolean)false);
        if (stringArray.length < 2) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(stringArray[1]);
        for (int i = 2; i < stringArray.length; ++i) {
            stringBuffer.append(LDAP_SEPARATOR).append(stringArray[i]);
        }
        return new EntityId(this.mType, stringBuffer.toString(), this.mIsInContainer, this.mParentIndex - 1);
    }

    public EntityId getParentEntity(EntityType entityType) {
        if (this.mParentIndex == -1) {
            return null;
        }
        String[] stringArray = LDAPDN.explodeDN((String)this.mLocation, (boolean)false);
        if (this.mParentIndex >= stringArray.length) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(stringArray[this.mParentIndex]);
        for (int i = this.mParentIndex + 1; i < stringArray.length; ++i) {
            stringBuffer.append(LDAP_SEPARATOR).append(stringArray[i]);
        }
        return new EntityId(entityType, stringBuffer.toString(), false, 1);
    }

    public static EntityType getTypeFromString(String string) {
        int n = string.indexOf(UH_SEPARATOR);
        EntityType entityType = null;
        if (n >= 0) {
            String string2 = string.substring(0, n);
            entityType = EntityType.getEntityType(string2);
        }
        return entityType;
    }

    public static String getUniqueIdFromString(String string) {
        String string2 = "";
        String[] stringArray = LDAPDN.explodeDN((String)string, (boolean)false);
        if (stringArray == null || stringArray.length != MANGLING_ATTRS.length) {
            return string2;
        }
        for (int i = 0; i < MANGLING_ATTRS.length; ++i) {
            if (stringArray[i].startsWith(MANGLING_ATTRS[i])) continue;
            return string2;
        }
        string2 = LDAPDN.unEscapeRDN((String)stringArray[5]);
        string2 = string2.substring(MANGLING_ATTRS[5].length());
        return string2;
    }
}

