/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.spi.ldap.profiles;

import com.sun.apoc.spi.SPIException;
import com.sun.apoc.spi.entities.User;
import com.sun.apoc.spi.ldap.util.Timestamp;
import com.sun.apoc.spi.policies.Policy;
import com.sun.apoc.spi.profiles.Applicability;
import com.sun.apoc.spi.profiles.Profile;
import com.sun.apoc.spi.profiles.ProfileRepository;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import netscape.ldap.util.LDIF;

public class LdapUserProfile
implements Profile {
    private static final String COMPONENT_PKG = "com.sun.jds";
    private static final String COMPONENT_NAME = "UserProfile";
    private static final String NODE_NAME = "Data";
    private static final String ID = "ou=UserProfile,";
    private static final String DISPLAY_NAME = " User Profile";
    private static final String POLICY_ID = "com.sun.jds.UserProfile";
    private String mId;
    private String mDisplayName = "";
    private Policy mPolicy = null;
    private static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?><oor:component-data xmlns:oor=\"http://openoffice.org/2001/registry\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" oor:package=\"com.sun.jds\" oor:name=\"UserProfile\"><node oor:name=\"Data\">";
    private static final String XML_TRAILER = "</node></oor:component-data>";
    private static final String PROP_HEADER = "<prop oor:name=\"";
    private static final String PROP_MIDDLE = "\" oor:type=\"xs:string\"><value>";
    private static final String PROP_TRAILER = "</value></prop>";

    public LdapUserProfile(User user, Hashtable hashtable) {
        this.mId = ID + user.getId();
        String string = LdapUserProfile.getPolicyData(hashtable);
        byte[] byArray = (byte[])hashtable.get("modifytimestamp");
        if (byArray != null) {
            long l = Timestamp.getMillis(new String(byArray));
            this.mPolicy = new Policy(POLICY_ID, this.mId, string, l);
        } else {
            this.mPolicy = new Policy(POLICY_ID, this.mId, string);
        }
        try {
            this.mDisplayName = user.getDisplayName() + DISPLAY_NAME;
        }
        catch (SPIException sPIException) {
            // empty catch block
        }
    }

    public Policy getPolicy() throws SPIException {
        return this.mPolicy;
    }

    private static String getPolicyData(Hashtable hashtable) {
        StringBuffer stringBuffer = new StringBuffer(XML_HEADER);
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            stringBuffer.append(LdapUserProfile.getPropertyData(string, (byte[])hashtable.get(string)));
        }
        stringBuffer.append(XML_TRAILER);
        return stringBuffer.toString();
    }

    private static StringBuffer getPropertyData(String string, byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(PROP_HEADER);
        if (byArray != null && byArray.length > 0 && LDIF.isPrintable((byte[])byArray)) {
            stringBuffer.append(string).append(PROP_MIDDLE);
            int n = 0;
            for (int i = 0; i < byArray.length; ++i) {
                boolean bl;
                byte by = byArray[i];
                boolean bl2 = bl = by == 38 || by == 60 || by == 62;
                if (!bl) continue;
                if (i != n) {
                    stringBuffer.append(new String(byArray, n, i - n));
                }
                if (by == 38) {
                    stringBuffer.append("&amp;");
                } else if (by == 60) {
                    stringBuffer.append("&lt;");
                } else if (by == 62) {
                    stringBuffer.append("&gt;");
                }
                n = i + 1;
            }
            if (n != byArray.length) {
                stringBuffer.append(new String(byArray, n, byArray.length - n));
            }
            stringBuffer.append(PROP_TRAILER);
        }
        return stringBuffer;
    }

    public String getId() {
        return this.mId;
    }

    public String getDisplayName() {
        return this.mDisplayName;
    }

    public int getPriority() {
        return 0;
    }

    public Applicability getApplicability() {
        return Applicability.USER;
    }

    public String getAuthor() throws SPIException {
        return new String("");
    }

    public String getComment() throws SPIException {
        return new String("");
    }

    public long getLastModified() throws SPIException {
        return this.mPolicy.getLastModified();
    }

    public boolean hasPolicies() throws SPIException {
        return this.mPolicy != null;
    }

    public Iterator getPolicies() throws SPIException {
        Vector<Policy> vector = new Vector<Policy>();
        vector.add(this.mPolicy);
        return vector.iterator();
    }

    public Iterator getPolicies(Iterator iterator) throws SPIException {
        Vector<Policy> vector = new Vector<Policy>();
        String string = this.mPolicy.getId();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string2.equals(string)) continue;
            vector.add(this.mPolicy);
            break;
        }
        return vector.iterator();
    }

    public Iterator getPolicyInfos(Iterator iterator) throws SPIException {
        return this.getPolicies(iterator);
    }

    public Policy getPolicy(String string) throws SPIException {
        if (string.equals(this.mPolicy.getId())) {
            return this.mPolicy;
        }
        return null;
    }

    public ProfileRepository getProfileRepository() {
        return null;
    }

    public void storePolicy(Policy policy) throws SPIException {
        throw new UnsupportedOperationException();
    }

    public void destroyPolicy(Policy policy) throws SPIException {
        throw new UnsupportedOperationException();
    }

    public boolean hasAssignedEntities() throws SPIException {
        throw new UnsupportedOperationException();
    }

    public Iterator getAssignedEntities() throws SPIException {
        throw new UnsupportedOperationException();
    }

    public void setApplicability(Applicability applicability) throws SPIException {
        throw new UnsupportedOperationException();
    }

    public void setComment(String string) throws SPIException {
        throw new UnsupportedOperationException();
    }

    public void setPriority(int n) throws SPIException {
        throw new UnsupportedOperationException();
    }

    public void setDisplayName(String string) throws SPIException {
        throw new UnsupportedOperationException();
    }
}

