/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.spi.ldap;

import com.sun.apoc.spi.SPIException;
import com.sun.apoc.spi.entities.Domain;
import com.sun.apoc.spi.entities.Organization;
import com.sun.apoc.spi.environment.ConfigurationProvider;
import com.sun.apoc.spi.environment.EnvironmentMgr;
import com.sun.apoc.spi.file.environment.FileConfigurationProvider;
import com.sun.apoc.spi.ldap.LdapClientContext;
import com.sun.apoc.spi.ldap.datastore.LdapDataStore;
import com.sun.apoc.spi.ldap.entities.mapping.LdapEntityMapping;
import com.sun.apoc.spi.ldap.environment.LdapConfigurationProvider;
import com.sun.apoc.spi.ldap.environment.LdapEnvironmentMgr;
import com.sun.apoc.spi.util.MetaConfiguration;
import java.util.Hashtable;

public class LdapConnectionHandler {
    private String mConnectionUrl = null;
    private LdapClientContext mAuthorizedContext = null;
    private LdapClientContext mAuthenticatedContext = null;
    private LdapDataStore mDataStore = null;
    private Organization mRootOrganization = null;
    private Domain mRootDomain = null;
    private int mMaxSearchResults;

    public void openAuthorizedContext(String string, String string2, int n, int n2, String string3, char[] cArray) throws SPIException {
        if (this.mAuthorizedContext == null) {
            this.mAuthorizedContext = new LdapClientContext(string, string2, n, n2);
            this.mAuthorizedContext.connect(string3, cArray);
            this.mAuthorizedContext.setConnectionSizeLimit(this.mMaxSearchResults);
        }
    }

    public void closeAuthorizedContext() throws SPIException {
        if (this.mAuthorizedContext != null) {
            this.mAuthorizedContext.close();
            this.mAuthorizedContext = null;
        }
    }

    public void createDataStore(String string) throws SPIException {
        this.mDataStore = new LdapDataStore(string, this.mAuthorizedContext);
    }

    public void connect(String string, int n, String string2, char[] cArray, LdapEnvironmentMgr ldapEnvironmentMgr) throws SPIException {
        this.mConnectionUrl = string;
        this.mMaxSearchResults = ldapEnvironmentMgr.getSearchResultSizeLimit();
        String string3 = LdapEnvironmentMgr.getProtocolFromURL(this.mConnectionUrl);
        String string4 = LdapEnvironmentMgr.getHostFromURL(this.mConnectionUrl);
        int n2 = LdapEnvironmentMgr.getPortFromURL(this.mConnectionUrl);
        String string5 = LdapEnvironmentMgr.getBaseEntryFromURL(this.mConnectionUrl);
        this.openAuthorizedContext(string3, string4, n2, n, string2, cArray);
        this.createDataStore(string5);
        MetaConfiguration metaConfiguration = this.getMetaConfiguration(ldapEnvironmentMgr);
        this.mDataStore.setVersion(metaConfiguration);
        LdapEntityMapping ldapEntityMapping = new LdapEntityMapping(metaConfiguration);
        this.mAuthenticatedContext = new LdapClientContext(string3, string4, n2, n);
        this.mRootOrganization = this.mDataStore.createRootOrganization(ldapEntityMapping, this.mAuthorizedContext, this.mAuthenticatedContext);
        this.mRootDomain = this.mDataStore.createRootDomain(ldapEntityMapping, this.mAuthorizedContext, this.mAuthenticatedContext);
    }

    public void authenticate(String string, char[] cArray) throws SPIException {
        this.mAuthenticatedContext.authenticate(string, cArray, this.mRootOrganization, this.mAuthorizedContext);
        this.mAuthenticatedContext.setConnectionSizeLimit(this.mMaxSearchResults);
    }

    public void authenticate(Object object) throws SPIException {
        this.mAuthenticatedContext.authenticate(object);
        this.mAuthenticatedContext.setConnectionSizeLimit(this.mMaxSearchResults);
    }

    public void disconnect() throws SPIException {
        if (this.mAuthenticatedContext != null) {
            this.mAuthenticatedContext.close();
        }
    }

    public MetaConfiguration getMetaConfiguration(LdapEnvironmentMgr ldapEnvironmentMgr) throws SPIException {
        Hashtable hashtable = ldapEnvironmentMgr.getMetaConfiguration();
        if (hashtable == null) {
            hashtable = new Hashtable();
            ConfigurationProvider configurationProvider = null;
            String[] stringArray = ldapEnvironmentMgr.getMetaConfURLs();
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                try {
                    String string2 = EnvironmentMgr.getProtocolFromURL(string);
                    if (ldapEnvironmentMgr.isLdapProtocol(string2)) {
                        configurationProvider = this.getLdapMetaConfProvider(ldapEnvironmentMgr, string);
                    } else if (ldapEnvironmentMgr.isFileProtocol(string2)) {
                        configurationProvider = this.getFileMetaConfProvider(ldapEnvironmentMgr, string);
                    }
                    if (configurationProvider == null) continue;
                    hashtable = configurationProvider.loadData();
                    break;
                }
                catch (SPIException sPIException) {
                    if (configurationProvider != null) {
                        configurationProvider = null;
                    }
                    if (i != stringArray.length - 1) continue;
                    throw sPIException;
                }
            }
        }
        return new MetaConfiguration(hashtable);
    }

    private LdapConfigurationProvider getLdapMetaConfProvider(LdapEnvironmentMgr ldapEnvironmentMgr, String string) throws SPIException {
        LdapConfigurationProvider ldapConfigurationProvider = null;
        String[] stringArray = new String[]{"organizationalmapping=", "ldapattributemapping="};
        if (string.equals(this.mConnectionUrl)) {
            ldapConfigurationProvider = new LdapConfigurationProvider(string, this.mAuthorizedContext, this.mDataStore, stringArray);
        } else {
            LdapConnectionHandler ldapConnectionHandler = new LdapConnectionHandler();
            ldapConnectionHandler.openAuthorizedContext(LdapEnvironmentMgr.getProtocolFromURL(string), LdapEnvironmentMgr.getHostFromURL(string), LdapEnvironmentMgr.getPortFromURL(string), ldapEnvironmentMgr.getMetaConfTimeout(), ldapEnvironmentMgr.getMetaConfAuthUser(), ldapEnvironmentMgr.getMetaConfAuthPassword());
            ldapConnectionHandler.createDataStore(LdapEnvironmentMgr.getBaseEntryFromURL(string));
            ldapConfigurationProvider = new LdapConfigurationProvider(string, ldapConnectionHandler.getAuthorizedContext(), ldapConnectionHandler.getDataStore(), stringArray);
            ldapConnectionHandler.closeAuthorizedContext();
        }
        return ldapConfigurationProvider;
    }

    private FileConfigurationProvider getFileMetaConfProvider(LdapEnvironmentMgr ldapEnvironmentMgr, String string) throws SPIException {
        FileConfigurationProvider fileConfigurationProvider = null;
        StringBuffer stringBuffer = new StringBuffer(string);
        if (!string.endsWith("/")) {
            stringBuffer.append("/");
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(stringBuffer).append("OrganizationMapping.properties");
        String[] stringArray = new String[]{stringBuffer2.toString()};
        fileConfigurationProvider = new FileConfigurationProvider(stringArray);
        return fileConfigurationProvider;
    }

    public LdapClientContext getAuthenticatedContext() {
        return this.mAuthenticatedContext;
    }

    public LdapClientContext getAuthorizedContext() {
        return this.mAuthorizedContext;
    }

    public LdapDataStore getDataStore() {
        return this.mDataStore;
    }

    public Domain getRootDomain() {
        return this.mRootDomain;
    }

    public Organization getRootOrganization() {
        return this.mRootOrganization;
    }
}

