/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.spi.cfgtree.property;

import com.sun.apoc.spi.SPIException;
import com.sun.apoc.spi.cfgtree.ConfigElementImpl;
import com.sun.apoc.spi.cfgtree.DataType;
import com.sun.apoc.spi.cfgtree.InvalidDataTypeException;
import com.sun.apoc.spi.cfgtree.MandatoryElementException;
import com.sun.apoc.spi.cfgtree.NodeKey;
import com.sun.apoc.spi.cfgtree.NodeValueImpl;
import com.sun.apoc.spi.cfgtree.policynode.PolicyNodeImpl;
import com.sun.apoc.spi.cfgtree.policynode.ReadWritePolicyNodeImpl;
import com.sun.apoc.spi.cfgtree.property.InvalidPropertyException;
import com.sun.apoc.spi.cfgtree.property.PropertyImpl;
import com.sun.apoc.spi.policies.Policy;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class ReadWritePropertyImpl
extends PropertyImpl {
    private ReadWritePropertyImpl mDefaultProperty;
    private boolean mHasBeenModified = false;

    public void addDefaultNodeValueImpl(Policy policy) {
        if (this.mValues == null) {
            this.mValues = new Hashtable();
        }
        NodeValueImpl nodeValueImpl = this.createDefaultNodeValueImpl();
        nodeValueImpl.setOrigin(policy);
        this.mValues.put(this.mRequiredLocale, nodeValueImpl);
    }

    public void clear() throws SPIException {
        this.checkIfReadOnly();
        ReadWritePropertyImpl readWritePropertyImpl = this.mDefaultProperty;
        PolicyNodeImpl policyNodeImpl = (PolicyNodeImpl)this.getParent();
        if (readWritePropertyImpl != null) {
            this.setDefaultProperty(readWritePropertyImpl);
            readWritePropertyImpl.setOperationType(3);
            if (policyNodeImpl.isProtected()) {
                readWritePropertyImpl.setFinalized(true, this.getNameOfElementWhereProtectionSet(), this.getOriginOfProtection());
                policyNodeImpl.addProperty(readWritePropertyImpl);
            }
        } else {
            this.checkIfMandatory();
            this.setOperationType(2);
        }
        this.mHasBeenModified = true;
    }

    public void copyUpdateNodeValueImpls(Hashtable hashtable, PropertyImpl propertyImpl, Policy policy, boolean bl) throws SPIException {
        Enumeration enumeration = hashtable.keys();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                NodeValueImpl nodeValueImpl = (NodeValueImpl)hashtable.get(string);
                if (nodeValueImpl == null || !propertyImpl.isNillable() && nodeValueImpl.hasNilAttribute()) continue;
                NodeValueImpl nodeValueImpl2 = nodeValueImpl.copyNodeValueImpl();
                nodeValueImpl2.setOrigin(policy);
                propertyImpl.setNodeValue(nodeValueImpl2, string);
                nodeValueImpl2.setPropertyImpl(propertyImpl);
                if (bl) continue;
                nodeValueImpl2.setModifiedAtTopLayer();
            }
        }
    }

    public void delete() throws SPIException {
        this.checkIfReadOnly();
        if (!this.isAddedAtTopLayer()) {
            throw new MandatoryElementException("Property", this.getName(), "error.spi.policytree.element.mandatory.noremove");
        }
        this.setOperationType(2);
        this.mHasBeenModified = true;
    }

    public ReadWritePropertyImpl getDefaultProperty() throws SPIException {
        return this.mDefaultProperty != null ? (ReadWritePropertyImpl)this.mDefaultProperty.shallowCopy() : null;
    }

    public boolean hasBeenModified() {
        return this.mHasBeenModified;
    }

    public boolean processUpdateOperation(PropertyImpl propertyImpl, Policy policy, String string) throws SPIException {
        boolean bl = false;
        switch (this.mOperationType) {
            case 1: {
                bl = this.updateReplaceProperty(propertyImpl, policy, string);
                break;
            }
            case 2: {
                bl = this.updateRemoveProperty(propertyImpl, policy, string);
                break;
            }
            case 3: {
                bl = this.updateResetProperty(propertyImpl, policy, string);
                break;
            }
            case -1: 
            case 0: {
                bl = this.updateModifyProperty(propertyImpl, policy, string);
            }
        }
        return bl;
    }

    private String[] getArrayFromListValue(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, this.mSeparator);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n++] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    private String getStringFromArray(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer(200);
        for (int i = 0; i < stringArray.length - 1; ++i) {
            stringBuffer.append(stringArray[i]);
            stringBuffer.append(this.mSeparator);
        }
        stringBuffer.append(stringArray[stringArray.length - 1]);
        return stringBuffer.toString();
    }

    public void put(String string, DataType dataType) throws SPIException {
        if (string == null) {
            throw new InvalidPropertyException("error.spi.policytree.property.value.invalid");
        }
        if (this.mDataType == DataType.UNKNOWN) {
            this.mDataType = dataType;
        } else if (this.mDataType != dataType) {
            throw new InvalidDataTypeException(this.mDataType.getStringValue());
        }
        this.getNodeValue().setNewContents(string);
        this.mHasBeenModified = true;
    }

    public void putString(String string) throws SPIException {
        this.put(string, DataType.STRING);
    }

    public void putHexBinary(String string) throws SPIException {
        this.put(string, DataType.HEXBIN);
    }

    public void putInt(int n) throws SPIException {
        this.put(Integer.toString(n), DataType.INT);
    }

    public void putDouble(double d) throws SPIException {
        this.put(Double.toString(d), DataType.DOUBLE);
    }

    public void putShort(short s) throws SPIException {
        this.put(Short.toString(s), DataType.SHORT);
    }

    public void putLong(long l) throws SPIException {
        this.put(Long.toString(l), DataType.LONG);
    }

    public void putBoolean(boolean bl) throws SPIException {
        this.put(Boolean.toString(bl), DataType.BOOLEAN);
    }

    public void putStringList(String[] stringArray) throws SPIException {
        if (stringArray == null || stringArray.length == 0) {
            throw new InvalidPropertyException("error.spi.policytree.property.value.invalid");
        }
        this.put(this.getStringFromArray(stringArray), DataType.STRING_LIST);
    }

    public void putHexBinaryList(String[] stringArray) throws SPIException {
        if (stringArray == null || stringArray.length == 0) {
            throw new InvalidPropertyException("error.spi.policytree.property.value.invalid");
        }
        this.put(this.getStringFromArray(stringArray), DataType.HEXBIN_LIST);
    }

    public void putIntList(int[] nArray) throws SPIException {
        if (nArray == null || nArray.length == 0) {
            throw new InvalidPropertyException("error.spi.policytree.property.value.invalid");
        }
        StringBuffer stringBuffer = new StringBuffer(200);
        for (int i = 0; i < nArray.length - 1; ++i) {
            stringBuffer.append(nArray[i]);
            stringBuffer.append(this.mSeparator);
        }
        stringBuffer.append(nArray[nArray.length - 1]);
        this.put(stringBuffer.toString(), DataType.INT_LIST);
    }

    public void putDoubleList(double[] dArray) throws SPIException {
        if (dArray == null || dArray.length == 0) {
            throw new InvalidPropertyException("error.spi.policytree.property.value.invalid");
        }
        StringBuffer stringBuffer = new StringBuffer(200);
        for (int i = 0; i < dArray.length - 1; ++i) {
            stringBuffer.append(dArray[i]);
            stringBuffer.append(this.mSeparator);
        }
        stringBuffer.append(dArray[dArray.length - 1]);
        this.put(stringBuffer.toString(), DataType.DOUBLE_LIST);
    }

    public void putShortList(short[] sArray) throws SPIException {
        if (sArray == null || sArray.length == 0) {
            throw new InvalidPropertyException("error.spi.policytree.property.value.invalid");
        }
        StringBuffer stringBuffer = new StringBuffer(200);
        for (int i = 0; i < sArray.length - 1; ++i) {
            stringBuffer.append(sArray[i]);
            stringBuffer.append(this.mSeparator);
        }
        stringBuffer.append(sArray[sArray.length - 1]);
        this.put(stringBuffer.toString(), DataType.SHORT_LIST);
    }

    public void putLongList(long[] lArray) throws SPIException {
        if (lArray == null || lArray.length == 0) {
            throw new InvalidPropertyException("error.spi.policytree.property.value.invalid");
        }
        StringBuffer stringBuffer = new StringBuffer(200);
        for (int i = 0; i < lArray.length - 1; ++i) {
            stringBuffer.append(lArray[i]);
            stringBuffer.append(this.mSeparator);
        }
        stringBuffer.append(lArray[lArray.length - 1]);
        this.put(stringBuffer.toString(), DataType.LONG_LIST);
    }

    public void putBooleanList(String[] stringArray) throws SPIException {
        if (stringArray == null || stringArray.length == 0) {
            throw new InvalidPropertyException("error.spi.policytree.property.value.invalid");
        }
        this.put(this.getStringFromArray(stringArray), DataType.BOOLEAN_LIST);
    }

    public void putBooleanList(boolean[] blArray) throws SPIException {
        if (blArray == null || blArray.length == 0) {
            throw new InvalidPropertyException("error.spi.policytree.property.value.invalid");
        }
        StringBuffer stringBuffer = new StringBuffer(200);
        for (int i = 0; i < blArray.length - 1; ++i) {
            stringBuffer.append(blArray[i]);
            stringBuffer.append(this.mSeparator);
        }
        stringBuffer.append(blArray[blArray.length - 1]);
        this.put(stringBuffer.toString(), DataType.BOOLEAN_LIST);
    }

    public void readModifyProperty(PolicyNodeImpl policyNodeImpl, NodeKey nodeKey, String string, boolean bl) throws SPIException {
        PropertyImpl propertyImpl;
        PropertyImpl propertyImpl2 = (PropertyImpl)policyNodeImpl.getProperty(this.getName());
        if (propertyImpl2 != null && propertyImpl2.isReadOnly()) {
            return;
        }
        if (propertyImpl2 == null) {
            propertyImpl = this;
            if (!bl) {
                propertyImpl.setAddedAtTopLayer();
            }
        } else {
            propertyImpl = (PropertyImpl)propertyImpl2.shallowCopy();
            if (this.mValues != null && !this.mValues.isEmpty()) {
                this.copyUpdateNodeValueImpls(this.mValues, propertyImpl, nodeKey.mLayer, bl);
            }
        }
        propertyImpl.setPath(PolicyNodeImpl.appendToPath(policyNodeImpl.getAbsolutePath(), this.getName()));
        if (this.isProtected()) {
            propertyImpl.setFinalized(true, propertyImpl.getAbsolutePath(), this.getOriginOfProtection());
            if (bl) {
                propertyImpl.setReadOnly();
            }
        }
        propertyImpl.setOperationType(0);
        policyNodeImpl.addProperty(propertyImpl);
    }

    public void readReplaceProperty(PolicyNodeImpl policyNodeImpl, NodeKey nodeKey, String string, boolean bl) throws SPIException {
        if (policyNodeImpl.getChild(this.getName()) != null) {
            return;
        }
        if (this.isProtected()) {
            String string2 = PolicyNodeImpl.appendToPath(policyNodeImpl.getAbsolutePath(), this.getName());
            this.setFinalized(true, string2, this.getOriginOfProtection());
            if (bl) {
                this.setReadOnly();
            }
        }
        if (this.mValues == null || this.mValues.isEmpty()) {
            this.addDefaultNodeValueImpl(this.getOrigin());
        }
        if (bl) {
            this.setMandatoryFlag();
            this.setOriginOfMandatory(this.getOrigin());
        }
        if (!bl) {
            this.setAddedAtTopLayer();
        }
        this.setPath(PolicyNodeImpl.appendToPath(policyNodeImpl.getAbsolutePath(), this.getName()));
        policyNodeImpl.addProperty(this);
    }

    public void setDefaultProperty(ReadWritePropertyImpl readWritePropertyImpl) throws SPIException {
        this.mDefaultProperty = readWritePropertyImpl;
    }

    public void setNil() throws SPIException {
        this.getNodeValue().setValueToNil();
        this.mHasBeenModified = true;
    }

    public void setProtected(boolean bl) throws SPIException {
        this.setProtected(bl, this.getAbsolutePath(), this.mPolicyTree.getPolicy());
    }

    public void setProtected(boolean bl, String string, Policy policy) throws SPIException {
        this.checkIfReadOnly();
        this.mIsProtected = bl;
        this.mNameOfElementWhereProtectionSet = string;
        this.mOriginOfProtection = policy;
        this.mHasBeenModified = true;
    }

    private void setPropertyToDefault(ReadWritePropertyImpl readWritePropertyImpl) throws SPIException {
        readWritePropertyImpl.setDefaultProperty((ReadWritePropertyImpl)readWritePropertyImpl.shallowCopy());
    }

    public void setSeparator(String string) {
        if (this.mSeparator != null) {
            this.mSeparator = string;
        }
        this.mHasBeenModified = true;
    }

    public ConfigElementImpl shallowCopy() throws SPIException {
        ConfigElementImpl configElementImpl = super.shallowCopy();
        ((ReadWritePropertyImpl)configElementImpl).mDefaultProperty = this.mDefaultProperty;
        return configElementImpl;
    }

    public boolean updateModifyProperty(PropertyImpl propertyImpl, Policy policy, String string) throws SPIException {
        boolean bl = false;
        if (this.isProtected()) {
            if (this.getParent() == null || !this.getParent().isProtected()) {
                bl = true;
            }
        } else if (this.isMandatory() && this.getOriginOfMandatory().equals(policy)) {
            bl = true;
        } else if (this.mValues != null) {
            if (this.isAddedAtTopLayer()) {
                bl = true;
            } else {
                Enumeration enumeration = this.mValues.keys();
                if (enumeration != null) {
                    Hashtable<String, NodeValueImpl> hashtable = null;
                    while (enumeration.hasMoreElements()) {
                        String string2 = (String)enumeration.nextElement();
                        NodeValueImpl nodeValueImpl = this.getNodeValue(string2);
                        if (nodeValueImpl == null || !nodeValueImpl.isModifiedAtTopLayer()) continue;
                        bl = true;
                        if (hashtable == null) {
                            propertyImpl.mValues = hashtable = new Hashtable<String, NodeValueImpl>();
                        }
                        hashtable.put(string2, nodeValueImpl);
                    }
                }
            }
        }
        if (!bl) {
            ((ReadWritePolicyNodeImpl)propertyImpl.getParent()).removeProperty(this.getName());
        }
        return bl;
    }

    public boolean updateRemoveProperty(PropertyImpl propertyImpl, Policy policy, String string) throws SPIException {
        ReadWritePolicyNodeImpl readWritePolicyNodeImpl = (ReadWritePolicyNodeImpl)this.getParent();
        readWritePolicyNodeImpl.removeProperty(this.getName());
        return false;
    }

    public boolean updateReplaceProperty(PropertyImpl propertyImpl, Policy policy, String string) throws SPIException {
        boolean bl = false;
        if (this.isProtected()) {
            if (this.getParent() == null || !this.getParent().isProtected()) {
                bl = true;
            }
        } else if (this.isMandatory() && this.getOriginOfMandatory().equals(policy)) {
            bl = true;
        } else if (this.mValues != null) {
            if (this.isAddedAtTopLayer()) {
                bl = true;
            } else {
                Enumeration enumeration = this.mValues.keys();
                if (enumeration != null) {
                    Hashtable<String, NodeValueImpl> hashtable = null;
                    while (enumeration.hasMoreElements()) {
                        String string2 = (String)enumeration.nextElement();
                        NodeValueImpl nodeValueImpl = this.getNodeValue(string2);
                        if (nodeValueImpl == null || !nodeValueImpl.isModifiedAtTopLayer()) continue;
                        bl = true;
                        if (hashtable == null) {
                            propertyImpl.mValues = hashtable = new Hashtable<String, NodeValueImpl>();
                        }
                        hashtable.put(string2, nodeValueImpl);
                    }
                }
            }
        }
        if (bl) {
            this.setOperationType(0);
            propertyImpl.setOperationType(0);
        } else {
            ((ReadWritePolicyNodeImpl)propertyImpl.getParent()).removeProperty(this.getName());
        }
        return bl;
    }

    public boolean updateResetProperty(PropertyImpl propertyImpl, Policy policy, String string) throws SPIException {
        Enumeration enumeration;
        boolean bl = false;
        if (this.isProtected()) {
            if (this.getParent() == null || !this.getParent().isProtected()) {
                bl = true;
            }
        } else if (this.isMandatory() && this.getOriginOfMandatory() != null && policy.equals(this.getOriginOfMandatory())) {
            bl = true;
        } else if (this.mValues != null && (enumeration = this.mValues.keys()) != null) {
            Hashtable<String, NodeValueImpl> hashtable = null;
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                NodeValueImpl nodeValueImpl = this.getNodeValue(string2);
                if (nodeValueImpl == null || !nodeValueImpl.isModifiedAtTopLayer()) continue;
                bl = true;
                if (hashtable == null) {
                    propertyImpl.mValues = hashtable = new Hashtable<String, NodeValueImpl>();
                }
                hashtable.put(string2, nodeValueImpl);
            }
        }
        if (bl) {
            propertyImpl.setOperationType(0);
        }
        return bl;
    }
}

