/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.spi.cfgtree.policynode;

import com.sun.apoc.spi.SPIException;
import com.sun.apoc.spi.cfgtree.ConfigElementImpl;
import com.sun.apoc.spi.cfgtree.NodeKey;
import com.sun.apoc.spi.cfgtree.OperationType;
import com.sun.apoc.spi.cfgtree.ProtectedElementImpl;
import com.sun.apoc.spi.cfgtree.XMLStreamable;
import com.sun.apoc.spi.cfgtree.policynode.InvalidPolicyNodeException;
import com.sun.apoc.spi.cfgtree.policynode.MergedPolicyNode;
import com.sun.apoc.spi.cfgtree.policynode.PolicyNode;
import com.sun.apoc.spi.cfgtree.property.Property;
import com.sun.apoc.spi.cfgtree.property.PropertyImpl;
import com.sun.apoc.spi.policies.Policy;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public abstract class PolicyNodeImpl
extends ProtectedElementImpl
implements PolicyNode,
MergedPolicyNode,
XMLStreamable {
    public Vector mAllChildrenNames;
    public Hashtable mChildNodeTable;
    public Hashtable mPropertyTable;
    public Vector mRemovedChildren;
    protected Policy mOriginLayer;
    protected String mNameOfElementWhereProtectionSet;
    protected Policy mOriginOfProtection;
    private static final String MODULE = "PolicyNodeImpl";
    public static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n";
    private static final String COMPONENT_NAMESPACE = " xmlns:oor=\"http://openoffice.org/2001/registry\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"";

    public void addChildNode(PolicyNodeImpl policyNodeImpl) {
        PolicyNodeImpl policyNodeImpl2;
        if (policyNodeImpl == null) {
            return;
        }
        if (this.mAllChildrenNames == null) {
            this.mAllChildrenNames = new Vector();
        }
        if (this.mChildNodeTable == null) {
            this.mChildNodeTable = new Hashtable();
        }
        if ((policyNodeImpl2 = (PolicyNodeImpl)this.mChildNodeTable.get(policyNodeImpl.getName())) != null) {
            int n = this.mAllChildrenNames.indexOf(policyNodeImpl2.getName());
            if (n > -1) {
                this.mAllChildrenNames.setElementAt(policyNodeImpl.getName(), n);
            } else {
                this.mAllChildrenNames.add(policyNodeImpl.getName());
            }
        } else {
            this.mAllChildrenNames.add(policyNodeImpl.getName());
        }
        this.mChildNodeTable.put(policyNodeImpl.getName(), policyNodeImpl);
        policyNodeImpl.setParent(this);
    }

    public abstract PolicyNode addNode(String var1) throws SPIException;

    public abstract Property addProperty(String var1) throws SPIException;

    public void addProperty(PropertyImpl propertyImpl) {
        PropertyImpl propertyImpl2;
        if (propertyImpl == null) {
            return;
        }
        if (this.mAllChildrenNames == null) {
            this.mAllChildrenNames = new Vector();
        }
        if (this.mPropertyTable == null) {
            this.mPropertyTable = new Hashtable();
        }
        if ((propertyImpl2 = (PropertyImpl)this.mPropertyTable.get(propertyImpl.getName())) != null) {
            int n = this.mAllChildrenNames.indexOf(propertyImpl2.getName());
            if (n > -1) {
                this.mAllChildrenNames.setElementAt(propertyImpl.getName(), n);
            } else {
                this.mAllChildrenNames.add(propertyImpl.getName());
            }
        } else {
            this.mAllChildrenNames.add(propertyImpl.getName());
        }
        this.mPropertyTable.put(propertyImpl.getName(), propertyImpl);
        propertyImpl.setParent(this);
    }

    public void addRemovedChild(Object object) {
        if (object == null) {
            return;
        }
        if (this.mRemovedChildren == null) {
            this.mRemovedChildren = new Vector();
        }
        this.mRemovedChildren.add(object);
    }

    public void changeProtectedNodesToReadOnly() {
        if (this.isProtected()) {
            this.mIsReadOnly = true;
            this.mIsProtected = false;
        }
        if (this.mAllChildrenNames != null) {
            for (int i = 0; i < this.mAllChildrenNames.size(); ++i) {
                PropertyImpl propertyImpl;
                String string = (String)this.mAllChildrenNames.get(i);
                PolicyNodeImpl policyNodeImpl = null;
                if (this.mChildNodeTable != null && (policyNodeImpl = (PolicyNodeImpl)this.mChildNodeTable.get(string)) != null) {
                    policyNodeImpl.changeProtectedNodesToReadOnly();
                }
                if (policyNodeImpl != null || this.mPropertyTable == null || (propertyImpl = (PropertyImpl)this.mPropertyTable.get(string)) == null) continue;
                propertyImpl.setReadOnly();
            }
        }
    }

    public void checkIfNodeOrChildrenReadOnly() throws SPIException {
        this.checkIfReadOnly();
        if (this.mAllChildrenNames != null) {
            for (int i = 0; i < this.mAllChildrenNames.size(); ++i) {
                PropertyImpl propertyImpl;
                String string = (String)this.mAllChildrenNames.get(i);
                PolicyNodeImpl policyNodeImpl = null;
                if (this.mChildNodeTable != null && (policyNodeImpl = (PolicyNodeImpl)this.mChildNodeTable.get(string)) != null) {
                    policyNodeImpl.checkIfNodeOrChildrenReadOnly();
                }
                if (policyNodeImpl != null || this.mPropertyTable == null || (propertyImpl = (PropertyImpl)this.mPropertyTable.get(string)) == null) continue;
                propertyImpl.checkIfReadOnly();
            }
        }
    }

    public void checkIfPropertiesReadOnly() throws SPIException {
        if (this.mAllChildrenNames != null && this.mPropertyTable != null && !this.mPropertyTable.isEmpty()) {
            for (int i = 0; i < this.mAllChildrenNames.size(); ++i) {
                String string = (String)this.mAllChildrenNames.get(i);
                PropertyImpl propertyImpl = (PropertyImpl)this.mPropertyTable.get(string);
                if (propertyImpl == null) continue;
                propertyImpl.checkIfReadOnly();
            }
        }
    }

    public void checkIfNodeOrChildrenReadOnlyOrMandatory() throws SPIException {
        this.checkIfReadOnly();
        this.checkIfMandatory();
        if (this.mAllChildrenNames != null) {
            for (int i = 0; i < this.mAllChildrenNames.size(); ++i) {
                PropertyImpl propertyImpl;
                String string = (String)this.mAllChildrenNames.get(i);
                PolicyNodeImpl policyNodeImpl = null;
                if (this.mChildNodeTable != null && (policyNodeImpl = (PolicyNodeImpl)this.mChildNodeTable.get(string)) != null) {
                    policyNodeImpl.checkIfNodeOrChildrenReadOnlyOrMandatory();
                }
                if (policyNodeImpl != null || this.mPropertyTable == null || (propertyImpl = (PropertyImpl)this.mPropertyTable.get(string)) == null) continue;
                propertyImpl.checkIfReadOnly();
                propertyImpl.checkIfMandatory();
            }
        }
    }

    public abstract void clearProperties() throws SPIException;

    public Vector copyNodeVector(Vector vector) throws SPIException {
        Vector<PolicyNodeImpl> vector2 = new Vector<PolicyNodeImpl>();
        for (int i = 0; i < vector.size(); ++i) {
            PolicyNodeImpl policyNodeImpl = (PolicyNodeImpl)vector.get(i);
            if (policyNodeImpl == null) continue;
            vector2.add(policyNodeImpl.deepCopy());
        }
        return vector2;
    }

    public PolicyNodeImpl deepCopy() throws SPIException {
        PolicyNodeImpl policyNodeImpl = (PolicyNodeImpl)this.shallowCopy();
        if (this.mAllChildrenNames != null) {
            for (int i = 0; i < this.mAllChildrenNames.size(); ++i) {
                PropertyImpl propertyImpl;
                String string = (String)this.mAllChildrenNames.get(i);
                if (string == null) continue;
                PolicyNodeImpl policyNodeImpl2 = null;
                if (this.mChildNodeTable != null && (policyNodeImpl2 = (PolicyNodeImpl)this.mChildNodeTable.get(string)) != null) {
                    policyNodeImpl.addChildNode(policyNodeImpl2.deepCopy());
                }
                if (policyNodeImpl2 != null || this.mPropertyTable == null || (propertyImpl = (PropertyImpl)this.mPropertyTable.get(string)) == null) continue;
                policyNodeImpl.addProperty((PropertyImpl)propertyImpl.shallowCopy());
            }
        }
        return policyNodeImpl;
    }

    public void delete() throws SPIException {
        this.checkIfReadOnly();
        this.checkIfNodeOrChildrenReadOnlyOrMandatory();
        this.setOperationType(2);
    }

    public void deleteChildNode(String string) {
        PolicyNodeImpl policyNodeImpl = null;
        if (this.mChildNodeTable != null && (policyNodeImpl = (PolicyNodeImpl)this.mChildNodeTable.get(string)) != null) {
            this.mChildNodeTable.remove(string);
        }
        if (policyNodeImpl != null && this.mAllChildrenNames != null) {
            this.mAllChildrenNames.remove(string);
        }
    }

    public void deleteProperty(PropertyImpl propertyImpl) {
        if (propertyImpl == null) {
            return;
        }
        if (this.mPropertyTable != null) {
            this.mPropertyTable.remove(propertyImpl.getName());
        }
        if (this.mAllChildrenNames != null) {
            this.mAllChildrenNames.remove(propertyImpl.getName());
        }
    }

    public void expand(String string, boolean bl) throws SPIException {
        String string2;
        ProtectedElementImpl protectedElementImpl;
        Enumeration enumeration;
        this.mPath = string;
        if (this.isProtected()) {
            if (this.getParent() == null || !this.getParent().isProtected()) {
                this.setFinalized(true, this.getAbsolutePath(), this.getOriginOfProtection());
            }
            if (bl) {
                this.setReadOnly();
            }
        }
        if (this.mPropertyTable != null) {
            enumeration = this.mPropertyTable.elements();
            while (enumeration.hasMoreElements()) {
                protectedElementImpl = (PropertyImpl)enumeration.nextElement();
                string2 = PolicyNodeImpl.appendToPath(string, protectedElementImpl.getName());
                ((PropertyImpl)protectedElementImpl).expand(string2, bl);
            }
        }
        if (this.mChildNodeTable != null) {
            enumeration = this.mChildNodeTable.elements();
            while (enumeration.hasMoreElements()) {
                protectedElementImpl = (PolicyNodeImpl)enumeration.nextElement();
                string2 = PolicyNodeImpl.appendToPath(string, protectedElementImpl.getName());
                ((PolicyNodeImpl)protectedElementImpl).expand(string2, bl);
            }
        }
    }

    public Vector getAllChildrenNames() {
        return this.mAllChildrenNames;
    }

    public String getAttributes(int n) {
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("oor:name").append("=\"").append(this.mName);
        stringBuffer.append("\"");
        if (this.getPackage() != null) {
            stringBuffer.append(" ").append("oor:package").append("=\"").append(this.getPackage()).append("\"");
        }
        String string = OperationType.getString(this.getOperationType());
        switch (n) {
            case 0: 
            case 1: {
                if (this.isProtected() && (this.getParent() == null || !((PolicyNodeImpl)this.getParent()).isProtected())) {
                    stringBuffer.append(" ").append("oor:finalized").append("=\"true\"");
                }
                if (n == 1 && this.isMandatory() && this.getOriginOfMandatory().equals(this.getPolicyTree().getPolicy())) {
                    stringBuffer.append(" ");
                    stringBuffer.append("oor:mandatory");
                    stringBuffer.append("=\"true\"");
                }
                if (n == 0 && this.isMandatory()) {
                    stringBuffer.append(" ");
                    stringBuffer.append("oor:mandatory");
                    stringBuffer.append("=\"true\"");
                }
                if (string == null) break;
                switch (OperationType.getInt(string)) {
                    case 1: 
                    case 2: {
                        stringBuffer.append(" ").append("oor:op").append("=\"").append(string).append("\"");
                    }
                }
                break;
            }
            case 2: {
                if (this.isReadOnly()) {
                    stringBuffer.append(" ").append("oor:readonly").append("=\"true\"");
                } else if (this.isProtected()) {
                    stringBuffer.append(" ").append("oor:finalized").append("=\"true\"");
                }
                if (this.isMandatory()) {
                    stringBuffer.append(" ").append("oor:mandatory").append("=\"true\"");
                }
                if (string == null) break;
                stringBuffer.append(" ").append("oor:op").append("=\"").append(string).append("\"");
            }
        }
        return stringBuffer.toString();
    }

    public PolicyNodeImpl getChild(String string) {
        if (string == null || this.mAllChildrenNames == null || this.mChildNodeTable == null) {
            return null;
        }
        return (PolicyNodeImpl)this.mChildNodeTable.get(string);
    }

    public Iterator getChildNodes() {
        if (this.mChildNodeTable == null || this.mChildNodeTable.isEmpty()) {
            return new Vector().iterator();
        }
        Vector<PolicyNodeImpl> vector = new Vector<PolicyNodeImpl>();
        for (int i = 0; i < this.mAllChildrenNames.size(); ++i) {
            String string = (String)this.mAllChildrenNames.get(i);
            PolicyNodeImpl policyNodeImpl = (PolicyNodeImpl)this.mChildNodeTable.get(string);
            if (policyNodeImpl == null) continue;
            vector.add(policyNodeImpl);
        }
        return vector.iterator();
    }

    public PolicyNodeImpl getChildNode(String string) {
        if (this.mChildNodeTable == null || this.mChildNodeTable.isEmpty()) {
            return null;
        }
        return (PolicyNodeImpl)this.mChildNodeTable.get(string);
    }

    public Hashtable getChildNodeTable() {
        return this.mChildNodeTable;
    }

    public String[] getChildrenNames() {
        if (this.mChildNodeTable == null || this.mChildNodeTable.isEmpty()) {
            return new String[0];
        }
        String[] stringArray = new String[this.mChildNodeTable.size()];
        Enumeration enumeration = this.mChildNodeTable.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = (String)enumeration.nextElement();
        }
        return stringArray;
    }

    public String getNameOfElementWhereProtectionSet() {
        return this.mNameOfElementWhereProtectionSet;
    }

    public Policy getOrigin() {
        return this.mOriginLayer;
    }

    public Policy getOriginOfProtection() {
        return this.mOriginOfProtection;
    }

    public Iterator getProperties() {
        if (this.mPropertyTable == null || this.mPropertyTable.isEmpty()) {
            return new Vector().iterator();
        }
        Vector<PropertyImpl> vector = new Vector<PropertyImpl>();
        for (int i = 0; i < this.mAllChildrenNames.size(); ++i) {
            String string = (String)this.mAllChildrenNames.get(i);
            PropertyImpl propertyImpl = (PropertyImpl)this.mPropertyTable.get(string);
            if (propertyImpl == null) continue;
            vector.add(propertyImpl);
        }
        return vector.iterator();
    }

    public Property getProperty(String string) {
        if (this.mPropertyTable == null || this.mPropertyTable.isEmpty()) {
            return null;
        }
        return (PropertyImpl)this.mPropertyTable.get(string);
    }

    public String[] getPropertyNames() {
        if (this.mPropertyTable == null || this.mPropertyTable.isEmpty()) {
            return new String[0];
        }
        String[] stringArray = new String[this.mPropertyTable.size()];
        Enumeration enumeration = this.mPropertyTable.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = (String)enumeration.nextElement();
        }
        return stringArray;
    }

    public Hashtable getPropertyTable() {
        return this.mPropertyTable;
    }

    public void printChildren(String string, PrintStream printStream, int n) {
        if (this.mAllChildrenNames != null) {
            for (int i = 0; i < this.mAllChildrenNames.size(); ++i) {
                PropertyImpl propertyImpl;
                String string2 = (String)this.mAllChildrenNames.get(i);
                PolicyNodeImpl policyNodeImpl = null;
                if (this.mChildNodeTable != null && (policyNodeImpl = (PolicyNodeImpl)this.mChildNodeTable.get(string2)) != null) {
                    policyNodeImpl.printToStream(string, printStream, n);
                }
                if (policyNodeImpl != null || this.mPropertyTable == null || (propertyImpl = (PropertyImpl)this.mPropertyTable.get(string2)) == null) continue;
                propertyImpl.printToStream(string, printStream, n);
            }
        }
    }

    public void printTag(String string, PrintStream printStream, boolean bl, int n) {
        if (bl && this.getParent() == null) {
            printStream.print(XML_HEADER);
        }
        printStream.print(string + (bl ? "<" : "</"));
        switch (n) {
            case 0: 
            case 1: {
                if (this.getParent() == null) {
                    printStream.print("oor:");
                    printStream.print("component-data");
                    if (!bl) break;
                    printStream.print(COMPONENT_NAMESPACE);
                    break;
                }
                printStream.print("node");
                break;
            }
            case 2: {
                printStream.print("node");
            }
        }
        if (bl) {
            printStream.print(" " + this.getAttributes(n));
        }
        printStream.print(">\n");
    }

    public void printToStream(String string, PrintStream printStream, int n) {
        this.printTag(string, printStream, true, n);
        this.printChildren(string + '\t', printStream, n);
        this.printTag(string, printStream, false, n);
    }

    public abstract void readModifyNode(PolicyNodeImpl var1, NodeKey var2, String var3, boolean var4) throws SPIException;

    public abstract void readRemoveNode(PolicyNodeImpl var1, String var2, boolean var3) throws SPIException;

    public abstract void readReplaceNode(PolicyNodeImpl var1, NodeKey var2, String var3, boolean var4) throws SPIException;

    public abstract void removeNode(String var1) throws SPIException;

    public abstract void removeProperty(String var1) throws SPIException;

    public abstract PolicyNode addReplaceNode(String var1) throws SPIException;

    public void setFinalized(boolean bl, String string, Policy policy) {
        ProtectedElementImpl protectedElementImpl;
        Enumeration enumeration;
        super.setFinalized(bl);
        this.mNameOfElementWhereProtectionSet = string;
        this.mOriginOfProtection = policy;
        if (this.mChildNodeTable != null) {
            enumeration = this.mChildNodeTable.elements();
            while (enumeration.hasMoreElements()) {
                protectedElementImpl = (PolicyNodeImpl)enumeration.nextElement();
                ((PolicyNodeImpl)protectedElementImpl).setFinalized(bl, string, policy);
            }
        }
        if (this.mPropertyTable != null) {
            enumeration = this.mPropertyTable.elements();
            while (enumeration.hasMoreElements()) {
                protectedElementImpl = (PropertyImpl)enumeration.nextElement();
                ((PropertyImpl)protectedElementImpl).setFinalized(bl, string, policy);
            }
        }
    }

    public void setOrigin(Policy policy) {
        this.mOriginLayer = policy;
    }

    public void setReadOnly() {
        ProtectedElementImpl protectedElementImpl;
        Enumeration enumeration;
        if (this.mIsProtected) {
            this.mIsReadOnly = true;
            this.mIsProtected = false;
        }
        if (this.mChildNodeTable != null) {
            enumeration = this.mChildNodeTable.elements();
            while (enumeration.hasMoreElements()) {
                protectedElementImpl = (PolicyNodeImpl)enumeration.nextElement();
                ((PolicyNodeImpl)protectedElementImpl).setReadOnly();
            }
        }
        if (this.mPropertyTable != null) {
            enumeration = this.mPropertyTable.elements();
            while (enumeration.hasMoreElements()) {
                protectedElementImpl = (PropertyImpl)enumeration.nextElement();
                protectedElementImpl.setReadOnly();
            }
        }
    }

    public void setSettingsForAddedNode(String string, Policy policy, boolean bl) throws SPIException {
        this.setPath(string);
        if (policy != null) {
            this.setOrigin(policy);
        }
        if (!bl) {
            this.setAddedAtTopLayer();
        }
        String string2 = null;
        if (this.mAllChildrenNames != null) {
            for (int i = 0; i < this.mAllChildrenNames.size(); ++i) {
                PropertyImpl propertyImpl;
                String string3 = (String)this.mAllChildrenNames.get(i);
                PolicyNodeImpl policyNodeImpl = null;
                if (this.mChildNodeTable != null && (policyNodeImpl = (PolicyNodeImpl)this.mChildNodeTable.get(string3)) != null) {
                    string2 = PolicyNodeImpl.appendToPath(string, policyNodeImpl.getName());
                    policyNodeImpl.setSettingsForAddedNode(string2, policy, bl);
                }
                if (policyNodeImpl != null || this.mPropertyTable == null || (propertyImpl = (PropertyImpl)this.mPropertyTable.get(string3)) == null) continue;
                string2 = PolicyNodeImpl.appendToPath(string, propertyImpl.getName());
                propertyImpl.setSettingsForAddedProperty(string2, policy, bl);
            }
        }
    }

    public ConfigElementImpl shallowCopy() throws SPIException {
        ConfigElementImpl configElementImpl = super.shallowCopy();
        if (this.mRemovedChildren != null) {
            ((PolicyNodeImpl)configElementImpl).mRemovedChildren = this.copyNodeVector(this.mRemovedChildren);
        }
        ((PolicyNodeImpl)configElementImpl).mNameOfElementWhereProtectionSet = this.mNameOfElementWhereProtectionSet;
        ((PolicyNodeImpl)configElementImpl).mOriginOfProtection = this.mOriginOfProtection;
        ((PolicyNodeImpl)configElementImpl).mOriginLayer = this.mOriginLayer;
        return configElementImpl;
    }

    public void processReadOperation(PolicyNodeImpl policyNodeImpl, NodeKey nodeKey, String string, boolean bl) throws SPIException {
        if (this.mName == null) {
            throw new InvalidPolicyNodeException();
        }
        switch (this.mOperationType) {
            case 1: {
                this.readReplaceNode(policyNodeImpl, nodeKey, string, bl);
                break;
            }
            case 2: {
                this.readRemoveNode(policyNodeImpl, string, bl);
                break;
            }
            case -1: 
            case 0: {
                this.readModifyNode(policyNodeImpl, nodeKey, string, bl);
            }
        }
    }

    public static String appendToPath(String string, String string2) throws SPIException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append("/");
        try {
            if (string2.indexOf(47) != -1) {
                stringBuffer.append(URLEncoder.encode(string2, "UTF-8"));
            } else {
                stringBuffer.append(string2);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SPIException(unsupportedEncodingException);
        }
        return stringBuffer.toString();
    }
}

