/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.spi.ldap.environment;

import com.sun.apoc.spi.SPIException;
import com.sun.apoc.spi.environment.EnvironmentMgr;
import com.sun.apoc.spi.environment.InvalidParameterException;
import com.sun.apoc.spi.environment.MissingParameterException;
import java.util.Hashtable;

public class LdapEnvironmentMgr
extends EnvironmentMgr {
    private static final int MINPORTNUMBER = 0;
    private static final int MAXPORTNUMBER = 65535;

    public LdapEnvironmentMgr(Hashtable hashtable) {
        super(hashtable);
    }

    private void checkURL(String string, String string2) throws SPIException {
        if (LdapEnvironmentMgr.getProtocolFromURL(string).equals("ldap")) {
            int n = LdapEnvironmentMgr.getPortFromURL(string);
            if (n < 0 || n > 65535) {
                throw new InvalidParameterException(string2 + " " + "PROVIDER_URL" + "#port", String.valueOf(n), "[0,65535]");
            }
            if (LdapEnvironmentMgr.getBaseEntryFromURL(string) == null) {
                throw new MissingParameterException(string2 + " " + "PROVIDER_URL" + "#BaseDN");
            }
        }
    }

    public void checkEnvironment() throws SPIException {
        boolean bl;
        Object object;
        int n;
        Object object2;
        String[] stringArray = this.getOrganizationURLs();
        for (int i = 0; i < stringArray.length; ++i) {
            this.checkURL(stringArray[i], "organization");
            object2 = this.getOrganizationUser(stringArray[i]);
            n = object2 == null || ((String)object2).length() == 0 ? 1 : 0;
            object = this.getOrganizationCredentials();
            boolean bl2 = bl = object == null || ((char[])object).length == 0;
            if (!bl || n != 0) continue;
            throw new MissingParameterException("organization SECURITY_CREDENTIALS");
        }
        String string = this.getOrganizationAuthType();
        if (!string.equals("Anonymous") && !string.equals("GSSAPI")) {
            throw new InvalidParameterException("organization AuthType", string, "{Anonymous,GSSAPI}");
        }
        object2 = this.getDomainURLs();
        for (n = 0; n < ((String[])object2).length; ++n) {
            boolean bl3;
            this.checkURL((String)object2[n], "domain");
            object = this.getDomainUser((String)object2[n]);
            bl = object == null || ((String)object).length() == 0;
            char[] cArray = this.getDomainCredentials();
            boolean bl4 = bl3 = cArray == null || cArray.length == 0;
            if (!bl3 || bl) continue;
            throw new MissingParameterException("domain SECURITY_CREDENTIALS");
        }
        string = this.getDomainAuthType();
        if (!string.equals("Anonymous") && !string.equals("GSSAPI")) {
            throw new InvalidParameterException("domain AuthType", string, "{Anonymous,GSSAPI}");
        }
        String[] stringArray2 = this.getProfileURLs();
        for (int i = 0; i < stringArray2.length; ++i) {
            boolean bl5;
            this.checkURL(stringArray2[i], "profile");
            String string2 = this.getProfileUser(stringArray2[i]);
            boolean bl6 = string2 == null || string2.length() == 0;
            char[] cArray = this.getProfileCredentials();
            boolean bl7 = bl5 = cArray == null || cArray.length == 0;
            if (!bl5 || bl6) continue;
            throw new MissingParameterException("profile SECURITY_CREDENTIALS");
        }
        string = this.getProfileAuthType();
        if (!string.equals("Anonymous") && !string.equals("GSSAPI")) {
            throw new InvalidParameterException("profile AuthType", string, "{Anonymous,GSSAPI}");
        }
        String[] stringArray3 = this.getAssignmentURLs();
        for (int i = 0; i < stringArray3.length; ++i) {
            boolean bl8;
            this.checkURL(stringArray3[i], "assignment");
            String string3 = this.getAssignmentUser(stringArray3[i]);
            boolean bl9 = string3 == null || string3.length() == 0;
            char[] cArray = this.getAssignmentCredentials();
            boolean bl10 = bl8 = cArray == null || cArray.length == 0;
            if (!bl8 || bl9) continue;
            throw new MissingParameterException("assignment SECURITY_CREDENTIALS");
        }
        string = this.getAssignmentAuthType();
        if (!string.equals("Anonymous") && !string.equals("GSSAPI")) {
            throw new InvalidParameterException("assignment AuthType", string, "{Anonymous,GSSAPI}");
        }
        String[] stringArray4 = this.getMetaConfURLs();
        for (int i = 0; i < stringArray4.length; ++i) {
            this.checkURL(stringArray4[i], "metaconfiguration");
        }
    }

    public static String getHostFromURL(String string) {
        String string2 = EnvironmentMgr.getHostFromURL(string);
        if (string2 == null || string2.equals("")) {
            string2 = "localhost";
        }
        return string2;
    }

    public static int getPortFromURL(String string) {
        int n = EnvironmentMgr.getPortFromURL(string);
        if (n < 0) {
            n = 389;
        }
        return n;
    }

    public Hashtable getMetaConfiguration() {
        return (Hashtable)this.mEnvironment.get("ldap");
    }

    public String getOrganizationAuthUser() {
        String string = this.getParam("ORGANIZATION_", "AuthDn");
        if (string == null) {
            string = "Anonymous";
        }
        return string;
    }

    public String getDomainAuthUser() {
        String string = this.getParam("DOMAIN_", "AuthDn");
        if (string == null) {
            string = "Anonymous";
        }
        return string;
    }

    public String getProfileAuthUser() {
        String string = this.getParam("PROFILE_", "AuthDn");
        if (string == null) {
            string = "Anonymous";
        }
        return string;
    }

    public String getAssignmentAuthUser() {
        String string = this.getParam("ASSIGNMENT_", "AuthDn");
        if (string == null) {
            string = "Anonymous";
        }
        return string;
    }

    public String getMetaConfAuthUser() {
        String string = this.getParam("LDAP_META_CONF_", "AuthDn");
        if (string == null) {
            string = "Anonymous";
        }
        return string;
    }

    public char[] getOrganizationAuthPassword() {
        return this.getPasswordParam("ORGANIZATION_", "Password");
    }

    public char[] getDomainAuthPassword() {
        return this.getPasswordParam("DOMAIN_", "Password");
    }

    public char[] getProfileAuthPassword() {
        return this.getPasswordParam("PROFILE_", "Password");
    }

    public char[] getAssignmentAuthPassword() {
        return this.getPasswordParam("ASSIGNMENT_", "Password");
    }

    public char[] getMetaConfAuthPassword() {
        return this.getPasswordParam("LDAP_META_CONF_", "Password");
    }

    public String getOrganizationAuthType() {
        String string = this.getParam("ORGANIZATION_", "AuthType");
        if (string == null || string.length() == 0) {
            string = "Anonymous";
        }
        return string;
    }

    public String getDomainAuthType() {
        String string = this.getParam("DOMAIN_", "AuthType");
        if (string == null || string.length() == 0) {
            string = "Anonymous";
        }
        return string;
    }

    public String getProfileAuthType() {
        String string = this.getParam("PROFILE_", "AuthType");
        if (string == null || string.length() == 0) {
            string = "Anonymous";
        }
        return string;
    }

    public String getAssignmentAuthType() {
        String string = this.getParam("ASSIGNMENT_", "AuthType");
        if (string == null || string.length() == 0) {
            string = "Anonymous";
        }
        return string;
    }

    public int getOrganizationTimeout() {
        String string = this.getParam("ORGANIZATION_", "ConnectTimeout");
        return this.getIntParamFromString(string, 1);
    }

    public int getDomainTimeout() {
        String string = this.getParam("DOMAIN_", "ConnectTimeout");
        return this.getIntParamFromString(string, 1);
    }

    public int getAssignmentTimeout() {
        String string = this.getParam("ASSIGNMENT_", "ConnectTimeout");
        return this.getIntParamFromString(string, 1);
    }

    public int getProfileTimeout() {
        String string = this.getParam("PROFILE_", "ConnectTimeout");
        return this.getIntParamFromString(string, 1);
    }

    public int getMetaConfTimeout() {
        String string = this.getParam("LDAP_META_CONF_", "ConnectTimeout");
        return this.getIntParamFromString(string, 1);
    }

    public static String getBaseEntryFromURL(String string) {
        String string2 = null;
        string2 = LdapEnvironmentMgr.getPathFromURL(string);
        if (string2 != null && string2.startsWith("/")) {
            string2 = string2.substring(1);
        }
        return string2;
    }

    public String[] getMetaConfURLs() {
        String string = this.getParam("LDAP_META_CONF_", "PROVIDER_URL");
        return this.getURLList(string);
    }

    public Object getOrganizationCallbackHandler() {
        Object var1_1 = null;
        var1_1 = this.mEnvironment.get("ORGANIZATION_AuthCallbackHandler");
        if (var1_1 == null) {
            var1_1 = this.mEnvironment.get("AuthCallbackHandler");
        }
        return var1_1;
    }

    public Object getDomainCallbackHandler() {
        Object var1_1 = null;
        var1_1 = this.mEnvironment.get("DOMAIN_AuthCallbackHandler");
        if (var1_1 == null) {
            var1_1 = this.mEnvironment.get("AuthCallbackHandler");
        }
        return var1_1;
    }

    public Object getProfileCallbackHandler() {
        Object var1_1 = null;
        var1_1 = this.mEnvironment.get("PROFILE_AuthCallbackHandler");
        if (var1_1 == null) {
            var1_1 = this.mEnvironment.get("AuthCallbackHandler");
        }
        return var1_1;
    }

    public Object getAssignmentCallbackHandler() {
        Object var1_1 = null;
        var1_1 = this.mEnvironment.get("ASSIGNMENT_AuthCallbackHandler");
        if (var1_1 == null) {
            var1_1 = this.mEnvironment.get("AuthCallbackHandler");
        }
        return var1_1;
    }

    public int getSearchResultSizeLimit() {
        String string = this.getStringParam("SizeLimit");
        int n = this.getIntParamFromString(string, 100);
        return n;
    }
}

