/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.spi.ldap.entities;

import com.sun.apoc.spi.IllegalReadException;
import com.sun.apoc.spi.SPIException;
import com.sun.apoc.spi.entities.Domain;
import com.sun.apoc.spi.entities.Entity;
import com.sun.apoc.spi.entities.InvalidFilterException;
import com.sun.apoc.spi.ldap.LdapClientContext;
import com.sun.apoc.spi.ldap.datastore.LdapDataStore;
import com.sun.apoc.spi.ldap.entities.LdapEntityType;
import com.sun.apoc.spi.ldap.entities.LdapNode;
import com.sun.apoc.spi.ldap.entities.mapping.LdapEntityMapping;
import com.sun.apoc.spi.util.BooleanReturnValue;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import netscape.ldap.LDAPDN;

public class LdapDomain
extends LdapNode
implements Domain {
    private LdapDomain mParent;

    public LdapDomain(String string, int n, LdapDataStore ldapDataStore, LdapEntityMapping ldapEntityMapping, LdapClientContext ldapClientContext) {
        super(string, n, ldapDataStore, ldapEntityMapping, ldapClientContext);
        this.setIsDomainTree();
        if (string.startsWith("1__")) {
            this.mLocation = string.substring("1__".length());
        }
    }

    public boolean equals(Object object) {
        if (object instanceof LdapDomain) {
            return LDAPDN.equals((String)this.mLocation.toLowerCase(), (String)((LdapDomain)object).mLocation.toLowerCase());
        }
        return false;
    }

    public Iterator getChildren() throws SPIException {
        BooleanReturnValue booleanReturnValue = new BooleanReturnValue(false);
        return this.getChildren(false, booleanReturnValue);
    }

    public Iterator getChildren(boolean bl, BooleanReturnValue booleanReturnValue) throws SPIException {
        Vector vector = this.getAllChildrenList(bl, booleanReturnValue);
        return vector.iterator();
    }

    public Entity[] getChildrenArray(boolean bl, BooleanReturnValue booleanReturnValue) throws SPIException {
        Vector vector = this.getAllChildrenList(bl, booleanReturnValue);
        Entity[] entityArray = new Entity[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            entityArray[i] = (Entity)vector.get(i);
        }
        return entityArray;
    }

    public Vector getAllChildrenList(boolean bl, BooleanReturnValue booleanReturnValue) throws SPIException {
        Vector vector = new Vector();
        String string = null;
        String string2 = this.buildClassFilter(this.mEntityMapping.mDomainMapping, false);
        Vector vector2 = this.getChildrenList(string2, LdapEntityType.DOMAIN, string, bl, booleanReturnValue);
        if (bl && booleanReturnValue.getReturnValue()) {
            return vector;
        }
        vector.addAll(vector2);
        string2 = this.buildClassFilter(this.mEntityMapping.mHostMapping, false);
        string = this.mEntityMapping.mHostMapping.getContainerEntry();
        vector2 = this.getChildrenList(string2, LdapEntityType.HOST, string, bl, booleanReturnValue);
        if (bl && booleanReturnValue.getReturnValue()) {
            return vector;
        }
        if (vector2 != null) {
            vector.addAll(vector2);
        }
        return vector;
    }

    public boolean hasChildren() throws SPIException {
        BooleanReturnValue booleanReturnValue = new BooleanReturnValue(false);
        this.getChildren(true, booleanReturnValue);
        return booleanReturnValue.getReturnValue();
    }

    public Entity[] getChildrenArray() throws SPIException {
        BooleanReturnValue booleanReturnValue = new BooleanReturnValue(false);
        return this.getChildrenArray(false, booleanReturnValue);
    }

    public Iterator getSubDomains() throws SPIException {
        BooleanReturnValue booleanReturnValue = new BooleanReturnValue(false);
        String string = this.buildClassFilter(this.mEntityMapping.mDomainMapping, false);
        Vector vector = this.getChildrenList(string, LdapEntityType.DOMAIN, null, false, booleanReturnValue);
        return vector.iterator();
    }

    public Entity[] getSubDomainsArray() throws SPIException {
        BooleanReturnValue booleanReturnValue = new BooleanReturnValue(false);
        String string = this.buildClassFilter(this.mEntityMapping.mDomainMapping, false);
        Vector vector = this.getChildrenList(string, LdapEntityType.DOMAIN, null, false, booleanReturnValue);
        Entity[] entityArray = new Entity[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            entityArray[i] = (Entity)vector.get(i);
        }
        return entityArray;
    }

    public Iterator findSubDomainsByName(String string, boolean bl) throws SPIException {
        Vector vector = this.findSubDomainsByNameList(string, bl);
        return vector.iterator();
    }

    public Entity[] findSubDomainsByNameArray(String string, boolean bl) throws SPIException {
        Vector vector = this.findSubDomainsByNameList(string, bl);
        Entity[] entityArray = new Entity[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            entityArray[i] = (Entity)vector.get(i);
        }
        return entityArray;
    }

    public Iterator findSubDomainsByFilter(String string, boolean bl) throws SPIException {
        Vector vector = this.findSubDomainsByFilterList(string, bl);
        return vector.iterator();
    }

    public Entity[] findSubDomainsByFilterArray(String string, boolean bl) throws SPIException {
        Vector vector = this.findSubDomainsByFilterList(string, bl);
        Entity[] entityArray = new Entity[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            entityArray[i] = (Entity)vector.get(i);
        }
        return entityArray;
    }

    public Iterator findHostsByName(String string, boolean bl) throws SPIException {
        Vector vector = this.findHostsByNameList(string, bl);
        return vector.iterator();
    }

    public Entity[] findHostsByNameArray(String string, boolean bl) throws SPIException {
        Vector vector = this.findHostsByNameList(string, bl);
        Entity[] entityArray = new Entity[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            entityArray[i] = (Entity)vector.get(i);
        }
        return entityArray;
    }

    public Iterator findHostsByFilter(String string, boolean bl) throws SPIException {
        Vector vector = this.findHostsByFilterList(string, bl);
        return vector.iterator();
    }

    public Entity[] findHostsByFilterArray(String string, boolean bl) throws SPIException {
        Vector vector = this.findHostsByFilterList(string, bl);
        Entity[] entityArray = new Entity[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            entityArray[i] = (Entity)vector.get(i);
        }
        return entityArray;
    }

    public Iterator getHosts() throws SPIException {
        BooleanReturnValue booleanReturnValue = new BooleanReturnValue(false);
        String string = this.buildClassFilter(this.mEntityMapping.mHostMapping, false);
        Vector vector = this.getChildrenList(string, LdapEntityType.HOST, this.mEntityMapping.mHostMapping.getContainerEntry(), false, booleanReturnValue);
        return vector.iterator();
    }

    public Entity[] getHostsArray() throws SPIException {
        BooleanReturnValue booleanReturnValue = new BooleanReturnValue(false);
        String string = this.buildClassFilter(this.mEntityMapping.mHostMapping, false);
        Vector vector = this.getChildrenList(string, LdapEntityType.HOST, this.mEntityMapping.mHostMapping.getContainerEntry(), false, booleanReturnValue);
        Entity[] entityArray = new Entity[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            entityArray[i] = (Entity)vector.get(i);
        }
        return entityArray;
    }

    public Entity getParent() {
        if (this.mParent == null && this.mParentIndex != -1) {
            String[] stringArray = LDAPDN.explodeDN((String)this.mLocation, (boolean)false);
            if (this.mParentIndex >= stringArray.length) {
                return null;
            }
            StringBuffer stringBuffer = new StringBuffer(stringArray[this.mParentIndex]);
            for (int i = this.mParentIndex + 1; i < stringArray.length; ++i) {
                stringBuffer.append(",").append(stringArray[i]);
            }
            this.mParent = (LdapDomain)this.getEntityFromDN(stringBuffer.toString(), LdapEntityType.DOMAIN, false, null);
        }
        return this.mParent;
    }

    public Iterator findSubDomains(String string, boolean bl) throws SPIException {
        if (string == null) {
            throw new InvalidFilterException();
        }
        if (string.startsWith("(")) {
            return this.findSubDomainsByFilter(string, bl);
        }
        return this.findSubDomainsByName(string, bl);
    }

    public Entity[] findSubDomainsArray(String string, boolean bl) throws SPIException {
        if (string == null) {
            throw new InvalidFilterException();
        }
        if (string.startsWith("(")) {
            return this.findSubDomainsByFilterArray(string, bl);
        }
        return this.findSubDomainsByNameArray(string, bl);
    }

    public Vector findEntitiesByNameList(String string, boolean bl) throws SPIException {
        Vector vector = this.findHostsByNameList(string, bl);
        Vector vector2 = this.findSubDomainsByNameList(string, bl);
        for (int i = 0; i < vector2.size(); ++i) {
            vector.add(vector2.get(i));
        }
        Vector vector3 = this.findRolesByNameList(string, bl);
        for (int i = 0; i < vector3.size(); ++i) {
            vector.add(vector3.get(i));
        }
        return vector;
    }

    public Vector findSubDomainsByNameList(String string, boolean bl) throws SPIException {
        String string2 = this.buildNameFilter(string, "=", this.mEntityMapping.mDomainMapping, bl);
        Vector vector = this.searchForDomains(string2, bl);
        return vector;
    }

    public Iterator findHosts(String string, boolean bl) throws SPIException {
        if (string == null) {
            throw new InvalidFilterException();
        }
        if (string.startsWith("(")) {
            return this.findHostsByFilter(string, bl);
        }
        return this.findHostsByName(string, bl);
    }

    public Entity[] findHostsArray(String string, boolean bl) throws SPIException {
        if (string == null) {
            throw new InvalidFilterException();
        }
        if (string.startsWith("(")) {
            return this.findHostsByFilterArray(string, bl);
        }
        return this.findHostsByNameArray(string, bl);
    }

    public Vector findHostsByNameList(String string, boolean bl) throws SPIException {
        String string2 = this.buildNameFilter(string, "=", this.mEntityMapping.mHostMapping, bl);
        Vector vector = this.searchForHosts(string2, bl);
        return vector;
    }

    public Vector findEntitiesByFilterList(String string, boolean bl) throws SPIException {
        Vector vector = this.findHostsByFilterList(string, bl);
        Vector vector2 = this.findSubDomainsByFilterList(string, bl);
        for (int i = 0; i < vector2.size(); ++i) {
            vector.add(vector2.get(i));
        }
        Vector vector3 = this.findRolesByFilterList(string, bl);
        for (int i = 0; i < vector3.size(); ++i) {
            vector.add(vector3.get(i));
        }
        return vector;
    }

    public Vector findSubDomainsByFilterList(String string, boolean bl) throws SPIException {
        String string2 = this.mapFilter(string, this.mEntityMapping.mDomainMapping, bl);
        Vector vector = this.searchForDomains(string2, bl);
        return vector;
    }

    public Vector findHostsByFilterList(String string, boolean bl) throws SPIException {
        String string2 = this.mapFilter(string, this.mEntityMapping.mHostMapping, bl);
        Vector vector = this.searchForHosts(string2, bl);
        return vector;
    }

    private Vector searchForDomains(String string, boolean bl) throws SPIException {
        StringBuffer stringBuffer = new StringBuffer(200);
        String[] stringArray = new String[]{"objectclass"};
        Vector vector = null;
        try {
            vector = this.getDataStore().performSearch(this.mLocation, bl, string, stringArray, true, false, null, false, this.getContext());
        }
        catch (IllegalReadException illegalReadException) {
            if (LdapDataStore.getLdapErrorCode(illegalReadException) == 32) {
                return new Vector();
            }
            throw illegalReadException;
        }
        Vector<Entity> vector2 = new Vector<Entity>();
        if (!vector.isEmpty()) {
            int n = vector.size();
            Entity entity = null;
            for (int i = 0; i < n; ++i) {
                try {
                    Hashtable hashtable = (Hashtable)vector.get(i);
                    Vector vector3 = (Vector)hashtable.get("DN");
                    if (vector3 != null && !vector3.isEmpty()) {
                        entity = this.getEntityFromDN((String)vector3.get(0), LdapEntityType.DOMAIN, false, hashtable);
                    }
                    if (entity == null) continue;
                    boolean bl2 = bl;
                    if (bl2) {
                        if (!this.equals(entity)) {
                            vector2.add(entity);
                            continue;
                        }
                        bl2 = false;
                        continue;
                    }
                    vector2.add(entity);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return vector2;
    }

    private Vector searchForHosts(String string, boolean bl) throws SPIException {
        Object object;
        StringBuffer stringBuffer = new StringBuffer(200);
        String[] stringArray = new String[]{"ObjectClass", this.mEntityMapping.mHostMapping.getUniqueAttribute()};
        if (!bl && (object = this.mEntityMapping.mHostMapping.getContainerEntry()) != null && object != "") {
            stringBuffer.append((String)object).append(",");
        }
        stringBuffer.append(this.mLocation);
        object = null;
        try {
            object = this.getDataStore().performSearch(stringBuffer.toString(), bl, string, stringArray, true, false, null, false, this.getContext());
        }
        catch (IllegalReadException illegalReadException) {
            if (LdapDataStore.getLdapErrorCode(illegalReadException) == 32) {
                return new Vector();
            }
            throw illegalReadException;
        }
        Vector<Entity> vector = new Vector<Entity>();
        if (!((Vector)object).isEmpty()) {
            int n = ((Vector)object).size();
            Entity entity = null;
            for (int i = 0; i < n; ++i) {
                try {
                    Hashtable hashtable = (Hashtable)((Vector)object).get(i);
                    Vector vector2 = (Vector)hashtable.get("DN");
                    if (vector2 != null && !vector2.isEmpty()) {
                        entity = this.getEntityFromDN((String)vector2.get(0), LdapEntityType.HOST, false, hashtable);
                    }
                    if (entity == null) continue;
                    vector.add(entity);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return vector;
    }
}

