/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.spi.ldap;

import com.netscape.sasl.Sasl;
import com.netscape.sasl.SaslClientFactory;
import com.sun.apoc.spi.AuthenticationException;
import com.sun.apoc.spi.ConnectionSizeLimitException;
import com.sun.apoc.spi.OpenConnectionException;
import com.sun.apoc.spi.SPIException;
import com.sun.apoc.spi.entities.Entity;
import com.sun.apoc.spi.entities.Organization;
import com.sun.apoc.spi.ldap.LdapConnectionPool;
import com.sun.apoc.spi.ldap.authentication.SaslFactory;
import com.sun.apoc.spi.ldap.entities.LdapEntity;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSocketFactory;
import netscape.ldap.factory.JSSESocketFactory;

public class LdapClientContext {
    public static final int DEFAULT_MAX_SEARCH_RESULTS = 100;
    public static final char DN_INDICATOR = '=';
    private static final JSSESocketFactory sSocketFactory = new JSSESocketFactory(null);
    private static final Integer sLDAPVersion3 = new Integer(3);
    private static Set sInsecureServers = new HashSet();
    private static final int NB_INSECURE_SERVERS = 20;
    private static Map sAnonymousPools = new HashMap();
    private static final int NB_ANONYMOUS_POOLS = 20;
    private LDAPConnection mConnection = null;
    private String mProtocol;
    private String mServer;
    private int mPort;
    private int mConnectTimeout;
    private int mMaxSearchResults = 100;

    public LdapClientContext(String string, String string2, int n, int n2) {
        this.mProtocol = string;
        this.mServer = string2;
        this.mPort = n;
        this.mConnectTimeout = n2;
    }

    public void connect(String string, char[] cArray) throws SPIException {
        try {
            if (LdapClientContext.isAnonymous(string, cArray)) {
                this.mConnection = LdapClientContext.getAnonymousConnection(this.mServer, this.mPort);
                if (this.mConnection == null) {
                    this.mConnection = this.prepareConnection();
                    this.mConnection.authenticate(null, null);
                    LdapClientContext.addAnonymousConnection(this.mServer, this.mPort, this.mConnection);
                }
            } else {
                this.mConnection = this.prepareConnection();
                this.mConnection.authenticate(string, new String(cArray));
            }
        }
        catch (LDAPException lDAPException) {
            throw new AuthenticationException(this.getConnectionURL(), string, (Throwable)lDAPException);
        }
    }

    public void authenticate(String string, char[] cArray, Organization organization, LdapClientContext ldapClientContext) throws SPIException {
        String string2 = null;
        if (string != null && string.length() != 0 && !string.equalsIgnoreCase("Anonymous")) {
            if (string.indexOf(61) >= 0) {
                string2 = string;
            } else {
                Entity entity = null;
                LdapClientContext ldapClientContext2 = ((LdapEntity)((Object)organization)).getContext();
                ((LdapEntity)((Object)organization)).setContext(ldapClientContext);
                Iterator iterator = organization.findUsers(string, true);
                ((LdapEntity)((Object)organization)).setContext(ldapClientContext2);
                if (iterator.hasNext()) {
                    entity = (Entity)iterator.next();
                }
                if (entity == null) {
                    throw new AuthenticationException(this.getConnectionURL(), string);
                }
                string2 = ((LdapEntity)entity).getLocation();
            }
        }
        this.connect(string2, cArray);
    }

    public void authenticate(Object object) throws SPIException {
        try {
            this.mConnection = this.prepareConnection();
            this.mConnection.authenticate(null, SaslFactory.sMechs, null, object);
        }
        catch (LDAPException lDAPException) {
            throw new AuthenticationException(this.getConnectionURL(), lDAPException);
        }
    }

    public void close() {
        if (this.mConnection != null) {
            if (!LdapClientContext.closeAnonymousConnection(this.mServer, this.mPort, this.mConnection)) {
                this.closeConnection(this.mConnection);
            }
            this.mConnection = null;
        }
    }

    private void closeConnection(LDAPConnection lDAPConnection) {
        if (lDAPConnection.isConnected()) {
            new LDAPConnectionDisconnector(lDAPConnection).start();
        }
    }

    private LDAPConnection prepareConnection() throws SPIException {
        LDAPConnection lDAPConnection = null;
        if (!LdapClientContext.isInsecureServer(this.mServer, this.mPort)) {
            try {
                lDAPConnection = new LDAPConnection((LDAPSocketFactory)sSocketFactory);
                this.setupConnection(lDAPConnection);
            }
            catch (LDAPException lDAPException) {
                if (!(lDAPException.getLDAPResultCode() != 80 && lDAPException.getLDAPResultCode() != 91 || this.mProtocol.equalsIgnoreCase("ldaps"))) {
                    LdapClientContext.addInsecureServer(this.mServer, this.mPort);
                    this.closeConnection(lDAPConnection);
                    lDAPConnection = null;
                }
                throw new OpenConnectionException(this.getConnectionURL(), lDAPException);
            }
        }
        if (lDAPConnection == null) {
            try {
                lDAPConnection = new LDAPConnection();
                this.setupConnection(lDAPConnection);
            }
            catch (LDAPException lDAPException) {
                this.closeConnection(lDAPConnection);
                lDAPConnection = null;
                throw new OpenConnectionException(this.getConnectionURL(), lDAPException);
            }
        }
        return lDAPConnection;
    }

    private void setupConnection(LDAPConnection lDAPConnection) throws LDAPException {
        try {
            lDAPConnection.setOption(17, (Object)sLDAPVersion3);
            lDAPConnection.setOption(8, (Object)new Boolean(true));
        }
        catch (LDAPException lDAPException) {
            // empty catch block
        }
        lDAPConnection.setConnectTimeout(this.mConnectTimeout);
        lDAPConnection.connect(this.mServer, this.mPort);
    }

    public LDAPConnection getConnection() {
        return this.mConnection;
    }

    public String getConnectionURL() {
        return this.mProtocol + "://" + this.mServer + ":" + String.valueOf(this.mPort);
    }

    public void setConnectionSizeLimit(int n) throws SPIException {
        try {
            this.mConnection.setOption(3, (Object)new Integer(n));
            this.mMaxSearchResults = n;
        }
        catch (LDAPException lDAPException) {
            throw new ConnectionSizeLimitException(this.getConnectionURL(), n, (Throwable)lDAPException);
        }
    }

    public int getConnectionSizeLimit() {
        return this.mMaxSearchResults;
    }

    private static String getServerPortKey(String string, int n) {
        return string + ":" + n;
    }

    private static boolean isInsecureServer(String string, int n) {
        return sInsecureServers.contains(LdapClientContext.getServerPortKey(string, n));
    }

    private static void addInsecureServer(String string, int n) {
        if (sInsecureServers.size() < 20) {
            sInsecureServers.add(LdapClientContext.getServerPortKey(string, n));
        }
    }

    private static LDAPConnection getAnonymousConnection(String string, int n) {
        LdapConnectionPool ldapConnectionPool = (LdapConnectionPool)sAnonymousPools.get(LdapClientContext.getServerPortKey(string, n));
        return ldapConnectionPool != null ? ldapConnectionPool.getConnection() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addAnonymousConnection(String string, int n, LDAPConnection lDAPConnection) {
        LdapConnectionPool ldapConnectionPool = null;
        Map map = sAnonymousPools;
        synchronized (map) {
            ldapConnectionPool = (LdapConnectionPool)sAnonymousPools.get(LdapClientContext.getServerPortKey(string, n));
            if (ldapConnectionPool == null && sAnonymousPools.size() < 20) {
                ldapConnectionPool = new LdapConnectionPool(string, n);
                sAnonymousPools.put(LdapClientContext.getServerPortKey(string, n), ldapConnectionPool);
            }
        }
        if (ldapConnectionPool != null) {
            ldapConnectionPool.addConnection(lDAPConnection);
        }
    }

    private static boolean closeAnonymousConnection(String string, int n, LDAPConnection lDAPConnection) {
        LdapConnectionPool ldapConnectionPool = (LdapConnectionPool)sAnonymousPools.get(LdapClientContext.getServerPortKey(string, n));
        return ldapConnectionPool != null ? ldapConnectionPool.closeConnection(lDAPConnection) : false;
    }

    private static boolean isAnonymous(String string, char[] cArray) {
        return cArray == null || cArray.length == 0 || string == null || string.length() == 0 || string.equalsIgnoreCase("Anonymous");
    }

    static {
        Sasl.setSaslClientFactory((SaslClientFactory)new SaslFactory());
    }

    class LDAPConnectionDisconnector
    extends Thread {
        LDAPConnection mConnection;

        LDAPConnectionDisconnector(LDAPConnection lDAPConnection) {
            this.mConnection = lDAPConnection;
        }

        public void run() {
            try {
                this.mConnection.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

