/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.spi.file.profiles;

import com.sun.apoc.spi.IllegalReadException;
import com.sun.apoc.spi.IllegalWriteException;
import com.sun.apoc.spi.PolicyMgr;
import com.sun.apoc.spi.SPIException;
import com.sun.apoc.spi.entities.Entity;
import com.sun.apoc.spi.file.profiles.FileProfile;
import com.sun.apoc.spi.file.profiles.FileProfileComparator;
import com.sun.apoc.spi.profiles.Applicability;
import com.sun.apoc.spi.profiles.Profile;
import com.sun.apoc.spi.profiles.ProfileRepositoryImpl;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;

public class FileProfileRepository
extends ProfileRepositoryImpl {
    public static final String PREFIX = "PROFILE_REPOSITORY_";
    public static final String DEFAULT_ID = "default";
    private boolean mProfilesLoaded;
    private File mFile;
    boolean mReadOnly;
    boolean mRemote;
    URL mRootLocation;

    public FileProfileRepository(PolicyMgr policyMgr, String string, URL uRL) throws SPIException {
        this.mId = string;
        this.mPolicyMgr = policyMgr;
        this.mProfilesLoaded = false;
        this.mRootLocation = uRL;
        this.mReadOnly = true;
        if (!uRL.getProtocol().equals("file")) {
            this.mRemote = true;
        } else {
            this.mRemote = false;
            try {
                this.mFile = new File(new URI(this.mRootLocation.toString()));
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new IllegalReadException("error.spi.access.illegal.read.file.name", this.mRootLocation.toString(), (Throwable)uRISyntaxException);
            }
            this.mReadOnly = this.isRepositoryReadOnly();
        }
    }

    public Profile findProfile(String string) throws SPIException {
        if (this.mRemote) {
            throw new UnsupportedOperationException();
        }
        List list = this.loadAllProfiles();
        Profile profile = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Profile profile2 = (Profile)iterator.next();
            if (profile2.getDisplayName() != string) continue;
            profile = profile2;
        }
        return profile;
    }

    public Iterator getProfilePriorities(Applicability applicability) throws SPIException {
        Profile profile = null;
        if (this.mRemote) {
            throw new UnsupportedOperationException();
        }
        List list = this.loadAllProfiles();
        LinkedList<Profile> linkedList = new LinkedList<Profile>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            profile = (Profile)iterator.next();
            if (profile.getApplicability() != applicability) continue;
            linkedList.add(profile);
        }
        return linkedList.iterator();
    }

    protected Profile createTheProfile(String string, Applicability applicability, int n) throws SPIException {
        if (this.mReadOnly) {
            throw new IllegalWriteException();
        }
        Profile profile = FileProfile.createNewProfile(this, string, applicability, n, this.mPolicyMgr);
        return profile;
    }

    public void deleteProfile(Profile profile) throws SPIException {
        String string = profile.getId();
        if (this.mReadOnly) {
            throw new IllegalWriteException();
        }
        try {
            URI uRI = new URI(FileProfile.getProfileURL(string, this).toString());
            File file = new File(uRI.getPath());
            if (!file.delete()) {
                throw new IllegalWriteException("error.spi.access.illegal.write.file");
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalWriteException("error.spi.access.illegal.write.file", uRISyntaxException);
        }
        profile = null;
    }

    public Profile getProfile(String string) throws SPIException {
        return FileProfile.loadProfile(string, this, this.mPolicyMgr);
    }

    protected TreeSet getTheProfiles(Applicability applicability) throws SPIException {
        if (this.mRemote) {
            throw new UnsupportedOperationException();
        }
        TreeSet<Profile> treeSet = new TreeSet<Profile>(new FileProfileComparator());
        List list = this.loadAllProfiles();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Profile profile = (Profile)iterator.next();
            if (applicability.equals(Applicability.ALL)) {
                treeSet.add(profile);
                continue;
            }
            if (!profile.getApplicability().equals(applicability)) continue;
            treeSet.add(profile);
        }
        return treeSet;
    }

    public String getId() {
        return this.mId;
    }

    private List readProfileList() throws SPIException {
        LinkedList<String> linkedList = new LinkedList<String>();
        String[] stringArray = this.mFile.list();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            int n = string.lastIndexOf(".zip");
            if (n == -1) continue;
            String string2 = string.substring(0, n);
            linkedList.add(string2);
        }
        return linkedList;
    }

    public boolean isReadOnly() throws SPIException {
        return this.mReadOnly;
    }

    public Entity getEntity() throws SPIException {
        Entity entity = this.mPolicyMgr.getOrganizationTreeProvider().getEntity(this.mId);
        if (entity == null) {
            entity = this.mPolicyMgr.getDomainTreeProvider().getEntity(this.mId);
        }
        return entity;
    }

    protected String getLocation() {
        return this.mRootLocation.toString();
    }

    protected boolean priorityExists(int n) throws SPIException {
        Iterator iterator = this.getProfiles(Applicability.ALL);
        while (iterator.hasNext()) {
            if (((Profile)iterator.next()).getPriority() != n) continue;
            return true;
        }
        return false;
    }

    protected void createStorage() {
        if (!this.mFile.exists()) {
            this.mFile.mkdirs();
        }
    }

    private List loadAllProfiles() throws SPIException {
        LinkedList<Profile> linkedList = new LinkedList<Profile>();
        if (this.mFile.exists()) {
            List list = this.readProfileList();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = FileProfile.createId(string, this.mId);
                Profile profile = this.getProfile(string2);
                linkedList.add(profile);
            }
        }
        return linkedList;
    }

    private boolean isRepositoryReadOnly() {
        File file = this.mFile;
        do {
            if (!file.exists()) continue;
            return !file.canWrite();
        } while ((file = file.getParentFile()) != null);
        return false;
    }
}

