/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.spi.file.entities;

import com.sun.apoc.spi.PolicyMgr;
import com.sun.apoc.spi.SPIException;
import com.sun.apoc.spi.entities.Entity;
import com.sun.apoc.spi.entities.Leaf;
import com.sun.apoc.spi.entities.Node;
import com.sun.apoc.spi.file.entities.FileEntity;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class FileNode
extends FileEntity
implements Node {
    Map mLeaves = Collections.synchronizedMap(new HashMap());
    Map mNodes = Collections.synchronizedMap(new HashMap());
    Map mRoles = Collections.synchronizedMap(new HashMap());

    public FileNode(String string, String string2, Entity entity, PolicyMgr policyMgr) {
        super(string, string2, entity, policyMgr);
    }

    public Iterator findEntities(String string, boolean bl) throws SPIException {
        return Collections.EMPTY_LIST.iterator();
    }

    public Iterator getRoles() throws SPIException {
        return this.mRoles.values().iterator();
    }

    public boolean hasRoles() throws SPIException {
        return !this.mRoles.isEmpty();
    }

    public Iterator getChildren() throws SPIException {
        LinkedList<Entity> linkedList = new LinkedList<Entity>();
        Iterator iterator = this.mLeaves.values().iterator();
        while (iterator.hasNext()) {
            linkedList.add((Entity)iterator.next());
        }
        iterator = this.mNodes.values().iterator();
        while (iterator.hasNext()) {
            linkedList.add((Node)iterator.next());
        }
        iterator = this.mRoles.values().iterator();
        while (iterator.hasNext()) {
            linkedList.add((Entity)iterator.next());
        }
        return linkedList.iterator();
    }

    public boolean hasChildren() throws SPIException {
        return this.hasLeaves() || this.hasNodes() || this.hasRoles();
    }

    public Iterator getLeaves() throws SPIException {
        return this.mLeaves.values().iterator();
    }

    public boolean hasLeaves() throws SPIException {
        return !this.mLeaves.isEmpty();
    }

    public Iterator getNodes() throws SPIException {
        return this.mNodes.values().iterator();
    }

    public boolean hasNodes() throws SPIException {
        return !this.mNodes.isEmpty();
    }

    public Entity getEntity(String string) throws SPIException {
        Entity entity = this.depthSearch(this, string);
        return entity;
    }

    private Entity depthSearch(FileNode fileNode, String string) {
        Entity entity = null;
        if (fileNode.getId().equals(string)) {
            return fileNode;
        }
        Iterator iterator = fileNode.mLeaves.values().iterator();
        entity = this.searchForEntity(iterator, string);
        iterator = fileNode.mNodes.values().iterator();
        while (iterator.hasNext() && entity == null) {
            FileNode fileNode2 = (FileNode)iterator.next();
            entity = this.depthSearch(fileNode2, string);
        }
        return entity;
    }

    protected void addChildNode(Node node) {
        this.mNodes.put(node.getId(), node);
    }

    protected void addChildLeaf(Leaf leaf) {
        this.mLeaves.put(leaf.getId(), leaf);
    }

    private Entity searchForEntity(Iterator iterator, String string) {
        while (iterator.hasNext()) {
            Entity entity = (Entity)iterator.next();
            if (!string.equals(entity.getId())) continue;
            return entity;
        }
        return null;
    }
}

