/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.spi.cfgtree;

import com.sun.apoc.spi.SPIException;
import com.sun.apoc.spi.cfgtree.PolicyTree;
import com.sun.apoc.spi.cfgtree.policynode.InvalidPolicyNodeException;
import com.sun.apoc.spi.cfgtree.policynode.PolicyNode;
import com.sun.apoc.spi.cfgtree.policynode.PolicyNodeImpl;
import com.sun.apoc.spi.policies.MismatchPolicyException;
import com.sun.apoc.spi.policies.Policy;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.StringTokenizer;

public abstract class PolicyTreeImpl
implements PolicyTree {
    private PolicyNodeImpl mRootNode;
    private Policy mTopPolicy;
    private static final String MODULE = "PolicyTreeImpl";

    public void checkLayerRootNodeValidity(PolicyNodeImpl policyNodeImpl, String string) throws SPIException {
        if (policyNodeImpl.getName() == null) {
            throw new InvalidPolicyNodeException();
        }
        String string2 = policyNodeImpl.getPackage();
        String string3 = policyNodeImpl.getName();
        if (string2 == null || string3 == null || !string.endsWith(string2 + "." + string3)) {
            throw new InvalidPolicyNodeException(string2 + "." + string3, string);
        }
    }

    public void checkPolicyIdsMatch(ArrayList arrayList) throws SPIException {
        String string = ((Policy)arrayList.get(0)).getId();
        for (int i = 1; i < arrayList.size(); ++i) {
            Policy policy = (Policy)arrayList.get(i);
            if (policy.getId().equalsIgnoreCase(string)) continue;
            throw new MismatchPolicyException();
        }
    }

    public abstract PolicyNode createNode(String var1) throws SPIException;

    public abstract PolicyNode createReplaceNode(String var1) throws SPIException;

    public PolicyNode getNode(String string) throws SPIException {
        Object object;
        if (string.equals(this.mRootNode.getAbsolutePath())) {
            return this.mRootNode;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        if (stringTokenizer.hasMoreTokens() && !((String)(object = stringTokenizer.nextToken())).equals(this.mTopPolicy.getId())) {
            throw new MismatchPolicyException();
        }
        object = this.mRootNode;
        while (stringTokenizer.hasMoreTokens()) {
            if ((object = ((PolicyNodeImpl)object).getChildNode(PolicyTreeImpl.decodePath(stringTokenizer.nextToken()))) != null) continue;
            return null;
        }
        return object;
    }

    public Policy getPolicy() {
        return this.mTopPolicy;
    }

    public String getPolicyId() {
        return this.mTopPolicy.getId();
    }

    public PolicyNode getRootNode() {
        return this.mRootNode;
    }

    public Policy getTopPolicy() {
        return this.mTopPolicy;
    }

    public boolean hasBeenModified() {
        return this.mRootNode.hasBeenModified();
    }

    public boolean nodeExists(String string) throws SPIException {
        String string2;
        if (string.equals(this.mRootNode.getAbsolutePath())) {
            return true;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        if (stringTokenizer.hasMoreTokens() && !(string2 = stringTokenizer.nextToken()).equals(this.mTopPolicy.getId())) {
            throw new MismatchPolicyException();
        }
        boolean bl = false;
        PolicyNodeImpl policyNodeImpl = this.mRootNode;
        int n = stringTokenizer.countTokens();
        for (int i = 0; i < n; ++i) {
            if ((policyNodeImpl = policyNodeImpl.getChildNode(PolicyTreeImpl.decodePath(stringTokenizer.nextToken()))) == null) {
                bl = false;
                break;
            }
            bl = true;
        }
        return bl;
    }

    public void setRootNode(PolicyNodeImpl policyNodeImpl) {
        this.mRootNode = policyNodeImpl;
    }

    public void setTopPolicy(Policy policy) {
        this.mTopPolicy = policy;
    }

    public static String decodePath(String string) throws SPIException {
        try {
            if (string.indexOf(37) == -1) {
                return string;
            }
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SPIException(unsupportedEncodingException);
        }
    }
}

