/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.sso.providers.dpro;

import com.iplanet.am.sdk.AMSearchResults;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.dpro.session.Session;
import com.iplanet.dpro.session.SessionException;
import com.iplanet.dpro.session.SessionID;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOProvider;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenID;
import com.iplanet.sso.providers.dpro.SSOProviderBundle;
import com.iplanet.sso.providers.dpro.SSOTokenImpl;
import java.net.InetAddress;
import java.security.Principal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public final class SSOProviderImpl
implements SSOProvider {
    public static Debug debug = null;
    private static boolean checkIP = Boolean.valueOf(SystemProperties.get((String)"com.iplanet.am.clientIPCheckEnabled"));

    public SSOToken createSSOToken(HttpServletRequest httpServletRequest) throws SSOException {
        try {
            Object object;
            SessionID sessionID = new SessionID(httpServletRequest);
            Session session = Session.getSession((SessionID)sessionID);
            if (sessionID != null) {
                object = sessionID.getCookieMode();
                if (debug.messageEnabled()) {
                    debug.message("cookieMode is :" + object);
                }
                if (object != null) {
                    session.setCookieMode((Boolean)object);
                }
            }
            if (checkIP && !this.isIPValid(session, httpServletRequest.getRemoteAddr())) {
                throw new Exception(SSOProviderBundle.getString("invalidIP"));
            }
            object = new SSOTokenImpl(session);
            return object;
        }
        catch (Exception exception) {
            if (debug.messageEnabled()) {
                debug.message("could not create SSOToken from HttpRequest", (Throwable)exception);
            }
            throw new SSOException((Throwable)exception);
        }
    }

    public SSOToken createSSOToken(Principal principal, String string) throws SSOException, UnsupportedOperationException {
        try {
            SSOTokenImpl sSOTokenImpl = new SSOTokenImpl(principal, string);
            if (debug.messageEnabled()) {
                debug.message("SSO token ldap auth successful for " + principal.toString());
            }
            return sSOTokenImpl;
        }
        catch (Exception exception) {
            if (debug.messageEnabled()) {
                debug.message("could not create SSOTOken for user " + principal.getName(), (Throwable)exception);
            }
            throw new SSOException((Throwable)exception);
        }
    }

    public SSOToken createSSOToken(String string) throws SSOException, UnsupportedOperationException {
        try {
            SessionID sessionID = new SessionID(string);
            Session session = Session.getSession((SessionID)sessionID);
            SSOTokenImpl sSOTokenImpl = new SSOTokenImpl(session);
            return sSOTokenImpl;
        }
        catch (Exception exception) {
            if (debug.messageEnabled()) {
                debug.message("could not create SSOTOken for token ID " + string, (Throwable)exception);
            }
            throw new SSOException((Throwable)exception);
        }
    }

    public SSOToken createSSOToken(String string, String string2) throws SSOException, UnsupportedOperationException {
        try {
            SessionID sessionID = new SessionID(string);
            Session session = Session.getSession((SessionID)sessionID);
            if (checkIP && !this.isIPValid(session, string2)) {
                throw new Exception(SSOProviderBundle.getString("invalidIP"));
            }
            SSOTokenImpl sSOTokenImpl = new SSOTokenImpl(session);
            return sSOTokenImpl;
        }
        catch (Exception exception) {
            if (debug.messageEnabled()) {
                debug.message("could not create SSOTOken for token ID " + string, (Throwable)exception);
            }
            throw new SSOException((Throwable)exception);
        }
    }

    public boolean isValidToken(SSOToken sSOToken) {
        SSOTokenImpl sSOTokenImpl = (SSOTokenImpl)sSOToken;
        return sSOTokenImpl.isValid();
    }

    public void validateToken(SSOToken sSOToken) throws SSOException {
        try {
            SSOTokenImpl sSOTokenImpl = (SSOTokenImpl)sSOToken;
            sSOTokenImpl.validate();
        }
        catch (Exception exception) {
            if (debug.messageEnabled()) {
                debug.message("validateToken: ", (Throwable)exception);
            }
            throw new SSOException(SSOProviderBundle.rbName, "invalidtoken", null);
        }
    }

    public void destroyToken(SSOToken sSOToken) throws SSOException {
        try {
            SSOTokenImpl sSOTokenImpl = (SSOTokenImpl)sSOToken;
            if (sSOTokenImpl.isLdapConnection()) {
                sSOTokenImpl.setStatus(false);
                return;
            }
            SSOTokenID sSOTokenID = sSOToken.getTokenID();
            String string = sSOTokenID.toString();
            SessionID sessionID = new SessionID(string);
            Session session = Session.getSession((SessionID)sessionID);
            session.destroySession(session);
        }
        catch (Exception exception) {
            if (debug.messageEnabled()) {
                debug.message("DestroyToken: ", (Throwable)exception);
            }
            throw new SSOException((Throwable)exception);
        }
    }

    public boolean isIPValid(Session session, String string) throws SSOException {
        boolean bl;
        block3: {
            bl = false;
            try {
                InetAddress inetAddress = InetAddress.getByName(session.getProperty("Host"));
                InetAddress inetAddress2 = InetAddress.getByName(string);
                if (inetAddress.equals(inetAddress2)) {
                    bl = true;
                }
            }
            catch (Exception exception) {
                if (!debug.messageEnabled()) break block3;
                debug.message("IP address check of Token Failed", (Throwable)exception);
            }
        }
        return bl;
    }

    public void refreshSession(SSOToken sSOToken) throws SSOException {
        try {
            SSOTokenID sSOTokenID = sSOToken.getTokenID();
            SessionID sessionID = new SessionID(sSOTokenID.toString());
            Session session = Session.getSession((SessionID)sessionID);
            session.refresh(true);
        }
        catch (Exception exception) {
            debug.error("Error in refreshing the session from sessions erver");
            throw new SSOException((Throwable)exception);
        }
    }

    public void destroyToken(SSOToken sSOToken, SSOToken sSOToken2) throws SSOException {
        try {
            Session session = ((SSOTokenImpl)sSOToken).getSession();
            Session session2 = ((SSOTokenImpl)sSOToken2).getSession();
            session.destroySession(session2);
        }
        catch (SessionException sessionException) {
            throw new SSOException((Throwable)sessionException);
        }
    }

    public Set getValidSessions(SSOToken sSOToken, String string) throws SSOException {
        HashSet<SSOTokenImpl> hashSet = new HashSet<SSOTokenImpl>();
        try {
            AMSearchResults aMSearchResults = ((SSOTokenImpl)sSOToken).getSession().getValidSessions(string, null);
            Iterator iterator = aMSearchResults.getResultAttributes().values().iterator();
            while (iterator.hasNext()) {
                Session session = (Session)iterator.next();
                if (session == null) continue;
                hashSet.add(new SSOTokenImpl(session));
            }
        }
        catch (SessionException sessionException) {
            throw new SSOException((Throwable)sessionException);
        }
        return hashSet;
    }

    static {
        debug = Debug.getInstance((String)"amSSOProvider");
    }
}

