/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.session.util;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.dpro.session.Session;
import com.iplanet.dpro.session.SessionException;
import com.iplanet.dpro.session.SessionID;
import com.iplanet.dpro.session.share.SessionBundle;
import com.iplanet.services.naming.WebtopNaming;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenID;
import java.net.InetAddress;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

public class SessionUtils {
    public static final short QUERY = 0;
    public static final short SLASH = 1;
    public static final short SEMICOLON = 2;
    static Debug debug = Debug.getInstance("amSessionUtils");
    private static Set trustedSources = null;
    private static final String httpClientIPHeader = SystemProperties.get("com.sun.identity.session.httpClientIPHeader", "proxy-ip");

    public static String getSessionId(HttpServletRequest httpServletRequest) {
        String string = new SessionID(httpServletRequest).toString();
        if (string.length() == 0) {
            string = null;
        }
        return string;
    }

    public static String encodeURL(SSOToken sSOToken, String string, short s, boolean bl) throws SSOException {
        String string2 = string;
        try {
            SSOTokenID sSOTokenID = sSOToken.getTokenID();
            SessionID sessionID = new SessionID(sSOTokenID.toString());
            Session session = Session.getSession(sessionID);
            string2 = session.encodeURL(string, s, bl);
        }
        catch (Exception exception) {
            debug.message("Exception encoding URL ", exception);
            throw new SSOException(exception);
        }
        return string2;
    }

    public static String encodeURL(SSOToken sSOToken, String string, boolean bl) throws SSOException {
        String string2 = string;
        try {
            string2 = SessionUtils.encodeURL(sSOToken, string, (short)0, bl);
        }
        catch (Exception exception) {
            debug.message("Exception encoding url", exception);
            throw new SSOException(exception);
        }
        return string2;
    }

    public static InetAddress getClientAddress(HttpServletRequest httpServletRequest) throws Exception {
        String string;
        InetAddress inetAddress = InetAddress.getByName(httpServletRequest.getRemoteAddr());
        if (SessionUtils.isTrustedSource(inetAddress) && (string = httpServletRequest.getHeader(httpClientIPHeader)) != null) {
            inetAddress = InetAddress.getByName(string);
        }
        return inetAddress;
    }

    private static Set getTrustedSourceList() throws SessionException {
        HashSet<InetAddress> hashSet = new HashSet<InetAddress>();
        try {
            String string = SystemProperties.get("com.sun.am.session.trustedSourceList");
            if (string != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    hashSet.add(InetAddress.getByName(stringTokenizer.nextToken()));
                }
            } else {
                Vector vector = WebtopNaming.getPlatformServerList();
                if (vector == null) {
                    throw new SessionException(SessionBundle.rbName, "emptyTrustedSourceList", null);
                }
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    URL uRL = new URL((String)enumeration.nextElement());
                    hashSet.add(InetAddress.getByName(uRL.getHost()));
                }
            }
        }
        catch (Exception exception) {
            throw new SessionException(exception);
        }
        return hashSet;
    }

    public static boolean isTrustedSource(InetAddress inetAddress) throws SessionException {
        if (trustedSources == null) {
            trustedSources = SessionUtils.getTrustedSourceList();
        }
        return trustedSources.contains(inetAddress);
    }
}

