/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.session.util;

import com.iplanet.services.util.Base64;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.session.util.RestrictedTokenAction;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class RestrictedTokenContext {
    private static ThreadLocal currentContext = new ThreadLocal();
    private static final String OBJECT_PREFIX = "object:";
    private static final String TOKEN_PREFIX = "token:";

    public static Object getCurrent() {
        return currentContext.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object doUsing(Object object, RestrictedTokenAction restrictedTokenAction) throws Exception {
        Object t = currentContext.get();
        try {
            currentContext.set(object);
            Object object2 = restrictedTokenAction.run();
            Object var5_4 = null;
            currentContext.set(t);
            return object2;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            currentContext.set(t);
            throw throwable;
        }
    }

    public static String marshal(Object object) throws Exception {
        if (object instanceof SSOToken) {
            return TOKEN_PREFIX + ((SSOToken)object).getTokenID().toString();
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(object);
        objectOutputStream.flush();
        objectOutputStream.close();
        return OBJECT_PREFIX + Base64.encode(byteArrayOutputStream.toByteArray());
    }

    public static Object unmarshal(String string) throws Exception {
        if (string.startsWith(TOKEN_PREFIX)) {
            return SSOTokenManager.getInstance().createSSOToken(string.substring(TOKEN_PREFIX.length()));
        }
        if (string.startsWith(OBJECT_PREFIX)) {
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(Base64.decode(string.substring(OBJECT_PREFIX.length()))));
            return objectInputStream.readObject();
        }
        throw new IllegalArgumentException("Bad context value:" + string);
    }
}

