/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.common.admin;

import com.iplanet.am.util.AdminUtils;
import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.internal.AuthPrincipal;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.ChoiceValues;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.Principal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class PossibleLocales
extends ChoiceValues {
    private static SSOToken ssoToken = PossibleLocales.getAdminSSOToken();
    private static final String G11N_SERIVCE_LOCALE_CHARSET_MAPPING = "sun-identity-g11n-settings-locale-charset-mapping";
    private static final String G11N_SERVICE_NAME = "iPlanetG11NSettings";
    private static final String SEPARATOR = "|";
    private static final String LOCALE_ATTR = "locale";
    private static Debug debug = Debug.getInstance("PossibleLocales");

    public Map getChoiceValues() {
        Set set;
        AttributeSchema attributeSchema;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("", "-");
        ServiceSchemaManager serviceSchemaManager = this.getG11NServiceSchemaManager();
        if (serviceSchemaManager != null && (attributeSchema = this.getLocaleCharsetMappingAttributeSchema(serviceSchemaManager)) != null && (set = attributeSchema.getDefaultValues()) != null && !set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = PossibleLocales.parseLocaleCharsetValue((String)iterator.next());
                if (string == null || string.length() <= 0) continue;
                hashMap.put(string, string);
            }
        }
        return hashMap;
    }

    private static String parseLocaleCharsetValue(String string) {
        String string2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, SEPARATOR);
        while (stringTokenizer.hasMoreTokens() && string2 == null) {
            string2 = PossibleLocales.getLocale(stringTokenizer.nextToken());
        }
        return string2;
    }

    private static String getLocale(String string) {
        String string2;
        String string3 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "=");
        if (stringTokenizer.countTokens() == 2 && (string2 = stringTokenizer.nextToken()).equals(LOCALE_ATTR)) {
            string3 = stringTokenizer.nextToken();
        }
        return string3;
    }

    private AttributeSchema getLocaleCharsetMappingAttributeSchema(ServiceSchemaManager serviceSchemaManager) {
        AttributeSchema attributeSchema = null;
        try {
            ServiceSchema serviceSchema = serviceSchemaManager.getSchema(SchemaType.GLOBAL);
            if (serviceSchema != null) {
                attributeSchema = serviceSchema.getAttributeSchema(G11N_SERIVCE_LOCALE_CHARSET_MAPPING);
            }
        }
        catch (SMSException sMSException) {
            debug.error("PossibleLocales.getLocaleCharsetMappingAttributeSchema", sMSException);
        }
        return attributeSchema;
    }

    private ServiceSchemaManager getG11NServiceSchemaManager() {
        ServiceSchemaManager serviceSchemaManager;
        block3: {
            serviceSchemaManager = null;
            if (ssoToken == null) break block3;
            try {
                serviceSchemaManager = new ServiceSchemaManager(G11N_SERVICE_NAME, ssoToken);
            }
            catch (SSOException sSOException) {
                debug.error("PossibleLocales.getG11NServiceSchemaManager", sSOException);
            }
            catch (SMSException sMSException) {
                debug.error("PossibleLocales.getG11NServiceSchemaManager", sMSException);
            }
        }
        return serviceSchemaManager;
    }

    private static SSOToken getAdminSSOToken() {
        SSOToken sSOToken = null;
        try {
            SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
            String string = AdminUtils.getAdminDN();
            String string2 = new String(AdminUtils.getAdminPassword());
            sSOToken = sSOTokenManager.createSSOToken((Principal)new AuthPrincipal(string), string2);
        }
        catch (SSOException sSOException) {
            debug.warning("PossibleLocales.getAdminSSOToken", sSOException);
        }
        return sSOToken;
    }
}

