/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.common;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMTemplate;
import com.iplanet.am.util.AMClientDetector;
import com.iplanet.am.util.Locale;
import com.iplanet.am.util.Misc;
import com.iplanet.services.cdm.Client;
import com.iplanet.services.cdm.ClientException;
import com.iplanet.services.cdm.ClientsManager;
import com.iplanet.services.cdm.G11NSettings;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.internal.AuthPrincipal;
import com.sun.identity.security.AdminDNAction;
import com.sun.identity.security.AdminPasswordAction;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.security.Principal;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class ISLocaleContext {
    public static final int OS_LOCALE = 0;
    public static final int PLATFORM_LOCALE = 1;
    public static final int CORE_AUTH_LOCALE = 2;
    public static final int HTTP_HEADER_LOCALE = 3;
    public static final int USER_PREFERRED_LOCALE = 4;
    public static final int URL_LOCALE = 5;
    private static int initLocaleLevel;
    private static java.util.Locale initLocale;
    private static AMStoreConnection dpStore;
    private static AMClientDetector clientDt;
    private static Client defaultClient;
    private static G11NSettings g11nSettings;
    private static String initCharset;
    private Client client = defaultClient;
    private String charset;
    private java.util.Locale locale = initLocale;
    private int localeLevel = initLocaleLevel;

    public ISLocaleContext() {
        this.charset = initCharset;
    }

    public ISLocaleContext(String string) {
        this();
        this.setOrgLocale(string);
    }

    public void setLocale(int n, String string) {
        if (string != null && string.length() > 0) {
            this.setLocale(n, Locale.getLocale(string));
        }
    }

    public void setLocale(int n, java.util.Locale locale) {
        if (n < 0 || n > 5) {
            throw new IllegalArgumentException("Invalid locale level=" + n);
        }
        if (n >= this.localeLevel) {
            this.localeLevel = n;
            this.charset = this.client.getCharset(locale);
            this.locale = locale;
        }
    }

    public void setLocale(HttpServletRequest httpServletRequest) {
        if (httpServletRequest != null) {
            String string = httpServletRequest.getParameter("locale");
            String string2 = clientDt.getClientType(httpServletRequest);
            try {
                this.client = ClientsManager.getInstance((String)string2);
            }
            catch (ClientException clientException) {
                // empty catch block
            }
            if (string != null && string.length() > 0) {
                this.setLocale(5, string);
            } else {
                String string3 = httpServletRequest.getHeader("Accept-Language");
                if (string3 != null && string3.length() > 0) {
                    String string4 = Locale.getLocaleStringFromAcceptLangHeader(string3);
                    this.setLocale(3, string4);
                }
            }
        }
    }

    public void setUserLocale(java.util.Locale locale) {
        this.setLocale(4, locale);
    }

    public void setUserLocale(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        this.setLocale(4, Locale.getLocale(string));
    }

    public java.util.Locale getLocale() {
        return this.locale;
    }

    public int getLocaleLevel() {
        return this.localeLevel;
    }

    public void setOrgLocale(String string) {
        if (this.localeLevel > 2) {
            return;
        }
        try {
            AMOrganization aMOrganization = dpStore.getOrganization(string);
            AMTemplate aMTemplate = aMOrganization.getTemplate("iPlanetAMAuthService", 302);
            Map map = aMTemplate.getAttributes();
            String string2 = Misc.getMapAttr(map, "iplanet-am-auth-locale");
            if (string2 != null && string2.length() > 0) {
                this.setLocale(2, Locale.getLocale(string2));
            }
        }
        catch (SSOException sSOException) {
        }
        catch (AMException aMException) {}
    }

    public String getMIMECharset() {
        return this.charset;
    }

    public String getJavaCharset() {
        String string = g11nSettings.getJavaCharset(this.charset);
        return string;
    }

    static {
        dpStore = null;
        clientDt = new AMClientDetector();
        defaultClient = ClientsManager.getDefaultInstance();
        g11nSettings = G11NSettings.getInstance();
        try {
            Map map;
            ServiceSchema serviceSchema;
            Object object;
            SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
            String string = (String)AccessController.doPrivileged(new AdminDNAction());
            String string2 = (String)AccessController.doPrivileged(new AdminPasswordAction());
            SSOToken sSOToken = sSOTokenManager.createSSOToken((Principal)new AuthPrincipal(string), string2);
            dpStore = new AMStoreConnection(sSOToken);
            String string3 = null;
            String string4 = null;
            try {
                object = new ServiceSchemaManager("iPlanetAMPlatformService", sSOToken);
                serviceSchema = object.getGlobalSchema();
                map = serviceSchema.getAttributeDefaults();
                string3 = Misc.getMapAttr(map, "iplanet-am-platform-locale");
            }
            catch (SMSException sMSException) {
                // empty catch block
            }
            try {
                object = new ServiceSchemaManager("iPlanetAMAuthService", sSOToken);
                serviceSchema = object.getOrganizationSchema();
                map = serviceSchema.getAttributeDefaults();
                string4 = Misc.getMapAttr(map, "iplanet-am-auth-locale");
            }
            catch (SMSException sMSException) {
                // empty catch block
            }
            object = string4;
            initLocaleLevel = 2;
            Object object2 = object;
            if (object == null || ((String)object).length() == 0) {
                object = string3;
                initLocaleLevel = 1;
                object2 = object;
                if (object == null || ((String)object).length() == 0) {
                    object = java.util.Locale.getDefault().toString();
                    initLocaleLevel = 0;
                    object2 = object;
                }
            }
            initLocale = Locale.getLocale((String)object2);
        }
        catch (SSOException sSOException) {
            initLocale = java.util.Locale.getDefault();
            initLocaleLevel = 0;
        }
        initCharset = defaultClient.getCharset(initLocale);
    }
}

