/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.common;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.am.util.AMSendMail;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Locale;
import com.iplanet.sso.SSOException;
import com.sun.identity.authentication.spi.AMAuthCallBackException;
import com.sun.identity.authentication.spi.AMAuthCallBackImpl;
import com.sun.identity.common.AccountLockoutInfo;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.mail.MessagingException;

public class ISAccountLockout {
    private static final String USER_STATUS_ATTR = "inetuserstatus";
    private static final String USER_ACTIVE = "Active";
    private static final String USER_INACTIVE = "Inactive";
    private static final String SPACE_DELIM = " ";
    private static final String PIPE_DELIM = "|";
    private static final String FROM_ADDRESS = "lockOutEmailFrom";
    private static final String EMAIL_SUBJECT = "lockOutEmailSub";
    private static final String EMAIL_MESSAGE = "lockOutEmailMsg";
    private boolean failureLockoutMode = false;
    private boolean memoryLocking = false;
    private long failureLockoutTime = 300L;
    private int failureLockoutCount = 5;
    private String lockoutNotification = null;
    private int lockoutUserWarning = 3;
    private int userWarningCount = 0;
    private long failureLockoutDuration = 0L;
    private String lockoutAttrValue = null;
    private String lockoutAttrName = null;
    private String bundleName = null;
    static Debug debug = Debug.getInstance("amAccountLockout");
    private AMAuthCallBackImpl callbackImpl = null;

    public ISAccountLockout(boolean bl, long l, int n, String string, int n2, String string2, String string3, long l2, String string4) {
        this.failureLockoutMode = bl;
        this.failureLockoutTime = l;
        this.failureLockoutCount = n;
        this.lockoutNotification = string;
        this.lockoutUserWarning = n2;
        this.lockoutAttrName = string2;
        this.lockoutAttrValue = string3;
        this.failureLockoutDuration = l2;
        if (l2 > 0L) {
            this.memoryLocking = true;
        }
        this.bundleName = string4;
    }

    public boolean isLockoutEnabled() {
        return this.failureLockoutMode && this.failureLockoutCount > 0 && this.failureLockoutTime > 0L;
    }

    public boolean isMemoryLocking() {
        return this.memoryLocking;
    }

    public AccountLockoutInfo invalidPasswd(AMUser aMUser, AccountLockoutInfo accountLockoutInfo) {
        int n;
        String string;
        block25: {
            string = aMUser.getDN();
            if (debug.messageEnabled()) {
                debug.message("userDN : " + string);
                debug.message("acinfo : " + accountLockoutInfo);
            }
            if (accountLockoutInfo != null && accountLockoutInfo.isLockout() && !this.memoryLocking) {
                accountLockoutInfo = null;
            }
            long l = System.currentTimeMillis();
            n = 0;
            if (accountLockoutInfo != null) {
                long l2 = accountLockoutInfo.getLastFailTime();
                n = accountLockoutInfo.getFailCount();
                long l3 = this.failureLockoutTime;
                if (l2 + l3 > l) {
                    if (n >= this.failureLockoutCount - 1) {
                        accountLockoutInfo.setFailCount(++n);
                        accountLockoutInfo.setLockoutAt(l);
                        if (this.failureLockoutDuration > 0L) {
                            accountLockoutInfo.setLockout(true);
                        } else {
                            accountLockoutInfo.setLockout(false);
                        }
                        try {
                            String string2;
                            block26: {
                                if (debug.messageEnabled()) {
                                    debug.message("lock outuser: userDN=" + string);
                                    debug.message("failCount =" + n);
                                    debug.message("failureLockoutCount=" + this.failureLockoutCount);
                                }
                                if (aMUser == null || n != this.failureLockoutCount) break block25;
                                string2 = null;
                                if (!this.memoryLocking) {
                                    this.inactivateUserAccount(aMUser);
                                } else {
                                    string2 = accountLockoutInfo.getUserToken();
                                }
                                if (string2 == null) {
                                    string2 = string;
                                }
                                this.sendLockOutNotice(string2);
                                try {
                                    this.callbackImpl = AMAuthCallBackImpl.getInstance((String)aMUser.getOrganizationDN());
                                }
                                catch (AMAuthCallBackException aMAuthCallBackException) {
                                    if (debug.getState() >= 1) {
                                        debug.error("invalidPasswd : unable to get AMAuthCallBackImpl instance", aMAuthCallBackException);
                                    }
                                }
                                catch (AMException aMException) {
                                    if (debug.getState() >= 1) {
                                        debug.error("invalidPasswd : unable to get org DN for current user.", aMException);
                                    }
                                }
                                catch (SSOException sSOException) {
                                    if (debug.getState() < 1) break block26;
                                    debug.error("invalidPasswd : unable to get org DN for current user.", sSOException);
                                }
                            }
                            this.callbackImpl.processedAccounttLockout(new Long(l), string2);
                        }
                        catch (AMAuthCallBackException aMAuthCallBackException) {
                            if (debug.getState() >= 1) {
                                debug.error("invalidPasswd : error from callback module", aMAuthCallBackException);
                            }
                        }
                        catch (Exception exception) {
                            debug.message("Error activating account/sendingnotification ", exception);
                        }
                    } else {
                        accountLockoutInfo.setFailCount(++n);
                    }
                } else {
                    debug.message("restart time and count");
                    accountLockoutInfo.setFailCount(1);
                    accountLockoutInfo.setLastFailTime(l);
                    n = 1;
                }
            } else {
                debug.message("First failure... :");
                accountLockoutInfo = new AccountLockoutInfo();
                accountLockoutInfo.setFailCount(1);
                accountLockoutInfo.setLastFailTime(l);
                n = 1;
            }
        }
        if (debug.messageEnabled()) {
            debug.message("InvalidPasswd: user: userDN =" + string + "\n\tfailCount = " + n + "\n\tloginFailureLockoutCount = " + this.failureLockoutCount + "\n\tloginLockoutUserWarning = " + this.lockoutUserWarning);
        }
        this.setWarningCount(n, this.failureLockoutCount);
        accountLockoutInfo.setWarningCount(this.userWarningCount);
        return accountLockoutInfo;
    }

    public void sendLockOutNotice(String string) {
        if (this.lockoutNotification != null) {
            AMSendMail aMSendMail = new AMSendMail();
            StringTokenizer stringTokenizer = new StringTokenizer(this.lockoutNotification, SPACE_DELIM);
            StringBuffer stringBuffer = new StringBuffer();
            while (stringTokenizer.hasMoreTokens()) {
                StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), PIPE_DELIM);
                String[] stringArray = new String[]{stringTokenizer2.nextToken()};
                String string2 = null;
                String string3 = null;
                if (stringTokenizer2.hasMoreTokens()) {
                    string2 = stringTokenizer2.nextToken();
                    if (stringTokenizer2.hasMoreTokens()) {
                        string3 = stringTokenizer2.nextToken();
                    }
                }
                ResourceBundle resourceBundle = Locale.getResourceBundle(this.bundleName, string2);
                String string4 = resourceBundle.getString(FROM_ADDRESS);
                String string5 = resourceBundle.getString(EMAIL_SUBJECT);
                Object[] objectArray = new String[]{string};
                String string6 = MessageFormat.format(resourceBundle.getString(EMAIL_MESSAGE), objectArray);
                if (debug.messageEnabled()) {
                    debug.message("sendLockOutNotice:lockoutNotification=" + this.lockoutNotification + " toAddress=" + stringArray);
                }
                try {
                    aMSendMail.postMail(stringArray, string5, string6, string4, string3);
                }
                catch (MessagingException messagingException) {
                    debug.error("cannot email lockout notification:token ", messagingException);
                }
            }
        }
    }

    public boolean isLockedOut(AccountLockoutInfo accountLockoutInfo) {
        boolean bl = accountLockoutInfo.isLockout();
        if (debug.messageEnabled()) {
            debug.message("isLockedOut : " + bl);
        }
        if (accountLockoutInfo != null && bl) {
            long l = System.currentTimeMillis();
            long l2 = accountLockoutInfo.getLockoutAt();
            if (l2 + this.failureLockoutDuration < l) {
                if (debug.messageEnabled()) {
                    debug.message("isLockedOut returns false. loginFailureLockoutDuration=" + this.failureLockoutDuration + " lockOutTime=" + l2 + " now=" + l);
                }
                bl = false;
            }
        }
        return bl;
    }

    private void inactivateUserAccount(AMUser aMUser) {
        debug.message("inactivateUseraccount");
        try {
            if (this.lockoutAttrName != null && this.lockoutAttrValue != null) {
                aMUser.setStringAttribute(this.lockoutAttrName, this.lockoutAttrValue);
            } else {
                aMUser.setStringAttribute(USER_STATUS_ATTR, USER_INACTIVE);
            }
            aMUser.store();
        }
        catch (Exception exception) {
            debug.error("Error inactivating user account");
        }
    }

    private void setWarningCount(int n, int n2) {
        int n3;
        this.userWarningCount = 0;
        if (n >= n2) {
            this.userWarningCount = -1;
        } else if (this.lockoutUserWarning > 0 && this.lockoutUserWarning < n2 && n >= (n3 = this.lockoutUserWarning)) {
            this.userWarningCount = n2 - n;
        }
    }

    public boolean isAccountLocked(AMUser aMUser) {
        boolean bl = false;
        if (!this.memoryLocking) {
            try {
                if (this.lockoutAttrName != null && this.lockoutAttrValue != null) {
                    String string = aMUser.getStringAttribute(this.lockoutAttrName);
                    if (string.equals(this.lockoutAttrValue)) {
                        bl = true;
                    }
                } else {
                    String string = aMUser.getStringAttribute(USER_STATUS_ATTR);
                    if (string.equals(USER_INACTIVE)) {
                        bl = true;
                    }
                }
            }
            catch (Exception exception) {
                debug.error("Error inactivating user account");
            }
        }
        if (debug.messageEnabled()) {
            if (bl) {
                debug.message("Account is locked");
            } else {
                debug.message("Account is unlocked");
            }
        }
        return bl;
    }
}

