/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.sso;

import com.iplanet.am.util.Debug;
import com.iplanet.services.util.I18n;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOProvider;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.providers.dpro.SSOProviderBundle;
import java.io.Serializable;
import java.security.Principal;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public final class SSOTokenManager {
    static final String DPRO_PROVIDER_CONFIG_FILE = "SSOConfig";
    static final String DPRO_PROVIDER_CLASSNAME_KEY = "com.iplanet.sso.providerimplclass";
    static final String DPRO_PROVIDER_CLASSNAME_KEY_OLD = "providerimplclass";
    static SSOProvider dProProvider = null;
    static final String GRAPPA_PROVIDER_CLASSNAME = "com.sun.identity.authentication.internal.AuthSSOProvider";
    static final String GRAPPA_PROVIDER_PACKAGE = "com.sun.identity.authentication.internal";
    static SSOProvider grappaProvider = null;
    public static Debug debug = Debug.getInstance("amSDK");
    private static SSOTokenManager instance = null;
    static /* synthetic */ Class class$com$iplanet$sso$SSOTokenManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SSOTokenManager getInstance() throws SSOException {
        if (instance == null) {
            Class clazz = class$com$iplanet$sso$SSOTokenManager == null ? (class$com$iplanet$sso$SSOTokenManager = SSOTokenManager.class$("com.iplanet.sso.SSOTokenManager")) : class$com$iplanet$sso$SSOTokenManager;
            synchronized (clazz) {
                if (instance == null) {
                    debug.message("Constructing a new instance of SSOTokenManager");
                    instance = new SSOTokenManager();
                }
            }
        }
        return instance;
    }

    private SSOTokenManager() throws SSOException {
        Object object;
        Object object2;
        Serializable serializable;
        try {
            serializable = Class.forName(GRAPPA_PROVIDER_CLASSNAME);
            grappaProvider = (SSOProvider)serializable.newInstance();
            debug.message("Grappa SSO Provider: com.sun.identity.authentication.internal.AuthSSOProvider");
        }
        catch (Exception exception) {
            debug.error("Unable to obtain Grappa SSO provider", exception);
        }
        serializable = null;
        try {
            object2 = null;
            object = ResourceBundle.getBundle(DPRO_PROVIDER_CONFIG_FILE);
            try {
                object2 = ((ResourceBundle)object).getString(DPRO_PROVIDER_CLASSNAME_KEY);
            }
            catch (Exception exception) {
                debug.warning("DPRO provider key not present: com.iplanet.sso.providerimplclass", exception);
                object2 = ((ResourceBundle)object).getString(DPRO_PROVIDER_CLASSNAME_KEY_OLD);
            }
            Class<?> clazz = Class.forName((String)object2);
            dProProvider = (SSOProvider)clazz.newInstance();
            debug.message("DPro SSO Provider: com.sun.identity.authentication.internal.AuthSSOProvider");
        }
        catch (MissingResourceException missingResourceException) {
            debug.error("Unable to obtain DPRO SSO provider:", missingResourceException);
            serializable = missingResourceException;
        }
        catch (Exception exception) {
            debug.error("DPRO SSO Provider Exception", exception);
            serializable = exception;
        }
        if (dProProvider == null && grappaProvider == null) {
            debug.error("Unable to obtain either GRAPPA or DPRO SSO providers");
            object2 = I18n.getInstance("amSDK");
            object = ((I18n)object2).getResBundleName();
            if (serializable instanceof MissingResourceException) {
                throw new SSOException((String)object, "sso-noproviderproperty", null);
            }
            if (serializable instanceof ClassNotFoundException) {
                throw new SSOException((String)object, "sso-noproviderclass", null);
            }
            if (serializable instanceof InstantiationException) {
                throw new SSOException((String)object, "sso-noproviderinstance", null);
            }
            if (serializable instanceof IllegalAccessException) {
                throw new SSOException((String)object, "sso-illegalaccess", null);
            }
            throw new SSOException((Throwable)serializable);
        }
    }

    protected static SSOProvider getProvider(SSOToken sSOToken) throws SSOException {
        if (sSOToken == null) {
            throw new SSOException(SSOProviderBundle.rbName, "ssotokennull", null);
        }
        String string = sSOToken.getClass().getName();
        if (string.startsWith(GRAPPA_PROVIDER_PACKAGE)) {
            if (grappaProvider == null) {
                I18n i18n = I18n.getInstance("amSDK");
                throw new SSOException(i18n.getResBundleName(), "sso-noproviderclass", null);
            }
            return grappaProvider;
        }
        return dProProvider;
    }

    public SSOToken createSSOToken(HttpServletRequest httpServletRequest) throws UnsupportedOperationException, SSOException {
        if (dProProvider != null) {
            return dProProvider.createSSOToken(httpServletRequest);
        }
        return grappaProvider.createSSOToken(httpServletRequest);
    }

    public SSOToken createSSOToken(Principal principal, String string) throws UnsupportedOperationException, SSOException {
        if (dProProvider != null) {
            return dProProvider.createSSOToken(principal, string);
        }
        return grappaProvider.createSSOToken(principal, string);
    }

    public SSOToken createSSOToken(String string) throws UnsupportedOperationException, SSOException {
        if (dProProvider != null) {
            return dProProvider.createSSOToken(string);
        }
        return grappaProvider.createSSOToken(string);
    }

    public SSOToken createSSOToken(String string, String string2) throws UnsupportedOperationException, SSOException {
        if (dProProvider != null) {
            return dProProvider.createSSOToken(string, string2);
        }
        return grappaProvider.createSSOToken(string, string2);
    }

    public boolean isValidToken(SSOToken sSOToken) {
        try {
            return SSOTokenManager.getProvider(sSOToken).isValidToken(sSOToken);
        }
        catch (SSOException sSOException) {
            return false;
        }
    }

    public void validateToken(SSOToken sSOToken) throws SSOException {
        SSOTokenManager.getProvider(sSOToken).validateToken(sSOToken);
    }

    public void destroyToken(SSOToken sSOToken) throws SSOException {
        SSOTokenManager.getProvider(sSOToken).destroyToken(sSOToken);
    }

    public void refreshSession(SSOToken sSOToken) throws SSOException {
        try {
            SSOTokenManager.getProvider(sSOToken).refreshSession(sSOToken);
        }
        catch (Exception exception) {
            debug.error("Error in refreshing the session from session server");
            throw new SSOException(exception);
        }
    }

    public void destroyToken(SSOToken sSOToken, SSOToken sSOToken2) throws SSOException {
        SSOTokenManager.getProvider(sSOToken).destroyToken(sSOToken, sSOToken2);
    }

    public Set getValidSessions(SSOToken sSOToken, String string) throws SSOException {
        return SSOTokenManager.getProvider(sSOToken).getValidSessions(sSOToken, string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

