/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.util;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.comm.https.JSSPasswordCallback;
import com.iplanet.services.util.AMEncryption;
import com.iplanet.services.util.ConfigurableKey;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.Provider;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Enumeration;
import java.util.Random;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.Algorithm;
import org.mozilla.jss.crypto.Cipher;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.EncryptionAlgorithm;
import org.mozilla.jss.crypto.IVParameterSpec;
import org.mozilla.jss.crypto.KeyGenAlgorithm;
import org.mozilla.jss.crypto.KeyGenerator;
import org.mozilla.jss.crypto.PBEAlgorithm;
import org.mozilla.jss.crypto.PBEKeyGenParams;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.util.Password;
import org.mozilla.jss.util.PasswordCallback;

public class JSSEncryption
implements AMEncryption,
ConfigurableKey {
    private static final byte VERSION = 1;
    private static final String DEFAULT_KEYGEN_ALG = "PBE_MD5_DES_CBC";
    private static final String DEFAULT_ENCYPTION_ALG = "DES_CBC_PAD";
    private static final String[] KEYGEN_ALGS;
    private static int NUM_KEYGEN_ALG;
    private static final String[] ENCRYPTION_ALGS;
    private static int NUM_ENCRYPTION_ALG;
    private SymmetricKey[] sKeys = null;
    private IVParameterSpec[] ivParamSpecs = null;
    private static CryptoToken mToken;
    private static Debug debug;
    private Random random = new Random();

    JSSEncryption() {
    }

    private static CryptoToken findToken() throws CryptoManager.NotInitializedException {
        Object var0 = null;
        CryptoManager cryptoManager = CryptoManager.getInstance();
        Enumeration enumeration = cryptoManager.getTokensSupportingAlgorithm((Algorithm)JSSEncryption.getEncryptionAlg(DEFAULT_ENCYPTION_ALG));
        while (enumeration.hasMoreElements()) {
            CryptoToken cryptoToken = (CryptoToken)enumeration.nextElement();
            boolean bl = true;
            int n = 0;
            while (n < NUM_KEYGEN_ALG) {
                if (!cryptoToken.doesAlgorithm((Algorithm)JSSEncryption.getKeyGenAlg(KEYGEN_ALGS[n]))) {
                    bl = false;
                    break;
                }
                ++n;
            }
            if (!bl) continue;
            return cryptoToken;
        }
        return null;
    }

    public void setPassword(String string) throws Exception {
        this.initSymmetricKeysAndInitializationVectors(string);
    }

    private void initSymmetricKeysAndInitializationVectors(String string) {
        this.sKeys = new SymmetricKey[NUM_KEYGEN_ALG];
        this.ivParamSpecs = new IVParameterSpec[NUM_KEYGEN_ALG];
        byte[] byArray = new byte[]{1, 1, 1, 1, 1, 1, 1, 1};
        Password password = new Password(string.toCharArray());
        int n = 0;
        while (n < NUM_KEYGEN_ALG) {
            block3: {
                try {
                    PBEAlgorithm pBEAlgorithm = JSSEncryption.getKeyGenAlg(KEYGEN_ALGS[n]);
                    KeyGenerator keyGenerator = mToken.getKeyGenerator((KeyGenAlgorithm)pBEAlgorithm);
                    PBEKeyGenParams pBEKeyGenParams = new PBEKeyGenParams(password, byArray, 5);
                    keyGenerator.initialize((AlgorithmParameterSpec)pBEKeyGenParams);
                    this.sKeys[n] = keyGenerator.generate();
                    this.ivParamSpecs[n] = new IVParameterSpec(keyGenerator.generatePBE_IV());
                }
                catch (Exception exception) {
                    if (debug == null) break block3;
                    debug.error("createing symKey ", exception);
                }
            }
            ++n;
        }
        password.clear();
    }

    private SymmetricKey getSymmetricKey(int n) {
        if (n >= 0 && n < NUM_KEYGEN_ALG) {
            return this.sKeys[n];
        }
        return null;
    }

    private IVParameterSpec getIVParameterSpec(int n) {
        if (n >= 0 && n < NUM_KEYGEN_ALG) {
            return this.ivParamSpecs[n];
        }
        return null;
    }

    public byte[] encrypt(byte[] byArray) {
        return this.encode(byArray);
    }

    public byte[] decrypt(byte[] byArray) {
        return this.decode(byArray);
    }

    private byte[] encode(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        try {
            byte[] byArray2 = new byte[2];
            String string = DEFAULT_ENCYPTION_ALG;
            EncryptionAlgorithm encryptionAlgorithm = JSSEncryption.getEncryptionAlg(string);
            int n = JSSEncryption.getEncryptionByte(string);
            byArray2[1] = (byte)n;
            Cipher cipher = mToken.getCipherContext(encryptionAlgorithm);
            String string2 = DEFAULT_KEYGEN_ALG;
            n = JSSEncryption.getKeyGenByte(string2);
            byArray2[0] = (byte)n;
            SymmetricKey symmetricKey = this.getSymmetricKey(n);
            IVParameterSpec iVParameterSpec = this.getIVParameterSpec(n);
            byte[] byArray3 = iVParameterSpec.getIV();
            cipher.initEncrypt(symmetricKey, (AlgorithmParameterSpec)iVParameterSpec);
            byte[] byArray4 = cipher.doFinal(byArray);
            byArray4 = JSSEncryption.addPrefix(byArray2, byArray3, byArray4);
            return byArray4;
        }
        catch (Throwable throwable) {
            if (debug != null) {
                debug.error("in encode string " + throwable);
            }
            return null;
        }
    }

    private byte[] decode(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        try {
            byte[] byArray2 = byArray;
            if (byArray2[0] != 1) {
                if (debug != null) {
                    debug.error("In decode string: unsupported version:" + byArray2[0]);
                }
                return null;
            }
            byte[] byArray3 = JSSEncryption.getType(byArray2);
            byArray2 = JSSEncryption.getRaw(byArray2);
            if (byArray3[1] < 0 && byArray3[1] >= NUM_ENCRYPTION_ALG) {
                if (debug != null) {
                    debug.error("In decode string: unsupported encryption bit:" + byArray3[1]);
                }
                return null;
            }
            EncryptionAlgorithm encryptionAlgorithm = JSSEncryption.getEncryptionAlg(ENCRYPTION_ALGS[byArray3[1]]);
            Cipher cipher = mToken.getCipherContext(encryptionAlgorithm);
            if (byArray3[0] < 0 && byArray3[0] >= NUM_KEYGEN_ALG) {
                if (debug != null) {
                    debug.error("In decode string: unsupported keygen bit:" + byArray3[0]);
                }
                return null;
            }
            SymmetricKey symmetricKey = this.getSymmetricKey(byArray3[0]);
            IVParameterSpec iVParameterSpec = this.getIVParameterSpec(byArray3[0]);
            cipher.initDecrypt(symmetricKey, (AlgorithmParameterSpec)iVParameterSpec);
            byte[] byArray4 = cipher.doFinal(byArray2);
            if (byArray4 == null) {
                debug.error("Failed to decode " + byArray);
                return null;
            }
            return byArray4;
        }
        catch (Throwable throwable) {
            if (debug != null) {
                debug.error("in decoding string " + byArray, throwable);
            }
            return null;
        }
    }

    private static byte[] addPrefix(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        byte[] byArray4 = new byte[byArray3.length + 11];
        byArray4[0] = 1;
        byArray4[1] = byArray[0];
        byArray4[2] = byArray[1];
        int n = 0;
        while (n < 8) {
            byArray4[3 + n] = byArray2[n];
            ++n;
        }
        int n2 = 0;
        while (n2 < byArray3.length) {
            byArray4[11 + n2] = byArray3[n2];
            ++n2;
        }
        return byArray4;
    }

    private static byte[] getType(byte[] byArray) {
        byte[] byArray2 = new byte[]{byArray[1], byArray[2]};
        return byArray2;
    }

    private static byte[] getIV(byte[] byArray) {
        byte[] byArray2 = new byte[8];
        int n = 0;
        while (n < 8) {
            byArray2[n] = byArray[n + 3];
            ++n;
        }
        return byArray2;
    }

    private static byte[] getRaw(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length - 11];
        int n = 11;
        while (n < byArray.length) {
            byArray2[n - 11] = byArray[n];
            ++n;
        }
        return byArray2;
    }

    private static int getKeyGenByte(String string) {
        int n = 0;
        while (n < NUM_KEYGEN_ALG) {
            if (string.equals(KEYGEN_ALGS[n])) {
                return n;
            }
            ++n;
        }
        if (debug != null) {
            debug.error("keyGen algorithm is not valid.");
        }
        return 0;
    }

    private static PBEAlgorithm getKeyGenAlg(String string) {
        if (string.equals("PBE_SHA1_DES3_CBC")) {
            return PBEAlgorithm.PBE_SHA1_DES3_CBC;
        }
        if (string.equals("PBE_MD2_DES_CBC")) {
            return PBEAlgorithm.PBE_MD2_DES_CBC;
        }
        if (string.equals(DEFAULT_KEYGEN_ALG)) {
            return PBEAlgorithm.PBE_MD5_DES_CBC;
        }
        if (string.equals("PBE_SHA1_DES_CBC")) {
            return PBEAlgorithm.PBE_SHA1_DES_CBC;
        }
        if (string.equals("PBE_SHA1_RC2_128_CBC")) {
            return PBEAlgorithm.PBE_SHA1_RC2_128_CBC;
        }
        if (string.equals("PBE_SHA1_RC2_40_CBC")) {
            return PBEAlgorithm.PBE_SHA1_RC2_40_CBC;
        }
        if (string.equals("PBE_SHA1_RC4_128")) {
            return PBEAlgorithm.PBE_SHA1_RC4_128;
        }
        if (string.equals("PBE_SHA1_RC4_40")) {
            return PBEAlgorithm.PBE_SHA1_RC4_40;
        }
        if (debug != null) {
            debug.message("keyGen algorithm is not valid.");
        }
        return PBEAlgorithm.PBE_SHA1_DES3_CBC;
    }

    private static int getEncryptionByte(String string) {
        int n = 0;
        while (n < NUM_ENCRYPTION_ALG) {
            if (string.equals(ENCRYPTION_ALGS[n])) {
                return n;
            }
            ++n;
        }
        if (debug != null) {
            debug.error("Encryption algorithm is not valid.");
        }
        return 0;
    }

    private static EncryptionAlgorithm getEncryptionAlg(String string) {
        if (string.equals("DES3_CBC_PAD")) {
            return EncryptionAlgorithm.DES3_CBC_PAD;
        }
        if (string.equals("DES3_CBC")) {
            return EncryptionAlgorithm.DES3_CBC;
        }
        if (string.equals("DES3_ECB")) {
            return EncryptionAlgorithm.DES3_ECB;
        }
        if (string.equals("DES_CBC")) {
            return EncryptionAlgorithm.DES_CBC;
        }
        if (string.equals(DEFAULT_ENCYPTION_ALG)) {
            return EncryptionAlgorithm.DES_CBC_PAD;
        }
        if (string.equals("DES_ECB")) {
            return EncryptionAlgorithm.DES_ECB;
        }
        if (string.equals("RC2_CBC")) {
            return EncryptionAlgorithm.RC2_CBC;
        }
        if (string.equals("RC4")) {
            return EncryptionAlgorithm.RC4;
        }
        if (debug != null) {
            debug.message("Encryption algorithm is not valid.");
        }
        return EncryptionAlgorithm.DES3_CBC_PAD;
    }

    static {
        block20: {
            Object object;
            Object object2;
            String string;
            File file;
            String string2;
            String string3;
            KEYGEN_ALGS = new String[]{"PBE_SHA1_DES3_CBC", "PBE_MD2_DES_CBC", DEFAULT_KEYGEN_ALG, "PBE_SHA1_DES_CBC", "PBE_SHA1_RC2_128_CBC", "PBE_SHA1_RC2_40_CBC", "PBE_SHA1_RC4_128", "PBE_SHA1_RC4_40"};
            NUM_KEYGEN_ALG = KEYGEN_ALGS.length;
            ENCRYPTION_ALGS = new String[]{"DES3_CBC_PAD", "DES_CBC", DEFAULT_ENCYPTION_ALG, "DES_ECB", "DES3_CBC", "DES3_ECB", "RC2_CBC", "RC4"};
            NUM_ENCRYPTION_ALG = ENCRYPTION_ALGS.length;
            mToken = null;
            debug = Debug.getInstance("amJSS");
            String string4 = System.getProperty("java.io.tmpdir");
            String string5 = System.getProperty("user.name") + "-";
            String string6 = null;
            String string7 = SystemProperties.get("com.iplanet.am.admin.cli.certdb.dir");
            if (string7 == null) {
                string7 = string4;
            }
            if ((string3 = SystemProperties.get("com.sun.identity.authentication.ocspCheck")) != null && string3.trim().equals("")) {
                string3 = null;
            }
            boolean bl = string3 != null && string3.equalsIgnoreCase("true");
            String string8 = SystemProperties.get("com.sun.identity.authentication.ocsp.responder.url");
            if (string8 != null && string8.trim().equals("")) {
                string8 = null;
            }
            if ((string2 = SystemProperties.get("com.sun.identity.authentication.ocsp.responder.nickname")) != null && string2.trim().equals("")) {
                string2 = null;
            }
            if ((file = new File(string7)).exists()) {
                String string9;
                string = SystemProperties.get("com.iplanet.am.admin.cli.certdb.prefix");
                if (string == null) {
                    string = "";
                }
                if ((string9 = SystemProperties.get("com.iplanet.am.admin.cli.certdb.passfile")) != null) {
                    try {
                        object2 = new FileInputStream(string9);
                        object = new InputStreamReader((InputStream)object2);
                        BufferedReader bufferedReader = new BufferedReader((Reader)object);
                        string6 = bufferedReader.readLine();
                    }
                    catch (Exception exception) {}
                }
            } else {
                string7 = string4;
                string = string5;
            }
            object2 = string;
            object = "secmod.db";
            try {
                mToken = JSSEncryption.findToken();
            }
            catch (CryptoManager.NotInitializedException notInitializedException) {
                try {
                    if (debug.messageEnabled()) {
                        debug.message("Intilize CryptoManager in JSSEncryption.java");
                    }
                    CryptoManager.InitializationValues initializationValues = null;
                    initializationValues = string.equals("") ? new CryptoManager.InitializationValues(string7) : new CryptoManager.InitializationValues(string7, string, (String)object2, (String)object);
                    initializationValues.removeSunProvider = false;
                    boolean bl2 = Boolean.valueOf(SystemProperties.get("com.sun.identity.jss.donotInstallAtHighestPriority", "false"));
                    if (bl2) {
                        initializationValues.installJSSProvider = false;
                    }
                    if (debug.messageEnabled()) {
                        debug.message("ocspCheck value in JSSEncryption : " + bl);
                    }
                    initializationValues.ocspCheckingEnabled = bl;
                    if (bl && string8 != null && string2 != null) {
                        initializationValues.ocspResponderCertNickname = string2;
                        initializationValues.ocspResponderURL = string8;
                    }
                    CryptoManager.initialize((CryptoManager.InitializationValues)initializationValues);
                    if (bl2) {
                        Security.addProvider((Provider)new org.mozilla.jss.provider.Provider());
                    }
                    if (string6 != null) {
                        CryptoManager.getInstance().setPasswordCallback((PasswordCallback)new JSSPasswordCallback(string6));
                    }
                    mToken = JSSEncryption.findToken();
                }
                catch (Exception exception) {
                    if (debug == null) break block20;
                    debug.error("Crypt: Initialize JSS ", exception);
                }
            }
        }
    }
}

