/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.util;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class CookieUtils {
    static boolean secureCookie = SystemProperties.get("com.iplanet.am.cookie.secure") != null && SystemProperties.get("com.iplanet.am.cookie.secure").equalsIgnoreCase("true");
    static boolean cookieEncoding = SystemProperties.get("com.iplanet.am.cookie.encode") != null && SystemProperties.get("com.iplanet.am.cookie.encode").equalsIgnoreCase("true");
    static String amCookieName = SystemProperties.get("com.iplanet.am.cookie.name");
    static String amPCookieName = SystemProperties.get("com.iplanet.am.pcookie.name");
    static String cdssoCookiedomain = SystemProperties.get("com.iplanet.services.cdsso.cookiedomain");
    static String fedCookieName = SystemProperties.get("com.sun.identity.federation.fedCookieName");
    private static Set cookieDomains = null;
    private static int defAge = -1;
    static Debug debug = Debug.getInstance("amCookieUtils");

    public static String getAmCookieName() {
        return amCookieName;
    }

    public static String getAmPCookieName() {
        return amPCookieName;
    }

    public static Set getCdssoCookiedomain() {
        if (cookieDomains != null) {
            return cookieDomains;
        }
        HashSet<String> hashSet = new HashSet<String>();
        if (cdssoCookiedomain == null || cdssoCookiedomain.length() < 1) {
            return Collections.EMPTY_SET;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(cdssoCookiedomain, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken().trim();
            if (string.length() <= 0) continue;
            hashSet.add(string);
        }
        if (hashSet.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        return hashSet;
    }

    public static String getFedCookieName() {
        return fedCookieName;
    }

    public static boolean isCookieSecure() {
        return secureCookie;
    }

    public static String getCookieValueFromReq(HttpServletRequest httpServletRequest, String string) {
        String string2 = null;
        try {
            Cookie cookie = CookieUtils.getCookieFromReq(httpServletRequest, string);
            if (cookie != null) {
                return CookieUtils.getCookieValue(cookie);
            }
            debug.message("No Cookie is in the request");
        }
        catch (Exception exception) {
            debug.error("Error getting cookie  : ", exception);
        }
        return string2;
    }

    public static Cookie getCookieFromReq(HttpServletRequest httpServletRequest, String string) {
        Cookie[] cookieArray = httpServletRequest.getCookies();
        if (cookieArray != null) {
            int n = 0;
            while (n < cookieArray.length) {
                if (cookieArray[n].getName().equalsIgnoreCase(string)) {
                    return cookieArray[n];
                }
                ++n;
            }
        }
        return null;
    }

    public static String getCookieValue(Cookie cookie) {
        String string = CookieUtils.checkDoubleQuote(cookie.getValue());
        if (string != null && cookieEncoding) {
            return URLDecoder.decode(string);
        }
        return string;
    }

    public static Cookie[] getCookieArrayFromReq(HttpServletRequest httpServletRequest) {
        Cookie[] cookieArray = httpServletRequest.getCookies();
        if (!cookieEncoding) {
            return cookieArray;
        }
        if (cookieArray != null) {
            int n = 0;
            while (n < cookieArray.length) {
                String string = CookieUtils.checkDoubleQuote(cookieArray[n].getValue());
                if (string != null) {
                    cookieArray[n].setValue(URLDecoder.decode(string));
                }
                ++n;
            }
        }
        return cookieArray;
    }

    public static Cookie newCookie(String string, String string2) {
        return CookieUtils.newCookie(string, string2, defAge, null, null);
    }

    public static Cookie newCookie(String string, String string2, int n) {
        return CookieUtils.newCookie(string, string2, n, null, null);
    }

    public static Cookie newCookie(String string, String string2, String string3) {
        return CookieUtils.newCookie(string, string2, defAge, string3, null);
    }

    public static Cookie newCookie(String string, String string2, String string3, String string4) {
        return CookieUtils.newCookie(string, string2, defAge, string3, string4);
    }

    public static Cookie newCookie(String string, String string2, int n, String string3, String string4) {
        Cookie cookie = null;
        cookie = cookieEncoding ? new Cookie(string, URLEncoder.encode(string2)) : new Cookie(string, string2);
        cookie.setMaxAge(n);
        if (string3 != null && string3.length() > 0) {
            cookie.setPath(string3);
        } else {
            cookie.setPath("/");
        }
        if (string4 != null && string4.length() > 0) {
            cookie.setDomain(string4);
        }
        cookie.setSecure(CookieUtils.isCookieSecure());
        return cookie;
    }

    public static String checkDoubleQuote(String string) {
        String string2 = "\"";
        if (string != null && string.startsWith(string2) && string.endsWith(string2)) {
            int n = string.length() - 1;
            string = string.substring(1, n);
        }
        return string;
    }
}

