/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.naming;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.comm.client.PLLClient;
import com.iplanet.services.comm.client.SendRequestException;
import com.iplanet.services.comm.share.Request;
import com.iplanet.services.comm.share.RequestSet;
import com.iplanet.services.comm.share.Response;
import com.iplanet.services.naming.ServerEntryNotFoundException;
import com.iplanet.services.naming.URLNotFoundException;
import com.iplanet.services.naming.service.NamingService;
import com.iplanet.services.naming.share.NamingBundle;
import com.iplanet.services.naming.share.NamingRequest;
import com.iplanet.services.naming.share.NamingResponse;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class WebtopNaming {
    private static final String sccsID = "$Id: WebtopNaming.java,v 1.36.2.1 2004/09/24 01:05:16 sp116981 Exp $ $Date: 2004/09/24 01:05:16 $  Sun Microsystems, Inc.";
    public static final String SERVER_MODE = "com.iplanet.am.serverMode";
    public static final String NAMING_SERVICE = "com.iplanet.am.naming";
    public static final String NOTIFICATION_SERVICE = "com.iplanet.am.notification";
    public static final String SERVER_HOST = "com.iplanet.am.server.host";
    public static final String SERVER_PORT = "com.iplanet.am.server.port";
    public static final String SERVER_PROTO = "com.iplanet.am.server.protocol";
    public static final String PLATFORM_LIST = "iplanet-am-platform-server-list";
    public static final String NAMING_SERVICE_FAILOVER_URL = "com.iplanet.am.naming.failover.url";
    private static Properties platformProperties = null;
    private static Hashtable namingTable = null;
    private static Hashtable serverIdTable = null;
    private static Vector platformServers = new Vector();
    private static String[] namingServiceURL = null;
    private static String server_host = null;
    private static String server_port = null;
    private static String server_proto = null;
    protected static Debug debug = Debug.getInstance("amNaming");
    private static boolean serverMode = false;
    private static final String IGNORE_NAMING_SERVICE = "com.iplanet.am.naming.ignoreNamingService";
    private static boolean ignoreNaming = false;

    public static boolean isServerMode() {
        return serverMode;
    }

    private static void initializeNamingService() {
        WebtopNaming.initProperties();
        server_host = platformProperties.getProperty(SERVER_HOST, "");
        server_port = platformProperties.getProperty(SERVER_PORT, "");
        server_proto = platformProperties.getProperty(SERVER_PROTO, "");
        ignoreNaming = Boolean.valueOf(platformProperties.getProperty(IGNORE_NAMING_SERVICE, "false"));
        try {
            WebtopNaming.getNamingServiceURL();
        }
        catch (Exception exception) {
            debug.error("Failed to initialize naming service", exception);
        }
    }

    public static URL getServiceURL(String string, String string2, String string3, String string4) throws URLNotFoundException {
        try {
            if (ignoreNaming && !WebtopNaming.isServerMode()) {
                string2 = server_proto;
                string3 = server_host;
                string4 = server_port;
            }
            if (string2 == null || string3 == null || string4 == null || string2.length() == 0 || string3.length() == 0 || string4.length() == 0) {
                throw new Exception(NamingBundle.getString("noServiceURL") + string);
            }
            if (namingTable == null) {
                WebtopNaming.getNamingProfile(false);
            }
            String string5 = null;
            String string6 = "iplanet-am-naming-" + string.toLowerCase() + "-url";
            string5 = (String)namingTable.get(string6);
            if (string5 != null) {
                int n;
                if (string5.indexOf("%") != -1) {
                    WebtopNaming.validate(string2, string3, string4);
                }
                if ((n = string5.indexOf("%protocol")) != -1) {
                    string5 = string5.substring(0, n) + string2 + string5.substring(n + "%protocol".length(), string5.length());
                }
                if ((n = string5.indexOf("%host")) != -1) {
                    string5 = string5.substring(0, n) + string3 + string5.substring(n + "%host".length(), string5.length());
                }
                if ((n = string5.indexOf("%port")) != -1) {
                    string5 = string5.substring(0, n) + string4 + string5.substring(n + "%port".length(), string5.length());
                }
                return new URL(string5);
            }
            throw new Exception(NamingBundle.getString("noServiceURL") + string);
        }
        catch (Exception exception) {
            throw new URLNotFoundException(exception.getMessage());
        }
    }

    public static Vector getServiceAllURLs(String string) throws URLNotFoundException {
        Vector<URL> vector = null;
        try {
            String string2;
            String string3;
            if (namingTable == null) {
                WebtopNaming.getNamingProfile(false);
            }
            if ((string3 = (String)namingTable.get(string2 = "iplanet-am-naming-" + string.toLowerCase() + "-url")) != null) {
                vector = new Vector<URL>();
                if (string3.indexOf("%") != -1) {
                    String string4 = (String)namingTable.get(PLATFORM_LIST);
                    if (string4 != null) {
                        Vector vector2 = new Vector();
                        StringTokenizer stringTokenizer = new StringTokenizer(string4, ",");
                        while (stringTokenizer.hasMoreTokens()) {
                            String string5 = stringTokenizer.nextToken();
                            URL uRL = new URL(string5);
                            vector.add(WebtopNaming.getServiceURL(string, uRL.getProtocol(), uRL.getHost(), String.valueOf(uRL.getPort())));
                        }
                    }
                } else {
                    vector.add(new URL(string3));
                }
            }
            return vector;
        }
        catch (Exception exception) {
            throw new URLNotFoundException(exception.getMessage());
        }
    }

    public static Vector getPlatformServerList() throws Exception {
        WebtopNaming.getNamingProfile(true);
        return platformServers;
    }

    private static String getValueFromTable(Hashtable hashtable, String string) {
        if (hashtable.contains(string)) {
            return (String)hashtable.get(string);
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.equalsIgnoreCase(string)) continue;
            return (String)hashtable.get(string2);
        }
        return null;
    }

    public static String getServerID(String string, String string2, String string3) throws ServerEntryNotFoundException {
        try {
            if (string == null || string2 == null || string3 == null || string.length() == 0 || string2.length() == 0 || string3.length() == 0) {
                throw new Exception(NamingBundle.getString("noServerID"));
            }
            String string4 = string + ":" + "//" + string2 + ":" + string3;
            String string5 = null;
            if (serverIdTable != null) {
                string5 = WebtopNaming.getValueFromTable(serverIdTable, string4);
            }
            if (string5 == null) {
                WebtopNaming.getNamingProfile(true);
                string5 = WebtopNaming.getValueFromTable(serverIdTable, string4);
            }
            if (string5 == null) {
                throw new ServerEntryNotFoundException(NamingBundle.getString("noServerID"));
            }
            return string5;
        }
        catch (Exception exception) {
            throw new ServerEntryNotFoundException(exception);
        }
    }

    public static String getServerFromID(String string) throws ServerEntryNotFoundException {
        String string2 = null;
        try {
            if (namingTable != null) {
                string2 = WebtopNaming.getValueFromTable(namingTable, string);
            }
            if (string2 == null) {
                WebtopNaming.getNamingProfile(true);
                string2 = WebtopNaming.getValueFromTable(namingTable, string);
            }
            if (string2 == null) {
                throw new ServerEntryNotFoundException(NamingBundle.getString("noServer"));
            }
        }
        catch (Exception exception) {
            throw new ServerEntryNotFoundException(exception);
        }
        return string2;
    }

    public static String getServiceClass(String string) throws ClassNotFoundException {
        try {
            if (namingTable == null) {
                WebtopNaming.getNamingProfile(false);
            }
            String string2 = null;
            String string3 = "iplanet-am-naming-" + string.toLowerCase() + "-class";
            string2 = (String)namingTable.get(string3);
            if (string2 == null) {
                throw new Exception(NamingBundle.getString("noServiceClass") + string);
            }
            return string2;
        }
        catch (Exception exception) {
            throw new ClassNotFoundException(exception.getMessage());
        }
    }

    public static synchronized URL getNotificationURL() throws URLNotFoundException {
        try {
            String string = System.getProperty("com.iplanet.am.notification.url");
            if (string == null) {
                WebtopNaming.initProperties();
                string = platformProperties.getProperty("com.iplanet.am.notification.url");
            }
            if (string == null) {
                throw new URLNotFoundException(NamingBundle.getString("noNotificationURL"));
            }
            return new URL(string);
        }
        catch (Exception exception) {
            throw new URLNotFoundException(exception.getMessage());
        }
    }

    private static synchronized void getNamingProfile(boolean bl) throws Exception {
        if (bl || namingTable == null) {
            WebtopNaming.updateNamingTable();
        }
    }

    private static void updateNamingTable() throws Exception {
        Object object;
        Object object2;
        if (!WebtopNaming.isServerMode()) {
            if (namingServiceURL == null) {
                WebtopNaming.initializeNamingService();
            }
            object2 = new NamingRequest("1.0");
            object = new Request(((NamingRequest)object2).toXMLString());
            RequestSet requestSet = new RequestSet(NAMING_SERVICE);
            requestSet.addRequest((Request)object);
            Vector vector = null;
            namingTable = null;
            int n = 0;
            while (namingTable == null && n < namingServiceURL.length) {
                try {
                    vector = PLLClient.send(new URL(namingServiceURL[n]), requestSet);
                    if (vector.size() != 1) {
                        throw new Exception(NamingBundle.getString("unexpectedResponse"));
                    }
                    Response response = (Response)vector.elementAt(0);
                    NamingResponse namingResponse = NamingResponse.parseXML(response.getContent());
                    if (namingResponse.getException() != null) {
                        throw new Exception(namingResponse.getException());
                    }
                    namingTable = namingResponse.getNamingTable();
                }
                catch (SendRequestException sendRequestException) {
                    debug.error("Naming service connection failed for " + namingServiceURL[n], sendRequestException);
                    int n2 = n + 1;
                    if (n2 < namingServiceURL.length) {
                        debug.error("Try next naming service URL : " + namingServiceURL[n2]);
                    }
                }
                catch (Exception exception) {
                    debug.error("updateNamingTable: ", exception);
                }
                ++n;
            }
            if (namingTable == null) {
                debug.error("updateNamingTable : " + NamingBundle.getString("noNamingServiceAvailable"));
                throw new Exception(NamingBundle.getString("noNamingServiceAvailable"));
            }
        } else {
            namingTable = NamingService.getNamingTable();
        }
        if ((object2 = (String)namingTable.get(PLATFORM_LIST)) != null) {
            object = new StringTokenizer((String)object2, ",");
            platformServers.clear();
            while (((StringTokenizer)object).hasMoreTokens()) {
                platformServers.add(((StringTokenizer)object).nextToken().toLowerCase());
            }
        }
        WebtopNaming.updateServerIdMappings();
    }

    private static void updateServerIdMappings() {
        serverIdTable = new Hashtable();
        Enumeration enumeration = namingTable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)namingTable.get(string);
            if (string == null || string2 == null || string.equals(PLATFORM_LIST)) continue;
            serverIdTable.put(string2, string);
        }
    }

    private static void initProperties() {
        block2: {
            if (platformProperties != null) break block2;
            platformProperties = new Properties();
            try {
                platformProperties = SystemProperties.getPlatform();
            }
            catch (Exception exception) {}
        }
    }

    private static void validate(String string, String string2, String string3) throws URLNotFoundException {
        String string4 = (string + "://" + string2 + ":" + string3).toLowerCase();
        try {
            if (string.equalsIgnoreCase(server_proto) && string2.equalsIgnoreCase(server_host) && string3.equals(server_port)) {
                return;
            }
            if (debug.messageEnabled()) {
                debug.message("platformServers: " + platformServers);
            }
            if (!platformServers.contains(string4)) {
                WebtopNaming.getNamingProfile(true);
                if (!platformServers.contains(string4)) {
                    throw new URLNotFoundException(NamingBundle.getString("invalidServiceHost") + " " + string4);
                }
            }
        }
        catch (Exception exception) {
            debug.error("platformServers: " + platformServers, exception);
            throw new URLNotFoundException(exception.getMessage());
        }
    }

    public static synchronized String[] getNamingServiceURL() throws Exception {
        if (namingServiceURL == null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            String string = System.getProperty("com.iplanet.am.naming.url");
            if (string != null) {
                arrayList.add(string);
            }
            String string2 = platformProperties.getProperty("com.iplanet.am.naming.url");
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (arrayList.contains(string3)) {
                    if (!debug.warningEnabled()) continue;
                    debug.warning("Duplicate naming service URL specified " + string3 + ", will be ignored.");
                    continue;
                }
                arrayList.add(string3);
            }
            if (arrayList.size() == 0) {
                throw new Exception(NamingBundle.getString("noNamingServiceURL"));
            }
            if (debug.messageEnabled()) {
                debug.message("Naming service URL list: " + arrayList);
            }
            namingServiceURL = new String[arrayList.size()];
            System.arraycopy(arrayList.toArray(), 0, namingServiceURL, 0, arrayList.size());
        }
        return namingServiceURL;
    }

    static {
        String string = System.getProperty(SERVER_MODE);
        if (string == null) {
            string = SystemProperties.get(SERVER_MODE, "false");
        }
        serverMode = Boolean.valueOf(string);
    }
}

