/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.comm.share;

import com.iplanet.services.comm.share.Request;
import com.iplanet.services.comm.share.RequestSetParser;
import java.util.Vector;

public class RequestSet {
    private static final String sccsID = "$Id: RequestSet.java,v 1.14 2004/02/05 17:56:06 vs125812 Exp $ $Date: 2004/02/05 17:56:06 $  Sun Microsystems, Inc.";
    static final String QUOTE = "\"";
    static final String NL = "\n";
    static final String BEGIN_CDATA = "<![CDATA[";
    static final String END_CDATA = "]]>";
    private String requestSetVersion = null;
    private String serviceID = null;
    private String requestSetID = null;
    private Vector requestVector = new Vector();
    private static int requestCount = 0;

    public RequestSet(String string) {
        this.serviceID = string;
        this.requestSetVersion = "1.0";
        this.requestSetID = Integer.toString(requestCount++);
    }

    RequestSet() {
    }

    public static RequestSet parseXML(String string) {
        RequestSetParser requestSetParser = new RequestSetParser(string);
        return requestSetParser.parseXML();
    }

    public String getRequestSetVersion() {
        return this.requestSetVersion;
    }

    public String getServiceID() {
        return this.serviceID;
    }

    public String getRequestSetID() {
        return this.requestSetID;
    }

    public Vector getRequests() {
        return this.requestVector;
    }

    public void addRequest(Request request) {
        this.requestVector.addElement(request);
    }

    public String toXMLString() {
        StringBuffer stringBuffer = new StringBuffer(300);
        stringBuffer.append("<?xml version=").append(QUOTE).append("1.0").append(QUOTE).append(" encoding=").append(QUOTE).append("UTF-8").append(QUOTE).append(" standalone=").append(QUOTE).append("yes").append(QUOTE).append("?>").append(NL);
        stringBuffer.append("<RequestSet vers=").append(QUOTE).append(this.requestSetVersion).append(QUOTE).append(" svcid=").append(QUOTE).append(this.serviceID).append(QUOTE).append(" reqid=").append(QUOTE).append(this.requestSetID).append(QUOTE).append(">").append(NL);
        int n = this.requestVector.size();
        int n2 = 0;
        while (n2 < n) {
            Request request = (Request)this.requestVector.elementAt(n2);
            stringBuffer.append("<Request");
            if (request.getDtdID() != null) {
                stringBuffer.append(" dtdid=").append(QUOTE).append(request.getDtdID()).append(QUOTE);
            }
            if (request.getSessionID() != null) {
                stringBuffer.append(" sid=").append(QUOTE).append(request.getSessionID()).append(QUOTE);
            }
            stringBuffer.append(">");
            stringBuffer.append(BEGIN_CDATA).append(request.getContent()).append(END_CDATA);
            stringBuffer.append("</Request>").append(NL);
            ++n2;
        }
        stringBuffer.append("</RequestSet>");
        return stringBuffer.toString();
    }

    void setRequestSetVersion(String string) {
        this.requestSetVersion = string;
    }

    void setServiceID(String string) {
        this.serviceID = string;
    }

    void setRequestSetID(String string) {
        this.requestSetID = string;
    }
}

