/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.comm.https;

import com.iplanet.services.comm.https.JSSDebug;
import com.iplanet.services.comm.https.JSSThreadPool;
import com.iplanet.services.comm.https.ReaderWriter;
import com.iplanet.services.comm.https.ReaderWriterClear;
import com.iplanet.services.comm.https.ReaderWriterLock;
import java.net.Socket;

public class RWGroupJSSProxy
extends ReaderWriterLock {
    private Socket fromClient;
    private Socket toServer;
    private ReaderWriterClear src_to_dst;
    private ReaderWriterClear dst_to_src;
    private boolean src_to_dst_clean = false;
    private boolean dst_to_src_clean = false;

    public RWGroupJSSProxy(Socket socket, Socket socket2) {
        this.fromClient = socket;
        this.toServer = socket2;
        this.src_to_dst = new ReaderWriterClear(this, this.fromClient, this.toServer);
        this.dst_to_src = new ReaderWriterClear(this, this.toServer, this.fromClient);
        try {
            JSSThreadPool.run(this.src_to_dst);
            JSSThreadPool.run(this.dst_to_src);
        }
        catch (InterruptedException interruptedException) {
            JSSDebug.debug.message("Could not start ReaderWriterClear tasks", interruptedException);
        }
    }

    public synchronized void notifyFinished(ReaderWriter readerWriter) {
        if (readerWriter == this.src_to_dst) {
            if (this.dst_to_src.isAlive()) {
                this.dst_to_src.stop();
            }
        } else if (readerWriter == this.dst_to_src && this.src_to_dst.isAlive()) {
            this.src_to_dst.stop();
        }
        this.cleanup();
        if (readerWriter == this.src_to_dst) {
            this.src_to_dst_clean = true;
        } else if (readerWriter == this.dst_to_src) {
            this.dst_to_src_clean = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        if (this.fromClient != null) {
            try {
                try {
                    this.fromClient.close();
                }
                catch (Exception exception) {
                    Object var3_2 = null;
                    this.fromClient = null;
                }
                Object var3_1 = null;
                this.fromClient = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.fromClient = null;
                throw throwable;
            }
        }
        if (this.toServer != null) {
            try {
                try {
                    this.toServer.close();
                }
                catch (Exception exception) {
                    Object var5_8 = null;
                    this.toServer = null;
                }
                Object var5_7 = null;
                this.toServer = null;
            }
            catch (Throwable throwable) {
                Object var5_9 = null;
                this.toServer = null;
                throw throwable;
            }
        }
    }

    public boolean isDone() {
        if (this.dst_to_src_clean && this.src_to_dst_clean) {
            this.dst_to_src = null;
            this.src_to_dst = null;
        }
        return this.dst_to_src_clean && this.src_to_dst_clean;
    }
}

