/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.comm.https;

import com.iplanet.services.comm.https.ApprovalCallback;
import com.iplanet.services.comm.https.JSSDebug;
import com.iplanet.services.comm.https.JSSProxy;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.util.StringTokenizer;
import java.util.Vector;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.ssl.SSLCertificateApprovalCallback;
import org.mozilla.jss.ssl.SSLClientCertificateSelectionCallback;
import org.mozilla.jss.ssl.SSLSocket;
import sun.misc.RegexpPool;
import sun.net.www.http.HttpClient;
import sun.security.action.GetPropertyAction;

public final class HttpsClient
extends HttpClient
implements SSLClientCertificateSelectionCallback {
    private static String secureTunnelHost = null;
    private static int secureTunnelPort = 80;
    private static RegexpPool dontProxy = null;
    private static final int httpsPortNumber = 443;
    private String instTunnelHost;
    private int instTunnelPort;
    private SSLSocket sslSocket = null;
    private String nickName;

    protected int getDefaultPort() {
        return 443;
    }

    public static synchronized void resetSecureProperties() {
        block6: {
            String string = HttpsClient.getProperty("https.proxyHost");
            if (JSSDebug.debug.messageEnabled()) {
                JSSDebug.debug.message("HttpsClient: proxyHost = " + string);
            }
            if (string == null || "".equals(string)) {
                secureTunnelHost = null;
                secureTunnelPort = 80;
            } else {
                secureTunnelHost = string;
                secureTunnelPort = Integer.getInteger("https.proxyPort", 80);
            }
            dontProxy = new RegexpPool();
            String string2 = HttpsClient.getProperty("http.nonProxyHosts");
            JSSDebug.debug.message("HttpsClient: nonProxyHosts = " + string2);
            if (string2 == null) break block6;
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "|", false);
            try {
                while (stringTokenizer.hasMoreTokens()) {
                    dontProxy.add(stringTokenizer.nextToken().toLowerCase(), (Object)new Boolean(true));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public HttpsClient(URL uRL) throws IOException {
        super(uRL, true);
        if (JSSDebug.debug.messageEnabled()) {
            JSSDebug.debug.message("HttpsClient: HttpsClient " + uRL);
        }
    }

    public static HttpClient New(URL uRL) throws IOException {
        if (JSSDebug.debug.messageEnabled()) {
            JSSDebug.debug.message("HttpsClient: New " + uRL);
        }
        return new HttpsClient(uRL);
    }

    protected boolean isNonProxyHost() {
        if (dontProxy.match(this.url.getHost().toLowerCase()) != null) {
            return true;
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(this.url.getHost());
            String string = inetAddress.getHostAddress();
            if (dontProxy.match(string) != null) {
                return true;
            }
        }
        catch (UnknownHostException unknownHostException) {}
        return false;
    }

    protected Socket doConnect(String string, int n) throws IOException {
        String string2 = null;
        try {
            string2 = InetAddress.getByName(string).getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            if (JSSDebug.debug.messageEnabled()) {
                JSSDebug.debug.message("Error : HttpsClient.doConnect ", unknownHostException);
            }
            string2 = string;
        }
        if (secureTunnelHost == null || this.isNonProxyHost()) {
            if (JSSDebug.debug.messageEnabled()) {
                JSSDebug.debug.message("HttpsClient: doConnect(" + string2 + ", " + n + ")");
            }
            this.sslSocket = new SSLSocket(InetAddress.getByName(string2), n, null, 0, (SSLCertificateApprovalCallback)new ApprovalCallback(string2), (SSLClientCertificateSelectionCallback)this);
        } else {
            if (JSSDebug.debug.messageEnabled()) {
                JSSDebug.debug.message("HttpsClient: doConnect through proxy " + secureTunnelHost + ":" + secureTunnelPort);
            }
            if (JSSDebug.debug.messageEnabled()) {
                JSSDebug.debug.message("HttpsClient: doConnect(" + string2 + ", " + n + ")");
            }
            this.sslSocket = new SSLSocket(InetAddress.getByName("localhost"), JSSProxy.serverPort, null, 0, (SSLCertificateApprovalCallback)new ApprovalCallback(string2), (SSLClientCertificateSelectionCallback)this);
            Integer n2 = new Integer(this.sslSocket.getLocalPort());
            String string3 = secureTunnelHost + " " + secureTunnelPort + " " + string + " " + n;
            JSSProxy.connectHashMap.put(n2, string3);
        }
        return this.sslSocket;
    }

    public String getCipherSuite() {
        try {
            return this.sslSocket.getStatus().getCipher();
        }
        catch (Exception exception) {
            JSSDebug.debug.error("HttpsClient: Can't get cipher suite on the connection.");
            return null;
        }
    }

    public X509Certificate[] getServerCertificateChain() {
        return null;
    }

    private static String getProperty(String string) {
        SecurityException securityException = null;
        try {
            return System.getProperty(string);
        }
        catch (SecurityException securityException2) {
            securityException = securityException2;
            try {
                return AccessController.doPrivileged(new GetPropertyAction("prop"));
            }
            catch (LinkageError linkageError) {
                throw securityException;
            }
        }
    }

    public void setClientCertificate(String string) {
        this.nickName = string;
    }

    public String select(Vector vector) {
        if (vector == null || vector.isEmpty()) {
            JSSDebug.debug.message("nicknames vector is null");
            return null;
        }
        if (JSSDebug.debug.messageEnabled()) {
            JSSDebug.debug.message("all certs=" + vector.toString());
        }
        if (this.nickName == null) {
            JSSDebug.debug.message("no nickname is set");
            return (String)vector.get(0);
        }
        if (vector.contains(this.nickName)) {
            JSSDebug.debug.message("found nickname in vector");
            return this.nickName;
        }
        JSSDebug.debug.message("no matching nickname found");
        return null;
    }

    static {
        HttpsClient.resetSecureProperties();
    }
}

