/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.comm.client;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.comm.client.AlreadyRegisteredException;
import com.iplanet.services.comm.client.NotificationHandler;
import com.iplanet.services.comm.client.SendRequestException;
import com.iplanet.services.comm.share.PLLBundle;
import com.iplanet.services.comm.share.RequestSet;
import com.iplanet.services.comm.share.ResponseSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;

public class PLLClient {
    private static final String sccsID = "$Id: PLLClient.java,v 1.19 2004/02/05 17:56:01 vs125812 Exp $ $Date: 2004/02/05 17:56:01 $  Sun Microsystems, Inc.";
    private static Hashtable notificationHandlers = new Hashtable();

    public static Vector send(URL uRL, RequestSet requestSet) throws SendRequestException {
        return PLLClient.send(uRL, null, requestSet);
    }

    public static Vector send(URL uRL, String string, RequestSet requestSet) throws SendRequestException {
        HttpURLConnection httpURLConnection = null;
        OutputStream outputStream = null;
        try {
            int n;
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setRequestMethod("POST");
            if (string == null) {
                if (SystemProperties.iasGXId != null) {
                    httpURLConnection.setRequestProperty("Cookie", "GX_jst=" + SystemProperties.iasGXId);
                }
            } else {
                if (SystemProperties.iasGXId != null) {
                    string = string + "; GX_jst=" + SystemProperties.iasGXId;
                }
                httpURLConnection.setRequestProperty("Cookie", string);
            }
            httpURLConnection.setRequestProperty("Content-Type", "text/xml;charset=UTF-8");
            String string2 = requestSet.toXMLString();
            int n2 = string2.getBytes("UTF-8").length;
            httpURLConnection.setRequestProperty("Content-Length", Integer.toString(n2));
            outputStream = httpURLConnection.getOutputStream();
            outputStream.write(string2.getBytes("UTF-8"));
            outputStream.flush();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream(), "UTF-8"));
            StringBuffer stringBuffer = new StringBuffer();
            char[] cArray = new char[1024];
            while ((n = bufferedReader.read(cArray, 0, cArray.length)) != -1) {
                stringBuffer.append(cArray, 0, n);
            }
            String string3 = stringBuffer.toString();
            ResponseSet responseSet = ResponseSet.parseXML(string3);
            Vector vector = responseSet.getResponses();
            return vector;
        }
        catch (Exception exception) {
            throw new SendRequestException(exception.getMessage());
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {
                    throw new SendRequestException(iOException.getMessage());
                }
            }
        }
    }

    public static void addNotificationHandler(String string, NotificationHandler notificationHandler) throws AlreadyRegisteredException {
        if (notificationHandlers.containsKey(string)) {
            throw new AlreadyRegisteredException(PLLBundle.getString("alreadyRegistered") + string);
        }
        notificationHandlers.put(string, notificationHandler);
    }

    public static void removeNotificationHandler(String string) {
        notificationHandlers.remove(string);
    }

    public static NotificationHandler getNotificationHandler(String string) {
        return (NotificationHandler)notificationHandlers.get(string);
    }
}

