/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.log;

import com.iplanet.am.util.Debug;
import com.iplanet.dpro.session.Session;
import com.iplanet.dpro.session.SessionID;
import com.iplanet.log.LogException;
import com.iplanet.log.LogRecord;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.log.Logger;
import com.sun.identity.log.s1is.LogSSOTokenDetails;
import java.util.logging.Level;

public class LogManager {
    private static Debug debug = Debug.getInstance("amLog");
    private Session session;
    private String sidString;
    public SSOToken token;

    public LogManager(SSOToken sSOToken) {
        this.sidString = sSOToken.getTokenID().toString();
        SessionID sessionID = new SessionID(this.sidString);
        this.sidString = sessionID.toString();
    }

    public LogManager(Session session) {
        SessionID sessionID = session.getID();
        this.sidString = sessionID.toString();
    }

    public LogManager(SessionID sessionID) {
        this.sidString = sessionID.toString();
    }

    public void create(String string) throws LogException {
    }

    public void access(LogRecord logRecord, String string) throws LogException {
        logRecord.setLogType(0);
        this.write(logRecord, string);
    }

    public void error(LogRecord logRecord, String string) throws LogException {
        logRecord.setLogType(1);
        this.write(logRecord, string);
    }

    public void write(LogRecord logRecord, String string) throws LogException {
        try {
            int n = logRecord.getLogType();
            String string2 = n == 0 ? "access" : "error";
            String string3 = string + "." + string2;
            Logger logger = null;
            try {
                logger = (Logger)Logger.getLogger((String)string3);
            }
            catch (Throwable throwable) {
                debug.error("Throwable", throwable);
            }
            Level level = Level.INFO;
            com.sun.identity.log.LogRecord logRecord2 = new com.sun.identity.log.LogRecord(level, logRecord.getRecMsg());
            if (this.sidString != null) {
                logRecord2.addLogInfo("LoginIDSid", (Object)this.sidString);
            }
            SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
            SSOToken sSOToken = sSOTokenManager.createSSOToken(this.sidString);
            try {
                logRecord2 = LogSSOTokenDetails.logSSOTokenInfo((com.sun.identity.log.LogRecord)logRecord2, (SSOToken)sSOToken);
            }
            catch (Exception exception) {
                // empty catch block
            }
            logger.log((java.util.logging.LogRecord)logRecord2, (Object)sSOToken);
        }
        catch (Exception exception) {
            debug.error("Exception during oldLogManager.write() :", exception);
            throw new LogException("Error in write() method");
        }
    }
}

