/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.dpro.session.service;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.dpro.session.service.InternalSession;
import com.iplanet.dpro.session.service.JDBCConnectionFactory;
import com.iplanet.dpro.session.service.SessionService;
import com.iplanet.services.util.Crypt;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;

public class JDBCSessionRepository
implements Runnable {
    private static final String table = "sunwam_session";
    private static final String table_ext = "sunwam_session_ext";
    private static int BLOB_CHUNK_SIZE = 7800;
    private static final ConnConfig multiStmtConfig = new ConnConfig();
    private static long gracePeriod;
    private static final String CLEANUP_GRACE_PERIOD = "com.sun.identity.session.repository.cleanupGracePeriod";
    private static long period;
    public static final String CLEANUP_RUN_PERIOD = "com.sun.identity.session.repository.cleanupRunPeriod";
    private Thread checker;

    private Connection getConnection() throws Exception {
        return JDBCConnectionFactory.getConnection();
    }

    JDBCSessionRepository() throws Exception {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getConnection();
            resultSet = connection.getMetaData().getTables(null, null, table, new String[]{"TABLE"});
            boolean bl = resultSet.next();
            resultSet.close();
            resultSet = null;
            if (!bl) {
                statement = connection.createStatement();
                statement.executeUpdate("create table sunwam_session(id varchar(100) not null primary key,blob_chunk varbinary(" + BLOB_CHUNK_SIZE + ")," + "blob_size integer not null," + "expiration_time double integer not null," + "version integer not null default 1);");
                statement.executeUpdate("create index sunwam_session_exp_time on sunwam_session(expiration_time)");
                statement.executeUpdate("create table sunwam_session_ext(id varchar(100) not null,blob_chunk_seq integer not null,blob_chunk varbinary(" + BLOB_CHUNK_SIZE + ")," + "expiration_time double integer not null," + "primary key(id,blob_chunk_seq))");
                statement.executeUpdate("create index sunwam_session_ext_exp_time on sunwam_session_ext(expiration_time)");
                connection.commit();
            }
        }
        catch (Exception exception) {
            try {
                connection.rollback();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw exception;
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {}
        }
        this.checker = new Thread(this);
        this.checker.setName("JDBCSessionRepositoryCleaner");
        this.checker.setDaemon(true);
        this.checker.start();
    }

    private ConnConfig getConnectionConfig(Connection connection) throws Exception {
        if (connection == null) {
            return null;
        }
        ConnConfig connConfig = new ConnConfig();
        connConfig.autoCommit = connection.getAutoCommit();
        connConfig.isolation = connection.getTransactionIsolation();
        return connConfig;
    }

    private void setConnectionConfig(Connection connection, ConnConfig connConfig) throws Exception {
        if (connection == null || connConfig == null) {
            return;
        }
        connection.setAutoCommit(connConfig.autoCommit);
        connection.setTransactionIsolation(connConfig.isolation);
    }

    /*
     * Loose catch block
     */
    InternalSession retrieve(String string) throws Exception {
        ConnConfig connConfig;
        ResultSet resultSet;
        Statement statement;
        Connection connection;
        block41: {
            connection = null;
            statement = null;
            resultSet = null;
            connConfig = null;
            connection = this.getConnection();
            connConfig = this.getConnectionConfig(connection);
            this.setConnectionConfig(connection, multiStmtConfig);
            statement = connection.prepareStatement("select * from sunwam_session where id = ?");
            statement.setString(1, string);
            resultSet = statement.executeQuery();
            if (resultSet.next()) break block41;
            InternalSession internalSession = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.setConnectionConfig(connection, connConfig);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return internalSession;
        }
        byte[] byArray = resultSet.getBytes("blob_chunk");
        int n = resultSet.getInt("blob_size");
        long l = resultSet.getLong("version");
        byte[] byArray2 = byArray;
        if (n != 0 && n > byArray.length) {
            byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            this.retrieveBlobRemainder(connection, string, byArray2);
        }
        InternalSession internalSession = (InternalSession)JDBCSessionRepository.decode(byArray2);
        internalSession.setVersion(l);
        connection.commit();
        InternalSession internalSession2 = internalSession;
        try {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.setConnectionConfig(connection, connConfig);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return internalSession2;
        catch (Exception exception) {
            try {
                try {
                    connection.rollback();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                throw exception;
            }
            catch (Throwable throwable) {
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception3) {
                    // empty catch block
                }
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception exception4) {
                    // empty catch block
                }
                try {
                    this.setConnectionConfig(connection, connConfig);
                }
                catch (Exception exception5) {
                    // empty catch block
                }
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception6) {}
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void save(InternalSession internalSession) throws Exception {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        ConnConfig connConfig = null;
        try {
            connection = this.getConnection();
            connConfig = this.getConnectionConfig(connection);
            this.setConnectionConfig(connection, multiStmtConfig);
            InternalSession internalSession2 = internalSession;
            synchronized (internalSession2) {
                String string = internalSession.getID().toString();
                byte[] byArray = JDBCSessionRepository.encode(internalSession);
                long l = internalSession.getVersion();
                long l2 = internalSession.getExpirationTime() + gracePeriod;
                byte[] byArray2 = byArray;
                if (byArray.length > BLOB_CHUNK_SIZE) {
                    byArray2 = new byte[BLOB_CHUNK_SIZE];
                    System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
                }
                if (l == 0L) {
                    statement = connection.prepareStatement("insert into sunwam_session(id,blob_chunk,blob_size,expiration_time,version)  values(?,?,?,?,?)");
                    statement.setString(1, string);
                    statement.setBytes(2, byArray2);
                    statement.setInt(3, byArray.length);
                    statement.setLong(4, l2);
                    statement.setLong(5, l + 1L);
                    statement.executeUpdate();
                } else {
                    statement = connection.prepareStatement("update sunwam_session set blob_chunk = ?, blob_size = ? , expiration_time = ? , version = ?  where id = ? and version = ?");
                    statement.setBytes(1, byArray2);
                    statement.setInt(2, byArray.length);
                    statement.setLong(3, l2);
                    statement.setLong(4, l + 1L);
                    statement.setString(5, string);
                    statement.setLong(6, l);
                    int n = statement.executeUpdate();
                    if (n == 0) {
                        throw new IllegalArgumentException("Missing or stale session");
                    }
                }
                this.saveBlobRemainder(connection, string, byArray, l2);
                connection.commit();
                internalSession.setVersion(l + 1L);
            }
        }
        catch (Exception exception) {
            try {
                connection.rollback();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw exception;
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {}
            try {
                this.setConnectionConfig(connection, connConfig);
            }
            catch (Exception exception) {}
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    void delete(String string) throws Exception {
        Connection connection = null;
        Statement statement = null;
        Object var4_4 = null;
        ConnConfig connConfig = null;
        try {
            connConfig = this.getConnectionConfig(connection);
            this.setConnectionConfig(connection, multiStmtConfig);
            connection = this.getConnection();
            statement = connection.prepareStatement("delete from sunwam_session where id = ?");
            statement.setString(1, string);
            statement.executeUpdate();
            statement.close();
            statement = null;
            statement = connection.prepareStatement("delete from sunwam_session_ext where id = ?");
            statement.setString(1, string);
            statement.executeUpdate();
            connection.commit();
        }
        catch (Exception exception) {
            try {
                connection.rollback();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw exception;
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {}
            try {
                this.setConnectionConfig(connection, connConfig);
            }
            catch (Exception exception) {}
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    void deleteExpired() throws Exception {
        Connection connection = null;
        Statement statement = null;
        Object var3_3 = null;
        Object var4_4 = null;
        try {
            connection = this.getConnection();
            long l = System.currentTimeMillis() / 1000L;
            statement = connection.prepareStatement("delete from sunwam_session where expiration_time < ?");
            statement.setLong(1, l);
            statement.executeUpdate();
            statement.close();
            statement = null;
            statement = connection.prepareStatement("delete from sunwam_session_ext where expiration_time < ?");
            statement.setLong(1, l);
            statement.executeUpdate();
            connection.commit();
        }
        catch (Exception exception) {
            try {
                connection.rollback();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw exception;
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveBlobRemainder(Connection connection, String string, byte[] byArray, long l) throws Exception {
        Statement statement = null;
        try {
            int n = byArray.length - BLOB_CHUNK_SIZE;
            int n2 = 1;
            statement = connection.prepareStatement("delete from sunwam_session_ext where id = ?");
            statement.setString(1, string);
            statement.executeUpdate();
            statement.close();
            statement = null;
            if (n > 0) {
                byte[] byArray2 = new byte[BLOB_CHUNK_SIZE];
                statement = connection.prepareStatement("insert into sunwam_session_ext(id,blob_chunk,blob_chunk_seq,expiration_time)  values(?,?,?,?)");
                while (n > 0) {
                    int n3 = Math.min(n, BLOB_CHUNK_SIZE);
                    System.arraycopy(byArray, n2 * BLOB_CHUNK_SIZE, byArray2, 0, n3);
                    statement.setString(1, string);
                    statement.setBytes(2, byArray2);
                    statement.setInt(3, n2);
                    statement.setLong(4, l);
                    statement.executeUpdate();
                    ++n2;
                    n -= BLOB_CHUNK_SIZE;
                }
            }
            Object var12_10 = null;
        }
        catch (Throwable throwable) {
            Object var12_11 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (Exception exception) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void retrieveBlobRemainder(Connection connection, String string, byte[] byArray) throws Exception {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            int n = byArray.length - BLOB_CHUNK_SIZE;
            if (n <= 0) {
                return;
            }
            statement = connection.prepareStatement("select blob_chunk, blob_chunk_seq from sunwam_session_ext where id = ?");
            statement.setString(1, string);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                byte[] byArray2 = resultSet.getBytes("blob_chunk");
                int n2 = resultSet.getInt("blob_chunk_seq");
                if (byArray2.length == 0 || byArray2.length > BLOB_CHUNK_SIZE || n2 < 1 || n2 * BLOB_CHUNK_SIZE > byArray.length) {
                    throw new IllegalArgumentException("Invalid chunk");
                }
                int n3 = Math.min(byArray2.length, byArray.length - n2 * BLOB_CHUNK_SIZE);
                System.arraycopy(byArray2, 0, byArray, n2 * BLOB_CHUNK_SIZE, n3);
                n -= n3;
            }
            if (n != 0) {
                throw new IllegalArgumentException("Missing chunks");
            }
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    long l = System.currentTimeMillis() + period;
                    if (SessionService.sessionDebug.messageEnabled()) {
                        SessionService.sessionDebug.message("Cleaning expired session records");
                    }
                    this.deleteExpired();
                    long l2 = l - System.currentTimeMillis();
                    if (l2 <= 0L) continue;
                    Thread.sleep(l2);
                }
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    private static byte[] encode(Object object) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(object);
        objectOutputStream.close();
        final byte[] byArray = byteArrayOutputStream.toByteArray();
        return (byte[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                return Crypt.getEncryptor().encrypt(byArray);
            }
        });
    }

    private static Object decode(final byte[] byArray) throws Exception {
        byte[] byArray2 = (byte[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                return Crypt.getEncryptor().decrypt(byArray);
            }
        });
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        return objectInputStream.readObject();
    }

    static {
        JDBCSessionRepository.multiStmtConfig.autoCommit = false;
        JDBCSessionRepository.multiStmtConfig.isolation = 4;
        gracePeriod = 300L;
        try {
            gracePeriod = Integer.parseInt(SystemProperties.get(CLEANUP_GRACE_PERIOD, String.valueOf(gracePeriod)));
        }
        catch (Exception exception) {
            SessionService.sessionDebug.error("Invalid value for com.sun.identity.session.repository.cleanupGracePeriod, using default");
        }
        period = 60000L;
        try {
            period = Integer.parseInt(SystemProperties.get(CLEANUP_RUN_PERIOD, String.valueOf(period)));
        }
        catch (Exception exception) {
            SessionService.sessionDebug.error("Invalid value for com.sun.identity.session.repository.cleanupRunPeriod, using default");
        }
    }

    private static class ConnConfig {
        boolean autoCommit;
        int isolation;

        private ConnConfig() {
        }
    }
}

