/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.dpro.session.service;

import com.iplanet.dpro.session.SessionID;
import com.iplanet.dpro.session.TokenRestriction;
import com.iplanet.dpro.session.TokenRestrictionFactory;
import com.iplanet.dpro.session.service.InternalSession;
import com.iplanet.dpro.session.service.SessionService;
import com.iplanet.services.naming.WebtopNaming;
import com.iplanet.services.util.CookieUtils;
import com.sun.identity.security.DecodeAction;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public final class GetHttpSession
extends HttpServlet {
    public static final String OP = "op";
    public static final String NO_OP = "";
    public static final String CREATE_OP = "create";
    public static final String RECOVER_OP = "recover";
    public static final String SAVE_OP = "save";
    public static final String INVALIDATE_OP = "invalidate";
    public static final String RELEASE_OP = "release";
    public static final String GET_RESTRICTED_TOKEN_OP = "get_restricted_token";
    public static final String DOMAIN = "domain";
    private static final long MAX_TIMESTAMP_DIFF = 600000L;

    private boolean validateRequest(HttpServletRequest httpServletRequest) {
        try {
            String string = CookieUtils.getCookieValueFromReq(httpServletRequest, "DSAMESecurityCookie");
            if (string == null) {
                SessionService.sessionDebug.error("GetHttpSession.validateRequest: no Security Cookie in the request");
                return false;
            }
            String string2 = (String)AccessController.doPrivileged(new DecodeAction(string));
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "@");
            String string3 = stringTokenizer.nextToken();
            long l = Long.parseLong(stringTokenizer.nextToken());
            long l2 = System.currentTimeMillis();
            if (Math.abs(l2 - l) > 600000L) {
                SessionService.sessionDebug.error("GetHttpSession.validateRequest: Max time elapsed for the Request");
                return false;
            }
            Vector vector = WebtopNaming.getPlatformServerList();
            if (!vector.contains(string3)) {
                SessionService.sessionDebug.error("GetHttpSession.validateRequest: request host :" + string3 + "was not part of the platformServerList");
            }
            return true;
        }
        catch (Exception exception) {
            SessionService.sessionDebug.error("GetHttpSession.validateRequest: Exception while validating the request ", exception);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        if (!this.validateRequest(httpServletRequest)) {
            httpServletResponse.setStatus(403);
            return;
        }
        String string = httpServletRequest.getParameter(OP);
        if (string.equals(RECOVER_OP)) {
            SessionID sessionID;
            HttpSession httpSession = httpServletRequest.getSession(false);
            if (httpSession == null) {
                SessionService.sessionDebug.error("GetHttpSession.recover: Old  HttpSession is not obtained");
                return;
            }
            if (SessionService.sessionDebug.messageEnabled()) {
                SessionService.sessionDebug.message("GetHttpSession.recover: Old HttpSession is obtained");
            }
            if ((sessionID = new SessionID(httpServletRequest)).isNull()) return;
            SessionService.getSessionService().retrieveSession(sessionID, httpSession);
            return;
        }
        if (string.equals(SAVE_OP)) {
            SessionID sessionID;
            HttpSession httpSession = httpServletRequest.getSession(false);
            if (httpSession == null) {
                SessionService.sessionDebug.error("GetHttpSession.save: HttpSession is not obtained");
                httpServletResponse.setStatus(404);
                return;
            }
            if (SessionService.sessionDebug.messageEnabled()) {
                SessionService.sessionDebug.message("GetHttpSession.save: HttpSession is obtained");
            }
            if ((sessionID = new SessionID(httpServletRequest)).isNull()) return;
            int n = SessionService.getSessionService().handleSaveSession(sessionID, httpSession);
            httpServletResponse.setStatus(n);
            return;
        }
        if (string.equals(CREATE_OP)) {
            HttpSession httpSession = httpServletRequest.getSession(true);
            String string2 = httpServletRequest.getParameter(DOMAIN);
            InternalSession internalSession = SessionService.getSessionService().newInternalSession(string2, httpSession);
            if (SessionService.sessionDebug.messageEnabled()) {
                SessionService.sessionDebug.message("GetHttpSession.create: Created new session=" + internalSession.getID());
            }
            DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)httpServletResponse.getOutputStream());
            dataOutputStream.writeUTF(internalSession.getID().toString());
            dataOutputStream.flush();
            dataOutputStream.close();
            return;
        }
        if (string.equals(INVALIDATE_OP)) {
            HttpSession httpSession = httpServletRequest.getSession(false);
            if (httpSession == null) {
                if (!SessionService.sessionDebug.warningEnabled()) return;
                SessionService.sessionDebug.warning("GetHttpSession.invalidate: session is not obtained");
                return;
            }
            if (SessionService.sessionDebug.messageEnabled()) {
                SessionService.sessionDebug.message("GetHttpSession.invalidate: HttpSession is obtained");
            }
            try {
                httpSession.invalidate();
                return;
            }
            catch (IllegalStateException illegalStateException) {
                if (!SessionService.sessionDebug.messageEnabled()) return;
                SessionService.sessionDebug.message("Exception:invalidateSession: the web containers session timeout could be shorter than the IS session timeout", illegalStateException);
                return;
            }
        }
        if (string.equals(RELEASE_OP)) {
            SessionID sessionID = new SessionID(httpServletRequest);
            if (sessionID.isNull()) {
                if (!SessionService.sessionDebug.messageEnabled()) return;
                SessionService.sessionDebug.message("GetHttpSession.release: missing session id");
                return;
            }
            if (SessionService.sessionDebug.messageEnabled()) {
                SessionService.sessionDebug.message("GetHttpSession.release: releasing session=" + sessionID);
            }
            int n = SessionService.getSessionService().handleReleaseSession(sessionID);
            httpServletResponse.setStatus(n);
            return;
        }
        if (!string.equals(GET_RESTRICTED_TOKEN_OP)) {
            SessionService.sessionDebug.error("GetHttpSession: unknown operation requested");
            httpServletResponse.setStatus(501);
            return;
        }
        DataInputStream dataInputStream = null;
        DataOutputStream dataOutputStream = null;
        SessionID sessionID = new SessionID(httpServletRequest);
        try {
            try {
                dataInputStream = new DataInputStream((InputStream)httpServletRequest.getInputStream());
                TokenRestriction tokenRestriction = TokenRestrictionFactory.unmarshal(dataInputStream.readUTF());
                String string3 = SessionService.getSessionService().handleGetRestrictedTokenIdRemotely(sessionID, tokenRestriction);
                if (string3 != null) {
                    if (SessionService.sessionDebug.messageEnabled()) {
                        SessionService.sessionDebug.message("GetHttpSession.get_restricted_token: Created new session=" + string3);
                    }
                    httpServletResponse.setStatus(200);
                    dataOutputStream = new DataOutputStream((OutputStream)httpServletResponse.getOutputStream());
                    dataOutputStream.writeUTF(string3);
                    dataOutputStream.flush();
                }
                SessionService.sessionDebug.error("GetHttpSession.get_restricted_token: failed to create token");
                httpServletResponse.setStatus(404);
            }
            catch (Exception exception) {
                SessionService.sessionDebug.error("GetHttpSession.get_restricted_token: exception occured while create token", exception);
                httpServletResponse.setStatus(404);
                Object var10_24 = null;
                SessionService.closeStream(dataInputStream);
                SessionService.closeStream(dataOutputStream);
                return;
            }
            Object var10_23 = null;
        }
        catch (Throwable throwable) {
            Object var10_25 = null;
            SessionService.closeStream(dataInputStream);
            SessionService.closeStream(dataOutputStream);
            throw throwable;
        }
        SessionService.closeStream(dataInputStream);
        SessionService.closeStream(dataOutputStream);
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        this.doGet(httpServletRequest, httpServletResponse);
    }
}

