/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.dpro.session;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.dpro.session.Session;
import com.iplanet.dpro.session.SessionEvent;
import com.iplanet.dpro.session.SessionException;
import com.iplanet.dpro.session.SessionID;
import com.iplanet.dpro.session.SessionListener;
import com.iplanet.dpro.session.service.SessionService;
import com.iplanet.dpro.session.share.SessionInfo;
import com.iplanet.dpro.session.share.SessionRequest;
import com.iplanet.dpro.session.share.SessionResponse;
import com.sun.identity.session.util.RestrictedTokenAction;
import com.sun.identity.session.util.RestrictedTokenContext;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SessionPoller
extends Thread {
    Hashtable sessionTable;
    Hashtable destroyedTable;
    private SessionService sessionService = null;
    public static Debug debug;
    static long period;

    public SessionPoller(Hashtable hashtable, Hashtable hashtable2) {
        this.sessionTable = hashtable;
        this.destroyedTable = hashtable2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Enumeration enumeration = this.sessionTable.elements();
        while (true) {
            long l = System.currentTimeMillis() + period;
            try {
                while (enumeration.hasMoreElements()) {
                    final Session session = (Session)enumeration.nextElement();
                    SessionID sessionID = session.getID();
                    Object var6_8 = null;
                    try {
                        if (session.getTimeLeftBeforePurge() != 0L) {
                            continue;
                        }
                    }
                    catch (SessionException sessionException) {
                        this.removeSID(sessionID);
                        debug.error("session is not in timeout state so clean it", sessionException);
                    }
                    RestrictedTokenContext.doUsing(session.getContext(), new RestrictedTokenAction(){

                        public Object run() throws Exception {
                            return SessionPoller.this.doPoll(session);
                        }
                    });
                }
            }
            catch (Exception exception) {
                debug.error("Exception encountered while polling", exception);
            }
            enumeration = this.sessionTable.elements();
            try {
                long l2 = l - System.currentTimeMillis();
                if (l2 <= 0L) continue;
                Thread.sleep(l2);
            }
            catch (Exception exception) {
            }
        }
    }

    private SessionInfo doPoll(Session session) {
        SessionID sessionID;
        SessionInfo sessionInfo;
        block12: {
            sessionInfo = null;
            sessionID = session.getID();
            if (session.isLocal()) {
                try {
                    this.sessionService = SessionService.getSessionService();
                    sessionInfo = this.sessionService.getSessionInfo(sessionID, false);
                }
                catch (SessionException sessionException) {
                    this.removeSID(sessionID);
                    if (debug.messageEnabled()) {
                        debug.message("Removed SID:" + sessionID);
                    }
                    return null;
                }
            }
            try {
                SessionRequest sessionRequest = new SessionRequest(0, sessionID.toString(), false);
                SessionResponse sessionResponse = Session.sendPLLRequest(session.getSessionServiceURL(), sessionRequest);
                if (sessionResponse.getException() != null) {
                    this.removeSID(sessionID);
                    return null;
                }
                Vector vector = sessionResponse.getSessionInfoVector();
                sessionInfo = (SessionInfo)vector.elementAt(0);
            }
            catch (Exception exception) {
                this.removeSID(sessionID);
                if (!debug.messageEnabled()) break block12;
                debug.message("Could not connect to the session server" + exception.getMessage());
            }
        }
        if (sessionInfo != null) {
            if (debug.messageEnabled()) {
                debug.message("Updating" + sessionInfo.toXMLString());
            }
            try {
                session.update(sessionInfo);
            }
            catch (SessionException sessionException) {
                this.removeSID(sessionID);
                debug.error("Exception encountered while update in polling", sessionException);
            }
        } else {
            this.removeSID(sessionID);
        }
        return sessionInfo;
    }

    private void removeSID(SessionID sessionID) {
        Session session = null;
        session = (Session)this.sessionTable.remove(sessionID);
        this.destroyedTable.remove(sessionID);
        if (session != null) {
            long l = System.currentTimeMillis();
            SessionEvent sessionEvent = new SessionEvent(session, 5, l);
            this.invokeListeners(sessionEvent);
        }
    }

    private void invokeListeners(SessionEvent sessionEvent) {
        Session session = sessionEvent.getSession();
        Vector vector = session.getSessionEventListeners();
        Vector vector2 = Session.getAllSessionEventListeners();
        int n = 0;
        while (n < vector.size()) {
            SessionListener sessionListener = (SessionListener)vector.elementAt(n);
            sessionListener.sessionChanged(sessionEvent);
            ++n;
        }
        int n2 = 0;
        while (n2 < vector2.size()) {
            SessionListener sessionListener = (SessionListener)vector2.elementAt(n2);
            sessionListener.sessionChanged(sessionEvent);
            ++n2;
        }
    }

    static {
        block2: {
            debug = null;
            period = 180000L;
            debug = Debug.getInstance("amSession");
            String string = SystemProperties.get("com.iplanet.am.session.client.polling.period");
            try {
                period = Long.parseLong(string);
                period *= 1000L;
            }
            catch (Exception exception) {
                if (!debug.messageEnabled()) break block2;
                debug.message("Can not get the polling time");
            }
        }
    }
}

