/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.dpro.session;

import com.iplanet.dpro.session.Session;
import com.iplanet.dpro.session.SessionEvent;
import com.iplanet.dpro.session.SessionID;
import com.iplanet.dpro.session.SessionListener;
import com.iplanet.dpro.session.service.SessionService;
import com.iplanet.dpro.session.share.SessionInfo;
import com.iplanet.dpro.session.share.SessionNotification;
import com.iplanet.services.comm.client.NotificationHandler;
import com.iplanet.services.comm.share.Notification;
import java.util.Hashtable;
import java.util.Vector;

public class SessionNotificationHandler
implements NotificationHandler {
    private static final String sccsID = "@(#)SessionNotificationHandler.java   1.8  00/03/29 03/29/00  Sun Microsystems, Inc.";
    private Hashtable sessionTable;
    private Hashtable destroyedSessionTable;
    public static SessionNotificationHandler handler = null;

    public SessionNotificationHandler(Hashtable hashtable, Hashtable hashtable2) {
        this.sessionTable = hashtable;
        this.destroyedSessionTable = hashtable2;
    }

    public void process(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            Notification notification = (Notification)vector.elementAt(n);
            SessionNotification sessionNotification = SessionNotification.parseXML(notification.getContent());
            if (sessionNotification != null) {
                this.processNotification(sessionNotification);
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processNotification(SessionNotification sessionNotification) {
        SessionInfo sessionInfo = sessionNotification.getSessionInfo();
        SessionService.sessionDebug.message("SESSION NOTIFICATION : " + sessionInfo.toXMLString());
        SessionID sessionID = new SessionID(sessionInfo.sid);
        Session session = null;
        Hashtable hashtable = this.sessionTable;
        synchronized (hashtable) {
            session = (Session)this.sessionTable.get(sessionID);
            if (session != null && !sessionInfo.state.equals("valid")) {
                this.sessionTable.remove(sessionID);
            }
            if (session == null) {
                session = (Session)this.destroyedSessionTable.remove(sessionID);
            }
        }
        try {
            if (session == null) {
                if (Session.getAllSessionEventListeners().size() == 0) {
                    return;
                }
                session = new Session(sessionID);
            }
            session.update(sessionInfo);
        }
        catch (Exception exception) {
            SessionService.sessionDebug.error("SessionNotificationHandler:processNotification : ", exception);
            this.sessionTable.remove(sessionID);
            return;
        }
        SessionEvent sessionEvent = new SessionEvent(session, sessionNotification.getNotificationType(), sessionNotification.getNotificationTime());
        this.invokeSessionListeners(sessionEvent);
    }

    private void invokeSessionListeners(SessionEvent sessionEvent) {
        Session session = sessionEvent.getSession();
        Vector vector = session.getSessionEventListeners();
        Vector vector2 = Session.getAllSessionEventListeners();
        int n = 0;
        while (n < vector.size()) {
            SessionListener sessionListener = (SessionListener)vector.elementAt(n);
            sessionListener.sessionChanged(sessionEvent);
            ++n;
        }
        int n2 = 0;
        while (n2 < vector2.size()) {
            SessionListener sessionListener = (SessionListener)vector2.elementAt(n2);
            sessionListener.sessionChanged(sessionEvent);
            ++n2;
        }
    }
}

