/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.dpro.session;

import com.iplanet.am.util.Misc;
import com.iplanet.dpro.session.TokenRestriction;
import com.iplanet.dpro.session.service.SessionService;
import com.iplanet.sso.SSOToken;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DNOrIPAddressListTokenRestriction
implements TokenRestriction {
    private String dn;
    private Set addressList = new HashSet();
    private String asString;
    private static Comparator addressComparator = new Comparator(){

        public int compare(Object object, Object object2) {
            return ((InetAddress)object).getHostAddress().compareTo(((InetAddress)object2).getHostAddress());
        }
    };

    public DNOrIPAddressListTokenRestriction(String string, List list) throws Exception {
        this.dn = Misc.canonicalize(string);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.addressList.add(InetAddress.getByName((String)iterator.next()));
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string).append("\n");
        Object[] objectArray = this.addressList.toArray();
        Arrays.sort(objectArray, addressComparator);
        int n = 0;
        while (n < objectArray.length) {
            stringBuffer.append(((InetAddress)objectArray[n]).getHostAddress());
            stringBuffer.append("\n");
            ++n;
        }
        this.asString = stringBuffer.toString();
    }

    public String toString() {
        return this.asString;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean isSatisfied(Object object) throws Exception {
        if (object == null) {
            return false;
        }
        if (object instanceof SSOToken) {
            SSOToken sSOToken = (SSOToken)object;
            return Misc.canonicalize(sSOToken.getPrincipal().getName()).equals(this.dn);
        }
        if (object instanceof InetAddress) {
            return this.addressList.contains(object);
        }
        if (SessionService.sessionDebug.warningEnabled()) {
            SessionService.sessionDebug.warning("Unknown context type:" + object);
        }
        return false;
    }

    public boolean equals(Object object) {
        return object != null && object instanceof DNOrIPAddressListTokenRestriction && object.toString().equals(this.toString());
    }
}

