/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.util;

import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMTemplate;
import com.iplanet.am.util.Debug;
import com.iplanet.services.ldap.DSConfigMgr;
import com.iplanet.services.ldap.LDAPUser;
import com.iplanet.services.ldap.ServerInstance;
import com.iplanet.sso.SSOToken;
import com.iplanet.ums.DataLayer;
import com.iplanet.ums.SearchTemplate;
import com.iplanet.ums.TemplateManager;
import com.sun.identity.policy.Policy;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.policy.ResourceManager;
import com.sun.identity.policy.Rule;
import com.sun.identity.sm.ServiceManager;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.Principal;
import java.util.Iterator;
import java.util.Set;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPDN;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchResults;

public class ServiceUtil {
    private static SSOToken ssoToken;
    private static String baseDN;
    private static Principal connPrincipal;
    private static DataLayer dlayer;
    private static Debug debug;

    public ServiceUtil(SSOToken sSOToken, Debug debug) {
        block5: {
            ssoToken = sSOToken;
            ServiceUtil.debug = debug;
            try {
                ServerInstance serverInstance = null;
                DSConfigMgr dSConfigMgr = DSConfigMgr.getDSConfigMgr();
                if (dSConfigMgr != null) {
                    serverInstance = dSConfigMgr.getServerInstance(LDAPUser.Type.AUTH_ADMIN);
                }
                if (serverInstance != null) {
                    dlayer = DataLayer.getInstance((ServerInstance)serverInstance);
                    baseDN = serverInstance.getBaseDN();
                }
                connPrincipal = ssoToken.getPrincipal();
                if (dlayer == null || baseDN == null || connPrincipal == null) {
                    ServiceUtil.debug.error("Service Util init failed");
                }
                ServiceUtil.debug.message("ServiceUtil init successfull");
            }
            catch (Exception exception) {
                if (ServiceUtil.debug == null) break block5;
                ServiceUtil.debug.error("Service Util init failed", exception);
            }
        }
    }

    public boolean deleteService(String string, boolean bl, String string2) {
        ServiceManager serviceManager = null;
        ServiceSchemaManager serviceSchemaManager = null;
        try {
            Object object;
            ServiceSchema serviceSchema;
            serviceManager = new ServiceManager(ssoToken);
            serviceSchemaManager = serviceManager.getSchemaManager(string, string2);
            if (serviceSchemaManager.getOrganizationSchema() != null) {
                debug.message("Processing Organization Schema");
                this.deleteOrgConfig(string);
            }
            if (serviceSchemaManager.getUserSchema() != null) {
                debug.message("Processing User Schema");
                if (bl && (serviceSchema = serviceSchemaManager.getUserSchema()) != null) {
                    object = serviceSchema.getAttributeSchemaNames();
                    this.deleteUserServiceAttributes((Set)object, string);
                }
            }
            if (serviceSchemaManager.getDynamicSchema() != null) {
                debug.message("Processing Dyanmic Schema");
                this.deleteCos(string);
                if (bl && (serviceSchema = serviceSchemaManager.getGlobalSchema()) != null) {
                    object = serviceSchema.getAttributeDefaults();
                    Set set = (Set)object.get("serviceObjectClasses");
                    if (set.size() > 0) {
                        Iterator iterator = set.iterator();
                        String string3 = iterator.next().toString();
                        this.deleteUserObjectClass(string3, string);
                    } else {
                        debug.error("ERROR deleting  user objectclass");
                    }
                }
            }
            if (serviceSchemaManager.getPolicySchema() != null) {
                debug.message("Processing Policy Schema");
                this.deletePolicies(string);
            }
            this.deleteOrgServiceStatus(string);
            return true;
        }
        catch (Exception exception) {
            debug.error("ERROR : while deleting service " + string, exception);
            return false;
        }
    }

    private void deleteCos(String string) {
        String string2 = "&(objectclass=cosclassicdefinition)(objectclass=ldapsubentry)(cn=" + string + ")";
        try {
            LDAPSearchResults lDAPSearchResults = this.searchResults(baseDN, string2, 2, null);
            while (lDAPSearchResults.hasMoreElements()) {
                LDAPEntry lDAPEntry = lDAPSearchResults.next();
                String string3 = lDAPEntry.getDN().toString();
                LDAPSearchResults lDAPSearchResults2 = this.searchResults(string3, "(objectclass=costemplate)", 2, null);
                while (lDAPSearchResults2.hasMoreElements()) {
                    LDAPEntry lDAPEntry2 = lDAPSearchResults2.next();
                    String string4 = lDAPEntry2.getDN();
                    this.delete(string4);
                }
                this.delete(string3);
            }
        }
        catch (Exception exception) {
            debug.error("ERROR : while deleting Cos for service " + string, exception);
        }
    }

    private void deletePolicies(String string) {
        String string2 = this.getObjectSearchFilter(2);
        if (string2 == null) {
            debug.error("searchfilter is null for AMObject.ORGANIZATION");
        }
        try {
            LDAPSearchResults lDAPSearchResults = this.searchResults(baseDN, string2, 2, null);
            PolicyManager policyManager = null;
            while (lDAPSearchResults.hasMoreElements()) {
                String string3;
                Iterator iterator;
                Set set;
                LDAPEntry lDAPEntry = lDAPSearchResults.next();
                String string4 = lDAPEntry.getDN().toString();
                policyManager = new PolicyManager(ssoToken, string4);
                ResourceManager resourceManager = policyManager.getResourceManager();
                if (resourceManager.getManagedResourceNames().size() > 0 || LDAPDN.equals((String)string4, (String)baseDN)) {
                    set = policyManager.getPolicyNames();
                    iterator = set.iterator();
                    while (iterator.hasNext()) {
                        string3 = iterator.next().toString();
                        Policy policy = policyManager.getPolicy(string3);
                        Set set2 = policy.getRuleNames();
                        Iterator iterator2 = set2.iterator();
                        while (iterator2.hasNext()) {
                            Rule rule;
                            String string5 = iterator2.next().toString();
                            Rule rule2 = policy.getRule(string5);
                            String string6 = rule2.getServiceTypeName();
                            if (!string6.equalsIgnoreCase(string) || (rule = policy.removeRule(string5)) == null) continue;
                            policyManager.replacePolicy(policy);
                        }
                    }
                    continue;
                }
                set = policyManager.getPolicyNames();
                iterator = set.iterator();
                while (iterator.hasNext()) {
                    string3 = iterator.next().toString();
                    policyManager.removePolicy(string3);
                }
            }
        }
        catch (Exception exception) {
            debug.error("ERROR : while deleting policys for service " + string, exception);
        }
    }

    private void deleteUserObjectClass(String string, String string2) {
        String string3 = this.getObjectSearchFilter(1);
        String string4 = "&(" + string3 + ")" + "(objectclass=" + string + ")";
        try {
            LDAPSearchResults lDAPSearchResults = this.searchResults(baseDN, string4, 2, null);
            while (lDAPSearchResults.hasMoreElements()) {
                LDAPEntry lDAPEntry = lDAPSearchResults.next();
                LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
                LDAPAttribute lDAPAttribute = new LDAPAttribute("objectclass", string);
                lDAPModificationSet.add(1, lDAPAttribute);
                String string5 = lDAPEntry.getDN();
                try {
                    this.modify(string5, lDAPModificationSet);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            debug.error("ERROR : while deleting UserObjectClass for service " + string2, exception);
        }
    }

    private void deleteOrgServiceStatus(String string) {
        String string2 = this.getObjectSearchFilter(2);
        if (string2 == null) {
            debug.error("searchfilter is null for AMObject.ORGANIZATION");
        }
        String string3 = "&(" + string2 + ")" + "(iplanet-am-service-status=" + string + ")";
        try {
            LDAPSearchResults lDAPSearchResults = this.searchResults(baseDN, string3, 2, null);
            while (lDAPSearchResults.hasMoreElements()) {
                LDAPEntry lDAPEntry = lDAPSearchResults.next();
                String string4 = lDAPEntry.getDN().toString();
                LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
                LDAPAttribute lDAPAttribute = new LDAPAttribute("iplanet-am-service-status", string);
                lDAPModificationSet.add(1, lDAPAttribute);
                this.modify(string4, lDAPModificationSet);
            }
        }
        catch (Exception exception) {
            debug.error("ERROR : while deleting OrgServiceStatus for service " + string, exception);
        }
    }

    private void deleteOrgConfig(String string) {
        String string2 = this.getObjectSearchFilter(2);
        if (string2 == null) {
            debug.error("searchfilter is null for AMObject.ORGANIZATION");
        }
        String string3 = "&(" + string2 + ")" + "(iplanet-am-service-status=" + string + ")";
        try {
            LDAPSearchResults lDAPSearchResults = this.searchResults(baseDN, string3, 2, null);
            AMStoreConnection aMStoreConnection = new AMStoreConnection(ssoToken);
            while (lDAPSearchResults.hasMoreElements()) {
                LDAPEntry lDAPEntry = lDAPSearchResults.next();
                String string4 = lDAPEntry.getDN().toString();
                AMOrganization aMOrganization = aMStoreConnection.getOrganization(string4);
                AMTemplate aMTemplate = aMOrganization.getTemplate(string, 302);
                aMTemplate.delete();
            }
        }
        catch (Exception exception) {
            debug.error("ERROR : while deleting OrgConfig for service " + string, exception);
        }
    }

    private void deleteUserServiceAttributes(Set set, String string) {
        String string2 = this.getObjectSearchFilter(1);
        try {
            LDAPSearchResults lDAPSearchResults = this.searchResults(baseDN, string2, 2, null);
            while (lDAPSearchResults.hasMoreElements()) {
                String string3;
                LDAPEntry lDAPEntry = lDAPSearchResults.next();
                Iterator iterator = set.iterator();
                LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
                while (iterator.hasNext()) {
                    string3 = iterator.next().toString();
                    LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(string3);
                    if (lDAPAttribute == null) continue;
                    lDAPModificationSet.add(1, lDAPAttribute);
                }
                string3 = lDAPEntry.getDN();
                if (lDAPModificationSet.size() <= 0) continue;
                this.modify(string3, lDAPModificationSet);
            }
        }
        catch (Exception exception) {
            debug.error("ERROR: while deleting UserAttributes for service " + string, exception);
        }
    }

    private LDAPConnection getConnection() throws Exception {
        try {
            LDAPConnection lDAPConnection = dlayer.getConnection(connPrincipal);
            if (lDAPConnection == null) {
                throw new Exception("ERROR: Unable to connect to server!");
            }
            return lDAPConnection;
        }
        catch (Exception exception) {
            throw new Exception(exception.toString());
        }
    }

    private LDAPSearchResults searchResults(String string, String string2, int n, String[] stringArray) throws Exception {
        LDAPSearchResults lDAPSearchResults;
        LDAPConnection lDAPConnection = this.getConnection();
        LDAPSearchConstraints lDAPSearchConstraints = lDAPConnection.getSearchConstraints();
        try {
            lDAPSearchResults = lDAPConnection.search(string, n, string2, stringArray, false, lDAPSearchConstraints);
            Object var9_9 = null;
        }
        catch (Exception exception) {
            try {
                throw new Exception(exception.toString());
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                dlayer.releaseConnection(lDAPConnection);
                throw throwable;
            }
        }
        dlayer.releaseConnection(lDAPConnection);
        return lDAPSearchResults;
    }

    private void modify(String string, LDAPModificationSet lDAPModificationSet) throws Exception {
        LDAPConnection lDAPConnection = this.getConnection();
        try {
            try {
                lDAPConnection.modify(string, lDAPModificationSet);
            }
            catch (Exception exception) {
                throw new Exception(exception.toString());
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            dlayer.releaseConnection(lDAPConnection);
            throw throwable;
        }
        dlayer.releaseConnection(lDAPConnection);
    }

    private void delete(String string) throws Exception {
        LDAPConnection lDAPConnection = this.getConnection();
        try {
            try {
                lDAPConnection.delete(string);
            }
            catch (Exception exception) {
                throw new Exception(exception.toString());
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            dlayer.releaseConnection(lDAPConnection);
            throw throwable;
        }
        dlayer.releaseConnection(lDAPConnection);
    }

    private String getObjectSearchFilter(int n) {
        SearchTemplate searchTemplate = null;
        try {
            TemplateManager templateManager = TemplateManager.getTemplateManager();
            switch (n) {
                case 1: {
                    searchTemplate = templateManager.getSearchTemplate("BasicUserSearch", null);
                    return searchTemplate.getSearchFilter();
                }
                case 2: {
                    searchTemplate = templateManager.getSearchTemplate("BasicOrganizationSearch", null);
                    return searchTemplate.getSearchFilter();
                }
            }
            return null;
        }
        catch (Exception exception) {
            debug.error("ERROR while getting Object class", exception);
            return null;
        }
    }
}

