/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.util;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.FileLookupException;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;

public class FileLookup {
    private static Debug debug = Debug.getInstance("amFileLookup");
    private static final String UNDERSCORE = "_";
    private static final String NULL_LOCALE = "nullLocale";
    private static int numberOfPlatformLocales = 0;
    private static String[] platformLocales;
    static String platformLocale;
    private static Map fileTable;

    public static File[] getOrderedPaths(String string, String string2, String string3, String string4, String string5, String string6) throws FileLookupException {
        int n;
        if (string6 == null) {
            debug.error("FileLookup.getOrderedPaths():Filename was null");
            throw new FileLookupException("filename is null");
        }
        if (debug.messageEnabled()) {
            debug.message("getting ordered paths for =" + string + "|" + string2 + "|" + string3 + "|" + string4 + "|" + string5 + "|" + string6);
        }
        String[] stringArray = null;
        int n2 = 1;
        boolean bl = false;
        if (string != null && !string.equals("default")) {
            bl = true;
            ++n2;
        }
        stringArray = new String[n2];
        if (bl) {
            stringArray[0] = string;
            stringArray[1] = "default";
            n = 2;
        } else {
            stringArray[0] = "default";
            n = 1;
        }
        int n3 = numberOfPlatformLocales;
        int n4 = 0;
        String[] stringArray2 = null;
        int n5 = 1;
        if (debug.messageEnabled()) {
            debug.message("platformLocale is : " + platformLocale);
            debug.message("locale is : " + string2);
        }
        if (string2 != null && string2.length() != 0 && !string2.equals(platformLocale)) {
            ++n3;
            String string7 = string2;
            while (n4 != -1) {
                n4 = string7.lastIndexOf(UNDERSCORE);
                if (n4 == -1) continue;
                string7 = string7.substring(0, n4);
                ++n3;
            }
            string7 = string2;
            stringArray2 = new String[n3 + 1];
            stringArray2[0] = string2;
            n4 = 0;
            while (n4 != -1) {
                n4 = string7.lastIndexOf(UNDERSCORE);
                if (n4 == -1) continue;
                String string8 = string7.substring(0, n4);
                stringArray2[n5++] = string8;
                string7 = string8;
            }
        } else {
            n5 = 0;
            stringArray2 = new String[n3 + 1];
        }
        int n6 = 0;
        while (n6 < numberOfPlatformLocales) {
            stringArray2[n5++] = platformLocales[n6];
            ++n6;
        }
        stringArray2[n5++] = NULL_LOCALE;
        if (++n3 > 1) {
            n *= n3;
        }
        boolean bl2 = false;
        String[] stringArray3 = null;
        if (string5 != null && string5.length() > 0) {
            stringArray3 = FileLookup.getClientPathKeys(string5);
            n *= stringArray3.length + 1;
            bl2 = true;
        }
        boolean bl3 = false;
        if (string3 != null && string3.length() != 0) {
            bl3 = true;
            n *= 2;
        }
        boolean bl4 = false;
        String[] stringArray4 = null;
        if (string4 != null && string4.length() > 0) {
            stringArray4 = FileLookup.getOrgPathKeys(string4);
            n *= stringArray4.length + 1;
            bl4 = true;
        }
        File[] fileArray = new File[n];
        String string9 = "";
        int n7 = 0;
        n5 = 0;
        while (n5 < n2) {
            String string10 = stringArray[n5];
            int n8 = 0;
            while (n8 < n3) {
                int n9;
                String string11;
                String string12 = null;
                if (stringArray2 != null) {
                    string12 = stringArray2[n8].equals(NULL_LOCALE) ? string10 : string10 + UNDERSCORE + stringArray2[n8];
                }
                if (bl3) {
                    string12 = string12 + File.separator + string3;
                    if (bl2) {
                        int n10 = stringArray3.length;
                        while (n10 > 0) {
                            string11 = string12 + FileLookup.buildClientPath(stringArray3, n10);
                            fileArray[n7++] = new File(string11, string6);
                            --n10;
                        }
                    }
                    fileArray[n7++] = new File(string12, string6);
                }
                String string13 = null;
                string11 = null;
                if (bl4) {
                    n9 = stringArray4.length;
                    int n11 = 0;
                    while (n9 > 0) {
                        String string14 = stringArray4[n11++];
                        string11 = string12 + File.separator + string14;
                        if (bl2) {
                            int n12 = stringArray3.length;
                            while (n12 > 0) {
                                string13 = FileLookup.getClientFilePath(string11, stringArray3, n12);
                                int n13 = n7;
                                fileArray[n7++] = new File(string13, string6);
                                --n12;
                            }
                        }
                        fileArray[n7++] = new File(string11, string6);
                        --n9;
                    }
                }
                if (bl2) {
                    n9 = stringArray3.length;
                    while (n9 > 0) {
                        string12 = stringArray2[n8].equals(NULL_LOCALE) ? string10 : string10 + UNDERSCORE + stringArray2[n8];
                        string13 = string12 + FileLookup.buildClientPath(stringArray3, n9);
                        fileArray[n7++] = new File(string13, string6);
                        --n9;
                    }
                }
                string12 = !stringArray2[n8].equals(NULL_LOCALE) ? string10 + UNDERSCORE + stringArray2[n8] : string10;
                fileArray[n7++] = new File(string12, string6);
                ++n8;
            }
            ++n5;
        }
        return fileArray;
    }

    public static File getFirstExisting(String string, String string2, String string3, String string4, String string5, String string6, boolean bl) throws FileLookupException {
        return FileLookup.getFirstExisting(string, string2, string3, null, string4, string5, string6, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getFirstExisting(String string, String string2, String string3, String string4, String string5, String string6, String string7, boolean bl) throws FileLookupException {
        File[] fileArray;
        String string8 = string + ":" + string2 + ":" + string3 + ":" + string4 + ":" + string5 + ":" + string6 + ":" + string7;
        if (debug.messageEnabled()) {
            debug.message("Check file=" + string8);
        }
        if (bl && (fileArray = (File[])fileTable.get(string8)) != null) {
            if (debug.messageEnabled()) {
                debug.message("Found existing file=" + string8);
            }
            return fileArray;
        }
        fileArray = FileLookup.getOrderedPaths(string, string2, string3, string4, string5, string6);
        if (debug.messageEnabled()) {
            debug.message("getFirstExisting:orderedPaths.length = " + fileArray.length);
        }
        int n = 0;
        while (n < fileArray.length) {
            File file;
            if (debug.messageEnabled()) {
                debug.message("orderedPath[" + n + "]=" + fileArray[n].toString());
            }
            if ((file = new File(string7, fileArray[n].toString())).exists()) {
                if (debug.messageEnabled()) {
                    debug.message("returning file=" + file.toString());
                }
                if (bl) {
                    Map map = fileTable;
                    synchronized (map) {
                        File file2 = (File)fileTable.get(string8);
                        if (file2 == null) {
                            fileTable.put(string8, file);
                        } else {
                            file = file2;
                        }
                    }
                }
                return file;
            }
            ++n;
        }
        return null;
    }

    public static String getFirstExistingRemote(String string, String string2, String string3, String string4) throws FileLookupException {
        debug.message("FileLookup:getFirstExistingRemote");
        File[] fileArray = FileLookup.getOrderedPaths(string2, string3, null, null, null, string4);
        int n = 0;
        while (n < fileArray.length) {
            String string5 = fileArray[n].toString();
            if (string5.charAt(0) != '/') {
                string5 = "/" + string5;
            }
            String string6 = string + string5;
            if (debug.messageEnabled()) {
                debug.message("path " + n + ") " + string6);
            }
            int n2 = -1;
            try {
                URL uRL = new URL(string6);
                HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
                n2 = httpURLConnection.getResponseCode();
                httpURLConnection.disconnect();
            }
            catch (MalformedURLException malformedURLException) {
                debug.error("malformed url excption", malformedURLException);
            }
            catch (IOException iOException) {
                debug.error("ioexcecption opening the connection", iOException);
            }
            if (n2 == 200) {
                if (debug.messageEnabled()) {
                    debug.message("returning remote file = " + string6);
                }
                return string6;
            }
            ++n;
        }
        if (debug.messageEnabled()) {
            debug.message("could not locate " + string4 + " on " + string + "; returning null");
        }
        return null;
    }

    private static String buildClientPath(String[] stringArray, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(File.separator).append(stringArray[n2]);
            ++n2;
        }
        return stringBuffer.toString();
    }

    private static String[] getClientPathKeys(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.separator);
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = stringTokenizer.nextToken();
            ++n2;
        }
        return stringArray;
    }

    private static String[] getOrgPathKeys(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.separator);
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = string;
            int n3 = string.lastIndexOf(File.separator);
            if (n3 != -1) {
                string = string.substring(0, n3);
            }
            ++n2;
        }
        return stringArray;
    }

    static String getClientFilePath(String string, String[] stringArray, int n) {
        String string2 = string + FileLookup.buildClientPath(stringArray, n);
        return string2;
    }

    static {
        platformLocale = null;
        platformLocale = Locale.getDefault().toString();
        ++numberOfPlatformLocales;
        String string = platformLocale;
        int n = 0;
        while (n != -1) {
            n = string.lastIndexOf(UNDERSCORE);
            if (n == -1) continue;
            string = string.substring(0, n);
            ++numberOfPlatformLocales;
        }
        string = platformLocale;
        platformLocales = new String[numberOfPlatformLocales];
        FileLookup.platformLocales[0] = platformLocale;
        n = 0;
        int n2 = 1;
        while (n != -1) {
            n = string.lastIndexOf(UNDERSCORE);
            if (n == -1) continue;
            String string2 = string.substring(0, n);
            FileLookup.platformLocales[n2++] = string2;
            string = string2;
        }
        fileTable = new HashMap();
    }
}

