/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.util;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.providers.dpro.SSOProviderImpl;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.util.Map;

public class CLILogin {
    String host = null;
    String domain = null;
    String userId = null;
    String passwd = null;
    String gotoUrl = "console";
    String protocol = "http";
    String cookie = null;
    String cookieValue = null;
    SSOToken ssotoken = null;

    public CLILogin(String string, String string2, String string3, String string4) {
        this.host = string;
        this.domain = string2;
        this.userId = string3;
        this.passwd = string4;
    }

    public boolean isLoggedIn() {
        return this.isSessionValid();
    }

    public String getSessionId() {
        return this.cookieValue;
    }

    public SSOToken getToken() {
        return this.ssotoken;
    }

    public boolean isSessionValid() {
        return this.validateSession(this.cookieValue);
    }

    public String getURL(URL uRL) {
        String string = null;
        try {
            string = CLILogin.urlAccess(uRL, this.cookie, true);
        }
        catch (Exception exception) {
            System.out.println("Exception in getURL");
        }
        return string;
    }

    public Map getCookies() {
        return null;
    }

    public void logout() {
        try {
            if (this.ssotoken != null) {
                SSOProviderImpl sSOProviderImpl = new SSOProviderImpl();
                sSOProviderImpl.destroyToken(this.ssotoken);
            }
            this.cookieValue = null;
            this.ssotoken = null;
            this.cookie = null;
        }
        catch (SSOException sSOException) {
            System.out.println(sSOException.getMessage());
        }
    }

    public boolean login() {
        if (this.host == null || this.domain == null || this.userId == null || this.passwd == null) {
            return false;
        }
        boolean bl = false;
        try {
            URL uRL = new URL(this.protocol + "://" + this.host + "/login/LDAP?goto=" + this.gotoUrl);
            this.cookie = CLILogin.getCookie(uRL);
            int n = this.cookie.indexOf("=");
            int n2 = this.cookie.indexOf(";");
            this.cookieValue = this.cookie.substring(n + 1, n2);
            if (this.cookieValue == null) {
                return false;
            }
            System.out.println("Cookie = " + this.cookie);
            System.out.println("CookieVal = " + this.cookieValue);
            uRL = new URL(this.protocol + "://" + this.host + "/login/LDAP");
            CLILogin.authenticate(uRL, this.cookie, this.userId, this.passwd);
            System.out.println("===== validate session after authenticate ===");
            this.cookieValue = CLILogin.convertCookie(this.cookieValue);
            bl = this.isSessionValid();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (!bl) {
            this.logout();
        }
        return bl;
    }

    private boolean validateSession(String string) {
        if (string == null) {
            return false;
        }
        try {
            SSOProviderImpl sSOProviderImpl = new SSOProviderImpl();
            this.ssotoken = sSOProviderImpl.createSSOToken(string);
            if (sSOProviderImpl.isValidToken(this.ssotoken)) {
                System.out.println("Valid session for " + this.ssotoken.getProperty("Principal"));
                return true;
            }
            System.out.println("Invalid session");
            return false;
        }
        catch (SSOException sSOException) {
            System.out.println(sSOException.getMessage());
            return false;
        }
    }

    private static String getCookie(URL uRL) throws IOException {
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        String string = httpURLConnection.getHeaderField("Set-cookie");
        if (string == null) {
            System.out.println("No cookies in HTTP request, server down ?" + uRL);
            return null;
        }
        httpURLConnection.disconnect();
        return string;
    }

    private static void authenticate(URL uRL, String string, String string2, String string3) throws IOException, ProtocolException {
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setRequestProperty("Cookie", string);
        HttpURLConnection.setFollowRedirects(false);
        PrintWriter printWriter = new PrintWriter(httpURLConnection.getOutputStream());
        printWriter.print("TOKEN0=" + string2 + "&TOKEN1=" + string3);
        printWriter.close();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
    }

    private static String urlAccess(URL uRL, String string, boolean bl) throws IOException, ProtocolException {
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setRequestMethod("GET");
        httpURLConnection.setRequestProperty("Cookie", string);
        String string2 = null;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
        if (bl) {
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            char[] cArray = new char[1024];
            while ((n = bufferedReader.read(cArray, 0, cArray.length)) != -1) {
                stringBuffer.append(cArray, 0, n);
            }
            string2 = stringBuffer.toString();
            System.out.print(string2);
        }
        return string2;
    }

    private static String convertCookie(String string) {
        int n;
        while ((n = string.indexOf("%25")) != -1) {
            String string2;
            string = string2 = string.substring(0, n) + "%" + string.substring(n + 3);
        }
        return string;
    }
}

