/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.util;

import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.internal.AuthPrincipal;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.Principal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class AMGenerateServerID {
    private static char[] alphabet = "0123456789abcdefghijklmnopqrstuvwxyz".toCharArray();
    static String delimiter = "|";
    static Debug debug = Debug.getInstance("amMultiInstall");

    public static void main(String[] stringArray) {
        if (stringArray.length != 4) {
            System.out.println(" Usage: AMGenerateServerID create|delete <serverurl> amadminDN amadminPassword");
            System.exit(1);
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        try {
            Object object;
            String string3 = stringArray[2];
            String string4 = stringArray[3];
            SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
            SSOToken sSOToken = sSOTokenManager.createSSOToken((Principal)new AuthPrincipal(string3), string4);
            ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager("iPlanetAMPlatformService", sSOToken);
            ServiceSchema serviceSchema = serviceSchemaManager.getGlobalSchema();
            Map map = serviceSchema.getAttributeDefaults();
            Set set = (Set)map.get("iplanet-am-platform-server-list");
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                if (!((String)object).startsWith(string2)) continue;
                debug.message("server already exists., exiting");
                System.exit(0);
            }
            if (string.equalsIgnoreCase("create")) {
                object = AMGenerateServerID.returnServerIds(set);
                String string5 = AMGenerateServerID.getTwoByteString((Set)object);
                String string6 = string2 + delimiter + string5;
                debug.message("New server entry:" + string6);
                set.add(string6);
                map.put("iplanet-am-platform-server-list", set);
            } else if (string.equalsIgnoreCase("delete")) {
                object = AMGenerateServerID.returnId(set, string2);
                if (object != null) {
                    String string7 = string2 + delimiter + (String)object;
                    debug.message("Server entry to be removed:" + string7);
                    set.remove(string7);
                    map.put("iplanet-am-platform-server-list", set);
                } else {
                    debug.message("Can not find server in server's list:" + string2);
                    System.exit(1);
                }
            } else {
                debug.message("Unknown option in AMGenerateServerID");
                System.exit(1);
            }
            serviceSchema.setAttributeDefaults(map);
        }
        catch (Exception exception) {
            debug.error("Exception occured:", exception);
        }
    }

    public static Set returnServerIds(Set set) {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            int n = string.indexOf(delimiter);
            if (n == -1) continue;
            String string2 = string.substring(n + 1, string.length());
            hashSet.add(string2);
        }
        return hashSet;
    }

    public static String returnId(Set set, String string) {
        String string2 = null;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            int n;
            String string3 = (String)iterator.next();
            if (!string3.startsWith(string) || (n = string3.indexOf(delimiter)) == -1) continue;
            string2 = string3.substring(n + 1, string3.length());
            return string2;
        }
        return string2;
    }

    public static String getTwoByteString(Set set) {
        int n = 0;
        while (n < alphabet.length) {
            char[] cArray = new char[2];
            cArray[0] = alphabet[n];
            int n2 = 1;
            while (n2 < alphabet.length) {
                cArray[1] = alphabet[n2];
                String string = new String(cArray);
                if (set == null || !set.contains(string)) {
                    return string;
                }
                ++n2;
            }
            ++n;
        }
        return "xx";
    }
}

