/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.extensions;

import iaik.asn1.ASN1Object;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.x509.V3Extension;
import iaik.x509.X509ExtensionException;
import java.util.Vector;

public class ExtendedKeyUsage
extends V3Extension {
    private Vector a = new Vector();
    public static final ObjectID netscapeSGC;
    public static final ObjectID microsoftSGC;
    public static final ObjectID iKEIntermediate;
    public static final ObjectID ocspSigning;
    public static final ObjectID timeStamping;
    public static final ObjectID ipsecUser;
    public static final ObjectID ipsecTunnel;
    public static final ObjectID ipsecEndSystem;
    public static final ObjectID emailProtection;
    public static final ObjectID codeSigning;
    public static final ObjectID clientAuth;
    public static final ObjectID serverAuth;
    public static final ObjectID anyExtendedKeyUsage;
    public static final ObjectID oid;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < this.a.size()) {
            stringBuffer.append("KeyPurposeId " + n2 + ":  " + ((ObjectID)this.a.elementAt(n2)).getName() + "\n");
            ++n2;
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    public ASN1Object toASN1Object() throws X509ExtensionException {
        SEQUENCE sEQUENCE = new SEQUENCE();
        int n2 = 0;
        while (n2 < this.a.size()) {
            sEQUENCE.addComponent((ASN1Object)this.a.elementAt(n2));
            ++n2;
        }
        return sEQUENCE;
    }

    public boolean removeKeyPurposeID(ObjectID objectID) {
        return this.a.removeElement(objectID);
    }

    public void removeAllKeyPurposeIDs() {
        this.a.removeAllElements();
    }

    public void init(ASN1Object aSN1Object) throws X509ExtensionException {
        try {
            int n2 = 0;
            while (n2 < aSN1Object.countComponents()) {
                this.a.addElement(aSN1Object.getComponentAt(n2));
                ++n2;
            }
            return;
        }
        catch (Exception exception) {
            throw new X509ExtensionException("Error decoding extension: " + exception.getMessage());
        }
    }

    public int hashCode() {
        return oid.hashCode();
    }

    public ObjectID getObjectID() {
        return oid;
    }

    public ObjectID[] getKeyPurposeIDs() {
        Object[] objectArray = new ObjectID[this.a.size()];
        this.a.copyInto(objectArray);
        return objectArray;
    }

    public void addKeyPurposeID(ObjectID objectID) {
        if (!this.a.contains(objectID)) {
            this.a.addElement(objectID);
        }
    }

    public ExtendedKeyUsage(ObjectID[] objectIDArray) {
        this();
        int n2 = 0;
        while (n2 < objectIDArray.length) {
            this.addKeyPurposeID(objectIDArray[n2]);
            ++n2;
        }
    }

    public ExtendedKeyUsage(ObjectID objectID) {
        this();
        this.addKeyPurposeID(objectID);
    }

    public ExtendedKeyUsage() {
    }

    static {
        oid = new ObjectID("2.5.29.37", "ExtendedKeyUsage");
        anyExtendedKeyUsage = new ObjectID("2.5.29.37.0", "Any extended key usage");
        serverAuth = new ObjectID("1.3.6.1.5.5.7.3.1", "TLS Web server authentication");
        clientAuth = new ObjectID("1.3.6.1.5.5.7.3.2", "TLS Web client authentication");
        codeSigning = new ObjectID("1.3.6.1.5.5.7.3.3", "Code signing");
        emailProtection = new ObjectID("1.3.6.1.5.5.7.3.4", "E-mail protection");
        ipsecEndSystem = new ObjectID("1.3.6.1.5.5.7.3.5", "IP security end system");
        ipsecTunnel = new ObjectID("1.3.6.1.5.5.7.3.6", "IP security tunel termination");
        ipsecUser = new ObjectID("1.3.6.1.5.5.7.3.7", "IP security user");
        timeStamping = new ObjectID("1.3.6.1.5.5.7.3.8", "Timestamping");
        ocspSigning = new ObjectID("1.3.6.1.5.5.7.3.9", "OCSPSigning");
        iKEIntermediate = new ObjectID("1.3.6.1.5.5.8.2.2", "iKEIntermediate");
        microsoftSGC = new ObjectID("1.3.6.1.4.1.311.10.3.3", "Microsoft Server Gated Cryptography");
        netscapeSGC = new ObjectID("2.16.840.1.113730.4.1", "Netscape Server Gated Cryptography");
    }
}

