/*
 * Decompiled with CFR 0.152.
 */
package iaik.utils;

import iaik.asn1.structures.Name;
import iaik.pkcs.pkcs10.CertificateRequest;
import iaik.security.rsa.RSAPrivateKey;
import iaik.security.rsa.RSAPublicKey;
import iaik.utils.Base64Exception;
import iaik.utils.Base64InputStream;
import iaik.utils.Base64OutputStream;
import iaik.utils.CryptoUtils;
import iaik.utils.InternalErrorException;
import iaik.utils.a;
import iaik.x509.X509CRL;
import iaik.x509.X509Certificate;
import iaik.x509.attr.AttributeCertificate;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Vector;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.SecretKeySpec;

public class Util {
    private static boolean a;
    private static String b;
    private static final byte[] d;
    private static final String c = "aAzZ09+/=";
    private static final String[] e;

    public static void waitKey() {
        try {
            System.out.println("Hit the <RETURN> key.");
            do {
                System.in.read();
            } while (System.in.available() > 0);
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public static String toString(byte[] byArray, String string) {
        return Util.toString(byArray, 0, byArray.length, string);
    }

    public static String toString(byte[] byArray, int n2, int n3, String string) {
        if (byArray.length < n2 + n3) {
            n3 = byArray.length - n2;
        }
        StringBuffer stringBuffer = new StringBuffer(2 * n3);
        boolean bl = true;
        int n4 = 0;
        while (n4 < n3) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(string);
            }
            stringBuffer.append(Util.toString(byArray[n2 + n4]));
            ++n4;
        }
        return stringBuffer.toString();
    }

    public static String toString(byte[] byArray, int n2, int n3) {
        return Util.toString(byArray, n2, n3, ":");
    }

    public static String toString(byte[] byArray) {
        return Util.toString(byArray, 0, byArray.length);
    }

    public static String toString(long l2) {
        return String.valueOf(Util.toString((int)(l2 >> 32))) + ":" + Util.toString((int)l2);
    }

    public static String toString(int n2) {
        byte[] byArray = new byte[]{(byte)(n2 >> 24), (byte)(n2 >> 16), (byte)(n2 >> 8), (byte)n2};
        return Util.toString(byArray);
    }

    public static String toString(byte by) {
        StringBuffer stringBuffer = new StringBuffer(2);
        int n2 = (by & 0xF0) >> 4;
        int n3 = by & 0xF;
        stringBuffer.append(new Character((char)(n2 > 9 ? 65 + n2 - 10 : 48 + n2)));
        stringBuffer.append(new Character((char)(n3 > 9 ? 65 + n3 - 10 : 48 + n3)));
        return stringBuffer.toString();
    }

    private static String a(byte[] byArray) {
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(byArray)));
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
            String string2 = null;
            while ((string = bufferedReader.readLine()) != null) {
                if (string2 != null) {
                    printWriter.println("\"" + string2 + "\" +");
                }
                string2 = string;
            }
            printWriter.println("\"" + string2 + "\";");
            printWriter.flush();
            return new String(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static String toPemString(java.security.cert.X509CRL x509CRL) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
        try {
            byteArrayOutputStream.write(Util.toASCIIBytes("-----BEGIN CRL-----\n"));
            byteArrayOutputStream.write(Util.Base64Encode(x509CRL.getEncoded()));
            byteArrayOutputStream.write(Util.toASCIIBytes("\n-----END CRL-----\n"));
        }
        catch (CRLException cRLException) {
            return null;
        }
        catch (IOException iOException) {}
        return Util.toASCIIString(byteArrayOutputStream.toByteArray());
    }

    public static String toPemString(Certificate certificate) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
        try {
            byteArrayOutputStream.write(Util.toASCIIBytes("-----BEGIN CERTIFICATE-----\n"));
            byteArrayOutputStream.write(Util.Base64Encode(certificate.getEncoded()));
            byteArrayOutputStream.write(Util.toASCIIBytes("\n-----END CERTIFICATE-----\n"));
        }
        catch (CertificateEncodingException certificateEncodingException) {
            return null;
        }
        catch (IOException iOException) {}
        return Util.toASCIIString(byteArrayOutputStream.toByteArray());
    }

    public static String toPemString(PrivateKey privateKey) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
        try {
            String string = privateKey.getAlgorithm();
            byteArrayOutputStream.write(Util.toASCIIBytes("-----BEGIN " + string + " PRIVATE KEY-----\n"));
            byteArrayOutputStream.write(Util.Base64Encode(privateKey.getEncoded()));
            byteArrayOutputStream.write(Util.toASCIIBytes("\n-----END " + string + " PRIVATE KEY-----\n"));
        }
        catch (IOException iOException) {}
        return Util.toASCIIString(byteArrayOutputStream.toByteArray());
    }

    public static String toPemString(CertificateRequest certificateRequest) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
        try {
            byteArrayOutputStream.write(Util.toASCIIBytes("-----BEGIN NEW CERTIFICATE REQUEST-----\n"));
            byteArrayOutputStream.write(Util.Base64Encode(certificateRequest.toByteArray()));
            byteArrayOutputStream.write(Util.toASCIIBytes("\n-----END NEW CERTIFICATE REQUEST-----\n"));
        }
        catch (IOException iOException) {}
        return Util.toASCIIString(byteArrayOutputStream.toByteArray());
    }

    public static byte[] toByteArray(String string) {
        int n2 = string.length();
        int n3 = -1;
        int n4 = -1;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n5 = 0;
        while (n5 < n2) {
            if (n4 == -1) {
                n4 = Util.toByte(string.charAt(n5), 16);
            } else {
                n3 = Util.toByte(string.charAt(n5), 16);
            }
            if (n4 != -1 && n3 != -1) {
                byteArrayOutputStream.write(n4 << 4 | n3);
                n3 = -1;
                n4 = -1;
            }
            ++n5;
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static int toByte(char c2, int n2) {
        int n3 = c2 >= '0' && c2 <= '9' ? c2 - 48 : (c2 >= 'A' && c2 <= 'Z' ? c2 - 65 + 10 : (c2 >= 'a' && c2 <= 'z' ? c2 - 97 + 10 : -1));
        if (n3 < 0 || n3 >= n2) {
            return -1;
        }
        return n3;
    }

    public static boolean[] toBooleanArray(String string) {
        boolean[] blArray = new boolean[string.length()];
        int n2 = 0;
        while (n2 < blArray.length) {
            blArray[n2] = string.charAt(n2) == '1';
            ++n2;
        }
        return blArray;
    }

    public static Object[] toArray(Vector vector, Class clazz) {
        Object[] objectArray = (Object[])Array.newInstance(clazz, vector.size());
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static Object[] toArray(Vector vector) {
        Object[] objectArray = new Object[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static String toASCIIString(byte[] byArray, int n2, int n3) {
        if (b == null) {
            Util.a();
        }
        try {
            return new String(byArray, n2, n3, b);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("ASCII encoding not supported?!: " + unsupportedEncodingException.toString());
        }
    }

    public static String toASCIIString(byte[] byArray) {
        return Util.toASCIIString(byArray, 0, byArray.length);
    }

    public static byte[] toASCIIBytes(String string) {
        if (b == null) {
            Util.a();
        }
        try {
            return string.getBytes(b);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("ASCII encoding not supported?!: " + unsupportedEncodingException.toString());
        }
    }

    private static synchronized void b() {
    }

    public static void setEncoding(String string) {
        b = string;
    }

    public static void saveToFile(byte[] byArray, String string) throws IOException {
        File file = new File(string);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        fileOutputStream.write(byArray);
        fileOutputStream.close();
    }

    public static Object[] resizeArray(Object[] objectArray, int n2) {
        Object[] objectArray2 = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n2);
        System.arraycopy(objectArray, 0, objectArray2, 0, Math.min(n2, objectArray.length));
        return objectArray2;
    }

    public static byte[] resizeArray(byte[] byArray, int n2) {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, Math.min(n2, byArray.length));
        return byArray2;
    }

    public static byte[] readStream(InputStream inputStream) throws IOException {
        int n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(10240);
        byte[] byArray = new byte[10240];
        while ((n2 = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n2);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] readFile(String string) throws IOException {
        File file = new File(string);
        byte[] byArray = new byte[(int)file.length()];
        FileInputStream fileInputStream = new FileInputStream(file);
        fileInputStream = new FileInputStream(file);
        fileInputStream.read(byArray);
        fileInputStream.close();
        return byArray;
    }

    public static X509Certificate[] readCertificateChain(InputStream inputStream) throws IOException {
        Vector<X509Certificate> vector = new Vector<X509Certificate>();
        try {
            while (inputStream.available() > 10) {
                vector.addElement(new X509Certificate(inputStream));
            }
        }
        catch (CertificateException certificateException) {
            throw new IOException("Unable to decode certificate: " + certificateException.toString());
        }
        Object[] objectArray = new X509Certificate[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static X509CRL[] readCRLChain(InputStream inputStream) throws IOException {
        Vector<X509CRL> vector = new Vector<X509CRL>();
        try {
            while (inputStream.available() > 10) {
                vector.addElement(new X509CRL(inputStream));
            }
        }
        catch (CRLException cRLException) {
            throw new IOException("Unable to decode crl: " + cRLException.toString());
        }
        Object[] objectArray = new X509CRL[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static void printTable(String string, int[] nArray) {
        int n2 = 0;
        System.out.println("*** " + string);
        int n3 = 0;
        while (n3 < nArray.length) {
            System.out.print(Util.toString(nArray[n3]));
            if (n2++ == 5) {
                n2 = 0;
                System.out.println();
            } else {
                System.out.print("  ");
            }
            ++n3;
        }
        System.out.println();
    }

    public static void printTable(String string, byte[] byArray) {
        int[] nArray = new int[byArray.length >> 2];
        CryptoUtils.squashBytesToInts(byArray, 0, nArray, 0, nArray.length);
        Util.printTable(string, nArray);
    }

    public static boolean loadClass(String string, boolean bl) {
        try {
            Class clazz = iaik.jce.com.fourthpass.a.a(string);
            if (bl) {
                clazz.newInstance();
            }
        }
        catch (InstantiationException instantiationException) {
            return false;
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        return true;
    }

    private static synchronized void a() {
        if (b != null) {
            return;
        }
        int n2 = 0;
        while (n2 < e.length) {
            try {
                String string = e[n2];
                byte[] byArray = c.getBytes(string);
                if (CryptoUtils.equalsBlock(byArray, d)) {
                    b = string;
                    return;
                }
            }
            catch (Throwable throwable) {}
            ++n2;
        }
        throw new RuntimeException("Could not find a ASCII compatible encoding!");
    }

    public static Vector getVector(Object[] objectArray) {
        return new a(objectArray);
    }

    public static String getRawCipherName(String string) {
        int n2 = string.indexOf("/");
        if (n2 == -1) {
            return string;
        }
        return string.substring(0, n2);
    }

    public static RSAPublicKey getRSAPublicKey(Key key) throws InvalidKeyException {
        if (key instanceof RSAPublicKey) {
            return (RSAPublicKey)key;
        }
        if (key instanceof java.security.interfaces.RSAPublicKey) {
            return new RSAPublicKey((java.security.interfaces.RSAPublicKey)key);
        }
        if (key instanceof PublicKey) {
            return new RSAPublicKey(key.getEncoded());
        }
        throw new InvalidKeyException("Class does not represent an RSA public key: " + key.getClass().getName());
    }

    public static RSAPrivateKey getRSAPrivateKey(Key key) throws InvalidKeyException {
        if (key instanceof RSAPrivateKey) {
            return (RSAPrivateKey)key;
        }
        if (key instanceof java.security.interfaces.RSAPrivateKey) {
            return new RSAPrivateKey((java.security.interfaces.RSAPrivateKey)key);
        }
        if (key instanceof PrivateKey) {
            return new RSAPrivateKey(key.getEncoded());
        }
        throw new InvalidKeyException("Class does not represent an RSA private key: " + key.getClass().getName());
    }

    public static int getKeyLength(PublicKey publicKey) {
        if (publicKey instanceof java.security.interfaces.RSAPublicKey) {
            return ((java.security.interfaces.RSAPublicKey)publicKey).getModulus().bitLength();
        }
        if (publicKey instanceof DSAPublicKey) {
            return ((DSAPublicKey)publicKey).getParams().getP().bitLength();
        }
        if (publicKey instanceof DHPublicKey) {
            return ((DHPublicKey)publicKey).getParams().getP().bitLength();
        }
        return -1;
    }

    public static int getKeyLength(PrivateKey privateKey) {
        if (privateKey instanceof java.security.interfaces.RSAPrivateKey) {
            return ((java.security.interfaces.RSAPrivateKey)privateKey).getModulus().bitLength();
        }
        if (privateKey instanceof DSAPrivateKey) {
            return ((DSAPrivateKey)privateKey).getParams().getP().bitLength();
        }
        if (privateKey instanceof DHPrivateKey) {
            return ((DHPrivateKey)privateKey).getParams().getP().bitLength();
        }
        return -1;
    }

    public static String fromBooleanArray(boolean[] blArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < blArray.length) {
            if (blArray[n2]) {
                stringBuffer.append('1');
            } else {
                stringBuffer.append('0');
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static void fillArray(byte[] byArray, InputStream inputStream) throws IOException {
        int n2 = 0;
        int n3 = 0;
        int n4 = byArray.length;
        while (n4 > 0) {
            n3 = inputStream.read(byArray, n2, n4);
            if (n3 < 0) {
                throw new EOFException();
            }
            n2 += n3;
            n4 -= n3;
        }
    }

    public static String encodeIntArray(int[] nArray) {
        int n2 = nArray.length;
        byte[] byArray = new byte[4 * n2];
        CryptoUtils.spreadIntsToBytes(nArray, 0, byArray, 0, n2);
        byte[] byArray2 = Util.Base64Encode(byArray);
        return Util.a(byArray2);
    }

    public static String encodeByteArray(byte[] byArray) {
        byte[] byArray2 = Util.Base64Encode(byArray);
        return Util.a(byArray2);
    }

    public static Key decodeKey(int n2, String string, byte[] byArray) throws InvalidKeyException, NoSuchAlgorithmException {
        if (n2 == 3) {
            return new SecretKeySpec(byArray, string);
        }
        if (n2 == 2) {
            try {
                KeyFactory keyFactory = KeyFactory.getInstance(string);
                PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
                return keyFactory.generatePrivate(pKCS8EncodedKeySpec);
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                throw new InvalidKeyException(invalidKeySpecException.toString());
            }
        }
        if (n2 == 1) {
            try {
                KeyFactory keyFactory = KeyFactory.getInstance(string);
                X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray);
                return keyFactory.generatePublic(x509EncodedKeySpec);
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                throw new InvalidKeyException(invalidKeySpecException.toString());
            }
        }
        throw new InvalidKeyException("Unknown key type " + n2);
    }

    public static int[] decodeIntArray(String string) throws RuntimeException {
        try {
            byte[] byArray = Util.toASCIIBytes(string);
            byte[] byArray2 = Util.Base64Decode(byArray);
            int n2 = byArray2.length / 4;
            int[] nArray = new int[n2];
            CryptoUtils.squashBytesToInts(byArray2, 0, nArray, 0, n2);
            return nArray;
        }
        catch (Base64Exception base64Exception) {
            throw new RuntimeException("Fatal decoding error: " + base64Exception);
        }
    }

    public static byte[] decodeByteArray(String string) throws RuntimeException {
        try {
            return Util.Base64Decode(Util.toASCIIBytes(string));
        }
        catch (Base64Exception base64Exception) {
            throw new RuntimeException("Fatal decoding error: " + base64Exception);
        }
    }

    public static AttributeCertificate[] convertToAttributeCertificateChain(Certificate[] certificateArray) throws CertificateException {
        if (certificateArray == null) {
            return null;
        }
        AttributeCertificate[] attributeCertificateArray = new AttributeCertificate[certificateArray.length];
        int n2 = 0;
        while (n2 < certificateArray.length) {
            attributeCertificateArray[n2] = certificateArray[n2] instanceof AttributeCertificate ? (AttributeCertificate)certificateArray[n2] : new AttributeCertificate(certificateArray[n2].getEncoded());
            ++n2;
        }
        return attributeCertificateArray;
    }

    public static byte[] convertEndian32(byte[] byArray) {
        int n2 = byArray.length;
        byte[] byArray2 = new byte[n2];
        int n3 = 0;
        while (n3 < n2) {
            byArray2[n3] = byArray[n3 + 3];
            byArray2[n3 + 1] = byArray[n3 + 2];
            byArray2[n3 + 2] = byArray[n3 + 1];
            byArray2[n3 + 3] = byArray[n3];
            n3 += 4;
        }
        return byArray2;
    }

    public static X509Certificate[] convertCertificateChain(Certificate[] certificateArray) throws CertificateException {
        if (certificateArray == null) {
            return null;
        }
        X509Certificate[] x509CertificateArray = new X509Certificate[certificateArray.length];
        int n2 = 0;
        while (n2 < certificateArray.length) {
            x509CertificateArray[n2] = certificateArray[n2] instanceof X509Certificate ? (X509Certificate)certificateArray[n2] : new X509Certificate(certificateArray[n2].getEncoded());
            ++n2;
        }
        return x509CertificateArray;
    }

    public static void compareTables(String string, int[] nArray, int[] nArray2) {
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            if (nArray[n3] != nArray2[n3]) {
                throw new RuntimeException("Error in " + string + " index " + n3 + ": " + Util.toString(nArray[n3]) + " != " + Util.toString(nArray2[n3]));
            }
            ++n3;
        }
    }

    public static int calculateHashCode(byte[] byArray) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < byArray.length) {
            n2 += byArray[n3] * n3;
            ++n3;
        }
        return n2;
    }

    public static long[] bubbleSort(long[] lArray) {
        boolean bl;
        do {
            bl = false;
            int n2 = 1;
            while (n2 < lArray.length) {
                if (lArray[n2 - 1] > lArray[n2]) {
                    bl = true;
                    long l2 = lArray[n2 - 1];
                    lArray[n2 - 1] = lArray[n2];
                    lArray[n2] = l2;
                }
                ++n2;
            }
        } while (bl);
        return lArray;
    }

    public static int[] bubbleSort(int[] nArray) {
        boolean bl;
        do {
            bl = false;
            int n2 = 1;
            while (n2 < nArray.length) {
                if (nArray[n2 - 1] > nArray[n2]) {
                    bl = true;
                    int n3 = nArray[n2 - 1];
                    nArray[n2 - 1] = nArray[n2];
                    nArray[n2] = n3;
                }
                ++n2;
            }
        } while (bl);
        return nArray;
    }

    public static X509Certificate[] arrangeCertificateChain(X509Certificate[] x509CertificateArray, boolean bl) {
        if (x509CertificateArray != null && x509CertificateArray.length > 0 && x509CertificateArray[0] != null) {
            int n2;
            Vector<X509Certificate> vector = new Vector<X509Certificate>();
            Vector<X509Certificate> vector2 = new Vector<X509Certificate>();
            vector.addElement(x509CertificateArray[0]);
            int n3 = 1;
            while (n3 < x509CertificateArray.length) {
                vector2.addElement(x509CertificateArray[n3]);
                ++n3;
            }
            boolean bl2 = false;
            boolean bl3 = false;
            while (!(vector2.size() <= 0 || bl3 && bl2)) {
                Name name;
                Name name2;
                X509Certificate x509Certificate;
                X509Certificate x509Certificate2;
                int n4 = 0;
                n2 = 0;
                while (n4 < vector2.size() && n2 == 0 && !bl2) {
                    x509Certificate2 = (X509Certificate)vector.elementAt(vector.size() - 1);
                    x509Certificate = (X509Certificate)vector2.elementAt(n4);
                    name2 = (Name)x509Certificate2.getSubjectDN();
                    name = (Name)x509Certificate.getIssuerDN();
                    if (name2 == null || !name2.elements().hasMoreElements()) break;
                    if (name.equals(name2)) {
                        try {
                            x509Certificate.verify(x509Certificate2.getPublicKey());
                            n2 = 1;
                            vector2.removeElementAt(n4);
                            vector.addElement(x509Certificate);
                        }
                        catch (Exception exception) {}
                    }
                    ++n4;
                }
                if (n2 == 0) {
                    bl2 = true;
                }
                n4 = 0;
                n2 = 0;
                while (n4 < vector2.size() && n2 == 0 && !bl3) {
                    x509Certificate2 = (X509Certificate)vector2.elementAt(n4);
                    x509Certificate = (X509Certificate)vector.elementAt(0);
                    name2 = (Name)x509Certificate2.getSubjectDN();
                    name = (Name)x509Certificate.getIssuerDN();
                    if (name.equals(name2)) {
                        try {
                            x509Certificate.verify(x509Certificate2.getPublicKey());
                            n2 = 1;
                            vector2.removeElementAt(n4);
                            vector.insertElementAt(x509Certificate2, 0);
                        }
                        catch (Exception exception) {}
                    }
                    ++n4;
                }
                if (n2 != 0) continue;
                bl3 = true;
            }
            if (vector2.size() == 0) {
                X509Certificate[] x509CertificateArray2 = new X509Certificate[vector.size()];
                n2 = 0;
                while (n2 < x509CertificateArray2.length) {
                    x509CertificateArray2[n2] = bl ? (X509Certificate)vector.elementAt(n2) : (X509Certificate)vector.elementAt(vector.size() - 1 - n2);
                    ++n2;
                }
                return x509CertificateArray2;
            }
            return null;
        }
        return null;
    }

    public static byte[] Base64Encode(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Base64OutputStream base64OutputStream = new Base64OutputStream(byteArrayOutputStream);
        try {
            base64OutputStream.write(byArray);
            base64OutputStream.flush();
        }
        catch (IOException iOException) {
            throw new InternalErrorException(iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] Base64Decode(byte[] byArray) throws Base64Exception {
        Base64InputStream base64InputStream = new Base64InputStream(new ByteArrayInputStream(byArray));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray2 = new byte[1024];
        try {
            int n2;
            while ((n2 = base64InputStream.read(byArray2)) > 0) {
                byteArrayOutputStream.write(byArray2, 0, n2);
            }
        }
        catch (IOException iOException) {
            throw new Base64Exception(iOException.getMessage());
        }
        return byteArrayOutputStream.toByteArray();
    }

    private Util() {
    }

    static {
        e = new String[]{"ISO8859_1", "iso-8859-1", "ISO-8859-1", "iso_8859-1", "iso8859-1", "iso_8859_1", "iso8859_1", "Cp1252", "ASCII", "Default"};
        d = new byte[]{97, 65, 122, 90, 48, 57, 43, 47, 61};
    }
}

