/*
 * Decompiled with CFR 0.152.
 */
package iaik.utils;

import iaik.utils.NumberTheory;
import java.math.BigInteger;
import java.util.Random;

public final class CryptoUtils {
    public static void zeroBlock(int[] nArray, int n2, int n3) {
        int n4 = n2;
        while (n4 < n2 + n3) {
            nArray[n4] = 0;
            ++n4;
        }
    }

    public static void zeroBlock(int[] nArray) {
        CryptoUtils.zeroBlock(nArray, 0, nArray.length);
    }

    public static void zeroBlock(byte[] byArray, int n2, int n3) {
        int n4 = n2;
        while (n4 < n2 + n3) {
            byArray[n4] = 0;
            ++n4;
        }
    }

    public static void zeroBlock(byte[] byArray) {
        CryptoUtils.zeroBlock(byArray, 0, byArray.length);
    }

    public static void xorBlock(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        CryptoUtils.xorBlock(byArray, 0, byArray2, 0, byArray3, 0, byArray.length);
    }

    public static void xorBlock(byte[] byArray, int n2, byte[] byArray2, int n3, byte[] byArray3, int n4, int n5) {
        int n6 = 0;
        while (n6 < n5) {
            byArray3[n4 + n6] = (byte)(byArray[n2 + n6] ^ byArray2[n3 + n6]);
            ++n6;
        }
    }

    public static void squashBytesToShortsLE(byte[] byArray, int n2, int[] nArray, int n3, int n4) {
        int n5 = 0;
        while (n5 < n4) {
            int n6 = n2 + (n5 << 1) + 1;
            nArray[n3 + n5] = (byArray[n6--] & 0xFF) << 8 | byArray[n6] & 0xFF;
            ++n5;
        }
    }

    public static void squashBytesToShortsBE(byte[] byArray, int n2, int[] nArray, int n3, int n4) {
        int n5 = 0;
        while (n5 < n4) {
            int n6 = n2 + (n5 << 1);
            nArray[n3 + n5] = (byArray[n6++] & 0xFF) << 8 | byArray[n6] & 0xFF;
            ++n5;
        }
    }

    public static void squashBytesToIntsPadZero(byte[] byArray, int n2, int[] nArray, int n3, int n4) {
        int n5 = n4 >> 2;
        int n6 = n4 & 3;
        if (n5 != 0) {
            CryptoUtils.squashBytesToInts(byArray, n2, nArray, n3, n5);
        }
        if (n6 != 0) {
            n2 += n4 - n6;
            n3 += n5;
            switch (n6) {
                case 3: {
                    nArray[n3] = (byArray[n2++] & 0xFF) << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8;
                    return;
                }
                case 2: {
                    nArray[n3] = (byArray[n2++] & 0xFF) << 24 | (byArray[n2++] & 0xFF) << 16;
                    return;
                }
                case 1: {
                    nArray[n3] = (byArray[n2++] & 0xFF) << 24;
                    return;
                }
            }
        }
    }

    public static int squashBytesToIntsLEPadZero(byte[] byArray, int n2, int[] nArray, int n3, int n4) {
        int n5 = n4 >> 2;
        int n6 = n4 & 3;
        if (n5 != 0) {
            CryptoUtils.squashBytesToIntsLE(byArray, n2, nArray, n3, n5);
        }
        if (n6 != 0) {
            n2 += n4 - n6;
            n3 += n5;
            switch (n6) {
                case 3: {
                    nArray[n3] = byArray[n2++] & 0xFF | (byArray[n2++] & 0xFF) << 8 | (byArray[n2++] & 0xFF) << 16;
                    break;
                }
                case 2: {
                    nArray[n3] = byArray[n2++] & 0xFF | (byArray[n2++] & 0xFF) << 8;
                    break;
                }
                case 1: {
                    nArray[n3] = byArray[n2++] & 0xFF;
                    break;
                }
            }
            return n5 + 1;
        }
        return n5;
    }

    public static void squashBytesToIntsLE(byte[] byArray, int n2, int[] nArray, int n3, int n4) {
        int n5 = 0;
        while (n5 < n4) {
            int n6 = n2 + (n5 << 2);
            nArray[n3 + n5] = byArray[n6++] & 0xFF | (byArray[n6++] & 0xFF) << 8 | (byArray[n6++] & 0xFF) << 16 | byArray[n6] << 24;
            ++n5;
        }
    }

    public static void squashBytesToInts(byte[] byArray, int n2, int[] nArray, int n3, int n4) {
        int n5 = 0;
        while (n5 < n4) {
            int n6 = n2 + (n5 << 2);
            nArray[n3 + n5] = (byArray[n6++] & 0xFF) << 24 | (byArray[n6++] & 0xFF) << 16 | (byArray[n6++] & 0xFF) << 8 | byArray[n6] & 0xFF;
            ++n5;
        }
    }

    public static void spreadShortsToBytesLE(int[] nArray, int n2, byte[] byArray, int n3, int n4) {
        int n5 = 0;
        while (n5 < n4) {
            byArray[n3 + (n5 << 1) + 1] = (byte)(nArray[n2 + n5] >>> 8);
            byArray[n3 + (n5 << 1)] = (byte)nArray[n2 + n5];
            ++n5;
        }
    }

    public static void spreadShortsToBytesBE(int[] nArray, int n2, byte[] byArray, int n3, int n4) {
        int n5 = 0;
        while (n5 < n4) {
            byArray[n3 + (n5 << 1)] = (byte)(nArray[n2 + n5] >>> 8);
            byArray[n3 + (n5 << 1) + 1] = (byte)nArray[n2 + n5];
            ++n5;
        }
    }

    public static void spreadIntsToBytesLE(int[] nArray, int n2, byte[] byArray, int n3, int n4) {
        int n5 = 0;
        while (n5 < n4) {
            int n6 = n3 + (n5 << 2);
            int n7 = n2 + n5;
            byArray[n6++] = (byte)nArray[n7];
            byArray[n6++] = (byte)(nArray[n7] >>> 8);
            byArray[n6++] = (byte)(nArray[n7] >>> 16);
            byArray[n6] = (byte)(nArray[n7] >>> 24);
            ++n5;
        }
    }

    public static void spreadIntsToBytes(int[] nArray, int n2, byte[] byArray, int n3, int n4) {
        int n5 = 0;
        while (n5 < n4) {
            int n6 = n3 + (n5 << 2);
            int n7 = n2 + n5;
            byArray[n6++] = (byte)(nArray[n7] >>> 24);
            byArray[n6++] = (byte)(nArray[n7] >>> 16);
            byArray[n6++] = (byte)(nArray[n7] >>> 8);
            byArray[n6] = (byte)nArray[n7];
            ++n5;
        }
    }

    public static void reverseArray(byte[] byArray, int n2, int n3) {
        if (byArray != null && byArray.length > 0) {
            int n4 = n2;
            while (n4 < n2 + n3 / 2) {
                byte by = byArray[n4];
                int n5 = 2 * n2 + n3 - n4 - 1;
                byArray[n4] = byArray[n5];
                byArray[n5] = by;
                ++n4;
            }
        }
    }

    public static byte[] resizeArray(byte[] byArray, int n2) {
        if (n2 < 0) {
            throw new NegativeArraySizeException("Invalid length: " + n2);
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, Math.min(n2, byArray.length));
        return byArray2;
    }

    public static void randomBlock(byte[] byArray, int n2, int n3) {
        int n4 = n2;
        while (n4 < n2 + n3) {
            byArray[n4] = (byte)(Math.random() * 256.0);
            ++n4;
        }
    }

    public static void randomBlock(byte[] byArray) {
        CryptoUtils.randomBlock(byArray, 0, byArray.length);
    }

    public static byte[] increment(byte[] byArray) {
        int n2 = byArray.length - 1;
        while (n2 >= 0) {
            int n3 = n2--;
            byArray[n3] = (byte)(byArray[n3] + 1);
            if (byArray[n3] == 0) continue;
        }
        return byArray;
    }

    public static BigInteger getStrongPrime(int n2, Random random) {
        return NumberTheory.getStrongPrime(n2, random);
    }

    public static int gcd(int n2, int n3) {
        return NumberTheory.gcd(n2, n3);
    }

    public static void fillBlock(byte[] byArray, int n2, byte by, int n3) {
        int n4 = n2;
        while (n4 < n2 + n3) {
            byArray[n4] = by;
            ++n4;
        }
    }

    public static void fillBlock(byte[] byArray, byte by) {
        CryptoUtils.fillBlock(byArray, 0, by, byArray.length);
    }

    public static int[] extGcd(int n2, int n3) {
        return NumberTheory.extGcd(n2, n3);
    }

    public static boolean equalsBlock(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        return CryptoUtils.equalsBlock(byArray, 0, byArray2, 0, byArray.length);
    }

    public static boolean equalsBlock(byte[] byArray, int n2, byte[] byArray2, int n3, int n4) {
        int n5 = 0;
        while (n5 < n4) {
            if (byArray[n2 + n5] != byArray2[n3 + n5]) {
                return false;
            }
            ++n5;
        }
        return true;
    }

    public static void copyBlock(long[] lArray, long[] lArray2) {
        int n2 = lArray.length;
        int n3 = 0;
        while (n3 < n2) {
            lArray2[n3] = lArray[n3];
            ++n3;
        }
    }

    public static void copyBlock(long[] lArray, int n2, long[] lArray2, int n3, int n4) {
        int n5 = 0;
        while (n5 < n4) {
            lArray2[n3 + n5] = lArray[n2 + n5];
            ++n5;
        }
    }

    public static void copyBlock(int[] nArray, int[] nArray2) {
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            nArray2[n3] = nArray[n3];
            ++n3;
        }
    }

    public static void copyBlock(int[] nArray, int n2, int[] nArray2, int n3, int n4) {
        int n5 = 0;
        while (n5 < n4) {
            nArray2[n3 + n5] = nArray[n2 + n5];
            ++n5;
        }
    }

    public static void copyBlock(byte[] byArray, byte[] byArray2) {
        int n2 = byArray.length;
        int n3 = 0;
        while (n3 < n2) {
            byArray2[n3] = byArray[n3];
            ++n3;
        }
    }

    public static void copyBlock(byte[] byArray, int n2, byte[] byArray2, int n3, int n4) {
        int n5 = 0;
        while (n5 < n4) {
            byArray2[n3 + n5] = byArray[n2 + n5];
            ++n5;
        }
    }

    public static int compareBlock(byte[] byArray, byte[] byArray2) {
        int n2 = byArray.length < byArray2.length ? byArray.length : byArray2.length;
        int n3 = CryptoUtils.compareBlock(byArray, 0, byArray2, 0, n2);
        if (n3 != -1) {
            return n3;
        }
        if (byArray.length != byArray2.length) {
            return n2;
        }
        return -1;
    }

    public static int compareBlock(byte[] byArray, int n2, byte[] byArray2, int n3, int n4) {
        int n5 = 0;
        while (n5 < n4) {
            if (byArray[n2 + n5] != byArray2[n3 + n5]) {
                return n5;
            }
            ++n5;
        }
        return -1;
    }

    private CryptoUtils() {
    }
}

